C   PROGRAM SHRINK BY S.M., AUG 22, 1985
C       THIS PROGRAM REDUCES A LARGE  REACTION MECHANISM TO A SET OF 
C       REACTIONS WHICH FOLLOW FROM THE INITAL SPECIES SELECTED BELOW.
C       INPUT:  REACTIONS, ACCORDING TO FORMAT # 200,201.
C       SELECT IN PROGRAM: INITAL REAGENTS
C       OUTPUT: REACTIONS (IN SAME FORMAT AS INPUT) WHICH ARE 
C               TRIGGERED BY THE INITAL REAGENTS AND SUBSEQUENT
C               STEPS.
C  added optional exclusion of certain reactions - see below
C
        PARAMETER(NXRXNS=6000,NXSPEC=2000)
        INTEGER MOVE(NXRXNS)
        CHARACTER*81 RLIST(NXRXNS)
        CHARACTER*81 RLINE
        CHARACTER*4 REACT1(NXRXNS),REACT2(NXRXNS),REACT3(NXRXNS)
        CHARACTER*4 PROD1(NXRXNS),PROD2(NXRXNS),PROD3(NXRXNS),
     |                PROD4(NXRXNS)
        CHARACTER*1 C1,C2,C3,C4
        CHARACTER*4 R1,R2,R3,P1,P2,P3, P4
        CHARACTER*79 RDICT(NXSPEC)
        CHARACTER*4 spec(NXSPEC), ADICT(NXSPEC), adum

        CHARACTER*20 FI

        OPEN(UNIT=10,FILE='../MM/mm2.4.01',STATUS='OLD')
        OPEN(UNIT=20,FILE='../MM/alphadict.dat',STATUS='OLD')
        OPEN(UNIT=11,FILE='tmp.mch',STATUS='UNKNOWN')

c     select  initial set of reagents:

        spec(1) = '    '
        spec(2) = 'HV  '
        spec(3) = 'M   '
        spec(4) = '(M) '
        nspec = 4

      !  WRITE(6,*) 'file name for initial species list?'
      !  READ(5,*) fi
        OPEN(UNIT=30,FILE='input.species',STATUS='OLD')
        DO i = 1, 10000
           READ(30,'(A4)') adum
           IF(adum .EQ. '****') GO TO 5
           nspec = nspec + 1
           spec(nspec) = adum
        ENDDO
 5        CONTINUE
        CLOSE(30)

C     read in reaction mechanism

        NREACT = 0
        DO 10 I=1, NXRXNS
           READ(10,200) RLINE
           IF(RLINE(1:4).EQ.'****') GO TO 19

           READ(RLINE,201)C1,C2,R1,R2,R3,
     |                C3,C4,SC1,P1,SC2,P2,SC3,P3,SC4,P4,RC,E

C options for NOT including certain reactions
c e.g. in this case, do not use: RO2+RO2, RCO3+RCO3, react.'s with J,k=0

           IF(C2.EQ.'X') GO TO 10
           IF(RC.EQ.0.) GO TO 10

C end of options
C load surviving reactions 

           NREACT = NREACT + 1
           RLIST(NREACT) = RLINE
           REACT1(NREACT) = R1
           REACT2(NREACT) = R2
           REACT3(NREACT) = R3
           PROD1(NREACT) = P1
           PROD2(NREACT) = P2
           PROD3(NREACT) = P3
           PROD4(NREACT) = P4
           MOVE(NREACT) = 0
  10    CONTINUE
  19    CONTINUE
 100    FORMAT(A79)
 200    FORMAT(A81)
 201    FORMAT(A1,A1,3(A4,1X),2A1,
     |          3(F5.2,1X,A4,1X),F5.2,1X,A4,1PE9.2,1X,1PE9.2)

C   scan reaction set for participating reactions

2000    CONTINUE
        NMOVE = 0
        DO 20 I=1, NREACT 

C   test each remaining reaction to see if it contains listed species

           IF (MOVE(I).EQ.1) GO TO 20
           M1 = 0
           M2 = 0
           M3 = 0
           DO 22 J=1,NSPEC
              IF (REACT1(I).EQ.SPEC(J))  M1=1
              IF (REACT2(I).EQ.SPEC(J))  M2=1
              IF (REACT3(I).EQ.SPEC(J))  M3=1
  22       CONTINUE

C  participating reactions have MOVE(I) = 1

           MOVE(I) = M1*M2*M3

C  identify any new product species, and augment species list

           IF (MOVE(I).EQ.1) THEN
              CALL TLIST(PROD1,SPEC,I,NSPEC)
              CALL TLIST(PROD2,SPEC,I,NSPEC)
              CALL TLIST(PROD3,SPEC,I,NSPEC)
              CALL TLIST(PROD4,SPEC,I,NSPEC)
              NMOVE = NMOVE + 1
           ENDIF
20            CONTINUE

c   test for completion: if a scan does not produce new moves, then finish

        IF (NMOVE.NE.0) GO TO 2000

c   output resulting reactions

        NWRITE = 0
        DO 30 I = 1, NREACT
           IF (MOVE(I).EQ.0) GO TO 30
           NWRITE = NWRITE + 1
           WRITE(11,200)RLIST(I)
30            CONTINUE
        WRITE(11,300)
300        FORMAT(81('*'))
        WRITE(11,'(i4,A28)') NWRITE,' = TOTAL NUMBER OF REACTIONS'
        WRITE(11,'(i4,A27,A22)') NSPEC, ' = TOTAL NUMBER OF SPECIES ',
     &          "INCLUDING { ,M,(M),HV}"

C---------------------- create small dictionary
C load in full dictionary

        NDICT = 0
        DO 40 I = 1,NXSPEC
           READ(20,100) RDICT(I)
           ADICT(I) = RDICT(I)(1:4)
           IF(ADICT(I).EQ.'****') GO TO 49
           NDICT = NDICT + 1
           MOVE(I) = 0
40        CONTINUE        
49        CONTINUE

c identify and write out participating species

        DO 50 I = 1, NSPEC
           CALL SEARCH(SPEC(I),ADICT,NDICT,J)
           MOVE(J) = 1
50        CONTINUE

        END
C##################
        SUBROUTINE TLIST(PROD, SPEC,I,NSPEC)
C  BUILDS UP SPECIES LIST. From W. Stockwell, ca. 1986
        CHARACTER*4 PROD(1), SPEC(1)
        DO 10 J=1, NSPEC
        IF(PROD(I) .EQ. SPEC(J)) THEN 
        RETURN
        ENDIF
 10     CONTINUE
        NSPEC = NSPEC + 1
        SPEC(NSPEC) = PROD(I)
        RETURN
        END
C################
        SUBROUTINE SEARCH(ASEEK,ALIST,NLIST,JFOUND)
C binary tree search
C assumes that array ALIST is sorted by increasing values.
c
        CHARACTER*4 ASEEK, ALIST(1)
                JOLD = 0
                JLO = 1
                JHI = NLIST + 1
10                J = (JHI+JLO)/2
                IF(J.EQ.JOLD) GO TO 40
                JOLD = J
                IF(ASEEK.GT.ALIST(J)) GO TO 20
                IF(ASEEK.EQ.ALIST(J)) GO TO 30
                JHI = J
                GO TO 10
20                JLO = J
                GO TO 10
C
30                JFOUND = J
                RETURN
40                JFOUND = 0
                write(6,*)'?',aseek
                RETURN
                END
