#! /bin/csh
#=======================================================================#
# Step1.csh - NCAR Master Mechanism calculation step 1: 
#             Extract a subset of the MM reaction scheme.
# INPUTS (Described in WORK/README)
# input.species => list of desired species
#=======================================================================#

set compile = ` grep "compile" setup.dat | awk '{print $3}' `
set homedir = ` grep "homedir" setup.dat | awk '{print $3}' `

if ( $#argv == 0 ) then
  #echo '--ERROR-- Required syntax is "Step1.csh <runname>"' 
  exit
endif
echo '-------------------------------------------------------'
echo ' NCAR MasterMechanism Step 1 : Create Mechanism Subset '
echo '-------------------------------------------------------'

if (-e input.species) then
  
  set runname = $argv[1]
  echo 'runname = '$runname

  set codedir = $homedir'/MM'
  set workdir = $homedir'/WORK'
  set tmpdir = $homedir'/TMP'
  set logdir = $workdir'/'$runname

  if (-e $logdir) then
    echo ' '
  else
    echo ' '
     mkdir $logdir
  endif

# delete previous versions of intermediate files
  if (-e $tmpdir'/tmp.mch') then
    rm $tmpdir'/tmp.mch'
  endif
  if (-e $tmpdir'/tmp.dep') then
    rm $tmpdir'/tmp.dep'
  endif

# do the work:
  cp input.species $tmpdir
#   create mechanism subset
  cd $codedir
     if (-e a.out) then
       rm a.out
     endif
     $compile shrink.f -o $tmpdir'/a.out'
  cd $tmpdir
     ./a.out
#   extract full deposition reaction set
  cd $codedir 
     $compile dep1.f -o $tmpdir'/a.out'
  cd $tmpdir
     ./a.out

# tidy up 
    if (-e tmp.mch) then
      set result = ` wc -w tmp.mch |  awk '{print $1}'`
      if ($result == 0) then
        echo '!! Output file TMP/tmp.mch is empty. !!'
        echo '!!     Run aborting at Step 1.       !!'
        exit
      endif

      echo '----------------------------------------'
      echo ' Completed MM subset file = TMP/tmp.mch '
      echo '----------------------------------------'

# move on
      cd $workdir
      echo ' Progress to Step 2, set up radiation conditions? (y/n)'
      set yn = $<
      if ($yn != 'y' && $yn != 'Y') then
        exit
      endif
      ./Step2.csh $runname 

# exit if no output
  else
    echo 'ERROR : NO OUTPUT!'
    exit
  endif

# exit if no input
else
  echo 'Cannot find required input file "input.species"'  
  exit
endif
#############################################################
