#! /bin/csh
#=======================================================================#
# Step3.csh - NCAR Master Mechanism calculation step 3: 
#             Set up environmental constraints, generate summary input file.
# INPUTS (Described in WORK/README)
# input.prep => list of external files describing non-radiative influences 
# plus AT LEAST generated input files TMP/tmp.mch & TMP/tmp.jv 
#=======================================================================#

set compile = ` grep "compile" setup.dat | awk '{print $3}' `
set homedir = ` grep "homedir" setup.dat | awk '{print $3}' `

if ( $#argv == 0 ) then
  echo '--ERROR-- Required syntax is "Step3.csh <runname>"' 
  exit
endif
echo '-----------------------------------------------------'
echo ' NCAR MasterMechanism Step 3 : Collate Inputs: SOLV/ '
echo '-----------------------------------------------------'

if (-e input.prep) then 
 
  set runname = $argv[1]
  echo 'runname = '$runname

  set codedir = $homedir'/SOLV'
  set workdir = $homedir'/WORK'
  set tmpdir = $homedir'/TMP'
  set logdir = $workdir'/'$runname

  if (-e $logdir) then
    echo ' '
  else
    echo ' '
    mkdir $logdir
  endif

# delete previous versions of intermediate file
  if (-e $tmpdir'/solv.inp') then
    rm $tmpdir'/solv.inp'
  endif

# do the work:
  #if (-e $logdir'/fort.9') then
  #  cp $logdir'/fort.9' $tmpdir
  #endif
  cp input.* $tmpdir
  cp output.* $tmpdir
  cd $codedir
     $compile prep.f90 -o $tmpdir'/a.out'
  cd $tmpdir
  if (-e tmp.mch) then 
     ./a.out

# tidy up 
    if (-e solv.inp) then
      set result = ` wc -w solv.inp |  awk '{print $1}'`
      if ($result == 0) then
        echo '!! Output file TMP/solv.inp is empty. !!'
        echo '!!      Run aborting at Step 3        !!'
        exit
      endif
      echo '------------------------------------------'
      echo ' Completed solver input file: TMP/solv.inp '
      echo '------------------------------------------'
      cp solv.inp $logdir
      cp bounds_mod.f90 $logdir
      #mv input.* $logdir

# move on
      cd $workdir
      echo ' Progress to Step 4, simulate chemistry? (y/n)'
      set yn = $<
      if ($yn != 'y') then
        if ($yn != 'Y') then
          exit
        endif
      endif
      ./Step4.csh $runname 

# exit if no output
    else
      echo 'ERROR : NO OUTPUT!'
      exit
    endif

# exit if no input
  else
    echo 'Cannot find required input file "tmp.mch"'
    exit
  endif
else
  echo 'Cannot find required input file "input.prep"'
  exit
endif

#############################################################
