#! /bin/csh
#=======================================================================#
# Step4.csh - NCAR Master Mechanism calculation step 4: 
#             Simulate chemistry.
# INPUTS -  TMP/solv.inp => full input file, generated in Step 3.
#=======================================================================#

set compile = ` grep "compile" setup.dat | awk '{print $3}' `
set homedir = ` grep "homedir" setup.dat | awk '{print $3}' `

if ( $#argv == 0 ) then
  echo '--ERROR-- Required syntax is "Step4.csh <runname>"' 
  exit
endif
echo '---------------------------------------------------------'
echo ' NCAR MasterMechanism Step 4 : Simulate Chemistry: SOLV/'
echo '---------------------------------------------------------'

set runname = $argv[1]
echo 'runname = '$runname

set codedir = $homedir'/SOLV'
set workdir = $homedir'/WORK'
set tmpdir = $homedir'/TMP'
set logdir = $workdir'/'$runname

if (-e $logdir) then
   echo ' '
else
   echo ' '
   mkdir $logdir
endif

# do the work:
if (-e $logdir'/solv.inp') then 
  cp $logdir'/solv.inp' $tmpdir'/solv.inp'
endif
if (-e $tmpdir'/solv.inp') then 
  cd $codedir
     cp gear.f90 $tmpdir
  cd $tmpdir
# compile with gfortran debug flags
#     gfortran -Wall -fbounds-check bounds_mod.f90 gear.f90 -o $tmpdir'/a.out'
# compile normally
     $compile bounds_mod.f90 gear.f90 -o $tmpdir'/a.out'
     ./a.out 
     rm $tmpdir'/gear.f90' 
     rm *.mod *.o

# tidy up 
  if (-e fort.7) then
     set result = ` wc -w fort.7 |  awk '{print $1}'`
     if ($result == 0) then
        echo '!! Results file fort.7 is empty. !!'
        echo '!!    Run aborting at Step 4     !!'
        exit
     endif
     mv fort.* $logdir
     cp solv.inp $logdir
     cp bounds_mod.f90 $logdir
     rm a.out
     echo '-----------------------------------------------------------'
     echo ' Completed chemistry simulation => results in files fort.* '
     echo '  '$logdir
     echo '-----------------------------------------------------------'

# move on
     cd $workdir
     echo ' Progress to Step 5, tabulate selected results for plotting? (y/n)'
     set yn = $<
     if ($yn != 'y' && $yn != 'Y') then
        exit
     endif
     ./Step5.csh $runname 

# exit if no output
  else
     echo 'ERROR : NO OUTPUT!'
     exit
  endif

# exit if no input
else
   echo 'Cannot find required input file "TMP/solv.inp"'
   exit
endif

#############################################################
