#! /bin/csh
#=======================================================================#
# Step5.csh - NCAR Master Mechansim calculation step 4:
#             Display Results.
# INPUTS (Described in WORK/README)
# plot.species => full input file  (select.plot for old version)
#=======================================================================#

set compile = ` grep "compile" setup.dat | awk '{print $3}' `
set homedir = ` grep "homedir" setup.dat | awk '{print $3}' `

if ( $#argv == 0 ) then
  echo '--ERROR-- Required syntax is "Step5.csh <runname>"'
  exit
endif
echo '-----------------------------------------------------------'
echo ' NCAR MasterMechanism Step 5 : Display Results: dir POST/'
echo '-----------------------------------------------------------'

set runname = $argv[1]
echo 'runname = '$runname

set codedir = $homedir'/POST'
set workdir = $homedir'/WORK'
set logdir = $workdir'/'$runname

# do the work

cd $codedir
cp $logdir'/fort.7' .
cp $logdir'/fort.8' .
cp $logdir'/solv.inp' .
cp $workdir'/plot.species' .
if (-e plotsel) then
  rm plotsel
endif
echo 'Write ASCII table of results? (y/n)'
set yn = $<
if ($yn == 'y' || $yn == 'Y') then
  echo 'Tabulating results for spreadsheet'
  echo '-----------------------------------------------------------'
  $compile plotsel.f90 -o plotsel
  ./plotsel
#  echo 'finished plotsel'
else
  echo 'Attempting to display results using NCAR graphics'
  ncargf90 plotsel_ncarg.f90 -o plotsel
  ./plotsel
  echo 'finished plotsel'
  idt gmeta
endif

# tidy up 
if (-e fort.23) then
   set result = ` wc -w fort.23 |  awk '{print $1}'`
   if ($result == 0) then
      echo '!! Results file fort.23 is empty. !!'
      echo '!!          Check inputs          !!'
      exit
   endif
   mv fort.2* $logdir
   echo '-----------------------------------------------------------'
   echo 'Results are in directory  '$logdir
   echo '-----------------------------------------------------------'
else
   echo '!! Cannot find results file fort.23 !!'
endif

rm $codedir'/fort.7' 
rm $codedir'/fort.8' 
rm $codedir'/solv.inp' 
cd $workdir

#############################################################
