#! /bin/csh
#=======================================================================#
# run_MM.csh : C-shell script to run an NCAR Master Mechanism calculation 
#              Invokes scripts "StepX.csh" in turn
#=======================================================================#

echo '----------------------------------'
echo ' NCAR MasterMechanism Version 2.4 '
echo '----------------------------------'
set compile = ` grep "compile" setup.dat | awk '{print $3}' `
echo 'compiler = '$compile
setenv FC $compile
#setenv | grep FC 

set homedir = ` grep "homedir" setup.dat | awk '{print $3}' `
echo '       Home path = '$homedir

set wkdir = `pwd`

if ($wkdir != $homedir"/WORK") then
  echo 'ERROR! Current dir = '$wkdir
  echo '       Please edit home path in file setup.dat'
  exit
endif

echo ' > Please input a run name? '
set runname = $<

echo ' > Input a starting point number (1-5)? '
echo '    1 : Extract subset of mechanism'
echo '    2 : Calculate j-values'
echo '    3 : Create summary input file solv.inp'
echo '    4 : Simulate chemistry'
echo '    5 : Extract subset of results for plotting/processing'
set n = $<

  ./Step$n'.csh' $runname 

# --------------------


