      PROGRAM dep1

*  dimension species dictionary parameters
      PARAMETER(NXSPEC=2000)
      CHARACTER*79 DICT
      CHARACTER*4 SPEC
      INTEGER IC,IX,IH,IN,IO,IS
      CHARACTER*40 CHEM
      CHARACTER*10 CODE
      CHARACTER*20 FI
      REAL kdep

      OPEN(UNIT=11,FILE='../MM/alphadict.dat',STATUS='OLD')
      OPEN(UNIT=20,FILE='tmp.dep')

*    read dictionary of species

        NDICT = 0
        DO 10 I=1,NXSPEC
           READ(11,'(A79)') DICT
           IF(DICT(1:4) .EQ. '****') GO TO 15
           NDICT = NDICT + 1
         READ(DICT,100) SPEC,IC,IX,IH,IN,IO,IS,CHEM,CODE
           IF ( SPEC .EQ. '    ' ) go to 10
           IF ( SPEC .EQ. 'HV  ' ) go to 10
           IF ( SPEC .EQ. 'M   ' ) go to 10
           IF ( SPEC .EQ. '(M) ' ) go to 10

* units are meter, seconds

* initialize

         RS = 1.E6
         VS = 1./RS

         DO 25 J = 1, 10
            IF(CODE(J:J) .EQ. '.') VS = 1.E6

*  to match Jacob and Wofsy:
* Jacob, D. J., and S. Wofsy, Photochemistry of biogenic emissions over
* the Amazon forest, J. Geophys. Res., 93, 1477-1486, 1988. 

            IF(CODE(J:J) .EQ. 'a') VS = VS + 1./67.
            IF(CODE(J:J) .EQ. 'd') VS = VS + 1./67.
            IF(CODE(J:J) .EQ. 'g') VS = VS + 1./67.
            IF(CODE(J:J) .EQ. 'h') VS = VS + 1./67.
            IF(CODE(J:J) .EQ. 'n') VS = VS + 1./16.7
            IF(CODE(J:J) .EQ. 'p') VS = VS + 1./16.7
            IF(CODE(J:J) .EQ. 'o') VS = VS + 1./167.
            IF(CODE(J:J) .EQ. 'm') VS = VS + 1./80.
25         CONTINUE

* overwrite for explicit species (from LOPEZ ET AL)
* Lopez, A., M.L. Hertas, and J. M. Lacome, Numerical simulation of the
* ozone chemistry observed over forested tropical areas during DECAFE
* experiments, J. Geophys. Res., 97, 6149-6158, 1992. 

         IF(SPEC .EQ. 'O3  ') VS = 1./91.7
         IF(SPEC .EQ. 'NO2 ') VS = 1./300.
         IF(SPEC .EQ. 'H2O2') VS = 1./967.

         IF(SPEC .EQ. 'NO  ') VS = 1./1000.
         IF(SPEC .EQ. 'CH2O') VS = 1./67.
         IF(SPEC .EQ. 'NH3 ') VS = 1./80.
         IF(SPEC .EQ. 'HNO3') VS = 1.E6
         IF(SPEC .EQ. 'HNO2') VS = 1./110.
         IF(SPEC .EQ. 'SO2 ') VS = 1./130.

* aerodynamic velocity (m/s), boundary layer height (m)

           V0 = 3.E-2
           Z = 1.e3
           VD = V0*VS / (V0 + VS)
           KDEP = VD/Z
        
           WRITE(20,111) SPEC,kdep,0.
! 110       FORMAT(1x,'d',A4,11X,'>',45X,1PE7.1,2X,'0.0E+00')
! NEW in version 2.4.05: rate expressions have 3 sig figs 
 111       FORMAT(1x,'d',A4,11X,'>',44X,E9.2,2X,E9.2) 
CCi O2   O1D       >       O2         O3P                        4.0E-11 -6.7E+01

10      CONTINUE
15      CONTINUE

100      FORMAT(A4,1X,6(I2,1X),1X,A40,2X,A10)

        CLOSE(11)

        WRITE(20,'(a40)') '****************************************'
        CLOSE(20)

       END
