       PROGRAM PREP
!      Written By S. Madronich 4/27/88
!      Adapted J. Lee-Taylor 9/23/05
!      This program prepares chemical mechanisms for input to solver
!        -        each type of reaction is identified and counted 
!        -        initial conditions are READ and appended
!        -        troe reactions are found and rate date is appended
!        -        table of temperature vs. time is found and appended
!        -        table of dilution vs. time is found and appended
!        -        units are converted

        IMPLICIT NONE 

        INTEGER,PARAMETER:: nxrxns=5000,nxspec=3000,ndat=1000,nhdr=3
        INTEGER :: nr1,nr2,nr3,nr4,nr5,nr7
        CHARACTER*30 :: fi
        CHARACTER*81 :: rline

        REAL :: start,stopp
        INTEGER :: msave,mrsave

        CHARACTER*4 molec(nxrxns,7)
        CHARACTER*1 c1(nxrxns),c2(nxrxns),c3(nxrxns),c4(nxrxns)
        REAL sc(nxrxns,7), A(nxrxns), S(nxrxns)
        CHARACTER*5 asc(7)

        INTEGER nics
        CHARACTER*4 icspec(ndat),icspecin(ndat)
        REAL ci(ndat),ciin(ndat),cO2,cN2
       
        INTEGER nusr, ntusr(ndat)
        CHARACTER*4 usrspec(ndat)
        REAL tusr(ndat,ndat), xusr(ndat,ndat)

        INTEGER nbg
        CHARACTER*4 bgspec(ndat)
        REAL cbg(ndat)

        INTEGER nsem, ntem(ndat)
        CHARACTER*4 emspec(ndat)
        REAL tem(ndat,ndat), em(ndat,ndat)

        INTEGER nz
        REAL tz(ndat),xz(ndat)

        INTEGER itype1(nxspec)
        CHARACTER*4 jspec(nxspec)
        REAL tjval(ndat), xjval(nxspec,ndat)

        INTEGER itype4(ndat)
        CHARACTER*79 trorea(ndat), trodat(ndat)
        REAL AK0300(ndat),AKI300(ndat),AN(ndat),AM(ndat),BAS(ndat), &
                  aequil(ndat), tequil(ndat)        
        INTEGER nreag(ndat)

        INTEGER idep(nxspec)
        CHARACTER*4 depspec(nxspec)
        REAL sdep(nxspec)
        REAL adep(nxspec)

        INTEGER :: ncloud,ntemp,ndilut
        REAL,DIMENSION(ndat) :: tcloud,xcloud,ttemp,xtemp,tdilut,xdilut
        INTEGER nreact(ndat)
        INTEGER :: i,j,k,n,ir,nr,ioerr
        INTEGER :: ndens,iphot,nphot,nrx,nspc,nrates,inO2,inN2
        INTEGER :: iout,nlocal,ntot,mtot,m1,m2,m3,nr4tot,nr7tot

        REAL :: temp,adens
        REAL :: ctime,cdens,TK,f0,f1,f2,f3

        CHARACTER*4 r1, r2, r3        
        CHARACTER*20 modname
        CHARACTER*10 varname

! ---Initialise counters
      n =0
      ncloud = 0
      nbg = 0
      ndens = 0
      ndilut = 0
      nics = 0
      nphot = 0
      nr = 0
      nrates = 0
      nsem = 0
      nspc = 0
      ntemp = 0
      nusr = 0
      inO2 = 0
      inN2 = 0
!---------------------------------------------------------------------------
!     Set defaults (in case no inputs available)
      temp = 294.

! ---Open Source And Output Filenames, Read Input Data

! ---Read Input Filenames
        fi = 'input.prep'
        OPEN (UNIT=9,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
        IF(ioerr.NE.0) CALL ERRSTOP(fi)
    
        DO i=1,nhdr
          READ(9,'(A10)') rline
        ENDDO
 
        READ(9,*) start,stopp
        print*,'start, stop times =',start,stopp
        READ(9,*) msave
        print*,'number of save times =',msave

! Troe reactions:
        fi='../MM/troe.mch'
        OPEN (UNIT=10,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
        IF(ioerr.NE.0) CALL ERRSTOP(fi)
        nr4tot = 0
        DO i = 1, nxrxns
           READ(10,'(A79)') rline
           IF (rline(1:4) .EQ. '****') EXIT
           nr4tot = nr4tot + 1
           trorea(i) = rline
           READ(10,'(A79)') trodat(i)
        ENDDO
        CLOSE (10)

! Deposition reactions:
        fi='tmp.dep'
        OPEN (UNIT=10,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
        IF(ioerr.NE.0) CALL ERRSTOP(fi)
        nr7tot = 0
        DO i = 1, nxspec
           READ(10,'(A81)') rline
           IF (rline(1:4) .EQ. '****') EXIT
           nr7tot = nr7tot + 1
           READ(rline,111) depspec(i),adep(i),sdep(i)
           
        ENDDO
        CLOSE (10)

! Chemical mechanism subset:
        fi='tmp.mch'
        OPEN (UNIT=11,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
        IF(ioerr.NE.0) CALL ERRSTOP(fi)
        nr = 0
        DO i = 1, nxrxns        
           READ(11,'(A81)') rline
           IF (rline(1:4) .EQ. '****') EXIT
           nr = nr + 1
           READ(rline,2100) c1(i),c2(i),(molec(i,j), J = 1, 3),     &
                   c3(i),c4(i),(sc(i,j),molec(i,j),J=4,7),A(i),S(i)
        ENDDO
        READ(11,*) nrx
        READ(11,*) nspc
        CLOSE (11)

        IF (nr.NE.nrx)THEN
          PRINT*,'!! Problem with reaction input file: nr, nrx =',nr,nrx
          STOP
        ENDIF

! Photolysis rates:

        OPEN (UNIT=13,FILE='tmp.jv',STATUS='OLD',IOSTAT=ioerr)
        IF(ioerr.NE.0)THEN
          PRINT*,"NO J-VALUE FILE: SUMMARY FILE STILL REQUIRES ",&
            "START & STOP TIMES, TEMPERATURE, O2 & N2 CONCENTRATIONS"
        ELSE
          READ(13,*)
          READ(13,*) temp, adens
          READ(13,*)
          READ(13,*) nr1, nphot
          READ(13,*)
          READ(13,*) (itype1(ir), ir = 1, nr1)
          READ(13,*) 
          READ(13,*) (tjval(iphot), iphot = 1, nphot)
          DO ir = 1, nr1
            READ(13,*) jspec(ir)
            READ(13,*) (xjval(ir,iphot), iphot = 1, nphot)
          ENDDO
          CLOSE(13)
          xtemp(1) = temp
          ttemp(1) = start
          cO2 = 0.209*adens
          cN2 = 0.79*adens
        ENDIF

! initial conditions files:

        READ(9,1000) fi
        IF (fi .NE. ' ') THEN
          WRITE(6,*)'file: initial concentrations =      ',fi
          OPEN (UNIT=12,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(12,*) n
          DO i = 1, n
             READ(12,*) icspecin(i),ciin(i)
             IF(ciin(i).NE.0.000)THEN
               nics = nics+1
               ci(nics) = ciin(i)
               icspec(nics)=icspecin(i)
             ENDIF
          ENDDO
          CLOSE (12)
        ENDIF

! User-defined species file:

        ntot=0 
        READ(9,1000)fi
        IF (fi .NE. ' ') THEN
          WRITE(6,*) 'file: [X] vs. time =               ',fi
          OPEN (UNIT=18,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(18,*) nlocal
          nusr = nusr + nlocal
          DO i = nusr-nlocal+1, nusr
            READ(18,*) usrspec(i),ntusr(i)
            IF(usrspec(i).EQ.'O2  ') inO2 = 1
            IF(usrspec(i).EQ.'N2  ') inN2 = 1
            IF (ntusr(i).GT.0)THEN
              DO j = 1, ntusr(i)
                READ(18,*) tusr(i,j), xusr(i,j)
              ENDDO
            ENDIF
          ENDDO
          CLOSE (18)
        ENDIF

! emitted species, time dependence

        READ(9,1000) fi
        IF(fi .NE. ' ') THEN
          WRITE(6,*) 'file: emissions =                ',fi
          OPEN(UNIT=23,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(23,*) nsem
          DO i = 1, nsem
            READ(23,'(a4,1x,i3)') emspec(i), ntem(i)
            DO j = 1, ntem(i)
              READ(23,*) tem(i,j), em(i,j)
            ENDDO
          ENDDO
          CLOSE (23)  
        ENDIF
    
! boundary layer height table:

        READ(9,1000)fi
        IF (fi .NE. ' ') THEN
          WRITE(6,*)'file: boundary layer ht vs time = ',fi
          OPEN (UNIT=17,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(17,*) nz
          DO i = 1, nz
            READ(17,*) tz(i), xz(i)
          ENDDO
         ELSE
           nz = 1
           tz(1) = 0.0
           xz(1) = 1.0
        CLOSE (17)
        ENDIF

! dilution background concentrations

        READ(9,1000) fi
        IF(fi .NE. ' ') THEN
          WRITE(6,*)'file: dilution background concs = ',fi
          OPEN (UNIT=22,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
           READ(22,*) nbg
           DO i = 1, nbg
              READ(22,*) bgspec(i),cbg(i)
!              cbg(i) = cbg(i) * adens
           ENDDO
           CLOSE (22)
        ENDIF

! dilution table

        READ(9,1000)fi
        IF (fi .NE. ' ') THEN
          WRITE(6,*)'file: dilution vs. time =         ',fi
          OPEN (UNIT=17,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(17,*) ndilut
          DO i = 1, ndilut
            READ(17,*) tdilut(i), xdilut(i)
          ENDDO
        CLOSE (17)
        ENDIF

! cloud factor table:

        READ(9,1000)fi
        IF (fi .NE. ' ') THEN
          WRITE(6,*)'file: cloud factor vs. time =     ',fi
          OPEN (UNIT=14,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(14,*) ncloud
          DO i = 1, ncloud
            READ(14,*) tcloud(i), xcloud(i)
          ENDDO
          CLOSE (14)
        ENDIF

! temperature table

        READ(9,1000)fi
        IF (fi .NE. ' ') THEN
          WRITE(6,*)'file: temperature vs. time =      ',fi
          OPEN (UNIT=15,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(15,*) ntemp
          DO i = 1, ntemp
            READ(15,*) ttemp(i), xtemp(i)
          ENDDO
          CLOSE (15)
        ENDIF
        IF(ntemp .EQ. 0) ntemp = 1

! Reaction number table for rate output:

        READ(9,1000)fi
        IF(fi .NE. ' ') THEN
          WRITE(6,*)'file: rxn numbers for rate o/p =  ',fi
          OPEN(UNIT=21,FILE=fi,STATUS='OLD',IOSTAT=ioerr)
          IF(ioerr.NE.0) CALL ERRSTOP(fi)
          READ(21,*) nrates
          PRINT*,nrates
          DO i = 1, nrates
            READ(21,*) nreact(i)
          PRINT*,nreact(i)
          ENDDO
          CLOSE (21)
        ENDIF

! Switch for deposition:

        READ(9,'(A79)') rline
        IF(rline(1:1).EQ.'N'.OR.rline(1:1).EQ.'n') THEN
          nr7tot = 0
        ELSE
         IF(rline(1:1).NE.'Y'.AND.rline(1:1).NE.'y') THEN
           WRITE(6,*)"Need switch for deposition: check file input.prep"
           STOP
         ENDIF
        ENDIF

! output file name

        fi = 'solv.inp'
        WRITE(6,*)'output file name =                ',fi
        OPEN (UNIT=40,FILE=fi,STATUS='UNKNOWN',IOSTAT=ioerr)


! ------------- END DATA READ -----------

!  count reactions of each type:

        nr1 = 0
        nr2 = 0
        nr3 = 0
        nr4 = 0
        nr5 = 0
        nr7 = 0
        DO i = 1, nr
! photolysis
           IF (molec(i,2) .EQ. 'HV  ') nr1 = nr1 + 1
! arrhenius
           IF (S(i) .NE. 0.)  nr2 = nr2 + 1
! three-body
           IF ((molec(i,2).EQ.'M   ') .OR. (molec(i,3).EQ.'M   '))   &
                     nr3 = nr3 + 1
! troe
           IF((molec(i,2).EQ.'(M) ').OR.(molec(i,3).EQ.'(M) ')) THEN
              nr4 = nr4 + 1
              IF(molec(i,2) .EQ. '(M) ') nreag(nr4) = 1
              IF(molec(i,3) .EQ. '(M) ') nreag(nr4) = 2
        
                 DO j = 1, nr4tot
                 
                 IF(    (molec(i,1) .EQ. trorea(j)(3:6))    .AND.   &
                        (molec(i,2) .EQ. trorea(j)(8:11)) ) THEN
                    itype4(nr4) = I
                    READ(trodat(j),*)                               &
                        AK0300(nr4), AN(nr4), AKI300(nr4), AM(nr4), &
                        BAS(nr4), aequil(nr4), tequil(nr4)
                    EXIT
                  ENDIF

                 ENDDO
             IF(itype4(nr4).NE.I)WRITE(6,*)'no troe data for reaction',I
           ENDIF
! special function
           IF (c2(i) .EQ. 's') nr5 = nr5 + 1
        ENDDO

! deposition 
     depos:DO k = 1,nr7tot
             DO i = 1, nr
               DO j = 1,7  
                 IF(molec(i,j).EQ.depspec(k)) THEN
                   nr7 = nr7+1
                   idep(nr7) = k 
                   CYCLE depos
                 ENDIF
               ENDDO
             ENDDO
           ENDDO depos

      nr = nr+nr7


!  -------- convert units

!  to stay in {molec, cm3, s} use following

        ctime = 1.
        cdens = 1.

! to convert from {molec, cm3, s} to {ppm,min} use following
!        ctime = 60.
!              PRESS = 760.
!        TK = 298.
!        cdens = 2.45E19*1.0E-06*(PRESS/760.)*(298./TK)

        f0 = ctime/cdens
        f1 = ctime
        f2 = ctime*cdens
        f3 = ctime*cdens*cdens

        DO i = 1, nr-nr7

           r1 = molec(i,1)
           r2 = molec(i,2)
           r3 = molec(i,3)
           m1 = 1
           m2 = 1
           m3 = 1
           IF(r1.EQ.'    '.OR.r1.EQ.'HV  '.OR.r1.EQ.'(M) ') m1 = 0
           IF(r2.EQ.'    '.OR.r2.EQ.'HV  '.OR.r2.EQ.'(M) ') m2 = 0
           IF(r3.EQ.'    '.OR.r3.EQ.'HV  '.OR.r3.EQ.'(M) ') m3 = 0
           mtot = m1 + m2 + m3

           IF(mtot.EQ.0)   A(i) = A(i)*f0
           IF(mtot.EQ.1)   A(i) = A(i)*f1
           IF(mtot.EQ.2)   A(i) = A(i)*f2
           IF(mtot.EQ.3)   A(i) = A(i)*f3
        ENDDO
        
        DO i = 1, nr4
           AK0300(i) = AK0300(i)*f3
           AKI300(i) = AKI300(i)*f2
           aequil(i) = aequil(i)*(cdens)**(2-nreag(i))
        ENDDO

! ----------- output ------------

      WRITE(40,'(a48)')  &
          '   nr,  nr1,  nr2,  nr3,  nr4,  nr5,  nr7, nphot'
      WRITE(40,'(8(i5,1X))') nr,nr1,nr2,nr3,nr4,nr5,nr7,nphot

      WRITE(40,*) 'Start, end times (s)'
      WRITE(40,'(4(1PE10.4,1X))') start, stopp

      WRITE(40,1001)ntemp,'Temperatures:'
      DO i = 1, ntemp
         WRITE(40,4200) ttemp(i), xtemp(i)
      ENDDO

      WRITE(40,1001)ncloud,'Clouds:'
      DO i = 1, ncloud
         WRITE(40,4200) tcloud(i), xcloud(i)
      ENDDO

      WRITE(40,1001)nz, 'PBL_heights_&_times:'
      DO i = 1, nz
         WRITE(40,4200) tz(i), xz(i)
      ENDDO

      WRITE(40,1001)ndilut,'Dilution_rates:'
      DO i = 1, ndilut
         WRITE(40,4200) tdilut(i), xdilut(i)
      ENDDO

      WRITE(40,1001)nsem,'Emitted_species:'
      DO i = 1, nsem
         WRITE(40,4005) emspec(i),ntem(i),'data_points'
         DO j = 1, ntem(i)
            WRITE(40,*) tem(i,j), em(i,j)
         ENDDO
      ENDDO

      WRITE(40,1001)nusr+2-inO2-inN2,'Constrained_species:'
      IF(inN2.eq.0)THEN
        WRITE(40,4005)'N2  ',1
        WRITE(40,4200) 0., cN2
      ENDIF
      IF(inO2.eq.0)THEN
        WRITE(40,4005)'O2  ',1
        WRITE(40,4200) 0., cO2
      ENDIF
      IF (nusr .GT. 0) THEN
        DO i = 1, nusr
          WRITE(40,4005)usrspec(i),ntusr(i)
          DO j = 1, ntusr(i)
            WRITE(40,4200) tusr(i,j), xusr(i,j)
          ENDDO
        ENDDO
      ENDIF

      WRITE(40,1001)nics,'Initial_conditions:'
      DO i = 1, nics
        WRITE(40,'(A4,1X,1PE10.4)') icspec(i), ci(i)
      ENDDO

      WRITE(40,1001)nbg,'Background_concs:'
      DO i = 1, nbg
         WRITE(40,'(A4,1X,1PE10.4)') bgspec(i), cbg(i)
      ENDDO

      WRITE(40,1001)nrates,'Output_rates:'
      IF(nrates .GT. 0) WRITE(40,'(15I5)') (nreact(i), I=1,nrates)

      WRITE(40,1001)nr,'Reactions:'
      DO i = 1, nr-nr7
        DO j = 4,7
          WRITE(asc(j),'(f5.2)') sc(i,j)
          IF(asc(j).EQ. ' 0.00') asc(j) = '     '
          IF(asc(j).EQ. '  .00') asc(j) = '     '
          IF(asc(j).EQ. ' 1.00') asc(j) = '     '
        ENDDO
        WRITE(40,4205) c1(i),c2(i),(molec(i,j), J = 1, 3),         &
                   c3(i),c4(i),(asc(j),molec(i,j),J=4,7),A(i),S(i)
      ENDDO
      DO k = 1, nr7
        WRITE(40,4111) depspec(idep(k)),adep(idep(k)),sdep(idep(k))
      ENDDO

      WRITE(40,1001)nr4,'Troe reactions:'
      DO i = 1, nr4
         WRITE(40,4000) itype4(i),                                 &
                       AK0300(i),AN(i),AKI300(i),AM(i),BAS(i),     &
                 aequil(i), tequil(i)
      ENDDO

      WRITE(40,*) 'Number of photolysis reactions, times:'
      WRITE(40,*) nr1, nphot

      WRITE(40,*) 'Mechanism index map for photolysis reactions:'
      WRITE(40,251) (itype1(ir), ir = 1, nr1)

      WRITE(40,*) 'Time (sec):'
      WRITE(40,252) (tjval(iphot), iphot = 1, nphot)

      DO ir = 1, nr1
         WRITE(40,*) jspec(ir)
         WRITE(40,253) (xjval(ir,iphot), iphot = 1, nphot)
      ENDDO

      CLOSE(40)

!--FORMATS--
 111  FORMAT(2x,A4,11X,1x,44x,E9.2,1X,E9.2)
 251  FORMAT(12(i6)) 
 252  FORMAT(7(1PE11.3))
 253  FORMAT(7(1PE11.3))
 1000 FORMAT(A30)
 1001 FORMAT(i5,1x,A20)
 2100 FORMAT(A1,A1,3(A4,1X),A1,A1,  &
                   3(F5.2,1X,A4,1X),F5.2,1X,A4,E9.2,1X,E9.2)
 4000 FORMAT(i5,1X,2(1PE10.4,1X,0PF5.2,1X),0PF5.2,2(1X,1PE10.4))
 4005 FORMAT(A4,1X,I3,1x,a12)
 4100 FORMAT(0PF5.2)
 4106 FORMAT(A1,A1,3(A4,1X),A1,A1,  &
                   3(A5,1X,A4,1X),A5,1X,A4,1PE9.2,1X,1PE9.2)
 4110 FORMAT(1x,'d',A4,11X,'>',45X,1PE7.1,2X,A7)
 4111 FORMAT(1x,'d',A4,11X,'>',44X,1PE9.2,1X,1PE9.2)
 4200 FORMAT(2(1PE10.4,1X))
 4205 FORMAT(A1,A1,3(A4,1X),A1,A1,  &
                   3(A5,1X,A4,1X),A5,1X,A4,1PE9.2,1X,1PE9.2)

! Write module for bounds which gets compiled along with gear.f90
    
      iout = 41
      modname = 'bounds_mod'
      OPEN(iout,file='bounds_mod.f90')
      CALL header(iout,modname) 

        WRITE(iout,515) 'nrxn', MAX(nr,20)
        WRITE(iout,515) 'nspc', MAX(nspc,20)
        WRITE(iout,515) 'msave',msave
        IF(nrates.GT.0) THEN
          WRITE(iout,515) 'mrsave',nrates
        ELSE
          WRITE(iout,515) 'mrsave',1
        ENDIF
        WRITE(iout,515) 'nenv',MAX(ntemp,ndens,ncloud,ndilut,nz)+1
        WRITE(iout,505) modname
        WRITE(iout,*) '!---------------------------------------'
      
      CLOSE(iout)  

!--FORMATS--
 505  FORMAT('end module ',A20)
 515  FORMAT('    integer,parameter ::',A8,'=',i4)
      END

!---------------------------------
      SUBROUTINE header(iout,modname)
! writes top 3-4 lines of each module.

      INTEGER :: iout
      CHARACTER*20 modname

      WRITE(iout,*) ''
      WRITE(iout,500) modname
      IF(modname.NE.'bounds_mod')  WRITE(iout,*) ' use bounds_mod'
      WRITE(iout,*) ' implicit none'
      WRITE(iout,*) ' save'

 500  FORMAT('module ',A20)

      END SUBROUTINE header
!---------------------------------
      SUBROUTINE errstop(fi)
! stops program, returns error message
      CHARACTER*30 :: fi

      PRINT*,'!! Problem with input file ',fi
      STOP

      END SUBROUTINE errstop
!---------------------------------
