#! /bin/csh
#=======================================================================#
# Step2.csh - NCAR Master Mechanism calculation step 2: 
#             Set up time & radiation conditions and calculate j-values. 
# INPUTS (Described in WORK/README)
# input.solar => radiation, time conditions (optional)
#=======================================================================#

set compile = ` grep "compile" setup.dat | awk '{print $3}' `
set homedir = ` grep "homedir" setup.dat | awk '{print $3}' `
set tuvdir = ` grep "tuvdir" setup.dat | awk '{print $3}' `

if ( $#argv == 0 ) then
  echo '--ERROR-- Required syntax is "Step2.csh <runname>"' 
  exit
endif
echo '---------------------------------------------------------------'
echo ' NCAR MasterMechanism Step 2 : Calculate j-values: JBLOCK/TUV/ '
echo '---------------------------------------------------------------'
  
set runname = $argv[1]
echo 'runname = '$runname

set codedir1 = $homedir'/JBLOCK'
set codedir2 = $codedir1'/'$tuvdir
echo $codedir2
set workdir = $homedir'/WORK'
set tmpdir = $homedir'/TMP'
set logdir = $workdir'/'$runname

if (-e $logdir) then
   echo ' '
else
   echo ' '
   mkdir $logdir
endif

# delete previous versions of intermediate files
if (-e $tmpdir'/tmp.jv') then
   rm $tmpdir'/tmp.jv'
endif

# do the work:
if (-e input.solar) then
  cp input.solar $codedir2'/usrinp'
  echo 'copying WORK/input.solar for use as "usrinp"...'
endif
cd $codedir2
   make
   ./tuv
   cd INPUTS
   if (-e usrinp) then
     cp usrinp $workdir'/input.solar'
     echo 'updating input.solar'
   endif

cd $codedir1
   mv *.txt $tmpdir
   $compile jblock.f -o $tmpdir'/a.out'
cd $tmpdir
   ./a.out

# tidy up 
if (-e tmp.jv) then
   set result = ` wc -w tmp.jv |  awk '{print $1}'`
   if ($result == 0) then
      echo '!! Output file TMP/tmp.jv is empty. !!'
      echo '!!     Run aborting at Step 2       !!'
      exit
   endif

   echo '-----------------------------------------'
   echo ' Completed photolysis rate file = tmp.jv '
   echo '-----------------------------------------'

# move on
   cd $workdir
   echo ' Progress to Step 3, generate summary input file? (y/n)'
   set yn = $<
   if ($yn != 'y' && $yn != 'Y') then
      exit
   endif
./Step3.csh $runname 

# exit if no output
else
   echo 'ERROR : NO OUTPUT!'
   exit
endif

#############################################################
