#! /bin/csh
#=======================================================================#
# clean_MM.csh - remove executables and object files, and intermediate 
#                output, in preparation for a new NCARMM case
#=======================================================================#

set homedir = ` grep "homedir" setup.dat | awk '{print $3}' `
set tuvdir = ` grep "tuvdir" setup.dat | awk '{print $3}' `

echo '-------------------------------------------------------'
echo ' Cleaning NCAR MasterMechanism '
echo '-------------------------------------------------------'

  set mechdir = $homedir'/MM'
  echo 'mechdir = '$mechdir

  set tuvdir = $homedir'/JBLOCK/'$tuvdir
  echo 'tuvdir = '$tuvdir
  cd $tuvdir 
   rm *.o
   if -e tuv then 
     rm tuv
   endif
  cd INPUTS
   if -e usrinp then 
     rm usinp
   endif

  set tmpdir = $homedir'/TMP'
  echo 'tmpdir = '$tmpdir
  cd $tmpdir
   rm tmp.*
   rm solv.inp
   rm input.*
   rm *.txt
   rm bounds_mod.f90

  set postdir = $homedir'/POST'
  echo 'postdir = '$postdir
  cd $postdir
   rm *.o
   rm plotsel
   rm gmeta

  set workdir = $homedir'/WORK'
  echo 'workdir = '$workdir
  cd $workdir

#############################################################
