; Interpolate POLMIP model results to POLARCAT ATR flight tracks

pro extract_flttracks_atr

today = bin_date(systime())
todaystr = String(today[0:2],format='(i4," ",i2.2," ",i2.2)')

kboltz = 1.381e-23  ; J/K
mw_air = 29.  ;g/mole
Rgas = 287.   ;J/K-kg 

modelname = 'MOZART4geos'
modelname = 'LMDZ4INCA3'
modelname = 'gmi-geos5'
modelname = 'TOMCAT'
modelname = 'GEOSChem'
modelname = 'CIFS_v2'
modelname = 'CAMchem_GEOS5'
modelname = 'MOZART4lut'
modelname = 'CAM5chem'  ;'CESM1_CAM5Chem_GEOS5_tune_sadfix'
modelname = 'SMHI_MATCH'
modelname = 'TM5'

path_model = '/Volumes/data1/POLMIP/'+modelname+'/'

ac='atr'
campaign='POLARCAT'
datapath = '/Users/emmons/PROJECTS/POLMIP/aircraft/flight_tracks/'

; MOZART variables, with SFs to apply
varnames = ['temp','vmr_h2o', 'vmr_o3', 'vmr_co', 'vmr_no', 'vmr_no2', 'vmr_hno3', $
  'vmr_pan', 'vmr_noy', 'vmr_oh','vmr_ho2','vmr_ch3o2','vmr_ch3co3',  $
  'vmr_so2', 'vmr_isop', 'vmr_hcho', $
  'vmr_c2h2','vmr_c2h6', 'vmr_c3h8', 'vmr_acetone', 'vmr_ch3cho','vmr_h2o2','vmr_ch3ooh','vmr_methanol', $
  'vmr_ethanol','j_o3_o1d','j_no2','j_pan', $
  'vmr_co_a_as','vmr_co_f_as','vmr_co_a_na','vmr_co_f_na','vmr_co_a_eu','vmr_co_f_eu']
longnames = ['temperature','H2O','O3','CO','NO','NO2','HNO3', $
  'PAN','NOy','OH','HO2','CH3O2','CH3CO3', $
  'SO2','isoprene','formaldehyde', 'C2H2', $
  'C2H6','C3H8','acetone','acetaldehyde','H2O2','CH3OOH','methanol','ethanol','j_o3_o1d','j_no2','j_pan', $
  'co_a_as','co_f_as','co_a_na','co_f_na','co_a_eu','co_f_eu']
units = ['K','ppmv','ppbv','ppbv','pptv','pptv','pptv', $
  'pptv','pptv','pptv','pptv','pptv','pptv', $
  'pptv','pptv','pptv', 'pptv', $
  'pptv', 'pptv', 'pptv', 'pptv','pptv', 'pptv', 'pptv', 'pptv','1/s','1/s','1/s', $
  'ppbv','ppbv','ppbv','ppbv','ppbv','ppbv']
nvar = n_elements(varnames)
sf=fltarr(nvar)

for ivar=0,nvar-1 do begin
  if (units[ivar] eq 'ppbv') then sf[ivar] = 1.e9 else $
  if (units[ivar] eq 'pptv') then sf[ivar] = 1.e12 else $
  if (units[ivar] eq 'ppmv') then sf[ivar] = 1.e6 else $
  if (units[ivar] eq '%') then sf[ivar] = 100. else $
  sf[ivar] = 1.
  print,varnames[ivar],' ',longnames[ivar],' ',units[ivar],sf[ivar]
endfor
;stop

files = File_search(datapath+'polarcatflt_atr_*.dat',count=nfiles)

for iflt = 0,nfiles-1 do begin
 navfile = files[iflt]
 pos1 = strpos(navfile,'atr_')+4
 pos2 = strpos(navfile,'.dat')
 datestr = strmid(navfile,pos1,(pos2-pos1))
print,datestr
 year = Fix(Strmid(datestr,4,2))+2000
 month = Fix(Strmid(datestr,2,2))
 day = Fix(Strmid(datestr,0,2))
 if ((pos2-pos1) eq 7) then fltlab = Strmid(datestr,6,1) else fltlab = 'a'
 print,year,month,day,fltlab

 ndata = nlines(navfile)-1
 time_ac = fltarr(ndata)
 lat_ac = fltarr(ndata)
 lon_ac = fltarr(ndata)
 pres_ac = fltarr(ndata)
 openr,ilun,navfile,/get_lun
 sdum=' '
 readf,ilun,sdum
 dataline = fltarr(4)
 for i=0,ndata-1 do begin
   readf,ilun,dataline
   time_ac[i] = dataline[0]
   lat_ac[i] = dataline[1]
   lon_ac[i] = dataline[2]
   pres_ac[i] = dataline[3]
 endfor
 alt_ac = alt_pres(pres_ac)*0.001

; window,1
; !p.multi=[0,1,3]
; !p.charsize = 2.
; plot,time_ac,lat_ac,/xstyle,/ynozer
; plot,time_ac,lon_ac,/xstyle
; plot,time_ac,pres_ac,/xstyle,yrange=[1000,200]

 print,'A/C times: ',Min(time_ac),Max(time_ac)

 filedate = String(year,month,day,format='(i4,i2.2,i2.2)')
 mozfile = path_model + modelname+'_'+filedate+'.nc'
 if (modelname eq 'gmi-geos5') then mozfile = path_model + modelname+'_'+filedate+'_hourly.nc'
 if (modelname eq 'CIFS_v2') then mozfile = path_model +'CIFS_V2small_'+filedate+'.nc'
 if (modelname eq 'CAM5chem') then mozfile = path_model +'CESM1_CAM5Chem_GEOS5_tune_sadfix_'+filedate+'.nc'
 print,mozfile

 ncid = ncdf_open(mozfile)
 ncdf_varget,ncid,'lon',lon
 ncdf_varget,ncid,'lat',lat
 ncdf_varget,ncid,'lev',lev
 ncdf_varget,ncid,'time',time
 ncdf_attget,ncid,'time','units',units_time
 print,String(units_time)
 print,time
 if (modelname eq 'CAMchem_GEOS5' or modelname eq 'MOZART4geos' or modelname eq 'CAM5chem') then begin
   ncdf_varget,ncid,'datesec',time
   if time[23] eq 0 then time[23]=86400.
 endif  else if (modelname eq 'GEOSChem') then begin
   time=(indgen(24)+1)*3600.
 endif else begin
   time=indgen(24)*3600.
 endelse
 print,'time: ',time

 nlon = n_elements(lon)
 nlat = n_elements(lat)
 nlev = n_elements(lev)
 ntim = n_elements(time)

 varid = ncdf_varid(ncid,'pres')
 if (varid ge 0) then begin
   ncdf_varget,ncid,'pres',pres
 endif else begin
   ncdf_varget,ncid,'ps',ps
   ncdf_varget,ncid,'p0',p0
   ncdf_varget,ncid,'a',a
   ncdf_varget,ncid,'b',b
   pres = fltarr(nlon,nlat,nlev,24)
   for ilon=0,nlon-1 do begin
    for ilat=0,nlat-1 do begin
     for ihr = 0,23 do begin
      pres[ilon,ilat,*,ihr] = a[*]*p0 + b[*]*ps[ilon,ilat,ihr]
     endfor
    endfor
   endfor
 endelse

 ;fix for GEOS-chem
 ind = where(lon lt 0,nneg)
 if (nneg gt 0) then lon[ind] = lon[ind]+360

 ;check if pres is in Pa or hPa
 if (max(pres) gt 90000) then sf_pres = 0.01 else sf_pres = 1.
 print,max(pres),min(pres),sf_pres

 print,String(units_time)
 ;GEOSchem time in YYYYMMDDHH - convert to seconds of day
 if (modelname eq 'GEOSchem') then begin
   for itim=0,ntim-1 do time[itim] = (itim+1)*3600.
 endif
 print,time

 ; if flight time goes beyond MOZART time, get next MZ file
 twofiles = 0  
 if (time[ntim-1] lt time_ac[ndata-1]) then begin
    twofiles = 1
    filedate = String(year,month,day+1,format='(i4,i2.2,i2.2)')
    mozfile2 = path_model + modelname+'_'+filedate+'.nc'
    if (modelname eq 'CIFS_v2') then mozfile = path_model +'CIFS_V2small_'+filedate+'.nc'
    if (modelname eq 'gmi-geos5') then mozfile2 = path_model + modelname+'_'+filedate+'_hourly.nc'
    if (modelname eq 'CAM5chem') then mozfile2 = path_model +'CESM1_CAM5Chem_GEOS5_tune_sadfix_'+filedate+'.nc'
    print,'Also reading: ',mozfile2
    ncid2 = ncdf_open(mozfile2)

    ; read time and append to 1st file
    ncdf_varget,ncid2,'time',time_2
    if (modelname eq 'CAMchem_GEOS5' or modelname eq 'MOZART4lut') then begin
     ncdf_varget,ncid,'datesec',time_2
     if time_2[23] eq 0 then time_2[23]=86400.
    endif  else if (modelname eq 'GEOSChem') then begin
     time_2=(indgen(24)+1)*3600.
    endif else begin
     time_2=indgen(24)*3600.
    endelse
    ntim1 = ntim
    ntim2 = n_elements(time_2)
    ntim = ntim1 + ntim2
    secs_moz = fltarr(ntim)
    secs_moz[0:(ntim1-1)] = time
    for itim = ntim1,ntim-1 do begin
      secs_moz[itim] = time_2[itim-ntim1] + 86400.
    endfor

    ; read pres and append to 1st file
    varid = ncdf_varid(ncid2,'pres')
    if (varid ge 0) then begin
     ncdf_varget,ncid2,'pres',pres_2
    endif else begin
     ncdf_varget,ncid,'ps',ps
     ncdf_varget,ncid,'p0',p0
     ncdf_varget,ncid,'a',a
     ncdf_varget,ncid,'b',b
     pres_2 = fltarr(nlon,nlat,nlev,24)
     for ilon=0,nlon-1 do begin
      for ilat=0,nlat-1 do begin
       for ihr = 0,23 do begin
        pres_2[ilon,ilat,*,ihr] = a[*]*p0 + b[*]*ps[ilon,ilat,ihr]
       endfor
      endfor
     endfor
    endelse
    pres_1 = pres
    pres = fltarr(nlon,nlat,nlev,ntim)
    pres[*,*,*,0:ntim1-1] = pres_1
    pres[*,*,*,ntim1:ntim-1] = pres_2

 endif else begin
    secs_moz = time
 endelse

 for itim = 0,ntim-1 do print,itim,': ',secs_moz[itim]

 if (lat[1] lt lat[0]) then reverse_lat = 1 else reverse_lat = 0
 if (reverse_lat eq 1) then begin
   print,'Reversing lat'
   lat = Reverse(lat)
   pres = Reverse(pres,2)
 endif
 if (modelname eq 'gmi-geos5') then lat[0]=-90.

 imzlat = fltarr(ndata)
 imzlon = fltarr(ndata)
 imzalt = fltarr(ndata)
 imztim = fltarr(ndata)
 trackalt = fltarr(ndata)
 no_model = intarr(ndata)
 dlon = lon[1]-lon[0]
 dlat = lat[2]-lat[1]

 print,'kmoz,time_ac[ipos],imztim[ipos],Interpolate(secs_moz,imztim[ipos])'
 for ipos = 0,ndata-1 do begin

    ; find MOZART time index
    if (time_ac[ipos] le secs_moz[0]) then begin
      print,'a/c starts before model'
      ;kmoz = 0
      stop
    endif else if (time_ac[ipos] ge secs_moz[ntim-1]) then begin
      print,'a/c ends after model'
      ;kmoz = ntim-1
      stop
    endif else begin
     for itim=1,ntim-1 do begin
      if ((time_ac[ipos] ge secs_moz[itim-1]) and (time_ac[ipos] lt secs_moz[itim])) $
       then kmoz = itim
     endfor
    endelse
    if (kmoz gt 0) then begin
     delt = float(time_ac[ipos]-secs_moz[kmoz-1]) / (secs_moz[kmoz]-secs_moz[kmoz-1])
     imztim[ipos] = (kmoz-1 + delt) < (ntim-1.)
    endif else imztim[ipos] = 0.

    ; Calculate interpolated indices
    if (lat_ac[ipos] gt lat[0]) then begin
     imzlat[ipos] = ((lat_ac[ipos]-lat[0]))/dlat
     if (min(lon) lt 0.) then begin
        if (lon_ac[ipos] gt 180) then lon_ac[ipos]=lon_ac[ipos]-360.
     endif else begin
        if (lon_ac[ipos] lt 0) then lon_ac[ipos]=lon_ac[ipos]+360.
     endelse
     imzlon[ipos] = (lon_ac[ipos]-lon[0])/dlon
    endif else if (lat_ac[ipos] lt -90) then begin
      lat_ac[ipos] = -99999.
      lon_ac[ipos] = -99999.
      alt_ac[ipos] = -99999.
      pres_ac[ipos] = -99999.
    endif else begin
      no_model[ipos] = 1
    endelse

    if (ipos eq 5) then print,' ... '
    if (ipos lt 5 or ipos gt ndata-5) then $
      print,kmoz,time_ac[ipos],imztim[ipos],Interpolate(secs_moz,imztim[ipos]), $
            imzlat[ipos],lat_ac[ipos],Interpolate(lat,imzlat[ipos]), $
            imzlon[ipos],lon_ac[ipos],Interpolate(lon,imzlon[ipos])
 endfor

 tracklat = Interpolate(lat,imzlat)
 tracklon = Interpolate(lon,imzlon)

;window,0
;!p.multi=[0,1,1]
plot,lon_ac,lat_ac,psym=4,/ynozero,title=sdate
oplot,tracklon,tracklat

 mozdata=fltarr(nvar,ndata)-99999.

 ; Interpolate model pressure to lat,lon,time of aircraft track for each model level 
 pres_prof_track = fltarr(ndata,nlev)
 for ilev = 0,nlev-1 do begin
   pres1 = Reform(pres[*,*,ilev,*])
   pres_prof_track[*,ilev] = Interpolate(pres1,imzlon,imzlat,imztim)
 endfor

 for ivar=0,nvar-1 do begin
  print,varnames[ivar],' ',sf[ivar],units[ivar]

  ;check for variable
  varid = ncdf_varid(ncid,varnames[ivar])
  if (varid lt 0) then goto,skipvar
  ;if (varnames[ivar] eq 'vmr_c2h2' and modelname eq 'CAMchem_GEOS5') then goto,skipvar

  ; read variable from NC files
  ncdf_varget,ncid,varnames[ivar],data
  print,min(data),max(data)
  if (twofiles) then begin
    ncdf_varget,ncid2,varnames[ivar],data_2
    data_1 = data
    data = fltarr(nlon,nlat,nlev,ntim)
    data[*,*,*,0:ntim1-1] = data_1
    data[*,*,*,ntim1:ntim-1] = data_2
  endif
  data = data*sf[ivar]
  if (reverse_lat eq 1) then begin
   data = Reverse(data,2)
  endif

  ; Interpolate to lat,lon,time of aircraft track for each model level 
  data_prof_track = fltarr(ndata,nlev)
  for ilev = 0,nlev-1 do begin
    data1 = Reform(data[*,*,ilev,*])
    data_prof_track[*,ilev] = Interpolate(data1,imzlon,imzlat,imztim)
  endfor

  ; For each aircraft point, interpolate to pressure of obs
  for ipos=0,ndata-1 do begin
   if (lat_ac[ipos] gt -90 and no_model[ipos] eq 0) then begin
    pres1 = reform(pres_prof_track[ipos,*]) * sf_pres ;convert to hPa
    data1 = reform(data_prof_track[ipos,*])
    pmax = max(pres1,imax)
    if (pres_ac[ipos] gt pmax) then begin
      pmax = max(pres1,imax)
      mozdata[ivar,ipos] = data1[imax]
    endif else mozdata[ivar,ipos] = Interpol(data1,pres1,pres_ac[ipos])
   endif
  endfor
  skipvar:
 endfor  ;ivar
 ncdf_close,ncid


 ; write to ICT file
 outfile = './model_tracks/'+modelname+'_POLMIP_'+filedate+fltlab+'_R3_'+Strupcase(ac)+'.ict'
 print,outfile

 nvar_all = nvar+4
 scale = strarr(nvar_all)+'1'
 miss=strarr(nvar_all)+ '-99999'
 names_all = ['Lat', 'Lon', 'Alt', 'Pres', longnames]
 units_all = ['degN', 'degE', 'km', 'hPa', units]
 colnames = strarr(nvar_all+1)
 colnames[0] = 'UTC_seconds'
 for i=1,nvar_all do colnames[i] = names_all[i-1]+'_'+units_all[i-1]

 ncomments = 18
 nhead = 12 + nvar_all + 2 + ncomments
 datestr = Strmid(filedate,0,4)+' '+Strmid(filedate,4,2)+' '+Strmid(filedate,6,2)+' '+todaystr
 pos1 = Strpos(navfile,'/',/reverse_search)
 navfilename = Strmid(navfile,pos1+1)

 close,1
 openw,1,outfile
 printf,1,format='(i0," 1001")',nhead
 printf,1,'Louisa Emmons'
 printf,1,'NCAR'
 printf,1,modelname+' results for '+Strupcase(ac)+' flight on '+filedate+'. Based on 60 sec merge.'
 printf,1,campaign
 printf,1,'1 1'
 printf,1,datestr
 printf,1,'60'
 printf,1,'UTC, s'
 printf,1,Strtrim(nvar_all,2)
 printf,1,Strjoin(scale,' ')
 printf,1,Strjoin(miss,' ')
 for i=0,nvar_all-1 do printf,1,Strtrim(names_all[i],2),', ',Strtrim(units_all[i],2)
 printf,1,'0'
 printf,1,strtrim(ncomments,2)
 printf,1,'PI_CONTACT_INFO: emmons@ucar.edu'
 printf,1,'PLATFORM: Model results interpolated to '+Strupcase(ac)+' aircraft location'
 printf,1,'LOCATION:  Latitude, Longitude, and Altitude included in data records, from '+navfilename
 printf,1,'ASSOCIATED_DATA: N/A'
 printf,1,'INSTRUMENT_INFO: N/A'
 printf,1,'DATA_INFO: '
 printf,1,'UNCERTAINTY: N/A'
 printf,1,'ULOD_FLAG: -77777'
 printf,1,'ULOD_VALUE: N/A'
 printf,1,'LLOD_FLAG: -88888'
 printf,1,'LLOD_VALUE: N/A'
 printf,1,'DM_CONTACT_INFO: emmons@ucar.edu'
 printf,1,'PROJECT_INFO: ARCTAS April-July 2008'
 printf,1,'STIPULATIONS_ON_USE: Please contact Louisa Emmons before use in presentation or publication.'
 printf,1,'Emissions: D.Streets ARCTAS-v1.2 anthro inventory and FINNv1 fire emissions (C.Wiedinmyer)'
 printf,1,'REVISION: R0'
 printf,1,'R0: Interpolated from hourly output of POLMIP simulation.'
 printf,1,Strjoin(colnames,' ')

 fmtstr = '(i8,2f12.2,f12.3,f12.1,'+String(nvar,format='(i0)')+'(e12.4))'
 for i=0,ndata-1 do begin
      printf,1, format=fmtstr,time_ac[i],lat_ac[i],lon_ac[i],alt_ac[i],pres_ac[i],Reform(mozdata[*,i])
 endfor
 close,1

endfor

end
