
      module mo_constants

      use mo_grid, only : plat, plon

      implicit none

      save

      real, parameter ::  gravit   = 9.80616          ! m/s
      real, parameter ::  rgrav    = 1./gravit
      real, parameter ::  dayspy   = 365.             ! days per year
      real, parameter ::  rearth   = 6.37122e6        ! radius earth (m)
      real, parameter ::  avogadro = 6.023e23         ! Avogadro number
      real, parameter ::  boltz    = 1.38044e-16      ! erg/k

      real ::  pi                 ! radians
      real ::  twopi              ! 2*pi (radians)
      real ::  pid2               ! pi/2 (radians)
      real ::  r2d                ! radians to degrees
      real ::  d2r                ! degrees to radians 
      real ::  lat25 = 0.         ! 25 latitude (radians)
      real ::  lat45 = 0.         ! 45 latitude (radians)
      real ::  lat59 = 0.         ! 59 latitude (radians)
      real ::  lat60 = 0.         ! 60 latitude (radians)
      real ::  lat70 = 0.         ! 70 latitude (radians)
      real ::  phi(plat)          ! latitudes (radians)
      real ::  latwts(plat)       ! latitude weights
      real ::  lam(plon)          ! longitudes( radians )
      real ::  sinlam(plon)       ! sine of longitudes
      real ::  coslam(plon)       ! cose of longitudes

      contains

      subroutine mo_constants_inti

      implicit none

!     pi     = 4.*atan( 1. )
      pi     = z'400921fd54442d18'
      twopi  = 2.*pi
      pid2   = .5*pi
      d2r    = pi/180.
      r2d    = 180./pi

      lat25 = d2r * 25.
      lat45 = d2r * 45.
      lat59 = d2r * 59.
      lat60 = d2r * 60.
      lat70 = d2r * 70.

      end subroutine mo_constants_inti

      end module mo_constants
