
      module mo_iniqth

      private
      public :: iniqth

      contains

      subroutine iniqth( ps, sh, t, nadv, x, &
                         plonl, platl, pplon )
!---------------------------------------------------------------------
! 	... Initialize the array of misc advected variables with q and theta
!---------------------------------------------------------------------

      use mo_mpi
      use plevs,      only : plevs0
      use mo_grid,    only : plev, plevp
      use mo_pottemp, only : t2pt
      use mo_control, only : xactive_h2o

      implicit none

!---------------------------------------------------------------------
! 	... Dummy arguments
!---------------------------------------------------------------------
      integer, intent(in) :: &
        plonl, &
        platl, &
        pplon
      integer, intent(in) :: &
        nadv                             ! number of misc adv var
      real, intent(in) :: &
        ps(plonl,-3:platl+4,pplon)       ! surface pressure
      real, dimension(plonl,plev,platl,pplon), intent(in) :: &
        sh, &                            ! specific humidity
        t                                ! temperature

      real, intent(inout) :: &
        x(plonl,plev,nadv,platl,pplon)   ! misc advected variables

!---------------------------------------------------------------------
! 	... Local variables
!---------------------------------------------------------------------
      integer :: &
        i, ip, j, k
      real, dimension(plonl,plevp) :: &
        pint                   ! pressure at layer interfaces
      real, dimension(plonl,plev) :: &
        pmid, &                ! pressure at layer midpoints
        pdel                   ! pressure difference across layers

has_xactive_h2o : &
      if( .not. xactive_h2o ) then
         if( pplon > 1 ) then
!$omp parallel do private( i, ip, j, k, pmid, pint, pdel )
            do ip = 1,pplon
               do j = 1,platl
                  call plevs0( ps(1,j,ip), pint, pmid, pdel, plonl )
                  do k = 1,plev
                     do i = 1,plonl
                        x(i,k,1,j,ip) = sh(i,k,j,ip)
                     end do
                  end do
                  call t2pt( t(1,1,j,ip), pmid, x(1,1,2,j,ip), plonl )
               end do
            end do
!$omp end parallel do
         else
!$omp parallel do private( i, j, k, pmid, pint, pdel )
            do j = 1,platl
               call plevs0( ps(1,j,1), pint, pmid, pdel, plonl )
               do k = 1,plev
                  do i = 1,plonl
                     x(i,k,1,j,1) = sh(i,k,j,1)
                  end do
               end do
               call t2pt( t(1,1,j,1), pmid, x(1,1,2,j,1), plonl )
            end do
!$omp end parallel do
         end if
      else has_xactive_h2o
         if( pplon > 1 ) then
!$omp parallel do private( i, ip, j, k, pmid, pint, pdel )
            do ip = 1,pplon
               do j = 1,platl
                  call plevs0( ps(1,j,ip), pint, pmid, pdel, plonl )
                  call t2pt( t(1,1,j,ip), pmid, x(1,1,2,j,ip), plonl )
               end do
            end do
!$omp end parallel do
         else
!$omp parallel do private( i, j, k, pmid, pint, pdel )
            do j = 1,platl
               call plevs0( ps(1,j,1), pint, pmid, pdel, plonl )
               call t2pt( t(1,1,j,1), pmid, x(1,1,2,j,1), plonl )
            end do
!$omp end parallel do
         end if
      end if has_xactive_h2o

      end subroutine iniqth

      end module mo_iniqth
