
      module mo_init_species

      contains

      subroutine initr0( as, ps, phi, plonl, platl, pplon )
!---------------------------------------------------------------------
! 	... initialize tracer concentrations
!---------------------------------------------------------------------

      use mo_grid, only : plat, pcnst, plev, plevp
      use plevs,   only : plevs0
      use mo_mpi,  only : base_lat

      implicit none

!---------------------------------------------------------------------
! 	... dummy arguments
!---------------------------------------------------------------------
      integer, intent(in) :: &
	   plonl, &
	   platl, &
	   pplon
      real, intent(in) :: &
           ps(plonl,-3:platl+4,pplon), & ! surface pressure ( pascals )
           phi(plat)                     ! latitudes (radians)

      real, intent(out) :: &
        as(plonl,plev,pcnst,platl,pplon) ! advected species

!---------------------------------------------------------------------
! 	... local variables
!---------------------------------------------------------------------
      integer :: &
        i, ip, j, jglob, k, m   ! indices
      real :: pcrit
      real, dimension(plonl,plev) :: &
              pmid, &
              pdel
      real :: pint(plonl,plevp)

      if( pplon > 1 ) then
!$omp parallel do private( i, ip, j, jglob, k, m, pcrit, pmid, pint, pdel )
         do ip = 1,pplon
            do j = 1,platl
	       jglob = j + base_lat
               call plevs0( ps(1,j,ip), pint, pmid, pdel, plonl )
               pcrit = (200. - 100.*cos( phi(jglob) ))*100.
               do m = 1,pcnst
                  do k = 1,plev
                     do i = 1,plonl
                        as(i,k,m,j,ip) = 0.
		     end do
                  end do
               end do
               do k = 1,plev
	          do i = 1,plonl
	             if( pmid(i,k) <= pcrit ) then
                        as(i,k,1,j,ip) = 1.
                     else
                        as(i,k,1,j,ip) = 0.
                     end if
                     as(i,k,2,j,ip) = 1. - as(i,k,1,j,ip)
                     as(i,k,3,j,ip) = real(k)/real(plev)
                     as(i,k,4,j,ip) = 1.e-6
                     as(i,k,5,j,ip) = 8.e-6*exp( -1.2*(1. - log10( pmid(i,k)*1.e-2 ))**2 )
                     do m = 6,pcnst-1
 		        as(i,k,m,j,ip) = 1.e-9
 	             end do
                  end do
               end do
            end do
         end do
!$omp end parallel do
      else
!$omp parallel do private( i, j, k, m, pcrit, pmid, pint, pdel )
         do j = 1,platl
            call plevs0( ps(1,j,1), pint, pmid, pdel, plonl )
            pcrit = (200. - 100.*cos( phi(j) ))*100.
            do m = 1,pcnst
               do k = 1,plev
                  do i = 1,plonl
                     as(i,k,m,j,1) = 0.
	          end do
               end do
            end do
            do k = 1,plev
	       do i = 1,plonl
	          if( pmid(i,k) <= pcrit ) then
                     as(i,k,1,j,1) = 1.
                  else
                     as(i,k,1,j,1) = 0.
                  end if
                  as(i,k,2,j,1) = 1. - as(i,k,1,j,1)
                  as(i,k,3,j,1) = real(k)/real(plev)
                  as(i,k,4,j,1) = 1.e-6
                  as(i,k,5,j,1) = 8.e-6*exp( -1.2*(1. - log10( pmid(i,k)*1.e-2 ))**2 )
                  do m = 6,pcnst-1
 		     as(i,k,m,j,1) = 1.e-9
 	          end do
               end do
            end do
         end do
      end if

      end subroutine initr0

      end module mo_init_species
