
      module MO_MSCOMMENT

      CONTAINS

      subroutine DATECOM( ncdate, ncsec, com )
!-----------------------------------------------------------------------
! 	... Build string containing day and date interval info.
!-----------------------------------------------------------------------

      use MO_CHARUTL, only : I2CHAR

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: &
        ncdate, &                       ! current date
        ncsec                           ! seconds relative to ncdate
      
      character(len=*), intent(out) :: &
        com                             ! comment field for mass storage system

!-----------------------------------------------------------------------
! 	... Local variables
!-----------------------------------------------------------------------
      integer :: &
        i, &
        lenc, &                    ! accumulate length of com string as it is built
        kblen, &                   ! length of strings from i2char
        khour
      real :: &
        hour
      character(len=20) :: &
        nctemp                     ! string from i2char
      character(len=80) :: &
        chtem                      ! string for temporary copies of com

      lenc   = 0
      hour   = REAL(ncsec)/3600.
      khour  = INT(hour)
      nctemp = I2CHAR( khour, kblen )
      com    = 'DATE: ' // nctemp(:kblen) // '.'
      lenc   = lenc + kblen + 7
      khour  = INT((hour - REAL(khour))*1000. + 1000.)
      nctemp = I2CHAR( khour, kblen )
      chtem  = com(:lenc) // nctemp(2:4) // 'Z '
      lenc   = lenc + 5
      nctemp = I2CHAR( ncdate, kblen )
      com    = chtem(:lenc) // nctemp(:kblen)
      lenc   = lenc + kblen

      if( lenc < LEN(com) ) then
         com(lenc+1:LEN(com)) = ' '
      end if

      end subroutine DATECOM

      subroutine DDICOM( ndcurf, nscurf, ndcur, nscur, ncdatf, &
			 ncsecf, ncdate, ncsec, com )
!-----------------------------------------------------------------------
! 	... Build string containing day and date interval info
!-----------------------------------------------------------------------

      use MO_CHARUTL, only : I2CHAR

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: &
        ndcurf, &                            ! first day
        nscurf, &                            ! seconds relative to ndcurf
        ndcur, &                             ! current day
        nscur, &                             ! seconds relative to ndcur
        ncdatf, &                            ! first date
        ncsecf, &                            ! seconds relative to ncdatf
        ncdate, &                            ! current date
        ncsec                                ! seconds relative to ncdate
      
      character(len=*), intent(out) :: &
        com                                  ! comment field for mass storage system

!-----------------------------------------------------------------------
! 	... Local variables
!-----------------------------------------------------------------------
      integer :: &
        i, &
        lenc, &                         ! accumulate length of com string as it is built
        kblen, &                        ! length of strings from i2char
        kdayno, &                       ! 3 digit fractional part of day converted to an integer
        khour
      real :: &
        hour
      character(len=20) :: &
        nctemp     ! string from i2char
      character(len=80) :: &
        chtem      ! string for temporary copies of com

      com(1:LEN(com)) = ' '
      lenc            = 0

!-----------------------------------------------------------------------
!     	... Number of first day in file
!-----------------------------------------------------------------------
      nctemp = I2CHAR( ndcurf, kblen )
      com    = 'DAYS: ' // nctemp(:kblen) // '.'
      lenc   = lenc + kblen + 7
      kdayno = INT((REAL(nscurf)/86400.)*1000.) + 1000.
      nctemp = I2CHAR( kdayno, kblen )
      chtem  = com(:lenc) // nctemp(2:4) // '-'
      lenc   = lenc + 4

!-----------------------------------------------------------------------
!     	... Number of last day in file
!-----------------------------------------------------------------------
      nctemp = I2CHAR( ndcur, kblen )
      com    = chtem(:lenc) // nctemp(:kblen) // '.'
      lenc   = lenc + kblen + 1
      kdayno = INT((REAL(nscur)/86400.)*1000.) + 1000.
      nctemp = I2CHAR( kdayno, kblen )
      chtem  = com(:lenc) // nctemp(2:4) // ' DATES: '
      lenc   = lenc + 11

!-----------------------------------------------------------------------
!     	... First date on file
!-----------------------------------------------------------------------
      hour   = REAL(ncsecf)/3600.
      khour  = INT(hour)
      nctemp = I2CHAR( khour, kblen )
      com    = chtem(:lenc) // nctemp(:kblen) // '.'
      lenc   = lenc + kblen + 1
      khour  = INT((hour - REAL(khour))*1000. + 1000.)
      nctemp = I2CHAR( khour, kblen )
      chtem  = com(:lenc) // nctemp(2:4) // 'Z '
      lenc   = lenc + 5
      nctemp = I2CHAR( ncdatf, kblen )
      com    = chtem(:lenc) // nctemp(:kblen) // ' - '
      lenc   = lenc + kblen + 3

!-----------------------------------------------------------------------
!     	... Last date on file
!-----------------------------------------------------------------------
      hour   = REAL(ncsec)/3600.
      khour  = INT(hour)
      nctemp = I2CHAR( khour, kblen )
      chtem  = com(:lenc) // nctemp(:kblen) // '.'
      lenc   = lenc + kblen + 1
      khour  = INT((hour - REAL(khour))*1000. + 1000.)
      nctemp = I2CHAR( khour, kblen )
      com    = chtem(:lenc) // nctemp(2:4) // 'Z '
      lenc   = lenc + 5
      nctemp = I2CHAR( ncdate, kblen )
      chtem  = com(:lenc) // nctemp(:kblen)
      lenc   = lenc + kblen

      com = chtem(:lenc)

      end subroutine DDICOM

      end module MO_MSCOMMENT
