
      module MO_POTTEMP
!-----------------------------------------------------------------------
! 	... Data for potential temperature calculations
!-----------------------------------------------------------------------

      implicit none

      private
      public :: inipottem, t2pt, pt2t

      save

      real, private :: &
        cappa, &   ! R / Cp for dry air
        p0         ! reference pressure (1.e5 Pa)


      CONTAINS

      subroutine INIPOTTEM( xcappa )
!-----------------------------------------------------------------------
! 	... Initialize module
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      real, intent(in) :: &
        xcappa      ! R / Cp for dry air

      cappa = xcappa
      p0    = 1.e5

      end subroutine INIPOTTEM

      subroutine T2PT( t, pmid, th, plonl )
!-----------------------------------------------------------------------
! 	... Compute potential temperature
!-----------------------------------------------------------------------

      use MO_GRID, only : plev

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: &
	plonl
      real, dimension(plonl,plev), intent(in) :: &
        t, &              ! temperature (K)
        pmid              ! midpoint pressures (Pa)

      real, intent(out) :: &
        th(plonl,plev)    ! potential temperature (K)

!-----------------------------------------------------------------------
! 	... Local variables
!-----------------------------------------------------------------------
      integer :: k

      do k = 1, plev
         th(:,k) = t(:,k)*(p0/pmid(:,k))**cappa
      end do

      end subroutine T2PT

      subroutine PT2T( th, pmid, t, plonl )
!-----------------------------------------------------------------------
! 	... Convert potential temperature back to temperature
!-----------------------------------------------------------------------

      use MO_GRID, only : plev

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: &
	plonl
      real, dimension(plonl,plev), intent(in) :: &
        th, &             ! potential temperature (K)
        pmid              ! midpoint pressures (Pa)

      real, dimension(plonl,plev), intent(out) :: &
        t                ! temperature (K)

!-----------------------------------------------------------------------
! 	... Local variables
!-----------------------------------------------------------------------
      integer :: k

      do k = 1, plev
         t(:,k) = th(:,k)*(pmid(:,k)/p0)**cappa
      end do

      end subroutine PT2T

      end module MO_POTTEMP
