
      module mo_cnum

      private
      public :: cnum

      contains

      subroutine cnum( mix, denx, cden, molw, rm, &
                       rw, num, weight )
!-----------------------------------------------------------------------------
!   	... calculate aerosol num and percent weigh
!-----------------------------------------------------------------------------

      use mo_params
      use mo_grid,      only : plevp
      use mo_constants, only : pi, avogadro

      implicit none

!-----------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------
      real, intent(in)  ::  cden
      real, intent(in)  ::  molw
      real, intent(in)  ::  rm
      real, intent(in)  ::  rw(plevp)
      real, intent(in)  ::  mix(plevp)
      real, intent(in)  ::  denx(plevp)
      real, intent(out) ::  num(plevp)
      real, intent(out) ::  weight(plevp)

!-----------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------
      real    :: factor, rm3
      real    :: const0
      real    :: mas(plevp)
      real    :: masw(plevp)

!-----------------------------------------------------------------------------
!  	... convert volume mix ratio to mass (SOOT)
!-----------------------------------------------------------------------------
      const0    = 4. * pi / 3.
      rm3       = rm*rm*rm
      factor    = 1./(const0 * cden * 1.e-12 * rm3)
      mas(:)    = mix(:) * denx(:) / avogadro * molw                       ! gram/cm3 carbon      
      num(:)    = mas(:) *factor
      weight(:) = cden/(cden + (rw(:)/rm)**3 - 1.)                         ! weight percentage (%*0.01)
      weight(:) = max( 0.,min( 1.,weight(:) ) )
       
      end subroutine cnum

      end module mo_cnum


