
      module mo_jpl

      contains

      subroutine jpl( rate, m, factor, ko, kinf, plnplv )
!-----------------------------------------------------------------
!        ... Calculate JPL troe rate
!-----------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------
      integer, intent(in) :: plnplv
      real, intent(in)  ::   factor
      real, intent(in)  ::   ko(plnplv)
      real, intent(in)  ::   kinf(plnplv)
      real, intent(in)  ::   m(plnplv)
      real, intent(out) ::   rate(plnplv)

!-----------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------
      real  ::     xpo(plnplv)
      

      xpo(:)  = ko(:) * m(:) / kinf(:)
      rate(:) = ko(:) / (1. + xpo(:))
      xpo(:)  = log10( xpo(:) )
      xpo(:)  = 1. / (1. + xpo(:)*xpo(:))
      rate(:) = rate(:) * factor**xpo(:)

      end subroutine jpl

      end module mo_jpl
