
      module mo_read_sim_chm

      private
      public :: read_sim_chm

      contains

      subroutine read_sim_chm( sim_data_flsp, hstinst, hsttimav, sim_file_cnt )
!--------------------------------------------------------
!    	... initialize chemistry modules
!--------------------------------------------------------

      use mo_histout,    only : hfile, hst_file_max, moz_file_cnt, &
                                match_file_cnt
      use m_tracname,    only : tracnam, natsnam
      use mass_diags,    only : ndiags
      use mo_file_utils, only : navu
      use mo_local_time, only : local_time, local_time_char
      use m_types,       only : hst_list, hstdim

      implicit none

!--------------------------------------------------------
!    	... dummy args
!--------------------------------------------------------
      integer, intent(out)          :: sim_file_cnt
      character(len=32), intent(in) :: sim_data_flsp
      type(hst_list), intent(in)    :: hstinst(hst_file_max)
      type(hst_list), intent(in)    :: hsttimav(hst_file_max)

!--------------------------------------------------------
!    	... local variables
!--------------------------------------------------------
      integer, parameter :: inst = 1
      integer, parameter :: avrg = 2
      integer, parameter :: max_hst_ind = 22
      integer  ::  i, k, ios, astat, funit, file
      integer  ::  start, end
      integer  ::  starti, endi
      integer, dimension(2)               ::  moz_cnt
      integer, allocatable, dimension(:)  ::  minst , mtimav

      funit = navu()
!--------------------------------------------------------
!    	... open chem input unit
!--------------------------------------------------------
      open( unit = funit, &
            file = trim( sim_data_flsp ), &
            status = 'old', &
            recl   = 2048, &
            iostat = ios )
      if( ios /= 0 ) then
         write(*,*) ' read_sim_chm: Failed to open file ',trim( sim_data_flsp )
         write(*,*) ' Error code = ',ios
         call endrun
      end if

      read(funit,'(i4)',iostat=ios) moz_file_cnt
      if( ios /= 0 ) then
         write(*,*) 'read_sim_chm: Failed to read moz_file_cnt; error = ',ios
	 call endrun
      end if
      sim_file_cnt = max( moz_file_cnt,match_file_cnt )
      do file = 1,moz_file_cnt
         read(funit,'(10i4)',iostat=ios) hfile(file)%histout_cnt(:,:)
         if( ios /= 0 ) then
            write(*,*) 'read_sim_chm: Failed to read histout_cnt for file ',file,'; error = ',ios
	    call endrun
         end if
      end do

file_loop : &
      do file = 1,sim_file_cnt
         do k = 1,hstdim
	    if( hstinst(file)%list(k) == ' ' ) then
	       exit
	    end if
         end do
         hfile(file)%match_cnt(inst) = k - 1
         do k = 1,hstdim
	    if( hsttimav(file)%list(k) == ' ' ) then
	       exit
	    end if
         end do
         hfile(file)%match_cnt(avrg) = k - 1
         do i = inst,avrg
            moz_cnt(i) = sum( hfile(file)%histout_cnt(:,i) )
         end do
         hfile(file)%mxoutflds = max( hfile(file)%match_cnt(inst)+moz_cnt(inst), &
                                      hfile(file)%match_cnt(avrg)+moz_cnt(avrg) )
         allocate( minst(hfile(file)%mxoutflds), mtimav(hfile(file)%mxoutflds), stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'read_sim_chm: Failed to allocate minst,mtimav; error = ',astat
	    call endrun
         end if
         allocate( hfile(file)%outinst(hfile(file)%mxoutflds), &
                   hfile(file)%outtimav(hfile(file)%mxoutflds), stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'read_sim_chm: Failed to allocate outinst,outtimav for file ',file,'; error = ',astat
	    call endrun
         end if
         minst(:)  = 0
         mtimav(:) = 0
         if( hfile(file)%match_cnt(inst) > 0 ) then
            hfile(file)%outinst(:hfile(file)%match_cnt(inst)) = hstinst(file)%list(:hfile(file)%match_cnt(inst))
         end if
         if( hfile(file)%match_cnt(avrg) > 0 ) then
            hfile(file)%outtimav(:hfile(file)%match_cnt(avrg)) = hsttimav(file)%list(:hfile(file)%match_cnt(avrg))
         end if

time_type_loop : &
         do i = inst,avrg
            end = hfile(file)%match_cnt(i)
	    endi = 0
output_type_loop : &
            do k = 1,max_hst_ind
has_output :   if( hfile(file)%histout_cnt(k,i) /= 0 ) then
	          start  = end + 1
	          end    = start + hfile(file)%histout_cnt(k,i) - 1
	          starti = endi + 1
	          endi   = starti + hfile(file)%histout_cnt(k,i) - 1
	          hfile(file)%histout_ind(k,i) = starti
	          if( i == inst ) then
                     read(funit,'(4a32)',iostat=ios) hfile(file)%outinst(start:end)
                     if( ios /= 0 ) then
                        write(*,*) 'read_sim_chm: Failed to read outinst; error = ',ios
	                call endrun
                     end if
                     if( k /= 18 ) then
                       read(funit,'(20i4)',iostat=ios) minst(starti:endi)
                     else
                       read(funit,'(10i8)',iostat=ios) minst(starti:endi)
                     end if
                     if( ios /= 0 ) then
                        write(*,*) 'read_sim_chm: Failed to read base index; error = ',ios
	                call endrun
                     end if
	          else if( i == avrg ) then
                     if( k == 20 ) then
                        read(funit,'(a5)',iostat=ios) local_time_char(file)
                        if( ios /= 0 ) then
                           write(*,*) 'read_sim_chm: Failed to read local_time_char; error = ',ios
	                   call endrun
                        end if
                        read(funit,'(i5)',iostat=ios) local_time(file)
                        if( ios /= 0 ) then
                           write(*,*) 'read_sim_chm: Failed to read local_time; error = ',ios
	                   call endrun
                        end if
                     end if
                     read(funit,'(4a32)',iostat=ios) hfile(file)%outtimav(start:end)
                     if( ios /= 0 ) then
                        write(*,*) 'read_sim_chm: Failed to read outtimav; error = ',ios
	                call endrun
                     end if
                     if( k /= 18 .and. k /= 20 ) then
                        read(funit,'(20i4)',iostat=ios) mtimav(starti:endi)
                     else if( k == 18 ) then
                        read(funit,'(10i8)',iostat=ios) mtimav(starti:endi)
                     else if( k == 20 ) then
                        read(funit,'(20i5)',iostat=ios) mtimav(starti:endi)
                     end if
                     if( ios /= 0 ) then
                        write(*,*) 'read_sim_chm: Failed to read base index; error = ',ios
	                call endrun
                     end if
	          end if
	       end if has_output
            end do output_type_loop
	    if( endi > 0 ) then
	       if( i == inst ) then
	          allocate( hfile(file)%hist_inst(end), stat=astat )
	          if( astat /= 0 ) then
	             write(*,*) ' read_sim_chm: Failed to allocate hist_ind for file ',file,'; error = ',astat
		     call endrun
	          end if
	          hfile(file)%hist_inst(:end-hfile(file)%match_cnt(i)) = &
                            hfile(file)%outinst(hfile(file)%match_cnt(i)+1:end)
	          allocate( hfile(file)%inst_map(endi), stat=astat )
	          if( astat /= 0 ) then
	             write(*,*) ' read_sim_chm: Failed to allocate inst_map for file ',file,'; error = ',astat
		     call endrun
	          end if
	          hfile(file)%inst_map(:endi) = minst(:endi)
	       else if( i == avrg ) then
	          allocate( hfile(file)%hist_timav(end), stat=astat )
	          if( astat /= 0 ) then
	             write(*,*) ' read_sim_chm: Failed to allocate hist_timav for file ',file,'; error = ',astat
		     call endrun
	          end if
	          hfile(file)%hist_timav(:end-hfile(file)%match_cnt(i)) = &
                          hfile(file)%outtimav(hfile(file)%match_cnt(i)+1:end)
	          allocate( hfile(file)%timav_map(endi), stat=astat )
	          if( astat /= 0 ) then
	             write(*,*) ' read_sim_chm: Failed to allocate timav_map for file ',file,'; error = ',astat
		     call endrun
	          end if
	          hfile(file)%timav_map(:endi) = mtimav(:endi)
	       end if
	    end if
         end do time_type_loop
	 deallocate( minst, mtimav )
      end do file_loop
      read(funit,'(i3)') ndiags

      close( funit )

      write(*,*) '---------------------------------------------------------------------------------'
      write(*,*) ' '

      end subroutine read_sim_chm

      end module mo_read_sim_chm
