
      module mo_rtlink

      private
      public :: rtlink

      contains

      subroutine rtlink( z, nw, albedo, zen, dsdh, &
                         nid, &
                         dtrl, &
                         dto3, & 
                         dto2, & 
                         dtcld, omcld, gcld, &
                         dtcbs1, omcbs1, gcbs1, &
                         dtcbs2, omcbs2, gcbs2, &
                         dtocs1, omocs1, gocs1, &
                         dtocs2, omocs2, gocs2, &
                         dtant, omant, gant, &
                         dtso4, omso4, gso4, &
                         dtsal, omsal, gsal, &
                         dtds1, omds1, gds1, &
                         dtds2, omds2, gds2, &
                         dtds3, omds3, gds3, &
                         dtds4, omds4, gds4, &
                         radfld )

!-----------------------------------------------------------------------
!
! Rewritten by P. Hess, April 2005 to account for new mie lookup table
!
!
! prefix dt = optical depth
! prefix om = single scattering albedo
! prefix g  = asymmetery parameter
! prefix ds = optical depth x single scattering albedo
! prefix da = optical depth x (1-single scattering albedo)
! suffix 1 = dry
! suffix 2 = wet
! cgs = soot, 
! ocs = organic carbon + soa (all soluble)
! ant = ammonia nitrate
! sal = sea-salt (4 bins) 
! ds1 - ds4 = dust
!-----------------------------------------------------------------------

      use mo_control, only : use_dust
      use mo_params,  only : smallest
      use mo_ps2str,  only : ps2str
      use mo_grid,    only : plev, plevp

      implicit none

!-----------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: nw
      integer, intent(in) :: nid(0:plev)
      real, intent(in)  :: z(plevp)
      real, intent(in)  :: albedo(nw)
      real, intent(in)  :: zen
      real, intent(in)  :: dtrl(plev,nw)
      real, intent(in)  :: dto3(plev,nw)
      real, intent(in)  :: dto2(plev,nw)
      real, intent(in)  :: dtcld(plev,nw)
      real, intent(in)  :: omcld(plev,nw)
      real, intent(in)  :: gcld(plev,nw)
 
      real, intent(in)  :: dtcbs1(plev,nw)
      real, intent(in)  :: omcbs1(plev,nw)
      real, intent(in)  :: gcbs1(plev,nw)
 
      real, intent(in)  :: dtcbs2(plev,nw)
      real, intent(in)  :: omcbs2(plev,nw)
      real, intent(in)  :: gcbs2(plev,nw)
 
      real, intent(in)  :: dtocs1(plev,nw)
      real, intent(in)  :: omocs1(plev,nw)
      real, intent(in)  :: gocs1(plev,nw)
 
      real, intent(in)  :: dtocs2(plev,nw)
      real, intent(in)  :: omocs2(plev,nw)
      real, intent(in)  :: gocs2(plev,nw)
 
      real, intent(in)  :: dtant(plev,nw)
      real, intent(in)  :: omant(plev,nw)
      real, intent(in)  :: gant(plev,nw)
      real, intent(in)  :: dtso4(plev,nw)
      real, intent(in)  :: omso4(plev,nw)
      real, intent(in)  :: gso4(plev,nw)
      real, intent(in)  :: dtsal(plev,nw,4)
      real, intent(in)  :: omsal(plev,nw,4)
      real, intent(in)  :: gsal(plev,nw,4)
      real, intent(in)  :: dtds1(plev,nw)
      real, intent(in)  :: omds1(plev,nw)
      real, intent(in)  :: gds1(plev,nw)
      real, intent(in)  :: dtds2(plev,nw)
      real, intent(in)  :: omds2(plev,nw)
      real, intent(in)  :: gds2(plev,nw)
      real, intent(in)  :: dtds3(plev,nw)
      real, intent(in)  :: omds3(plev,nw)
      real, intent(in)  :: gds3(plev,nw)
      real, intent(in)  :: dtds4(plev,nw)
      real, intent(in)  :: omds4(plev,nw)
      real, intent(in)  :: gds4(plev,nw)

      real, intent(in)  :: dsdh(0:plev,plev)
      real, intent(out) :: radfld(plevp,nw)

!-----------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------
      integer :: k, kk, wn
      real    :: daaer, dtsct, dtabs, dsaer, dscld, dacld
      real    :: dscbs1, dacbs1                            
      real    :: dscbs2, dacbs2                            
      real    :: dsocs1, daocs1  
      real    :: dsocs2, daocs2  
      real    :: dsant, daant                            
      real    :: dsso4, daso4  
      real    :: dssal1, dssal2, dssal3, dssal4
      real    :: dasal1, dasal2, dasal3, dasal4
      real    :: dsds1, dads1
      real    :: dsds2, dads2
      real    :: dsds3, dads3
      real    :: dsds4, dads4
      real    :: wrk
      real    :: dt(plev,nw)
      real    :: om(plev,nw)
      real    :: g(plev,nw)

!-----------------------------------------------------------------------
!  	... set any coefficients specific to rt scheme
!-----------------------------------------------------------------------
wave_loop : &
      do wn = 1,nw
level_loop : &
         do k = 1,plev
            kk = plevp - k
!-----------------------------------------------------------------------
! scattering and absorbing optical depths
!-----------------------------------------------------------------------
            dscld = dtcld(k,wn)*omcld(k,wn)
            dacld = dtcld(k,wn)*abs( 1. - omcld(k,wn) )
!-----------------------------------------------------------------------
! black carbon
!-----------------------------------------------------------------------
            wrk     = max( min( omcbs1(k,wn),1. ),smallest )
            dscbs1 = dtcbs1(k,wn)*wrk
            dacbs1 = dtcbs1(k,wn)*(1. - wrk)

            wrk     = max( min( omcbs2(k,wn),1. ),smallest )
            dscbs2 = dtcbs2(k,wn)*wrk
            dacbs2 = dtcbs2(k,wn)*(1. - wrk)
!-----------------------------------------------------------------------
! organic carbon and soa
!-----------------------------------------------------------------------
            wrk     = max( min( omocs1(k,wn),1. ),smallest )
            dsocs1 = dtocs1(k,wn)*wrk
            daocs1 = dtocs1(k,wn)*(1. - wrk)

            wrk     = max( min( omocs2(k,wn),1. ),smallest )
            dsocs2 = dtocs2(k,wn)*wrk
            daocs2 = dtocs2(k,wn)*(1. - wrk)
!-----------------------------------------------------------------------
! ammonia sulfate
!-----------------------------------------------------------------------
            wrk     = max( min( omant(k,wn),1. ),smallest )
            dsant   = dtant(k,wn)*wrk
            daant =   dtant(k,wn)*(1. - wrk)
!-----------------------------------------------------------------------
! ammonia sulfate
!-----------------------------------------------------------------------
            wrk     = max( min( omso4(k,wn),1. ),smallest )
            dsso4   = dtso4(k,wn)*wrk
            daso4 =   dtso4(k,wn)*(1. - wrk)
!-----------------------------------------------------------------------
! summation to this point
!-----------------------------------------------------------------------
            dtsct = dtrl(k,wn)  + dscld  &
                  + dscbs2 + dscbs1 + dsocs2 + dsocs1 + dsant + dsso4 
            dtabs = dto3(k,wn) + dto2(k,wn) + dacld &
                  + dacbs2 + dacbs1 + daocs2 + daocs1 + daant + daso4 
!-----------------------------------------------------------------------
! sea salt
!-----------------------------------------------------------------------
               wrk     = max( min( omsal(k,wn,1),1. ),smallest )
               dssal1 = dtsal(k,wn,1)*wrk
               dasal1 = dtsal(k,wn,1)*(1. - wrk)

               wrk     = max( min( omsal(k,wn,2),1. ),smallest )
               dssal2 = dtsal(k,wn,2)*wrk
               dasal2 = dtsal(k,wn,2)*(1. - wrk)

               wrk     = max( min( omsal(k,wn,3),1. ),smallest )
               dssal3 = dtsal(k,wn,3)*wrk
               dasal3 = dtsal(k,wn,3)*(1. - wrk)

               wrk     = max( min( omsal(k,wn,4),1. ),smallest )
               dssal4 = dtsal(k,wn,4)*wrk
               dasal4 = dtsal(k,wn,4)*(1. - wrk)
!-----------------------------------------------------------------------
! summation
!-----------------------------------------------------------------------
               dtsct = dtsct + dssal1 + dssal2 + dssal3 + dssal4
               dtabs = dtabs + dasal1 + dasal2 + dasal3 + dasal4

            if( use_dust ) then
               wrk     = max( min( omds1(k,wn),1. ),smallest )
               dsds1 = dtds1(k,wn)*wrk
               dads1 = dsds1*(1. - wrk)

               wrk     = max( min( omds2(k,wn),1. ),smallest )
               dsds2 = dtds2(k,wn)*wrk
               dads2 = dsds2*(1. - wrk)

               wrk     = max( min( omds3(k,wn),1. ),smallest )
               dsds3 = dtds3(k,wn)*wrk
               dads3 = dsds3*(1. - wrk)

               wrk     = max( min( omds4(k,wn),1. ),smallest )
               dsds4 = dtds4(k,wn)*wrk
               dads4 = dsds4*(1. - wrk)

               dtsct = dtsct + dsds1 + dsds2 + dsds3 + dsds4
               dtabs = dtabs + dads1 + dads2 + dads3 + dads4
            end if

            dtabs = max( dtabs,smallest )
            dtsct = max( dtsct,smallest )
!-----------------------------------------------------------------------
! 	... invert z-coordinate
!-----------------------------------------------------------------------
            dt(kk,wn) = dtsct + dtabs
            if( dtsct /= smallest ) then
               om(kk,wn) = dtsct/(dtsct + dtabs)
               g(kk,wn) = gcld(k,wn)*dscld     &
                        + gcbs1(k,wn)*dscbs1 &
                        + gcbs2(k,wn)*dscbs2 &
                        + gocs2(k,wn)*dsocs2 &
                        + gocs1(k,wn)*dsocs1 &
                        + gant(k,wn)*dsant     &
                        + gso4(k,wn)*dsso4     &            
                        + gsal(k,wn,1)*dssal1  &
                        + gsal(k,wn,2)*dssal2  &
                        + gsal(k,wn,3)*dssal3  &
                        + gsal(k,wn,4)*dssal4

               if( use_dust ) then
                  g(kk,wn) = g(kk,wn) &
                           + gds1(k,wn)*dsds1 + gds2(k,wn)*dsds2 &
                           + gds3(k,wn)*dsds3 + gds4(k,wn)*dsds4
               end if
               g(kk,wn) = min( max( g(kk,wn)/dtsct,smallest ),1. )
            else
               om(kk,wn) = smallest
               g(kk,wn)  = smallest
            end if
         end do level_loop
      end do wave_loop

!-----------------------------------------------------------------------
!  	... call rt routine
!-----------------------------------------------------------------------
      call ps2str( nw, zen, albedo, dt, om, &
                   g, dsdh, nid, radfld )

      end subroutine rtlink

      end module mo_rtlink
