
      module mo_setaer

      implicit none

      private
      public :: setaer

      save

      real, parameter :: qext_so4(8,17) = reshape( (/  &                      ! m^2/gram (NH4)_2(SO4) 
            7.15,  10.29,  12.86,  15.45,  21.52,  30.97,  50.30,  72.31, &
            7.15,  10.30,  12.87,  15.48,  21.58,  31.07,  50.43,  72.49, &
            7.14,  10.29,  12.88,  15.51,  21.68,  31.23,  50.67,  72.78, &
            7.12,  10.28,  12.89,  15.55,  21.78,  31.41,  50.94,  73.10, &
            7.09,  10.26,  12.89,  15.57,  21.88,  31.61,  51.27,  73.48, &
            7.06,  10.22,  12.87,  15.59,  21.98,  31.81,  51.64,  73.95, &
            7.01,  10.43,  12.96,  15.24,  22.10,  32.23,  52.39,  74.86, &
            6.96,  10.35,  12.93,  15.20,  22.12,  32.39,  52.72,  75.39, &
            6.89,  10.26,  12.87,  15.16,  22.11,  32.49,  53.05,  75.85, &
            6.54,   9.80,  12.36,  14.68,  21.88,  32.74,  54.25,  77.77, &
            6.21,   9.34,  11.86,  14.14,  21.41,  32.55,  55.02,  79.20, &
            6.07,   9.14,  11.62,  13.88,  21.17,  32.33,  55.08,  79.56, &
            5.90,   8.90,  11.32,  13.57,  20.80,  32.03,  55.17,  80.02, &
            5.31,   8.04,  10.31,  12.42,  19.45,  30.76,  54.62,  80.61, &
            4.56,   6.97,   9.00,  10.92,  17.55,  28.69,  53.02,  80.43, &
            3.23,   5.02,   6.59,   8.09,  13.57,  23.64,  47.11,  75.36, &
            2.37,   3.73,   4.95,   6.14,  10.65,  19.54,  41.41,  69.26  &
            /),(/8,17/))

      real, parameter :: qext_dso4(7,17) = qext_so4(2:8,:) - qext_so4(1:7,:)

      real, parameter :: ssa_so4(8,17) = reshape( (/  &
        1.00000,0.99907,0.99855,0.99810,0.99724,0.99623,0.99469,0.99340, &
        1.00000,0.99976,0.99962,0.99950,0.99928,0.99900,0.99857,0.99820, &
        1.00000,0.99996,0.99994,0.99992,0.99989,0.99984,0.99978,0.99971, &
        1.00000,1.00000,1.00000,0.99999,0.99999,0.99999,0.99998,0.99998, &
        1.00000,1.00000,1.00000,1.00000,1.00000,0.99999,0.99999,0.99999, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000  &
            /),(/8,17/))

      real, parameter :: ssa_dso4(7,17) = ssa_so4(2:8,:) - ssa_so4(1:7,:)

      real, parameter :: asm_so4(8,17) = reshape( (/ &
        0.67,   0.68,   0.68,   0.68,   0.69,   0.70,   0.71,   0.73, &
        0.67,   0.68,   0.68,   0.68,   0.69,   0.70,   0.72,   0.73, &
        0.67,   0.68,   0.69,   0.69,   0.70,   0.70,   0.72,   0.73, & 
        0.67,   0.69,   0.69,   0.70,   0.70,   0.71,   0.72,   0.74, &
        0.67,   0.69,   0.70,   0.70,   0.71,   0.71,   0.73,   0.74, &
        0.67,   0.69,   0.70,   0.71,   0.71,   0.72,   0.73,   0.74, &
        0.67,   0.70,   0.71,   0.71,   0.72,   0.72,   0.73,   0.74, &
        0.67,   0.70,   0.71,   0.72,   0.73,   0.73,   0.74,   0.75, &
        0.67,   0.70,   0.71,   0.72,   0.73,   0.74,   0.74,   0.75, &
        0.67,   0.71,   0.72,   0.73,   0.75,   0.75,   0.76,   0.76, &
        0.67,   0.71,   0.73,   0.74,   0.76,   0.76,   0.77,   0.77, &
        0.67,   0.71,   0.73,   0.74,   0.76,   0.77,   0.77,   0.77, &
        0.67,   0.71,   0.73,   0.74,   0.76,   0.77,   0.77,   0.77, &
        0.66,   0.71,   0.73,   0.75,   0.77,   0.77,   0.78,   0.78, &
        0.66,   0.71,   0.73,   0.75,   0.77,   0.78,   0.79,   0.79, &
        0.64,   0.69,   0.72,   0.73,   0.76,   0.78,   0.79,   0.80, &
        0.62,   0.67,   0.70,   0.72,   0.75,   0.77,   0.79,   0.80  &
            /),(/8,17/))

      real, parameter :: asm_dso4(7,17) = asm_so4(2:8,:) - asm_so4(1:7,:)

      real, parameter :: qext_ant(8,17) = reshape( (/ &                ! m^2/gram (NH4)NO3
         7.27,  10.47,  13.08,  15.72,  21.90,  31.51,  51.17,  73.57, &
         7.27,  10.48,  13.09,  15.74,  21.96,  31.60,  51.30,  73.75, &
         7.26,  10.47,  13.10,  15.78,  22.05,  31.77,  51.55,  74.04, &
         7.24,  10.46,  13.11,  15.82,  22.16,  31.96,  51.83,  74.37, &
         7.22,  10.43,  13.11,  15.84,  22.26,  32.15,  52.16,  74.76, &
         7.18,  10.40,  13.10,  15.86,  22.36,  32.37,  52.53,  75.24, &
         7.14,  10.35,  13.06,  15.86,  22.44,  32.58,  52.94,  75.75, &
         7.08,  10.53,  13.15,  15.47,  22.50,  32.95,  53.64,  76.69, &
         7.01,  10.44,  13.09,  15.42,  22.49,  33.05,  53.97,  77.17, &
         6.65,   9.96,  12.57,  14.93,  22.26,  33.31,  55.19,  79.12, &
         6.32,   9.50,  12.06,  14.38,  21.78,  33.11,  55.97,  80.57, &
         6.17,   9.30,  11.82,  14.12,  21.53,  32.89,  56.04,  80.94, &
         6.00,   9.05,  11.52,  13.80,  21.16,  32.59,  56.13,  81.41, &
         5.40,   8.18,  10.49,  12.63,  19.79,  31.29,  55.57,  82.01, &
         4.64,   7.09,   9.16,  11.11,  17.86,  29.19,  53.94,  81.83, &
         3.28,   5.11,   6.70,   8.23,  13.80,  24.05,  47.93,  76.67, &
         2.41,   3.79,   5.04,   6.24,  10.83,  19.88,  42.13,  70.46  &
            /),(/8,17/))
 
      real, parameter :: qext_dant(7,17) = qext_ant(2:8,:) - qext_ant(1:7,:)

      real, parameter :: ssa_ant(8,17) = reshape( (/ &
        1.00000,0.99907,0.99855,0.99810,0.99724,0.99623,0.99469,0.99340, &
        1.00000,0.99976,0.99962,0.99950,0.99928,0.99900,0.99857,0.99820, &
        1.00000,0.99996,0.99994,0.99992,0.99989,0.99984,0.99978,0.99971, &
        1.00000,1.00000,1.00000,0.99999,0.99999,0.99999,0.99998,0.99998, &
        1.00000,1.00000,1.00000,1.00000,1.00000,0.99999,0.99999,0.99999, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
        1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000  &
            /),(/8,17/))

      real, parameter :: ssa_dant(7,17) = ssa_ant(2:8,:) - ssa_ant(1:7,:)
 
      real, parameter :: asm_ant(8,17) = reshape( (/ &
        0.67,   0.68,   0.68,   0.68,   0.69,   0.70,   0.71,   0.73, &
        0.67,   0.68,   0.68,   0.68,   0.69,   0.70,   0.72,   0.73, &
        0.67,   0.68,   0.69,   0.69,   0.70,   0.70,   0.72,   0.73, &
        0.67,   0.69,   0.69,   0.70,   0.70,   0.71,   0.72,   0.74, &
        0.67,   0.69,   0.70,   0.70,   0.71,   0.71,   0.73,   0.74, &
        0.67,   0.69,   0.70,   0.71,   0.71,   0.72,   0.73,   0.74, &
        0.67,   0.70,   0.71,   0.71,   0.72,   0.72,   0.73,   0.74, &
        0.67,   0.70,   0.71,   0.72,   0.73,   0.73,   0.74,   0.75, &
        0.67,   0.70,   0.71,   0.72,   0.73,   0.74,   0.74,   0.75, &
        0.67,   0.71,   0.72,   0.73,   0.75,   0.75,   0.76,   0.76, &
        0.67,   0.71,   0.73,   0.74,   0.76,   0.76,   0.77,   0.77, &
        0.67,   0.71,   0.73,   0.74,   0.76,   0.77,   0.77,   0.77, &
        0.67,   0.71,   0.73,   0.74,   0.76,   0.77,   0.77,   0.77, &
        0.66,   0.71,   0.73,   0.75,   0.77,   0.77,   0.78,   0.78, &
        0.66,   0.71,   0.73,   0.75,   0.77,   0.78,   0.79,   0.79, &
        0.64,   0.69,   0.72,   0.73,   0.76,   0.78,   0.79,   0.80, &
        0.62,   0.67,   0.70,   0.72,   0.75,   0.77,   0.79,   0.80  &
            /),(/8,17/))

      real, parameter :: asm_dant(7,17) = asm_ant(2:8,:) - asm_ant(1:7,:)

!--------------------------------------------------------------------
!      dust: bin 1
!--------------------------------------------------------------------
      real, parameter :: qext_ds1(17) =                            &
       (/ 1.99,  1.99,  1.99,  1.99, 2.00,  2.00, 2.00, 2.01,       &
          2.03,  2.13,  2.20,  2.20, 2.20,  2.23, 2.45, 2.82, 2.77 /)

      real, parameter  :: ssa_ds1(17) =                             &
       (/ 0.71575, 0.71916, 0.72437, 0.73098, 0.73895, 0.74845, 0.75953, &
          0.77247, 0.78667, 0.84334, 0.88486, 0.89887, 0.91254, 0.94728, &
          0.97546, 0.99257, 0.99627 /)

      real, parameter :: asm_ds1(17) =                            &
       (/ 0.81, 0.80, 0.80, 0.79, 0.78, 0.78, 0.77, 0.76, 0.75, 0.71,&
          0.68, 0.67, 0.65, 0.62, 0.62, 0.68, 0.69 /)
!--------------------------------------------------------------------
!      dust: bin 2
!--------------------------------------------------------------------
      real, parameter :: qext_ds2(17) =                              &
       (/ 0.77, 0.77, 0.77, 0.77, 0.78, 0.78, 0.78, 0.79, 0.79, 0.79, &
          0.79, 0.80, 0.81, 0.84, 0.84, 0.84, 0.92 /)

      real, parameter ::  ssa_ds2(17) =                               &
       (/0.59522, 0.59816, 0.60304, 0.60951, 0.61766, 0.62757, 0.63939,&
         0.65308, 0.66760, 0.72707, 0.78134, 0.80412, 0.82832, 0.88852,&
         0.93596, 0.97452, 0.98760 /)

      real, parameter :: asm_ds2(17) =                                &
       (/0.91, 0.90, 0.90, 0.90, 0.89, 0.89, 0.88, 0.87, 0.87, 0.83, &
         0.80, 0.80, 0.79, 0.76, 0.72, 0.64, 0.62 /)
!--------------------------------------------------------------------
!      dust: bin 3
!--------------------------------------------------------------------
      real, parameter :: qext_ds3(17) =                                    &
       (/0.36, 0.36, 0.36, 0.36, 0.36, 0.36, 0.36, 0.36, 0.36, 0.36, 0.37, &
         0.37, 0.37, 0.37, 0.37, 0.38, 0.38 /)

      real, parameter :: ssa_ds3(17) =                                          &
       (/0.54872, 0.54937, 0.55055, 0.55244, 0.55533, 0.55919, 0.56387, 0.56968, &
         0.57716, 0.62358, 0.67763, 0.70405, 0.73102, 0.81296, 0.88850, 0.95481, &
         0.97307/)

      real, parameter :: asm_ds3(17) =                                      &
       (/ 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.93, 0.93, 0.92, 0.90, 0.88, &
          0.87, 0.85, 0.82, 0.78, 0.75, 0.73 /)

!--------------------------------------------------------------------
!      dust: bin 4
!--------------------------------------------------------------------
      real, parameter :: qext_ds4(17) =           &
      (/0.18, 0.18, 0.18, 0.18, 0.18, 0.18, 0.18, 0.19, 0.19, 0.19, 0.19, 0.19, &
        0.19, 0.19, 0.19, 0.19, 0.20 /)

      real, parameter :: ssa_ds4(17) =            &
      (/0.55982, 0.56067, 0.56205, 0.56381, 0.56604, 0.56911, 0.57321, 0.57809, 0.58376, &
        0.60863, 0.62981, 0.64251, 0.65974, 0.73256, 0.82372, 0.92454, 0.95662 /)

      real, parameter :: asm_ds4(17) =           &
       (/ 0.94, 0.94, 0.94, 0.94, 0.94, 0.93, 0.93, 0.93, 0.93, 0.91, 0.91, 0.90, &
         0.89, 0.87, 0.83, 0.79, 0.77 /)

!--------------------------------------------------------------------
! black carbon
!--------------------------------------------------------------------
      real, parameter :: qext_cbs(8,17) = reshape( (/ & 
      26.47,  26.47,  26.47,  68.55,  54.51,  68.55,  93.69, 128.49, &
      26.35,  26.35,  26.35,  67.19,  53.53,  67.19,  91.62, 125.62, &
      26.15,  26.15,  26.15,  65.24,  52.13,  65.24,  88.62, 121.44, &
      25.89,  25.89,  25.89,  63.07,  50.57,  63.07,  85.27, 116.72, &
      25.59,  25.59,  25.59,  60.75,  48.90,  60.75,  81.69, 111.62, &
      25.23,  25.23,  25.23,  58.35,  47.17,  58.35,  77.96, 106.29, &
      24.82,  24.82,  24.82,  55.92,  45.41,  55.92,  74.20, 100.86, &
      24.36,  24.36,  24.36,  53.51,  43.65,  53.51,  70.46,  95.43, &
      23.89,  23.89,  23.89,  51.24,  41.98,  51.24,  66.95,  90.33, &
      21.92,  21.92,  21.92,  43.84,  36.46,  43.84,  55.67,  73.81, &
      20.35,  20.35,  20.35,  39.12,  32.87,  39.12,  48.65,  63.58, &
      19.59,  19.59,  19.59,  37.26,  31.38,  37.26,  46.12,  60.08, &
      18.52,  18.52,  18.52,  34.78,  29.37,  34.78,  42.83,  55.62, &
      15.51,  15.51,  15.51,  28.14,  23.92,  28.14,  34.14,  43.91, &
      12.45,  12.45,  12.45,  21.75,  18.64,  21.75,  25.93,  32.95, &
       8.38,   8.38,   8.38,  13.90,  12.07,  13.90,  16.12,  20.04, &
       6.13,   6.13,   6.13,   9.74,   8.56,   9.74,  11.00,  13.35  &
            /),(/8,17/))

      real, parameter :: qext_dcbs(7,17) = qext_cbs(2:8,:) - qext_cbs(1:7,:)

      real, parameter :: ssa_cbs(8,17) = reshape( (/ & 
      0.30538,0.30538,0.30538,0.58171,0.52858,0.58171,0.66772,0.73300, &
      0.30531,0.30531,0.30531,0.57816,0.52490,0.57816,0.66490,0.73116, &
      0.30524,0.30524,0.30524,0.57281,0.51947,0.57281,0.66041,0.72800, &
      0.30519,0.30519,0.30519,0.56680,0.51346,0.56680,0.65519,0.72418, &
      0.30520,0.30520,0.30520,0.56029,0.50707,0.56029,0.64937,0.71979, &
      0.30530,0.30530,0.30530,0.55345,0.50049,0.55345,0.64304,0.71487, &
      0.30552,0.30552,0.30552,0.54644,0.49387,0.54644,0.63633,0.70948, &
      0.30588,0.30588,0.30588,0.53936,0.48731,0.53936,0.62932,0.70368, &
      0.30637,0.30637,0.30637,0.53261,0.48117,0.53261,0.62241,0.69779, &
      0.30947,0.30947,0.30947,0.50973,0.46122,0.50973,0.59715,0.67476, &
      0.31199,0.31199,0.31199,0.49449,0.44836,0.49449,0.57921,0.65742, &
      0.30839,0.30839,0.30839,0.48822,0.44229,0.48822,0.57287,0.65174, &
      0.30122,0.30122,0.30122,0.47923,0.43325,0.47923,0.56425,0.64429, &
      0.27707,0.27707,0.27707,0.44969,0.40365,0.44969,0.53566,0.61916, &
      0.24673,0.24673,0.24673,0.41274,0.36689,0.41274,0.49934,0.58653, &
      0.19216,0.19216,0.19216,0.34214,0.29839,0.34214,0.42664,0.51768, &
      0.15153,0.15153,0.15153,0.28528,0.24454,0.28528,0.36566,0.45729  &
            /),(/8,17/))

      real, parameter :: ssa_dcbs(7,17) = ssa_cbs(2:8,:) - ssa_cbs(1:7,:)

      real, parameter :: asm_cbs(8,17) = reshape( (/ &
      0.59,   0.59,   0.59,   0.71,   0.70,   0.71,   0.71,   0.72, &
      0.59,   0.59,   0.59,   0.71,   0.70,   0.71,   0.72,   0.72, &
      0.59,   0.59,   0.59,   0.71,   0.69,   0.71,   0.72,   0.72, &
      0.58,   0.58,   0.58,   0.70,   0.69,   0.70,   0.72,   0.72, &
      0.57,   0.57,   0.57,   0.70,   0.69,   0.70,   0.72,   0.72, &
      0.56,   0.56,   0.56,   0.70,   0.68,   0.70,   0.71,   0.72, &
      0.55,   0.55,   0.55,   0.69,   0.68,   0.69,   0.71,   0.72, &
      0.54,   0.54,   0.54,   0.69,   0.67,   0.69,   0.71,   0.72, &
      0.53,   0.53,   0.53,   0.68,   0.66,   0.68,   0.70,   0.72, &
      0.49,   0.49,   0.49,   0.65,   0.63,   0.65,   0.68,   0.70, &
      0.46,   0.46,   0.46,   0.63,   0.60,   0.63,   0.66,   0.68, &
      0.45,   0.45,   0.45,   0.62,   0.59,   0.62,   0.65,   0.68, &
      0.44,   0.44,   0.44,   0.61,   0.58,   0.61,   0.64,   0.67, &
      0.41,   0.41,   0.41,   0.58,   0.55,   0.58,   0.61,   0.64, &
      0.37,   0.37,   0.37,   0.54,   0.51,   0.54,   0.58,   0.61, &
      0.32,   0.32,   0.32,   0.47,   0.45,   0.47,   0.51,   0.55, &
      0.28,   0.28,   0.28,   0.42,   0.40,   0.42,   0.46,   0.50  &
            /),(/8,17/))

      real, parameter :: asm_dcbs(7,17) = asm_cbs(2:8,:) - asm_cbs(1:7,:)

!--------------------------------------------------------------------
! organic carbon
!--------------------------------------------------------------------
      real, parameter :: qext_ocs(8,17) = reshape( (/ & 
      5.38,   8.22,  11.03,  13.09,  14.66,  18.31,  25.39,  28.27, &
      5.37,   8.20,  11.00,  13.06,  14.63,  18.29,  25.39,  28.28, &
      5.35,   8.16,  10.95,  13.02,  14.59,  18.26,  25.39,  28.29, &
      5.33,   8.12,  10.90,  12.96,  14.53,  18.21,  25.38,  28.30, &
      5.30,   8.06,  10.83,  12.89,  14.46,  18.15,  25.34,  28.27, &
      5.26,   8.00,  10.74,  12.80,  14.37,  18.07,  25.29,  28.24, &
      5.22,   7.92,  10.65,  12.71,  14.28,  17.98,  25.22,  28.19, &
      5.17,   7.84,  10.54,  12.59,  14.15,  17.85,  25.13,  28.12, &
      5.12,   7.75,  10.42,  12.47,  14.02,  17.71,  25.01,  28.00, &
      4.86,   7.35,   9.90,  11.89,  13.41,  17.05,  24.35,  27.38, &
      4.65,   7.01,   9.46,  11.39,  12.87,  16.45,  23.70,  26.73, &
      4.56,   6.88,   9.29,  11.20,  12.67,  16.21,  23.44,  26.46, &
      4.44,   6.70,   9.06,  10.95,  12.38,  15.89,  23.06,  26.07, &
      4.06,   6.14,   8.32,  10.10,  11.46,  14.81,  21.77,  24.72, &
      3.61,   5.47,   7.44,   9.08,  10.34,  13.47,  20.09,  22.94, &
      2.81,   4.27,   5.86,   7.22,   8.26,  10.91,  16.70,  19.24, &
      2.25,   3.44,   4.74,   5.89,   6.77,   9.04,  14.12,  16.39  &
            /),(/8,17/))

      real, parameter :: qext_docs(7,17) = qext_ocs(2:8,:) - qext_ocs(1:7,:)

      real, parameter :: ssa_ocs(8,17) = reshape( (/ & 
      0.67508,0.73829,0.78690,0.80446,0.82190,0.84991,0.87960,0.88715, &
      0.67840,0.74179,0.79056,0.80819,0.82564,0.85366,0.88338,0.89096, &
      0.68373,0.74715,0.79586,0.81346,0.83078,0.85852,0.88777,0.89520, &
      0.69072,0.75403,0.80249,0.81995,0.83703,0.86424,0.89272,0.89991, &
      0.69947,0.76249,0.81046,0.82767,0.84441,0.87098,0.89863,0.90556, &
      0.71012,0.77261,0.81984,0.83676,0.85311,0.87886,0.90536,0.91195, &
      0.72284,0.78447,0.83062,0.84703,0.86276,0.88742,0.91264,0.91888, &
      0.73788,0.79817,0.84282,0.85864,0.87367,0.89703,0.92063,0.92642, &
      0.75456,0.81304,0.85573,0.87075,0.88494,0.90689,0.92883,0.93416, &
      0.83969,0.88348,0.91349,0.92370,0.93306,0.94713,0.96070,0.96392, &
      0.92455,0.94805,0.96298,0.96787,0.97222,0.97858,0.98451,0.98588, &
      0.93919,0.95861,0.97073,0.97469,0.97818,0.98326,0.98796,0.98905, &
      0.94732,0.96439,0.97494,0.97838,0.98140,0.98578,0.98983,0.99076, &
      0.96028,0.97347,0.98153,0.98416,0.98643,0.98973,0.99275,0.99344, &
      0.96294,0.97536,0.98295,0.98546,0.98760,0.99068,0.99351,0.99416, &
      0.95723,0.97159,0.98043,0.98344,0.98593,0.98957,0.99290,0.99366, &
      0.94701,0.96465,0.97566,0.97951,0.98263,0.98721,0.99143,0.99239  &
            /),(/8,17/))

      real, parameter :: ssa_docs(7,17) = ssa_ocs(2:8,:) - ssa_ocs(1:7,:)

      real, parameter :: asm_ocs(8,17) = reshape( (/ &
      0.77,   0.76,   0.75,   0.74,   0.74,   0.73,   0.73,   0.73, &
      0.77,   0.76,   0.75,   0.74,   0.74,   0.74,   0.73,   0.73, &
      0.77,   0.76,   0.75,   0.75,   0.74,   0.74,   0.74,   0.74, &
      0.76,   0.76,   0.75,   0.75,   0.75,   0.74,   0.74,   0.74, &
      0.76,   0.76,   0.75,   0.75,   0.75,   0.75,   0.75,   0.75, &
      0.75,   0.76,   0.75,   0.75,   0.75,   0.75,   0.75,   0.75, &
      0.75,   0.75,   0.75,   0.75,   0.75,   0.75,   0.75,   0.75, &
      0.74,   0.75,   0.75,   0.75,   0.75,   0.75,   0.75,   0.76, &
      0.74,   0.75,   0.75,   0.75,   0.76,   0.76,   0.76,   0.76, &
      0.71,   0.73,   0.75,   0.75,   0.75,   0.76,   0.76,   0.76, &
      0.68,   0.72,   0.74,   0.74,   0.75,   0.76,   0.76,   0.77, &
      0.68,   0.72,   0.74,   0.74,   0.75,   0.76,   0.76,   0.77, &
      0.68,   0.71,   0.74,   0.74,   0.75,   0.76,   0.77,   0.77, &
      0.67,   0.71,   0.74,   0.74,   0.75,   0.76,   0.77,   0.77, &
      0.66,   0.71,   0.73,   0.74,   0.75,   0.76,   0.77,   0.77, &
      0.65,   0.70,   0.73,   0.74,   0.75,   0.76,   0.77,   0.78, &
      0.64,   0.69,   0.72,   0.73,   0.74,   0.76,   0.77,   0.77  &
            /),(/8,17/))

      real, parameter :: asm_docs(7,17) = asm_ocs(2:8,:) - asm_ocs(1:7,:)

!--------------------------------------------------------------------
! sea-salt bin 1
!--------------------------------------------------------------------
      real, parameter :: qext_sal01(8,17) = reshape( (/ &
      2.18,   3.87,   5.09,   6.46,   0.00,  15.67,  29.00,  40.81, &
      2.19,   3.89,   5.13,   6.49,   0.00,  15.67,  29.03,  40.76, &
      2.18,   3.83,   5.16,   6.45,   0.00,  15.62,  29.02,  40.81, &
      2.17,   3.82,   5.23,   6.39,   0.00,  15.72,  29.06,  40.86, &
      2.15,   3.85,   5.24,   6.45,   0.00,  15.71,  29.13,  40.89, &
      2.14,   3.93,   5.18,   6.56,   0.00,  15.71,  29.13,  40.90, &
      2.15,   4.01,   5.18,   6.57,   0.00,  15.85,  29.34,  41.03, &
      2.18,   4.02,   5.27,   6.48,   0.00,  15.72,  29.21,  41.15, &
      2.23,   3.96,   5.38,   6.50,   0.00,  15.88,  29.50,  41.17, &
      2.39,   4.09,   5.34,   6.71,   0.00,  16.08,  29.66,  41.58, &
      2.34,   4.34,   5.61,   6.69,   0.00,  16.05,  29.95,  41.93, &
      2.31,   4.35,   5.75,   6.84,   0.00,  16.07,  29.72,  41.59, &
      2.26,   4.28,   5.85,   7.10,   0.00,  16.45,  29.96,  42.10, &
      2.36,   4.10,   5.62,   7.20,   0.00,  16.62,  30.41,  42.58, &
      2.78,   4.50,   5.61,   6.85,   0.00,  17.18,  31.51,  42.82, &
      3.20,   5.65,   7.29,   8.64,   0.00,  17.51,  32.64,  44.52, &
      3.02,   5.74,   7.96,   9.96,   0.00,  18.03,  33.24,  47.22  &
            /),(/8,17/))

      real, parameter :: qext_dsal01(7,17) = qext_sal01(2:8,:) - qext_sal01(1:7,:)

      real, parameter :: ssa_sal01(8,17) = reshape( (/ &
      0.99971,0.99603,0.99413,0.99292,0.00000,0.98870,0.98441,0.98456, &
      0.99972,0.99886,0.99844,0.99822,0.00000,0.99688,0.99566,0.99559, &
      0.99972,0.99970,0.99965,0.99965,0.00000,0.99948,0.99928,0.99927, &
      0.99974,0.99983,0.99989,0.99990,0.00000,0.99992,0.99993,0.99993, &
      0.99975,0.99987,0.99990,0.99992,0.00000,0.99994,0.99996,0.99996, &
      0.99977,0.99988,0.99991,0.99993,0.00000,0.99997,0.99998,0.99998, &
      0.99979,0.99990,0.99992,0.99993,0.00000,0.99997,0.99998,0.99999, &
      0.99982,0.99991,0.99993,0.99994,0.00000,0.99997,0.99999,0.99999, &
      0.99984,0.99992,0.99994,0.99995,0.00000,0.99998,0.99999,0.99999, &
      0.99992,0.99996,0.99997,0.99998,0.00000,0.99999,0.99999,1.00000, &
      0.99996,0.99998,0.99999,0.99999,0.00000,1.00000,1.00000,1.00000, &
      0.99997,0.99999,0.99999,0.99999,0.00000,1.00000,1.00000,1.00000, &
      0.99998,0.99999,0.99999,0.99999,0.00000,1.00000,1.00000,1.00000, &
      1.00000,1.00000,1.00000,1.00000,0.00000,1.00000,1.00000,1.00000, &
      1.00000,1.00000,1.00000,1.00000,0.00000,1.00000,1.00000,1.00000, &
      1.00000,1.00000,1.00000,1.00000,0.00000,1.00000,1.00000,1.00000, &
      1.00000,1.00000,1.00000,1.00000,0.00000,1.00000,1.00000,1.00000  &
            /),(/8,17/))

      real, parameter :: ssa_dsal01(7,17) = ssa_sal01(2:8,:) - ssa_sal01(1:7,:)

      real, parameter :: asm_sal01(8,17) = reshape( (/ &
      0.73,   0.75,   0.75,   0.76,   0.00,   0.78,   0.79,   0.80, &
      0.72,   0.74,   0.75,   0.76,   0.00,   0.78,   0.79,   0.80, &
      0.72,   0.74,   0.76,   0.76,   0.00,   0.78,   0.79,   0.80, &
      0.72,   0.74,   0.76,   0.76,   0.00,   0.79,   0.80,   0.80, &
      0.71,   0.74,   0.76,   0.76,   0.00,   0.79,   0.80,   0.81, &
      0.71,   0.75,   0.76,   0.77,   0.00,   0.79,   0.80,   0.81, &
      0.70,   0.75,   0.75,   0.77,   0.00,   0.79,   0.81,   0.81, &
      0.70,   0.75,   0.76,   0.76,   0.00,   0.79,   0.81,   0.82, &
      0.70,   0.74,   0.76,   0.76,   0.00,   0.80,   0.81,   0.82, &
      0.69,   0.73,   0.75,   0.77,   0.00,   0.80,   0.81,   0.82, &
      0.66,   0.73,   0.75,   0.75,   0.00,   0.79,   0.81,   0.82, &
      0.64,   0.72,   0.75,   0.75,   0.00,   0.79,   0.81,   0.82, &
      0.62,   0.71,   0.75,   0.76,   0.00,   0.79,   0.81,   0.82, &
      0.61,   0.68,   0.71,   0.74,   0.00,   0.79,   0.81,   0.82, &
      0.66,   0.70,   0.70,   0.71,   0.00,   0.78,   0.80,   0.81, &
      0.73,   0.78,   0.78,   0.77,   0.00,   0.75,   0.78,   0.80, &
      0.74,   0.80,   0.82,   0.82,   0.00,   0.75,   0.77,   0.79  &
            /),(/8,17/))

      real, parameter :: asm_dsal01(7,17) = asm_sal01(2:8,:) - asm_sal01(1:7,:)

!--------------------------------------------------------------------
! sea-salt bin 2
!--------------------------------------------------------------------
      real, parameter :: qext_sal02(8,17) = reshape( (/ &
      0.63,   1.15,   1.56,   1.95,   3.07,   4.83,   8.83,  14.00, &
      0.63,   1.15,   1.56,   1.95,   3.07,   4.82,   8.83,  14.00, &
      0.63,   1.15,   1.56,   1.96,   3.07,   4.83,   8.83,  14.01, &
      0.64,   1.16,   1.56,   1.96,   3.07,   4.83,   8.84,  14.02, &
      0.64,   1.16,   1.56,   1.96,   3.08,   4.84,   8.84,  14.01, &
      0.64,   1.16,   1.57,   1.96,   3.08,   4.84,   8.86,  14.04, &
      0.64,   1.16,   1.57,   1.96,   3.09,   4.85,   8.86,  14.05, &
      0.64,   1.16,   1.57,   1.97,   3.09,   4.85,   8.86,  14.04, &
      0.64,   1.17,   1.57,   1.97,   3.09,   4.86,   8.88,  14.08, &
      0.65,   1.18,   1.59,   1.99,   3.11,   4.88,   8.92,  14.12, &
      0.66,   1.19,   1.59,   2.00,   3.13,   4.91,   8.95,  14.17, &
      0.66,   1.18,   1.60,   2.01,   3.13,   4.91,   8.96,  14.17, &
      0.66,   1.19,   1.61,   2.00,   3.15,   4.92,   8.98,  14.20, &
      0.67,   1.21,   1.62,   2.03,   3.17,   4.96,   9.03,  14.27, &
      0.67,   1.22,   1.65,   2.04,   3.19,   5.00,   9.08,  14.36, &
      0.70,   1.24,   1.67,   2.10,   3.26,   5.10,   9.21,  14.53, &
      0.75,   1.30,   1.67,   2.09,   3.32,   5.21,   9.32,  14.58  &
           /),(/8,17/))

      real, parameter :: qext_dsal02(7,17) = qext_sal02(2:8,:) - qext_sal02(1:7,:)

      real, parameter :: ssa_sal02(8,17) = reshape( (/ &
      0.99919,0.98950,0.98773,0.98690,0.98636,0.98579,0.98479,0.98335, &
      0.99919,0.99678,0.99634,0.99621,0.99608,0.99603,0.99579,0.99540, &
      0.99923,0.99911,0.99916,0.99924,0.99925,0.99933,0.99930,0.99925, &
      0.99927,0.99958,0.99968,0.99975,0.99986,0.99990,0.99992,0.99993, &
      0.99931,0.99961,0.99973,0.99980,0.99989,0.99993,0.99996,0.99997, &
      0.99935,0.99965,0.99975,0.99979,0.99990,0.99995,0.99997,0.99998, &
      0.99942,0.99970,0.99976,0.99983,0.99991,0.99995,0.99998,0.99999, &
      0.99947,0.99973,0.99979,0.99983,0.99991,0.99996,0.99998,0.99999, &
      0.99951,0.99976,0.99982,0.99986,0.99992,0.99995,0.99998,0.99999, &
      0.99973,0.99987,0.99990,0.99992,0.99995,0.99997,0.99999,0.99999, &
      0.99986,0.99992,0.99996,0.99997,0.99998,0.99998,0.99999,1.00000, &
      0.99991,0.99995,0.99996,0.99997,0.99998,0.99999,0.99999,1.00000, &
      0.99994,0.99997,0.99998,0.99998,0.99999,0.99999,1.00000,1.00000, &
      0.99999,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
      1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
      1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
      0.99998,0.99999,0.99999,0.99999,0.99999,0.99999,0.99999,0.99999  &
           /),(/8,17/))

      real, parameter :: ssa_dsal02(7,17) = ssa_sal02(2:8,:) - ssa_sal02(1:7,:)

      real, parameter :: asm_sal02(8,17) = reshape( (/ &
      0.78,   0.80,   0.80,   0.80,   0.81,   0.81,   0.82,   0.82, &
      0.78,   0.80,   0.80,   0.80,   0.81,   0.81,   0.82,   0.82, &
      0.78,   0.80,   0.80,   0.80,   0.81,   0.81,   0.82,   0.82, &
      0.78,   0.80,   0.80,   0.81,   0.81,   0.82,   0.82,   0.82, &
      0.78,   0.80,   0.81,   0.81,   0.82,   0.82,   0.83,   0.83, &
      0.78,   0.80,   0.81,   0.81,   0.82,   0.82,   0.83,   0.83, &
      0.78,   0.80,   0.81,   0.81,   0.82,   0.83,   0.83,   0.84, &
      0.78,   0.80,   0.81,   0.82,   0.82,   0.83,   0.84,   0.84, &
      0.78,   0.80,   0.81,   0.82,   0.83,   0.83,   0.84,   0.84, &
      0.77,   0.80,   0.81,   0.82,   0.83,   0.84,   0.84,   0.85, &
      0.76,   0.80,   0.81,   0.82,   0.83,   0.84,   0.85,   0.85, &
      0.76,   0.80,   0.81,   0.82,   0.83,   0.84,   0.85,   0.85, &
      0.76,   0.80,   0.81,   0.82,   0.83,   0.84,   0.85,   0.85, &
      0.75,   0.80,   0.81,   0.82,   0.83,   0.84,   0.85,   0.85, &
      0.74,   0.79,   0.81,   0.81,   0.83,   0.84,   0.85,   0.85, &
      0.72,   0.77,   0.79,   0.80,   0.82,   0.83,   0.84,   0.85, &
      0.71,   0.75,   0.77,   0.78,   0.81,   0.83,   0.84,   0.85  &
           /),(/8,17/))

      real, parameter :: asm_dsal02(7,17) = asm_sal02(2:8,:) - asm_sal02(1:7,:)

!--------------------------------------------------------------------
! sea-salt bin 3
!--------------------------------------------------------------------
      real, parameter :: qext_sal03(8,17) = reshape( (/ &
          0.19,   0.34,   0.46,   0.58,   0.91,   1.44,   2.66,   4.20, &
          0.19,   0.34,   0.46,   0.58,   0.91,   1.44,   2.66,   4.20, &
          0.19,   0.34,   0.46,   0.58,   0.91,   1.44,   2.66,   4.20, &
          0.19,   0.34,   0.46,   0.58,   0.91,   1.44,   2.66,   4.20, &
          0.19,   0.34,   0.46,   0.58,   0.92,   1.44,   2.66,   4.20, &
          0.19,   0.34,   0.46,   0.58,   0.92,   1.45,   2.66,   4.20, &
          0.19,   0.34,   0.46,   0.58,   0.92,   1.45,   2.66,   4.21, &
          0.19,   0.34,   0.46,   0.58,   0.92,   1.45,   2.66,   4.20, &
          0.19,   0.34,   0.46,   0.58,   0.92,   1.45,   2.66,   4.21, &
          0.19,   0.34,   0.46,   0.58,   0.92,   1.45,   2.67,   4.21, &
          0.19,   0.34,   0.47,   0.58,   0.92,   1.45,   2.68,   4.22, &
          0.19,   0.34,   0.47,   0.58,   0.92,   1.46,   2.67,   4.22, &
          0.19,   0.35,   0.47,   0.59,   0.92,   1.46,   2.68,   4.23, &
          0.19,   0.35,   0.47,   0.59,   0.93,   1.46,   2.68,   4.23, &
          0.19,   0.35,   0.47,   0.59,   0.93,   1.47,   2.69,   4.25, &
          0.19,   0.35,   0.48,   0.60,   0.94,   1.48,   2.71,   4.27, &
          0.20,   0.36,   0.48,   0.60,   0.94,   1.49,   2.72,   4.29  &
            /),(/8,17/))

      real, parameter :: qext_dsal03(7,17) = qext_sal03(2:8,:) - qext_sal03(1:7,:)

      real, parameter :: ssa_sal03(8,17) = reshape( (/ &
       0.99903,0.98942,0.98658,0.98454,0.98105,0.97736,0.97161,0.96631, &
       0.99907,0.99687,0.99611,0.99559,0.99470,0.99369,0.99208,0.99059, &
       0.99910,0.99917,0.99917,0.99913,0.99905,0.99893,0.99870,0.99847, &
       0.99911,0.99958,0.99970,0.99976,0.99982,0.99985,0.99987,0.99986, &
       0.99915,0.99961,0.99973,0.99980,0.99987,0.99990,0.99993,0.99993, &
       0.99919,0.99963,0.99974,0.99981,0.99988,0.99992,0.99995,0.99996, &
       0.99923,0.99965,0.99976,0.99983,0.99990,0.99994,0.99996,0.99997, &
       0.99929,0.99968,0.99978,0.99984,0.99991,0.99994,0.99997,0.99998, &
       0.99935,0.99970,0.99979,0.99985,0.99991,0.99995,0.99997,0.99998, &
       0.99958,0.99980,0.99987,0.99990,0.99994,0.99997,0.99998,0.99999, &
       0.99976,0.99989,0.99992,0.99995,0.99997,0.99998,0.99999,1.00000, &
       0.99982,0.99991,0.99994,0.99996,0.99998,0.99999,0.99999,1.00000, &
       0.99987,0.99994,0.99996,0.99997,0.99998,0.99999,1.00000,1.00000, &
       0.99998,0.99999,0.99999,1.00000,1.00000,1.00000,1.00000,1.00000, &
       1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
       0.99999,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
       0.99994,0.99996,0.99997,0.99997,0.99997,0.99997,0.99997,0.99997  &
            /),(/8,17/))

      real, parameter :: ssa_dsal03(7,17) = ssa_sal03(2:8,:) - ssa_sal03(1:7,:)

      real, parameter :: asm_sal03(8,17) = reshape( (/ &
          0.81,   0.82,   0.82,   0.82,   0.82,   0.82,   0.83,   0.83, &
          0.81,   0.82,   0.82,   0.82,   0.82,   0.82,   0.82,   0.83, &
          0.81,   0.82,   0.82,   0.82,   0.82,   0.83,   0.83,   0.83, &
          0.81,   0.82,   0.82,   0.83,   0.83,   0.83,   0.83,   0.83, &
          0.81,   0.82,   0.83,   0.83,   0.83,   0.83,   0.84,   0.84, &
          0.81,   0.82,   0.83,   0.83,   0.84,   0.84,   0.84,   0.84, &
          0.81,   0.83,   0.83,   0.83,   0.84,   0.84,   0.84,   0.85, &
          0.81,   0.83,   0.83,   0.84,   0.84,   0.84,   0.85,   0.85, &
          0.81,   0.83,   0.84,   0.84,   0.84,   0.85,   0.85,   0.85, &
          0.81,   0.83,   0.84,   0.84,   0.85,   0.85,   0.86,   0.86, &
          0.80,   0.83,   0.84,   0.85,   0.85,   0.86,   0.86,   0.87, &
          0.80,   0.83,   0.84,   0.85,   0.85,   0.86,   0.86,   0.86, &
          0.80,   0.83,   0.84,   0.85,   0.86,   0.86,   0.86,   0.87, &
          0.80,   0.83,   0.84,   0.85,   0.86,   0.86,   0.87,   0.87, &
          0.80,   0.83,   0.84,   0.85,   0.86,   0.86,   0.87,   0.87, &
          0.79,   0.83,   0.84,   0.85,   0.86,   0.86,   0.87,   0.87, &
          0.78,   0.82,   0.84,   0.84,   0.85,   0.86,   0.87,   0.87  &
            /),(/8,17/))

      real, parameter :: asm_dsal03(7,17) = asm_sal03(2:8,:) - asm_sal03(1:7,:)

      real, parameter :: qext_sal04(8,17) = reshape( (/ &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   1.99, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   1.99, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   1.99, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   1.99, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   1.99, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   1.99, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   2.00, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.69,   1.26,   1.99, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.68,   1.26,   2.00, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.69,   1.26,   2.00, &
          0.09,   0.16,   0.22,   0.28,   0.43,   0.69,   1.26,   2.00, &
          0.09,   0.16,   0.22,   0.27,   0.43,   0.69,   1.27,   2.00, &
          0.09,   0.16,   0.22,   0.28,   0.44,   0.69,   1.27,   2.00, &
          0.09,   0.16,   0.22,   0.28,   0.44,   0.69,   1.27,   2.00, &
          0.09,   0.16,   0.22,   0.28,   0.44,   0.69,   1.27,   2.01, &
          0.09,   0.16,   0.22,   0.28,   0.44,   0.69,   1.27,   2.01, &
          0.09,   0.17,   0.22,   0.28,   0.44,   0.70,   1.28,   2.02  &
            /),(/8,17/))

      real, parameter :: qext_dsal04(7,17) = qext_sal04(2:8,:) - qext_sal04(1:7,:)

      real, parameter :: ssa_sal04(8,17) = reshape( (/ &
       0.99874,0.98463,0.97956,0.97596,0.96927,0.96213,0.95108,0.94110, &
       0.99879,0.99541,0.99411,0.99316,0.99134,0.98932,0.98605,0.98300, &
       0.99881,0.99880,0.99873,0.99866,0.99846,0.99820,0.99771,0.99723, &
       0.99887,0.99940,0.99954,0.99963,0.99971,0.99975,0.99976,0.99975, &
       0.99893,0.99946,0.99960,0.99969,0.99978,0.99984,0.99988,0.99988, &
       0.99899,0.99949,0.99963,0.99972,0.99982,0.99987,0.99991,0.99993, &
       0.99907,0.99952,0.99966,0.99974,0.99984,0.99989,0.99994,0.99995, &
       0.99915,0.99957,0.99969,0.99977,0.99985,0.99991,0.99995,0.99997, &
       0.99923,0.99960,0.99971,0.99979,0.99987,0.99992,0.99996,0.99997, &
       0.99954,0.99976,0.99983,0.99987,0.99992,0.99995,0.99997,0.99998, &
       0.99976,0.99988,0.99991,0.99993,0.99996,0.99998,0.99999,0.99999, &
       0.99982,0.99991,0.99993,0.99995,0.99997,0.99998,0.99999,0.99999, &
       0.99988,0.99994,0.99995,0.99997,0.99998,0.99999,0.99999,1.00000, &
       0.99998,0.99999,0.99999,1.00000,1.00000,1.00000,1.00000,1.00000, &
       1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
       0.99999,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000,1.00000, &
       0.99990,0.99993,0.99995,0.99996,0.99997,0.99997,0.99997,0.99997 &
            /),(/8,17/))

      real, parameter :: ssa_dsal04(7,17) = ssa_sal04(2:8,:) - ssa_sal03(1:7,:)

      real, parameter :: asm_sal04(8,17) = reshape( (/ &
          0.82,   0.82,   0.82,   0.83,   0.83,   0.83,   0.83,   0.83, &
          0.82,   0.82,   0.82,   0.82,   0.83,   0.83,   0.83,   0.83, &
          0.82,   0.82,   0.83,   0.83,   0.83,   0.83,   0.83,   0.83, &
          0.82,   0.83,   0.83,   0.83,   0.83,   0.83,   0.83,   0.84, &
          0.82,   0.83,   0.83,   0.83,   0.84,   0.84,   0.84,   0.84, &
          0.82,   0.83,   0.84,   0.84,   0.84,   0.84,   0.84,   0.84, &
          0.82,   0.83,   0.84,   0.84,   0.84,   0.85,   0.85,   0.85, &
          0.82,   0.84,   0.84,   0.84,   0.85,   0.85,   0.85,   0.85, &
          0.82,   0.84,   0.84,   0.85,   0.85,   0.85,   0.85,   0.85, &
          0.82,   0.84,   0.85,   0.85,   0.86,   0.86,   0.86,   0.86, &
          0.81,   0.84,   0.85,   0.85,   0.86,   0.86,   0.86,   0.87, &
          0.81,   0.84,   0.85,   0.85,   0.86,   0.86,   0.87,   0.87, &
          0.81,   0.84,   0.85,   0.86,   0.86,   0.87,   0.87,   0.87, &
          0.81,   0.84,   0.85,   0.86,   0.86,   0.87,   0.87,   0.87, &
          0.81,   0.85,   0.85,   0.86,   0.87,   0.87,   0.87,   0.88, &
          0.81,   0.84,   0.85,   0.86,   0.87,   0.87,   0.88,   0.88, &
          0.81,   0.84,   0.85,   0.86,   0.87,   0.87,   0.88,   0.88  &
            /),(/8,17/))

      real, parameter :: asm_dsal04(7,17) = asm_sal04(2:8,:) - asm_sal03(1:7,:)

      contains

      subroutine setaer( z, airden, rh, aocs1, aocs2, acbs1, acbs2,&
                         aant, aso4, asal, ads1, ads2, &
                         ads3, ads4, asoa, &
                         dtcbs1, dtcbs2, omcbs1, omcbs2, gcbs1, gcbs2, &
                         dtocs1, dtocs2, omocs1, omocs2, gocs1, gocs2, &
                         dtant, omant, gant, &
                         dtso4, omso4, gso4, &
                         dtsal, omsal, gsal, &
                         dtds1, dtds2, dtds3, dtds4, &
                         omds1, omds2, omds3, omds4, &
                         gds1, gds2, gds3, gds4, nw )
!-----------------------------------------------------------------------------
!   	... calculate aerosol optical depth
!-----------------------------------------------------------------------------
!   AEROSOL TYPES: 
!   ocs1, ocs2, cbs1, cbs2, ant, so4, ds1-ds4,soa, sal
!   where 1=hydrophobic, 2=hydrophilic;
!
!   PARAMETERS:                                                              
!   NZ      - INTEGER, number of specified altitude levels in the working
!             grid                                                           
!   Z       - REAL, specified altitude working grid (km)
!   axxx     aerosoling mix ratio (where xxx is aerosol type)
!
!   dtxxx    REAL, optical depth (absorption)
!   omxxx    REAL, single albedo             
!   gxxx   asysmetry factor
!
!-----------------------------------------------------------------------------
!     VERTICAL DOMAIN is from bottom(1)  to TOP (TOP=plevp)
!        CCM from top(1) to bottom(plevp)
!
!   Converted to MIE Look-up Table by P. Hess, April 2005
!-----------------------------------------------------------------------------

      use mo_control,   only : use_dust
      use mo_grid,      only : plev, plevp
      use mo_chem_utls, only : get_spc_ndx
      use chem_mods,    only : adv_mass
      use mo_constants, only : avogadro

      implicit none

!-----------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in) :: nw
      real, intent(in)    :: z(plevp)
      real, intent(in)    :: aocs1(plevp)
      real, intent(in)    :: aocs2(plevp)
      real, intent(in)    :: acbs1(plevp)
      real, intent(in)    :: acbs2(plevp)
      real, intent(in)    :: aant(plevp)
      real, intent(in)    :: aso4(plevp)
      real, intent(in)    :: asal(plevp,4)
      real, intent(in)    :: ads1(plevp)
      real, intent(in)    :: ads2(plevp)
      real, intent(in)    :: ads3(plevp)
      real, intent(in)    :: ads4(plevp)
      real, intent(in)    :: asoa(plevp)
      real, intent(in)    :: rh(plevp)
      real, intent(in)    :: airden(plevp)            ! molecules air / cm^3

      real, intent(out)    :: dtcbs1(plev,nw)
      real, intent(out)    :: dtcbs2(plev,nw)
      real, intent(out)    :: omcbs1(plev,nw)
      real, intent(out)    :: omcbs2(plev,nw)
      real, intent(out)    :: gcbs1(plev,nw)
      real, intent(out)    :: gcbs2(plev,nw)

      real, intent(out)    :: dtocs1(plev,nw)
      real, intent(out)    :: dtocs2(plev,nw)
      real, intent(out)    :: omocs1(plev,nw)
      real, intent(out)    :: omocs2(plev,nw)
      real, intent(out)    :: gocs1(plev,nw)
      real, intent(out)    :: gocs2(plev,nw)

      real, intent(out)    :: dtant(plev,nw)
      real, intent(out)    :: omant(plev,nw)
      real, intent(out)    :: gant(plev,nw)

      real, intent(out)    :: dtso4(plev,nw)
      real, intent(out)    :: omso4(plev,nw)
      real, intent(out)    :: gso4(plev,nw)

      real, intent(out)    :: dtsal(plev,nw,4)
      real, intent(out)    :: omsal(plev,nw,4)
      real, intent(out)    :: gsal(plev,nw,4)


      real, intent(out)    :: dtds1(plev,nw)
      real, intent(out)    :: dtds2(plev,nw)
      real, intent(out)    :: dtds3(plev,nw)
      real, intent(out)    :: dtds4(plev,nw)
      real, intent(out)    :: omds1(plev,nw)
      real, intent(out)    :: omds2(plev,nw)
      real, intent(out)    :: omds3(plev,nw)
      real, intent(out)    :: omds4(plev,nw)
      real, intent(out)    :: gds1(plev,nw)
      real, intent(out)    :: gds2(plev,nw)
      real, intent(out)    :: gds3(plev,nw)
      real, intent(out)    :: gds4(plev,nw)

!-----------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------
      real, parameter :: km2m     = 1.e3
      real, parameter :: cm3_2_m3 = 1.e6
      real, parameter :: mw_dust  = 34.
      real, parameter :: s2as     = 1.37557  ! conversion factor from mass SO4 to mass (NH4)2(SO4) (assumed in mie calculation).
      real, parameter :: rhmax    = .98      ! maximum relative humidity allowed
      real, parameter :: con_fac  = km2m*cm3_2_m3/avogadro

      integer :: k, n, ndx, wn
      integer :: rh_l
      integer :: rh_u
      integer :: rh_ndx(plev)
      real    :: mw
      real    :: delrh
      real    :: rhtest
      real    :: dz(plev)
      real    :: del_rh(plev)
      real    :: gpm2(plev)
      real    :: table_rh(8) = (/ 0., .5, .7, .8, .9, .95, .98, .99 /)

!-----------------------------------------------------------------------------
! Tables are based on the following wavelength bins from ftuv
!    178.60- 180.00
!    180.00- 183.00
!    183.00- 187.00
!    187.00- 192.00
!    192.00- 198.00
!    198.00- 205.00
!    205.00- 213.00
!    213.00- 222.00
!    222.00- 231.00
!    241.00- 289.90
!    289.90- 305.50
!    305.50- 313.50
!    313.50- 337.50
!    337.50- 420.00
!    420.00- 475.00
!    475.00- 729.00
!    729.00- 743.60
!
! For aerosol types so4 and  ant data tabulated for CAM is used in wavelength bins for which it exists
! This data has been created by  D. Fillmore in the file aerOptics.nc 
! Data is weighted by wavelength bin
! 
! Otherwise, tables have been recreated by P. Hess
!
! Refractive indices and other DATA is mostly from OPAC dataset Hess et al., .....
!
! SULFATE
!
!              r_m = 0.05 ; from Grant 1999   ! median radius of number distribution (microns)
!              sigma = alog10(2.00)           ! standard deviation of distribution
!              rmin = 0.005                   ! minimum radius microns
!              rmax = 20.0                    ! maximum radius microns
!              rho = 1.76                     ! grams / cm^3 
!        PARAMETERS NEEDED FOR CALCULATING KOHLER CURVES for calculating growth with relative humidity
!              nu_s = 3.0
!              rho_u = rho
!              rho_s = rho
!              gamma = 1.0
!              phi = 0.717  ; optimal fit to water activity curves of Tang 1994
!              eps = 1.0
!
!  REFRACTIVE INDEXES FOR SULFATE (for wavelength um)
!     0.300, 0.405, 0.535, 0.656, 0.706, 0.800, 1.00, 1.07,
!     1.15, 1.20, 1.30, 1.40, 1.50, 1.58, 1.60, 1.70, 1.80,
!     1.90, 2.00, 2.05, 2.14, 2.20, 2.30, 2.40, 2.50, 2.63,
!     2.78, 2.94, 3.08, 3.13, 3.18, 3.23, 3.30, 3.33, 3.39,
!     3.45, 3.51, 3.57, 3.85, 4.17, 4.55, 4.76, 5.26]
!
!  REAL
!     1.53, 1.53, 1.52, 1.52, 1.52, 1.52, 1.51, 1.51, $
!     1.51, 1.50, 1.50, 1.50, 1.49, 1.49, 1.49, 1.49, 1.48, $
!     1.48, 1.47, 1.47, 1.47, 1.46, 1.46, 1.45, 1.44, 1.42, $
!     1.40, 1.33, 1.27, 1.39, 1.49, 1.48, 1.56, 1.61, 1.61, $
!     1.60, 1.62, 1.63, 1.56, 1.53, 1.49, 1.48, 1.44]
!  
!  IMAGINARY
!    1.0e-7, 1.0e-7, 1.0e-7, 1.0e-7, 1.0e-7, 1.0e-7, 3.5e-7, 2.4e-6, 
!    9.5e-7, 3.4e-6, 1.7e-5, 1.1e-5, 3.4e-5, 2.1e-4, 1.9e-4, 9.0e-5, 7.6e-5, $
!    1.5e-4, 1.0e-3, 1.5e-3, 3.4e-3, 1.7e-3, 7.7e-4, 4.5e-4, 3.5e-4, 9.0e-4, $
!    5.0e-3, 5.0e-2, 2.3e-1, 3.3e-1, 2.7e-1, 2.4e-1, 2.7e-1, 2.4e-1, 1.7e-1, $
!    1.5e-1, 1.4e-1, 1.0e-1, 2.0e-2, 1.0e-2, 7.0e-3, 6.0e-3, 7.0e-3]
!
!
! NH4NO3
!
! treated the same as sulphate except 
! rho=1.73 (Lowenthal, 1999, Atmospheric Environment).
! 
! DUST
!
! dust is treated as 4 size distributions
! 0.05 - 0.5; 0.5 - 1.25; 1.25 - 2.5; 2.5 - 5.0 microns
! each bin is part of a distribution with median number r_m = 2.524 * exp(- 3.0 * log(2.00)^2) / 2 [number median radius]
! r_m = 0.298, sigma = 2.00, rho = 2.650
! 
! note this treatment of dust is somewhat different than that made in CAM, where each size bin
! has a different number median radius
!
! dust is not assumed to take up water. 
!
! refractive indexes are as in CAM (Fillmore...)
!
! ORGANIC CARBON
!
! In absence of data for organic aerosol 
! refractive indexes are taken as for WASO: based on Fillmore (and OPAC). This is similar to 
! the formulation used in Liao and Seinfeld, 2004, JGR. 
! The growth of organic carbon with relative humidity is assumed constant at all radii following
! hygrscopic growth given in Chen et al. : rel. hum: 0, 50, 70, 80, 90, 95, 98, 99
! multiplier for radius: 1,  1.2,  1.4,  1.5, 1.6, 1.8, 2.1 , 2.2
!
! SOA 
!
! Treated the same as organic aerosol.
!
! SOOT
!
! Refractive index are taken from Fillmore based on OPAC. 
! In a different formulation than that followed in CAM we let hydrophillic soot grow.
!  The growth of organic carbon with relative humidity is assumed constant at all radii following
! hygrscopic growth given in Chen et al. : rel. hum: 0, 50, 70, 80, 90, 95, 98, 99
! multiplier for radius: (1,  1,  1,  1.2, 1.4,  1.5, 1.7, 1.9]
! 
!
! SEA SALT
!
! Assumes 4 bins: 0.1 - 0.5, 0.5-1.5, 1.5-5, 5-10 um assuming a step distribution
! additional parameters used calculation
!   phi = 0.8
!  mol_s = 35.453 + 22.98977
!  nu_s = 2.0
!  rmin = 0.005, rmax = 500, nr = 300
!
! refractive indices are from fillmore
!-----------------------------------------------------------------------------

!-----------------------------------------------------------------------------
! 	... vertical interval dz
!-----------------------------------------------------------------------------
      do k = 1,plev
         dz(k) = abs( z(k+1) - z(k) )  * airden(k) * con_fac
      end do

!----------------------------------------------------------------------------
!  	... calculate interpolatant for relative humidity
!----------------------------------------------------------------------------
       do k = 1,plev
          rhtest = min( rh(k),rhmax )
          do rh_u = 2,8
             if( rhtest <= table_rh(rh_u) ) then
                exit
             end if
          end do
          rh_l      = rh_u - 1
          rh_ndx(k) = rh_l
          del_rh(k) = (rhtest - table_rh(rh_l))/(table_rh(rh_u) - table_rh(rh_l))
       end do

!-----------------------------------------------------------------------------
!      	... so4
!-----------------------------------------------------------------------------
      ndx = get_spc_ndx( 'SO4' )
      if( ndx > 0 ) then
         mw = adv_mass( ndx )
         gpm2(:) = s2as * dz(:) * aso4(:plev) * mw 
         do wn = 1,nw
            do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtso4(k,wn) = gpm2(k)*(qext_so4(rh_l,wn) + delrh*qext_dso4(rh_l,wn))
               omso4(k,wn) = ssa_so4(rh_l,wn) + delrh*ssa_dso4(rh_l,wn)
               gso4(k,wn)  = asm_so4(rh_l,wn) + delrh*asm_dso4(rh_l,wn)
            end do
         end do
      else
         do wn = 1,nw
            dtso4(:,wn) = 0.
            omso4(:,wn) = 0.
            gso4(:,wn)  = 0.
         end do
      end if

!-----------------------------------------------------------------------------
!   	... ant:  nh4no3
!-----------------------------------------------------------------------------    
      ndx = get_spc_ndx( 'NH4NO3' )
      if( ndx > 0 ) then
         mw = adv_mass( ndx )
         gpm2(:) = dz(:) * aant(:plev) * mw 
         do wn = 1,nw
            do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtant(k,wn) = gpm2(k)*(qext_ant(rh_l,wn) + delrh*qext_dant(rh_l,wn))
               omant(k,wn) = ssa_ant(rh_l,wn) + delrh*ssa_dant(rh_l,wn)
               gant(k,wn)  = asm_ant(rh_l,wn) + delrh*asm_dant(rh_l,wn)
            end do
         end do
      else
         do wn = 1,nw
            dtant(:,wn) = 0.
            omant(:,wn) = 0.
            gant(:,wn)  = 0.
         end do
      end if

!-----------------------------------------------------------------------------
!  	... cbs : blackcarbon hydrophobic
!-----------------------------------------------------------------------------
       ndx = get_spc_ndx( 'CB1' )
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * acbs1(:plev) * mw 
          do wn = 1,nw
             dtcbs1(:,wn) = gpm2(:)*qext_cbs(1,wn)
             omcbs1(:,wn) = ssa_cbs(1,wn) 
             gcbs1(:,wn)  = asm_cbs(1,wn)
          end do
      else
         do wn = 1,nw
            dtcbs1(:,wn) = 0.
            omcbs1(:,wn) = 0.
            gcbs1(:,wn)  = 0.
         end do
       end if

       ndx = get_spc_ndx( 'CB2' )
       if( ndx > 0 ) then
          gpm2(:) = dz(:) * acbs2(:plev) * mw 
          do wn = 1,nw
             do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtcbs2(k,wn) = gpm2(k)*(qext_cbs(rh_l,wn) + delrh*qext_dcbs(rh_l,wn))
               omcbs2(k,wn) = ssa_cbs(rh_l,wn) + delrh*ssa_dcbs(rh_l,wn)
               gcbs2(k,wn)  = asm_cbs(rh_l,wn) + delrh*asm_dcbs(rh_l,wn)
             end do
          end do
      else
         do wn = 1,nw
            dtcbs2(:,wn) = 0.
            omcbs2(:,wn) = 0.
            gcbs2(:,wn)  = 0.
         end do
       end if

       ndx = get_spc_ndx( 'OC1' )
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * aocs1(:plev) * mw 
          do wn = 1,nw
             dtocs1(:,wn) =  gpm2(:)*qext_ocs(1,wn)
             omocs1(:,wn) =  ssa_ocs(1,wn) 
             gocs1(:,wn)  =  asm_ocs(1,wn)
          end do
      else
         do wn = 1,nw
            dtocs1(:,wn) = 0.
            omocs1(:,wn) = 0.
            gocs1(:,wn)  = 0.
         end do
       end if
 
       ndx = get_spc_ndx( 'OC2' )
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * aocs2(:plev) * mw 
          do wn = 1,nw
            do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtocs2(k,wn) = gpm2(k)*(qext_ocs(rh_l,wn) + delrh*qext_docs(rh_l,wn))
               omocs2(k,wn) = ssa_ocs(rh_l,wn) + delrh*ssa_docs(rh_l,wn)
               gocs2(k,wn)  = asm_ocs(rh_l,wn) + delrh*asm_docs(rh_l,wn)
             end do
          end do
      else
         do wn = 1,nw
            dtocs2(:,wn) = 0.
            omocs2(:,wn) = 0.
            gocs2(:,wn)  = 0.
         end do
       end if

       ndx = get_spc_ndx( 'SOA' )
       if( ndx > 0 ) then
          ndx = get_spc_ndx( 'OC2' )
          if( ndx > 0 ) then
             mw = adv_mass( ndx )
             gpm2(:) = dz(:) * asoa(:plev) * mw 
             if( ndx > 0 ) then
                do wn = 1,nw
                   do k = 1,plev
                      rh_l  = rh_ndx(k)
                      dtocs2(k,wn) = dtocs2(k,wn) + gpm2(k)*(qext_ocs(rh_l,wn) + del_rh(k)*qext_docs(rh_l,wn))
                   end do
                end do
             end if
          end if
       end if

       if( use_dust ) then
          mw = mw_dust
          gpm2(:) = dz(:) * ads1(:plev) * mw 
          do wn = 1,nw
             dtds1(:,wn) = gpm2(:)*qext_ds1(wn)
             omds1(:,wn) = ssa_ds1(wn) 
             gds1(:,wn)  = asm_ds1(wn)
          end do
          gpm2(:) = dz(:) * ads2(:plev) * mw 
          do wn = 1,nw
             dtds2(:,wn) = gpm2(:)*qext_ds2(wn)
             omds2(:,wn) = ssa_ds2(wn) 
             gds2(:,wn)  = asm_ds2(wn)
          end do
          gpm2(:) = dz(:) * ads3(:plev) * mw 
          do wn = 1,nw
             dtds3(:,wn) = gpm2(:)*qext_ds3(wn)
             omds3(:,wn) = ssa_ds3(wn) 
             gds3(:,wn)  = asm_ds3(wn)
          end do
          gpm2(:) = dz(:) * ads4(:plev) * mw 
          do wn = 1,nw
             dtds4(:,wn) = gpm2(:)*qext_ds4(wn)
             omds4(:,wn) = ssa_ds4(wn) 
             gds4(:,wn)  = asm_ds4(wn)
          end do
       else
          do wn = 1,nw
             dtds1(:,wn) = 0.
             dtds2(:,wn) = 0.
             dtds3(:,wn) = 0.
             dtds4(:,wn) = 0.
             omds1(:,wn) = 0.
             omds2(:,wn) = 0.
             omds3(:,wn) = 0.
             omds4(:,wn) = 0.
             gds1(:,wn)  = 0.
             gds2(:,wn)  = 0.
             gds3(:,wn)  = 0.
             gds4(:,wn)  = 0.
          end do
       end if

       ndx = get_spc_ndx( 'SA1' )
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:plev,1) * mw 
          do wn = 1,nw
            do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,1) = gpm2(k)*(qext_sal01(rh_l,wn) + delrh*qext_dsal01(rh_l,wn))
               omsal(k,wn,1) = ssa_sal01(rh_l,wn) + delrh*ssa_dsal01(rh_l,wn)
               gsal(k,wn,1)  = asm_sal01(rh_l,wn) + delrh*asm_dsal01(rh_l,wn)
             end do
          end do
       else
         do wn = 1,nw
            dtsal(:,wn,1) = 0.
            omsal(:,wn,1) = 0.
            gsal(:,wn,1)  = 0.
         end do
       end if
 
       ndx = get_spc_ndx( 'SA2' )
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:plev,2) * mw 
          do wn = 1,nw
            do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,2) = gpm2(k)*(qext_sal02(rh_l,wn) + delrh*qext_dsal02(rh_l,wn))
               omsal(k,wn,2) = ssa_sal02(rh_l,wn) + delrh*ssa_dsal02(rh_l,wn)
               gsal(k,wn,2)  = asm_sal02(rh_l,wn) + delrh*asm_dsal02(rh_l,wn)
             end do
          end do
       else
         do wn = 1,nw
            dtsal(:,wn,2) = 0.
            omsal(:,wn,2) = 0.
            gsal(:,wn,2)  = 0.
         end do
       end if

       ndx = get_spc_ndx( 'SA3' )
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:plev,3) * mw 
          do wn = 1,nw
            do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,3) = gpm2(k)*(qext_sal03(rh_l,wn) + delrh*qext_dsal03(rh_l,wn))
               omsal(k,wn,3) = ssa_sal03(rh_l,wn) + delrh*ssa_dsal03(rh_l,wn)
               gsal(k,wn,3)  = asm_sal03(rh_l,wn) + delrh*asm_dsal03(rh_l,wn)
            end do
         end do
       else
         do wn = 1,nw
            dtsal(:,wn,3) = 0.
            omsal(:,wn,3) = 0.
            gsal(:,wn,3)  = 0.
         end do
      end if

      ndx = get_spc_ndx( 'SA4' )
      if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:plev,4) * mw 
          do wn = 1,nw
            do k = 1,plev
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,4) = gpm2(k)*(qext_sal04(rh_l,wn) + delrh*qext_dsal04(rh_l,wn))
               omsal(k,wn,4) = ssa_sal04(rh_l,wn) + delrh*ssa_dsal04(rh_l,wn)
               gsal(k,wn,4)  = asm_sal04(rh_l,wn) + delrh*asm_dsal04(rh_l,wn)
            end do
         end do
       else
         do wn = 1,nw
            dtsal(:,wn,4) = 0.
            omsal(:,wn,4) = 0.
            gsal(:,wn,4)  = 0.
         end do
      end if

      end subroutine setaer

      end module mo_setaer
