
      module mo_setext

!--------------------------------------------------------
! LKE, 8/21/07 - remove reading aircraft emissions file
! Now, this routine reads external forcings from datasets, 
!  calculates lightning NO and SYNOZ
!--------------------------------------------------------

      private
      public :: setext_inti, setext

      save

      integer :: no_ndx, synoz_ndx

      contains

      subroutine setext_inti
!--------------------------------------------------------
!	... Initialize the external forcing module
!--------------------------------------------------------

      use mo_chem_utls, only : get_extfrc_ndx

      implicit none

      no_ndx    = get_extfrc_ndx( 'NO' )
      synoz_ndx = get_extfrc_ndx( 'SYNOZ' )

      write(*,*) ' '
      write(*,*) 'setext_inti: diagnostics '
      write(*,'(10i5)') no_ndx, synoz_ndx

      end subroutine setext_inti

      subroutine setext( extfrc, lat, ip, zint, cldtop, &
                         ncdate, ncsec,  plonl )
!--------------------------------------------------------
!     ... for this latitude slice:
!         - form the production from datasets
!         - form the nox production from lighting
!         - form synoz
!--------------------------------------------------------

      use mo_grid,      only : plev, plevp
      use mo_lghtning,  only : prod_no, do_lghtning
      use mo_extfrc,    only : extfrc_set
      use chem_mods,    only : extcnt
      use mo_synoz,     only : po3
      use mo_offline_sources, only: srcs_offline, srcs_names, mxsrcsflds
      use mo_histout,   only : outfld, sim_file_cnt
      use mo_chem_utls, only : get_extfrc_ndx

      implicit none

!--------------------------------------------------------
!     ... dummy arguments
!--------------------------------------------------------
      integer, intent(in) ::   lat                                ! incoming latitude index
      integer, intent(in) ::   plonl                              ! lon tile dim
      integer, intent(in) ::   ip                                 ! incoming longitude tile index
      integer, intent(in) ::   ncdate                             ! present date (yyyymmdd)
      integer, intent(in) ::   ncsec                              ! present seconds in date
      real, intent(in)    ::   zint(plonl,plevp)                  ! interface geopot height above surface (km)
      real, intent(in)    ::   cldtop(plonl)                      ! cloud top index
      real, intent(out)   ::   extfrc(plonl,plev,max(1,extcnt))   ! the "extraneous" forcing (molec/cm^3/s)

!--------------------------------------------------------
!     ... local variables
!--------------------------------------------------------
      real, parameter :: km2cm = 1.e5
      integer :: i, k, k1, kk, cldind
      integer :: file, ndx, m
      real    :: frac
      real    :: zlev_top, zlev_bot, zdel, zdeli

      extfrc(:,:,:) = 0.
!--------------------------------------------------------
!     ... set frcing from datasets
!--------------------------------------------------------
      call extfrc_set( lat, ip, ncdate, ncsec, extfrc, &
                       zint, plonl )
!--------------------------------------------------------
!     ... set nox production from lighting
!         note: from ground to cloud top production is c shaped
!--------------------------------------------------------
      if( no_ndx > 0 ) then
         if( do_lghtning ) then
            do i = 1,plonl
               cldind = nint( cldtop(i) )
               if( cldind < plev .and. cldind > 0  ) then
                  extfrc(i,cldind:plev,no_ndx) = extfrc(i,cldind:plev,no_ndx) &
						 + prod_no(i,lat,cldind:plev,ip)
               end if
            end do
         end if
      end if

!---------------------------------------------------------------------
! 	... synoz production
!---------------------------------------------------------------------
      if( synoz_ndx > 0 ) then
         do k = 1,plev
            do i = 1,plonl
               extfrc(i,k,synoz_ndx) = extfrc(i,k,synoz_ndx) + po3(i,k,lat,ip)
            end do
         end do
      end if

!---------------------------------------------------------------------
! 	... set namelist specified external forcing
!---------------------------------------------------------------------
      do m = 1,mxsrcsflds
         ndx =  get_extfrc_ndx( srcs_names(m) )
         if( ndx > 0 ) then
            do k = 1,plev
               extfrc(:,k,ndx) = extfrc(:,k,ndx) + srcs_offline(:,k,lat,ip,m)
            end do
            do file = 1,sim_file_cnt
               call outfld( 'CO_SRC2', extfrc(:,:,ndx), plonl, ip, lat, file )
            end do
         endif
         if( trim(srcs_names(m)) == 'CO' ) then
            do file = 1,sim_file_cnt
               call outfld( 'CO_SRC1', srcs_offline(:,:,lat,ip,m), plonl, ip, lat, file )
            end do
         end if
      end do

      end subroutine setext

      end module mo_setext
