   +====================================================================+
   | Note: this file, MZ4ROOT/model/docs/README.make, is just an        |
   |       ordinary ascii file and may be printed with the usual Linux  |
   |       print commands such as enscript or lpr                       |
   +====================================================================+

     Purpose : build a mozart4 executable

     Usage   : in the MZ4_ROOT/model directory issue the command:
           
               make_mz4 [argument] [argument] ...

     WARNING : You have to run the configuration utility cfg_mz4 in the
               MZ4ROOT/configuration directory before building any executable.
               (MZ4ROOT denotes the top level mozart4 directory)
               For configuration information issue the command :
                 cfg_mz4 help
               in the MZ4ROOT/configuration directory.

     Details : General

             - No arguments are required

             - If present each argument is of the form :

               keyword=value

               Note that no whitespace (blanks, tabs, ... ) is allowed
               in each keyword=value argument

             - Individual arguments must be separated by one or more blanks

             - Keywords are case insensitive; that is model= and ModeL=
               both denote the "model" keyword

             - Invalid arguments are ignored

             - Duplicate keywords are processed; last argument, left to right, takes effect

             - Value case sensitivity depends on the keyword; see "Details : Arguments"
 
     Details : Arguments

                           Value case                                                              Value 
               Keyword     sensitive    Valid value             Description                        Default    
               -------     ----------   -----------             -----------                        -------
               model       no           {hyb,mpi,omp,sng}       (1)                                  (a)
               exe         yes          filename                simulation executable file           (b)
               usr_src     yes          filenames, directories  user code modifications,additions    None (c)

               Notes
               -----

               (a) - "model" default is taken from the mz4 configuration file MZ4.cfg
               (b) - if unspecified "exe", short for executable,  will default to
                     mz4_$model, where $model is one of {sng,omp,mpi,hyb}, in the
                     MZ4ROOT/model/bin directory
               (c) - usr_src allows for simulations other than the "standard"
                     supplied code.  In particular this option is used in conjunction
                     with the preprocessor, mozpp, to build executables other
                     than the "standard" simulation
                   - usr_src is set as a series of directories, either full,
                     absolute paths or paths relative to the MZ4ROOT/model
	             directory, separated by commas(see example 3)

               (1) - a mozart simulation is run with one of the four following executables

                     sng = single cpu(no openmp or mpi)
                           - the slowest option
                           - most likely to run
                           - mostly for historical purposes
                     omp = distributes computation over cpus sharing a common memory using
                           openmp compiler directives
                           - generally only efficient with four or fewer cpus
                     mpi = distributes computation over cpus using mpi functions
                           - your computing environment must be able to build and run mpi executables
                           - mozart limits the mpi process count depending on the number of spatial latitudes
                             (for the supplied mozart model the mpi process count must be <= 16)
                     hyb = distributes computation over cpus using a combination
                           of mpi functions and openmp compiler directives
                           - your computing environment must be able to build and run mpi executables
                           - mozart limits the mpi process count depending on the number of spatial latitudes
                             (for the supplied mozart model the mpi process count must be <= 16)
                   
     Examples :

               (1) make_mz4
                  
                   This is the simpliest make command.  All arguments will assume
	           default values.  The executable, mz4_$model {hyb,mpi,omp,sng}
                   will be in the MZ4ROOT/model/bin directory.

                   To recap the following defaults are in place for this model build
                   (assuming cfg_mz4 was run with default options)

                     (i) - builds the hybrid mz4_hyb executable
                    (ii) - uses the mpif90 script defined in the configuration file
                   (iii) - uses the fortran90 compiler defined in the configuration file
                    (iv) - uses the netcdf library and include files defined in the
                           configuration file

               (2) make_mz4 model=omp 
                  
                   Same as example (1) except an openmp executable, mz4_omp,
                   will be built.

               (3) make_mz4 exe=mz4_t63_hyb usr_src=pp_t63

                   Same as example (1) except the executable is named mz4_t63_hyb
                   reflecting the horizontal resolution (the standard model has
	           t42 horizontal resolution).  And code output from preprocessing
	           an input file specifying t63 horizontal resolution has been placed
                   in the MZ4ROOT/model/pp_t63 directory and will be used to build
                   the mz4_t63_hyb executable.  The standard executable uses preprocessor
	           source files in the MZ4ROOT/model/pp directory.
	           
