
      module mo_hist_hdr

      private
      public :: hist_hdr

      contains

      subroutine hist_hdr( hst_file_cnt, histout_cnt, histout_map, user_hst_names, hist_type, &
                           dyn_hst_fld_cnt, spcsym, spccnt, hetmap, usrmap, &
                           ptplen, filename )
!-----------------------------------------------------------------------
!        ... Process all output history tape controls
!-----------------------------------------------------------------------

      use mass_diags
      use var_mod, only : var_lim, hst_file_lim, hst_map_lim, hst_cat_lim
      use var_mod, only : class_prod_cnt, class_loss_cnt, clsmap
      use var_mod, only : local_time, local_time_char
      use rxt_mod, only : rxt_lim, rxt_tag, phtcnt, rxntot, rxt_has_tag

      implicit none

!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in)  ::      hst_file_cnt                        ! number of history files
      integer, intent(in)  ::      histout_cnt(hst_cat_lim,2,hst_file_lim)             ! number of outputs in each catagory
      integer, intent(in)  ::      histout_map(hst_map_lim,hst_cat_lim,2,hst_file_lim) ! map of outputs
      integer, intent(in)  ::      dyn_hst_fld_cnt(2)
      integer, intent(in)  ::      spccnt(*)                           ! number of symbols in each catagory
      integer, intent(in)  ::      hetmap(*)                           ! wet dep map
      integer, intent(in)  ::      usrmap(*)                           ! ext frc map
      integer, intent(out) ::      ptplen                              ! total hist tape fields
      character(len=64), intent(in) :: hist_type                       ! type of dyn hist tape ( short/long )
      character(len=8), intent(in)  :: user_hst_names(var_lim,4)
      character(len=8), intent(in)  :: spcsym(var_lim,*)               ! list of symbols
      character(len=*), intent(in)  :: filename                        ! path/name of simulation data file

!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer, parameter :: inst = 1
      integer, parameter :: avgr = 2

      integer  ::  i, j, m, n, typind
      integer  ::  id_ox = 0
      integer  ::  cat_ndx
      integer  ::  file
      integer  ::  istat
      integer  ::  class, classno
      integer  ::  summ(2), sums(2)
      integer, allocatable :: ndx(:)
      character(len=32) :: fld_name(4)
      character(len=8)  :: namtag(1000)
      character(len=4)  :: numa
      character(len=4)  :: oper_tag(2) = (/ 'inst', 'avrg' /)
      character(len=3)  :: num
      logical  ::  lexist
      logical  ::  is_emission
      
      close( 30 )
      open( unit = 30, &
            file = 'hist.h', &
            status = 'replace', &
            iostat = istat )
      if( istat /= 0 ) then
         write(*,*) 'HIST_HDR: Failed to open hist.h'
         stop
      end if
!-----------------------------------------------------------------------
!	... Form reaction tag mapping
!-----------------------------------------------------------------------
      allocate( ndx(max(rxntot,1)) )
      ndx(:) = 0
      if( rxntot > 0 ) then
         j = 0
         do m = 1,rxntot
            if( rxt_has_tag(m) ) then
               j = j + 1
               if( m > phtcnt ) then
                  ndx(m) = j
               end if
            end if
         end do 
      end if
!-----------------------------------------------------------------------
!	... Locate index for ox
!-----------------------------------------------------------------------
      do i = 1,spccnt(6)
         if( spcsym(i,6) == 'OX' ) then
            id_ox = i
            exit
         end if
      end do

      do typind = inst,avgr
         summ(typind) = sum( histout_cnt(:2,typind,1) ) + sum( histout_cnt(5:6,typind,1) ) &
                      + sum( histout_cnt(8:11,typind,1) ) + sum( histout_cnt(13:16,typind,1) ) &
                      + histout_cnt(18,typind,1) + histout_cnt(20,typind,1)
      end do
      write(30,'(''# define PMULTI '',i3)') summ(1) + summ(2)
      write(30,'(''# define PMULTA '',i3)') summ(2)
      sums(1) = histout_cnt(3,inst,1) + histout_cnt(4,inst,1) &
              + histout_cnt(7,inst,1) + histout_cnt(12,inst,1) &
              + histout_cnt(17,inst,1) + histout_cnt(19,inst,1)
      sums(2) = histout_cnt(3,avgr,1) + histout_cnt(4,avgr,1) + histout_cnt(12,avgr,1) &
              + histout_cnt(17,avgr,1) + histout_cnt(19,avgr,1)
      write(30,'(''# define PSINGL '',i3)') sums(1) + sums(2)
      write(30,'(''# define PSINGLA '',i3)') sums(2)
      ptplen = summ(1) + sums(1) + summ(2) + sums(2)
      write(30,'(''# define PTPLEN '',i3)') ptplen
      i = sum( histout_cnt(:4,inst,1) ) + sum( histout_cnt(8:13,inst,1) ) &
        + sum( histout_cnt(:4,avgr,1) ) + sum( histout_cnt(8:13,avgr,1) )
      write(30,'(''# define HSTLEN '',i3)') i
      write(30,'(''# define HSTOFFSET '',i3)') sum( histout_cnt(5:7,inst,1) )
      write(30,'(''# define HSTINSCNT '',i3)') sum( histout_cnt(:17,inst,1) )
      write(30,'(''# define HSTINSCNTM '',i3)') &
              sum( histout_cnt(:4,inst,1) ) &
            + sum( histout_cnt(8:13,inst,1) )
      write(30,'(''# define HSTPHTCNT '',i3)') histout_cnt(8,inst,1)
      write(30,'(''# define HSTRXTCNT '',i3)') histout_cnt(9,inst,1)
      write(30,'(''# define HSTPHTCNTA '',i3)') histout_cnt(8,avgr,1)
      write(30,'(''# define HSTRXTCNTA '',i3)') histout_cnt(9,avgr,1)
      write(30,'(''# define HSTRXTIND '',i3)') sum( histout_cnt(:4,inst,1) )
      write(30,'(''# define HSTUSRINDI '',i3)') sum( histout_cnt(:4,inst,1) ) &
                                                + sum( histout_cnt(8:11,inst,1) )
      write(30,'(''# define HSTRXTINDA '',i3)') sum( histout_cnt(:4,inst,1) ) &
                                            + sum( histout_cnt(8:13,inst,1) ) &
                                            + sum( histout_cnt(:4,avgr,1) )
      write(30,'(''# define HSTUSRINDA '',i3)') sum( histout_cnt(:4,inst,1) ) &
                                                + sum( histout_cnt(8:13,inst,1) ) &
                                                + sum( histout_cnt(:11,avgr,1) )
      write(30,'(''# define HSTAVGCNT '',i3)') sum( histout_cnt(:17,avgr,1) )
      write(30,'(''# define HSTXPTICNT '',i3)') histout_cnt(1,inst,1)
      write(30,'(''# define HSTXPTACNT '',i3)') histout_cnt(1,avgr,1)
      write(30,'(''# define HSTPCEICNT '',i3)') histout_cnt(2,inst,1)
      write(30,'(''# define HSTPCEACNT '',i3)') histout_cnt(2,avgr,1)
      write(30,'(''# define HSTSFLXICNT '',i3)') histout_cnt(3,inst,1)
      write(30,'(''# define HSTSFLXACNT '',i3)') histout_cnt(3,avgr,1)
      write(30,'(''# define HSTDVELICNT '',i3)') histout_cnt(4,inst,1)
      write(30,'(''# define HSTDVELACNT '',i3)') histout_cnt(4,avgr,1)
      write(30,'(''# define HSTWDEPICNT '',i3)') histout_cnt(10,inst,1)
      write(30,'(''# define HSTWDEPACNT '',i3)') histout_cnt(10,avgr,1)
      write(30,'(''# define HSTEXTICNT '',i3)') histout_cnt(11,inst,1)
      write(30,'(''# define HSTEXTACNT '',i3)') histout_cnt(11,avgr,1)
      write(30,'(''# define HSTUSRSICNT '',i3)') histout_cnt(12,inst,1)
      write(30,'(''# define HSTUSRMICNT '',i3)') histout_cnt(13,inst,1)
      write(30,'(''# define HSTUSRSACNT '',i3)') histout_cnt(12,avgr,1)
      write(30,'(''# define HSTUSRMACNT '',i3)') histout_cnt(13,avgr,1)
      write(30,'(''# define HSTPROD '',i3)') histout_cnt(14,inst,1)
      write(30,'(''# define HSTPRODA '',i3)') histout_cnt(14,avgr,1)
      write(30,'(''# define HSTLOSS '',i3)') histout_cnt(15,inst,1)
      write(30,'(''# define HSTLOSSA '',i3)') histout_cnt(15,avgr,1)
      write(30,'(''# define HSTPLCNT1 '',i3)') max( maxval(class_prod_cnt(1,:)),maxval(class_loss_cnt(1,:)) )
      write(30,'(''# define HSTPLCNT2 '',i3)') max( maxval(class_prod_cnt(2,:)),maxval(class_loss_cnt(2,:)) )
      write(30,'(''# define HSTPLCNT3 '',i3)') max( maxval(class_prod_cnt(3,:)),maxval(class_loss_cnt(3,:)) )
      write(30,'(''# define HSTPLCNT4 '',i3)') max( maxval(class_prod_cnt(4,:)),maxval(class_loss_cnt(4,:)) )
      write(30,'(''# define HSTPLCNT5 '',i3)') max( maxval(class_prod_cnt(5,:)),maxval(class_loss_cnt(5,:)) )
      write(30,'(''# define SW_MDI_CNT '',i3)') histout_cnt(16,inst,1)
      write(30,'(''# define SW_MDA_CNT '',i3)') histout_cnt(16,avgr,1)
      write(30,'(''# define SW_HINST '',i5)') sum(histout_cnt(:4,inst,1)) &
                                              + sum(histout_cnt(8:11,inst,1)) &
                                              + sum(histout_cnt(14:17,inst,1))
      write(30,'(''# define SW_HTIMAV '',i5)') sum(histout_cnt(:4,avgr,1)) &
                                               + sum(histout_cnt(8:11,avgr,1)) &
                                               + sum(histout_cnt(14:17,avgr,1))
      if( sum(histout_cnt(14,:,1)+histout_cnt(15,:,1)) /= 0 ) then
         write(30,'(''# define HSTPRDLOSS'')')
      end if
      if( sum( histout_cnt(17,:,1) ) /= 0 ) then
         write(30,'(''# define HSTMDIAGS'')')
      end if
      if( id_ox /= 0 ) then
         do i = 14,15
            if( any( histout_map(:histout_cnt(i,1,1),i,1,1) == id_ox ) .or. &
                any( histout_map(:histout_cnt(i,2,1),i,2,1) == id_ox ) ) then
               if( i == 14 ) then
                  write(30,'(''# define OX_PROD '')')
               else
                  write(30,'(''# define OX_LOSS '')')
               end if
            end if
         end do
      end if
      if( sum( histout_cnt(12:13,inst,1) ) + sum( histout_cnt(12:13,avgr,1) ) /= 0 ) then
         write(30,'(''# define HSTUSR'')')
      end if

!-----------------------------------------------------------------------
!	... Group history output flag
!-----------------------------------------------------------------------
      if( (histout_cnt(2,inst,1) + histout_cnt(2,avgr,1)) /= 0 ) then
         write(30,'(''# define GRPHST'')')
      end if

      close(30)

!-----------------------------------------------------------------------
!        ... Write the history output tape information
!	     1. item count by category
!	     2. xported species
!	     3. "pce" species
!	     4. surface emissions
!	     5. deposition velocities
!	     6. washout rates
!	     7. "extraneous" forcing rates
!-----------------------------------------------------------------------
      open( unit   = 30, &
            file   = trim(filename), &
            status = 'replace', &
            iostat = istat )
      if( istat /= 0 ) then
         write(*,*) 'HIST_HDR: Failed to open '// trim(filename)
         stop
      end if
      write(30,'(i4)') hst_file_cnt
      do m = 1,hst_file_cnt
         write(30,'(10i4)') histout_cnt(:,:,m)
      end do
      if( ptplen /= 0 ) then
file_loop : &
         do file = 1,hst_file_cnt
output_type : &
            do typind = 1,2
!----------------------------------------------------------------------
!        ... species concentrations
!----------------------------------------------------------------------
               if( histout_cnt(1,typind,file) /= 0 ) then
                  fld_name(:) = ' '
                  do j = 1,histout_cnt(1,typind,file)
                     m = mod( j-1,4 ) + 1
                     write(fld_name(m),'(a)') trim( spcsym(histout_map(j,1,typind,file),6) )
                     write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_VMR_'',a4)') oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(1,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
		     end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(1,typind,file),1,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... group member concentrations
!----------------------------------------------------------------------
	       if( histout_cnt(2,typind,file) /= 0 ) then
	          fld_name(:) = ' '
	          do j = 1,histout_cnt(2,typind,file)
		     m = mod( j-1,4 ) + 1
	             write(fld_name(m),'(a)') trim( spcsym(histout_map(j,2,typind,file),7) )
	             write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_VMR_'',a4)') oper_tag(typind)
                     if( m == 4 .or. j == histout_cnt(2,typind,file) ) then
                        write(30,'(4a32)') fld_name(:m)
                        fld_name(:) = ' '
                     end if
                  end do
                  write(30,'(20i4)') histout_map(:histout_cnt(2,typind,file),2,typind,file)
               end if

!----------------------------------------------------------------------
!        ... surface emissions
!----------------------------------------------------------------------
               if( histout_cnt(3,typind,file) /= 0 ) then
                  fld_name(:) = ' '
                  do j = 1,histout_cnt(3,typind,file)
                     m = mod( j-1,4 ) + 1
                     write(fld_name(m),'(a)') trim( spcsym(histout_map(j,3,typind,file),6) )
                     write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_SRF_EMIS_'',a4)') oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(3,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(3,typind,file),3,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... dry deposition velocity
!----------------------------------------------------------------------
	       if( histout_cnt(4,typind,file) /= 0 ) then
	          fld_name(:) = ' '
	          do j = 1,histout_cnt(4,typind,file)
		     m = mod( j-1,4 ) + 1
	             write(fld_name(m),'(a)') trim( spcsym(histout_map(j,4,typind,file),6) )
	             write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_DEP_VEL_'',a4)') oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(4,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(4,typind,file),4,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... photolysis rate constants
!----------------------------------------------------------------------
	       if( histout_cnt(8,typind,file) /= 0 ) then
	          do j = 1,histout_cnt(8,typind,file)
		     m = mod( j-1,4 ) + 1
		     n = histout_map(j,8,typind,file)
		     fld_name(m) = trim(rxt_tag(n)) // '_rcon_' // oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(8,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	           end do
	          write(30,'(20i4)') histout_map(:histout_cnt(8,typind,file),8,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... reaction rate constants
!----------------------------------------------------------------------
	       if( histout_cnt(9,typind,file) /= 0 ) then
	          do j = 1,histout_cnt(9,typind,file)
		     m = mod( j-1,4 ) + 1
		     n = histout_map(j,9,typind,file)
                     if( ndx(n+phtcnt) /= 0 ) then
		        fld_name(m) = trim(rxt_tag(n+phtcnt)) // '_rcon_' // oper_tag(typind)
                     else
		        write(numa,'(i4)') n + 1000
		        fld_name(m) = 'R_' // numa(2:4) // '_rcon_' // oper_tag(typind)
                     end if
		     if( m == 4 .or. j == histout_cnt(9,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(9,typind,file),9,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... washout rate constants
!----------------------------------------------------------------------
	       if( histout_cnt(10,typind,file) /= 0 ) then
	          fld_name(:) = ' '
	          do j = 1,histout_cnt(10,typind,file)
		     m = mod( j-1,4 ) + 1
		     i = hetmap(histout_map(j,10,typind,file))
	             write(fld_name(m),'(a)') trim( spcsym(i,6) )
	             write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_WET_DEP_RATE_'',a4)') oper_tag(typind)
                     if( m == 4 .or. j == histout_cnt(10,typind,file) ) then
                        write(30,'(4a32)') fld_name(:m)
                        fld_name(:) = ' '
                     end if
                  end do
                  write(30,'(20i4)') histout_map(:histout_cnt(10,typind,file),10,typind,file)
               end if

!----------------------------------------------------------------------
!        ... external forcing
!----------------------------------------------------------------------
               if( histout_cnt(11,typind,file) /= 0 ) then
                  fld_name(:) = ' '
                  do j = 1,histout_cnt(11,typind,file)
                     m = mod( j-1,4 ) + 1
                     i = usrmap(histout_map(j,11,typind,file))
                     write(fld_name(m),'(a)') trim( spcsym(i,6) )
                     write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_EXT_FRC_'',a4)') oper_tag(typind)
                     if( m == 4 .or. j == histout_cnt(11,typind,file) ) then
                        write(30,'(4a32)') fld_name(:m)
                        fld_name(:) = ' '
                     end if
                  end do
	          write(30,'(20i4)') histout_map(:histout_cnt(11,typind,file),11,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... defaults
!----------------------------------------------------------------------
	       if( histout_cnt(12,typind,file) /= 0 ) then
	          do j = 1,histout_cnt(12,typind,file)
		     m = mod( j-1,4 ) + 1
	             fld_name(m) = trim( user_hst_names(j,2*(typind-1)+1) ) // '_' // oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(12,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	       end if

!----------------------------------------------------------------------
!        ... user defined
!----------------------------------------------------------------------
	       if( histout_cnt(13,typind,file) /= 0 ) then
	          do j = 1,histout_cnt(13,typind,file)
		     m = mod( j-1,4 ) + 1
	             fld_name(m) = trim( user_hst_names(j,2*(typind-1)+2) ) // '_' // oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(13,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	       end if

!----------------------------------------------------------------------
!        ... species production
!----------------------------------------------------------------------
	       if( histout_cnt(14,typind,file) /= 0 ) then
	          fld_name(:) = ' '
	          do j = 1,histout_cnt(14,typind,file)
		     class   = histout_map(j,14,typind,file)/1000
		     classno = mod( histout_map(j,14,typind,file),1000 )
		     n       = clsmap(classno,class,2)
		     m = mod( j-1,4 ) + 1
	             write(fld_name(m),'(a)') trim( spcsym(n,6) )
	             write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_PROD_'',a4)') oper_tag(typind)
                     if( m == 4 .or. j == histout_cnt(14,typind,file) ) then
                        write(30,'(4a32)') fld_name(:m)
                        fld_name(:) = ' '
                     end if
                  end do
                  write(30,'(20i4)') histout_map(:histout_cnt(14,typind,file),14,typind,file)
               end if

!----------------------------------------------------------------------
!        ... species loss
!----------------------------------------------------------------------
               if( histout_cnt(15,typind,file) /= 0 ) then
                  fld_name(:) = ' '
                  do j = 1,histout_cnt(15,typind,file)
                     class   = histout_map(j,15,typind,file)/1000
                     classno = mod( histout_map(j,15,typind,file),1000 )
                     n       = clsmap(classno,class,2)
                     m = mod( j-1,4 ) + 1
                     write(fld_name(m),'(a)') trim( spcsym(n,6) )
                     write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_LOSS_'',a4)') oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(15,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(15,typind,file),15,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... mass diagnostics
!----------------------------------------------------------------------
	       if( histout_cnt(16,typind,file) /= 0 ) then
	          do j = 1,histout_cnt(16,typind,file),8
	             fld_name(:) = ' '
		     do i = 1,4
		        select case (i)
			case( 1 )
	                   write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
	                   write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_ADV_'',a4)') oper_tag(typind)
                        case( 2 )
                           write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
                           write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_DPS_'',a4)') oper_tag(typind)
			case( 3 )
	                   write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
	                   write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_CNV_'',a4)') oper_tag(typind)
                        case( 4 )
                           write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
                           write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_DIF_'',a4)') oper_tag(typind)
	                   write(30,'(4a32)') fld_name(:)
		        end select
	             end do
	             fld_name(:) = ' '
		     do i = 1,4
		        select case (i)
			case( 1 )
	                   write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
	                   write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_CHM_'',a4)') oper_tag(typind)
                        case( 2 )
                           write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
                           write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_XFLX_'',a4)') oper_tag(typind)
			case( 3 )
	                   write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
	                   write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_YFLX_'',a4)') oper_tag(typind)
                        case( 4 )
                           write(fld_name(i),'(a)') trim( spcsym(histout_map(j,16,typind,file),6) )
                           write(fld_name(i)(len_trim(fld_name(i))+1:),'(''_ZFLX_'',a4)') oper_tag(typind)
	                   write(30,'(4a32)') fld_name(:)
		        end select
	             end do
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(16,typind,file),16,typind,file)
	       end if

!----------------------------------------------------------------------
!        ... dry deposition flux
!----------------------------------------------------------------------
	       if( histout_cnt(17,typind,file) /= 0 ) then
	          fld_name(:) = ' '
	          do j = 1,histout_cnt(17,typind,file)
		     m = mod( j-1,4 ) + 1
	             write(fld_name(m),'(a)') trim( spcsym(histout_map(j,17,typind,file),6) )
	             write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_DRY_DEP_FLX_'',a4)') oper_tag(typind)
                     if( m == 4 .or. j == histout_cnt(17,typind,file) ) then
                        write(30,'(4a32)') fld_name(:m)
                        fld_name(:) = ' '
                     end if
                  end do
                  write(30,'(20i4)') histout_map(:histout_cnt(17,typind,file),17,typind,file)
               end if

!----------------------------------------------------------------------
!        ... washout flux at lower bndy
!----------------------------------------------------------------------
	       if( histout_cnt(18,typind,file) /= 0 ) then
	          fld_name(:) = ' '
	          do j = 1,histout_cnt(18,typind,file)
		     m = mod( j-1,4 ) + 1
		     i = hetmap(histout_map(j,18,typind,file)/1000)
	             write(fld_name(m),'(a)') trim( spcsym(i,6) )
	             write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_WETDEP_FLUX_'',a4)') oper_tag(typind)
                     if( m == 4 .or. j == histout_cnt(18,typind,file) ) then
                        write(30,'(4a32)') fld_name(:m)
                        fld_name(:) = ' '
                     end if
                  end do
                  write(30,'(10i8)') histout_map(:histout_cnt(18,typind,file),18,typind,file)
               end if
!----------------------------------------------------------------------
!        ... species lifetime
!----------------------------------------------------------------------
               if( histout_cnt(19,typind,file) /= 0 ) then
                  fld_name(:) = ' '
                  do j = 1,histout_cnt(19,typind,file)
                     class   = histout_map(j,19,typind,file)/1000
                     classno = mod( histout_map(j,19,typind,file),1000 )
                     n       = clsmap(classno,class,2)
                     m = mod( j-1,4 ) + 1
                     write(fld_name(m),'(a)') trim( spcsym(n,6) )
                     write(fld_name(m)(len_trim(fld_name(m))+1:),'(''_LIFETIME_'',a4)') oper_tag(typind)
		     if( m == 4 .or. j == histout_cnt(19,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(19,typind,file),19,typind,file)
	       end if
!----------------------------------------------------------------------
!        ... local time
!----------------------------------------------------------------------
               if( histout_cnt(20,typind,file) /= 0 .and. typind == avgr ) then
	          write(30,'(a5)') local_time_char(file)
	          write(30,'(i5)') local_time(file)
                  fld_name(:) = ' '
                  do j = 1,histout_cnt(20,typind,file)
                     n   = histout_map(j,20,typind,file)
                     if( n > 10000 ) then
                        n = mod( n,10000 )
                        is_emission = .true.
                     else
                        is_emission = .false.
                     end if
                     m = mod( j-1,4 ) + 1
                     write(fld_name(m),'(a)') trim( spcsym(n,6) )
                     if( .not. is_emission ) then
                        fld_name(m)(len_trim(fld_name(m))+1:) = '_' // local_time_char(file) // '_LT'
                     else
                        fld_name(m)(len_trim(fld_name(m))+1:) = '_emis_' // local_time_char(file) // '_LT'
                     end if
		     if( m == 4 .or. j == histout_cnt(20,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i5)') histout_map(:histout_cnt(20,typind,file),20,typind,file)
	       end if
!----------------------------------------------------------------------
!        ... photolysis rates and rate constants
!----------------------------------------------------------------------
	       if( histout_cnt(21,typind,file) /= 0 ) then
	          do j = 1,histout_cnt(21,typind,file)
		     m = mod( j-1,4 ) + 1
		     n = histout_map(j,21,typind,file)
		     fld_name(m) = trim(rxt_tag(n)) // '_' // oper_tag(typind)
                     if( m == 4 .or. j == histout_cnt(21,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(21,typind,file),21,typind,file)
	       end if
!----------------------------------------------------------------------
!        ... reaction rates
!----------------------------------------------------------------------
	       if( histout_cnt(22,typind,file) /= 0 ) then
	          do j = 1,histout_cnt(22,typind,file)
		     m = mod( j-1,4 ) + 1
		     n = histout_map(j,22,typind,file)
                     if( ndx(n+phtcnt) /= 0 ) then
		        fld_name(m) = trim(rxt_tag(n+phtcnt)) // '_' // oper_tag(typind)
                     else
		        write(numa,'(i4)') n + 1000
		        fld_name(m) = 'R_' // numa(2:4) // '_' // oper_tag(typind)
                     end if
                     if( m == 4 .or. j == histout_cnt(22,typind,file) ) then
	                write(30,'(4a32)') fld_name(:m)
	                fld_name(:) = ' '
	             end if
	          end do
	          write(30,'(20i4)') histout_map(:histout_cnt(22,typind,file),22,typind,file)
	       end if
            end do output_type
         end do file_loop
      end if

!-----------------------------------------------------------------------
!        ... Write out the diagnostics
!-----------------------------------------------------------------------
      call mass_diags_serialize( 30 )

      close(30)

      deallocate( ndx )

      end subroutine hist_hdr

      end module mo_hist_hdr
