
      module LU_FACTOR

      use IO, only : temp_path

      implicit none

      character(len= 4) :: hdr, up_hdr

      CONTAINS

      subroutine MAKE_LU_FAC( n, class, lu_sp_pat, mat_sp_pat, sp_map, machine )
!-----------------------------------------------------------------------
!        ... Write the fortran code for the sparse matrix decomposition
!-----------------------------------------------------------------------

      implicit none
     
!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) :: n                       ! species in class count
      integer, intent(in) :: class                   ! class number
      integer, intent(in) :: sp_map(n,n)             ! sparsity matrix map
      character(len=8), intent(in) :: machine        ! computational machine
      logical, intent(in), dimension(n,n) :: lu_sp_pat, mat_sp_pat
      
!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer, parameter :: max_lines = 50
      integer           :: i, ip1, j, k, l, row, col, sub_cnt
      integer           :: indx, pos, line_cnt
      character(len=90) :: code
      character(len=72) :: comment, blank, buff
      character(len=32) :: sub_name
      character(len= 6) :: mat_piece
      character(len= 4) :: num
      logical           :: lexist
      logical           :: sp_pat(n,n)
      
!-----------------------------------------------------------------------
!        ... Create and open code file; if it exists remove first
!-----------------------------------------------------------------------
      line_cnt = 0
      if( class == 4 ) then
         sub_name = 'imp_factor.F'
	 hdr    = 'imp_'
	 up_hdr = 'imp_'
      else
         sub_name = 'rod_factor.F'
	 hdr    = 'rod_'
	 up_hdr = 'rod_'
      end if

      inquire( file = trim( temp_path ) // trim( sub_name ), exist = lexist )
      if( lexist ) then
         call system( 'rm ' // trim( temp_path ) // trim( sub_name ) )
      end if
      open( unit = 30, file = trim( temp_path ) // trim( sub_name ) )

      if( n == 0 ) then
	 sub_cnt = 0
      else
	 sub_cnt = 1
      end if
      code = ' '
      write(30,100) trim(code)
      if( class == 4 ) then
         code = '      module mo_imp_factor'
      else if( class == 5 ) then
         code = '      module mo_rod_factor'
      end if
      write(30,100) trim(code)
      code = ' '
      write(30,100) trim(code)
      code = '      contains'
      write(30,100) trim(code)
      call MAKE_LU_FAC_HDR( sub_cnt, machine )

      code = ' ' ; blank = ' '
      if( n > 0 ) then
         sp_pat = mat_sp_pat
         comment = '!------------------------------------------------------------------------'

         select case( machine )
            case( 'INTEL' )
	       mat_piece = 'lu('
	    case default
	       mat_piece = 'lu(k,'
         end select
      end if

Column_loop : &
      do i = 1,n
!-----------------------------------------------------------------------
!        ... Form diagonal inverse
!-----------------------------------------------------------------------
         indx = sp_map(i,i)
         write(num,'(i4)') indx
	 num = ADJUSTL( num )
	 l = LEN_trim( num )
         code(10:) = trim( mat_piece ) // num(:l) // ') = 1. / ' // trim( mat_piece ) // num(:l) // ')'
         write(30,100) trim(code)
	 line_cnt = line_cnt + 1
         buff = ' * ' // trim( mat_piece ) // num(:l) // ')'
	 ip1 = i + 1
!-----------------------------------------------------------------------
!        ... Multiply column below diagonal
!-----------------------------------------------------------------------
	 do row = ip1,n
	    if( sp_pat(row,i) ) then
               indx = sp_map(row,i)
               write(num,'(i4)') indx
	       num = ADJUSTL( num )
	       l = LEN_trim( num )
               code(10:) = trim( mat_piece ) // num(:l) // ') = ' // trim( mat_piece ) // num(:l) // ')' &
				   // buff(:LEN_trim(buff))
               write(30,100) trim(code)
	       line_cnt = line_cnt + 1
	    end if
	 end do
!-----------------------------------------------------------------------
!        ... Modify sub-matrix
!-----------------------------------------------------------------------
	 do col = ip1,n
	    if( sp_pat(i,col) ) then
               indx = sp_map(i,col)
               write(num,'(i4)') indx
	       num = ADJUSTL( num )
	       l = LEN_trim( num )
               buff = ' * ' // trim( mat_piece ) // num(:l) // ')'
	       do row = ip1,n
	          if( sp_pat(row,i) ) then
                     indx = sp_map(row,col)
                     write(num,'(i4)') indx
	             num = ADJUSTL( num )
	             l = LEN_trim( num )
	             if( sp_pat(row,col) ) then
                        code(10:) = trim( mat_piece ) // num(:l) // ') = ' // trim( mat_piece ) // num(:l) // ')'
                        indx = sp_map(row,i)
                        write(num,'(i4)') indx
	                num = ADJUSTL( num )
	                l = LEN_trim( num )
                        code(LEN_trim(code)+2:) = '- ' // trim( mat_piece ) // num(:l) // ')' // buff(:LEN_trim(buff))
                        write(30,100) trim(code)
		        code(6:) = ' '
		     else
			sp_pat(row,col) = .true.
                        code(10:) = trim( mat_piece ) // num(:l) // ') = '
                        indx = sp_map(row,i)
                        write(num,'(i4)') indx
	                num = ADJUSTL( num )
	                l = LEN_trim( num )
		        pos = INDEX( code,'=' ) + 2
                        code(pos:) = '- ' // trim( mat_piece ) // num(:l) // ')' // buff(:LEN_trim(buff))
                        write(30,100) trim(code)
	                line_cnt = line_cnt + 1
	             end if
	          end if
	       end do
	    end if
	 end do
         write(30,100) blank
	 if( line_cnt > max_lines ) then
            if( machine /= 'INTEL' ) then
               code = '      end do'
               write(30,100) trim(code)
            end if
            write(30,100) blank
            write(num,'(i3)') 100+sub_cnt
            write(code,'(''      end subroutine '',a,''lu_fac'',a)') up_hdr,num(2:3)
            write(30,100) trim(code)
	    line_cnt = 0
	    if( i /= n ) then
	       sub_cnt  = sub_cnt + 1
               call MAKE_LU_FAC_HDR( sub_cnt, machine )
	    end if
            code = ' '
	 end if
      end do Column_loop

      if( line_cnt /= 0 ) then
         if( machine /= 'INTEL' ) then
            code(7:) = 'end do'
            write(30,100) trim(code)
         end if
         write(30,100) blank
         write(num,'(i3)') 100+sub_cnt
         write(code,'(''      end subroutine '',a,''lu_fac'',a)') up_hdr,num(2:3)
         write(30,100) trim(code)
      end if

      if( n > 0 ) then
         call MAKE_LU_FAC_HDR( 0, machine )
      end if
      do k = 1,sub_cnt
         write(num,'(i3)') 100+k
	 select case( machine )
	    case( 'NEC', 'FUJITSU' )
               write(code,'(''      call '',a,''lu_fac'',a,''( ofl, ofu, lu )'')') up_hdr,num(2:3)
	    case default
               write(code,'(''      call '',a,''lu_fac'',a,''( lu )'')') up_hdr,num(2:3)
	 end select
         write(30,100) trim(code)
      end do
      write(30,100) blank
      code(7:) = 'end subroutine ' // up_hdr // 'lu_fac'
      write(30,100) trim(code)
      write(30,100) blank

      if( class == 4 ) then
         code = '      end module mo_imp_factor'
      else if( class == 5 ) then
         code = '      end module mo_rod_factor'
      end if
      write(30,100) trim(code)

      CLOSE( 30 )

100   format(a)

      end subroutine MAKE_LU_FAC

      subroutine MAKE_LU_FAC_HDR( sub_cnt, machine )
!-----------------------------------------------------------------------
!        ... Write the fortran header code for the sparse matrix decomposition
!-----------------------------------------------------------------------

      implicit none
     
!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in)          :: sub_cnt
      character(len=8), intent(in) :: machine
      
!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer  ::   i, ip1, j, k, l, row, col
      integer  ::   indx, pos
      character(len=72) :: code, comment, blank, buff
      character(len=3)  :: num

      code = ' ' ; blank = ' '
      comment = '!------------------------------------------------------------------------'

      write(30,100) blank
      write(num,'(i3)') 100+sub_cnt
      select case( machine )
         case( 'NEC', 'FUJITSU' )
            if( sub_cnt /= 0 ) then
               write(code,'(''      subroutine '',a,''lu_fac'',a,''( ofl, ofu, lu )'')') up_hdr,num(2:3)
            else
               write(code,'(''      subroutine '',a,''lu_fac( ofl, ofu, lu )'')') up_hdr
            end if
         case default
            if( sub_cnt /= 0 ) then
               write(code,'(''      subroutine '',a,''lu_fac'',a,''( lu )'')') up_hdr,num(2:3)
            else
               write(code,'(''      subroutine '',a,''lu_fac( lu )'')') up_hdr
            end if
      end select
      write(30,100) trim(code)
      write(30,100) blank
      if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
         code(7:) = 'use mo_grid,   only : plnplv'
         write(30,100) trim(code)
         code(7:) = 'use chem_mods, only : ' // hdr // 'nzcnt'
      else
         code(7:) = 'use chem_mods, only : ' // hdr // 'nzcnt, clsze'
      end if
      write(30,100) trim(code)
      write(30,100) blank
      code(7:) = 'implicit none '
      write(30,100) trim(code)
      write(30,100) blank
      write(30,100) comment
      code = '!       ... Dummy args'
      write(30,100) trim(code)
      write(30,100) comment
      code = ' '
      select case( machine )
         case( 'INTEL' )
            code(7:) = 'real, intent(inout) ::   lu(' // hdr // 'nzcnt)'
         case( 'NEC', 'FUJITSU' )
            code(7:) = 'integer, intent(in) ::   ofl'
            write(30,100) trim(code)
            code(7:) = 'integer, intent(in) ::   ofu'
            write(30,100) trim(code)
            code(7:) = 'real, intent(inout) ::   lu(plnplv,' // hdr // 'nzcnt)'
         case default
            code(7:) = 'real, intent(inout) ::   lu(clsze,' // hdr // 'nzcnt)'
      end select
      write(30,100) trim(code)
      write(30,100) blank
      if( sub_cnt /= 0 ) then
         if( machine /= 'INTEL' ) then
            write(30,100) comment
            code = '!       ... Local variables'
            write(30,100) trim(code)
            write(30,100) comment
            code = ' '
            code(7:) = 'integer :: k'
            write(30,100) trim(code)
            write(30,100) blank
	    if( machine == 'CRAY' .or. machine == 'CRAYYMP' .or. machine == 'J90' .or. machine == 'C90' ) then
               code = 'CDIR$ IVDEP'
               write(30,100) trim(code)
	    end if
            code = ' '
	    if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
               code(7:) = 'do k = ofl,ofu'
	    else
               code(7:) = 'do k = 1,clsze'
	    end if
            write(30,100) trim(code)
         end if
      end if

100   format(a)

      end subroutine MAKE_LU_FAC_HDR

      end module LU_FACTOR
