
      module LU_SOLVE

      use IO, only : temp_path

      implicit none

      character(len= 4) :: hdr, up_hdr

      CONTAINS

      subroutine MAKE_LU_SLV( n, class, lu_sp_pat, machine )
!-----------------------------------------------------------------------
!        ... Write the fortran code for the sparse matrix solver
!-----------------------------------------------------------------------

      implicit none
     
!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) :: n                            ! count of species in class
      integer, intent(in) :: class                        ! class number
      character(len=8), intent(in) :: machine             ! computational env
      logical, intent(in), dimension(n,n) :: lu_sp_pat
      
!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer           :: i, ip1, j, k, l, row, col, sub_cnt
      integer           :: indx, pos, line_cnt
      integer           :: sp_map(n,n)
      character(len=72) :: code, comment, blank, buff
      character(len=32) :: sub_name
      character(len= 6) :: mat_piece
      character(len= 4) :: b_piece
      character(len= 4) :: num
      logical           :: lexist
      
!-----------------------------------------------------------------------
!        ... Create and open code file; if it exists remove first
!-----------------------------------------------------------------------
      line_cnt = 0
      if( class == 4 ) then
         sub_name = 'imp_solve.F'
	 hdr    = 'imp_'
	 up_hdr = 'imp_'
      else
         sub_name = 'rod_solve.F'
	 hdr    = 'rod_'
	 up_hdr = 'rod_'
      end if

      inquire( file = trim( temp_path ) // trim( sub_name ), exist = lexist )
      if( lexist ) then
         call system( 'rm ' // trim( temp_path ) // trim( sub_name ) )
      end if
      open( unit = 30, file = trim( temp_path ) // trim( sub_name ) )

      if( n == 0 ) then
	 sub_cnt = 0
      else
	 sub_cnt = 1
      end if
      code = ' '
      write(30,100) trim(code)
      if( class == 4 ) then
         code = '      module mo_imp_solve'
      else if( class == 5 ) then
         code = '      module mo_rod_solve'
      end if
      write(30,100) trim(code)
      code = ' '
      write(30,100) trim(code)
      code = '      contains'
      write(30,100) trim(code)
      call MAKE_LU_SLV_HDR( n, class, sub_cnt, machine )

      code = ' ' ; blank = ' '
      if( n > 0 ) then
!-----------------------------------------------------------------------
!        ... Form the lu matrix map
!-----------------------------------------------------------------------
         k = 0 ; sp_map = 0
         do i = 1,n
            do j = 1,n
	       if( lu_sp_pat(j,i) ) then
	          k = k + 1
	          sp_map(j,i) = k
	       end if
            end do
         end do

         code = ' ' ; blank = ' '
         comment = '!------------------------------------------------------------------------'

         if( machine == 'INTEL' ) then
	    mat_piece = 'lu('
	    b_piece = 'b('
         else
	    mat_piece = 'lu(k,'
	    b_piece = 'b(k,'
         end if
      end if

!-----------------------------------------------------------------------
!        ... Solve L * y = b
!-----------------------------------------------------------------------
Forward_loop : &
      do col = 1,n-1
         write(num,'(i4)') col
	 num = ADJUSTL( num )
	 l = LEN_trim( num )
         buff = ' * ' // trim( b_piece ) // num(:l) // ')'
	 do row = col+1,n
	    if( lu_sp_pat(row,col) ) then
               write(num,'(i4)') row
	       num = ADJUSTL( num )
	       l = LEN_trim( num )
               code(10:) = trim( b_piece ) // num(:l) // ') = ' // trim( b_piece ) // num(:l) // ')'
               indx = sp_map(row,col)
               write(num,'(i4)') indx
	       num = ADJUSTL( num )
	       l = LEN_trim( num )
               code(LEN_trim(code)+2:) = '- ' // trim( mat_piece ) // num(:l) // ')' // buff(:LEN_trim(buff))
               write(30,100) trim(code)
	       line_cnt = line_cnt + 1
	    end if
	 end do
         write(30,100) blank
	 if( line_cnt > 200 ) then
	    if( machine /= 'INTEL' ) then
	       code = '      end do'
               write(30,100) trim(code)
	    end if
            write(30,100) blank
            write(num,'(i3)') 100+sub_cnt
            write(code,'(''      end subroutine '',a,''lu_slv'',a)') up_hdr,num(2:3)
            write(30,100) trim(code)
	    line_cnt = 0
!    if( col /= n-1 ) then
	       sub_cnt = sub_cnt + 1
	       call Make_LU_SLV_HDR( n, class, sub_cnt, machine )
!    end if
	    code = ' '
	 end if
      end do Forward_loop

      if( line_cnt /= 0 ) then
	 if( machine /= 'INTEL' ) then
	    code = '      end do'
            write(30,100) trim(code)
	 end if
         write(30,100) blank
         write(num,'(i3)') 100+sub_cnt
         write(code,'(''      end subroutine '',a,''lu_slv'',a)') up_hdr,num(2:3)
         write(30,100) trim(code)
	 line_cnt = 0
	 sub_cnt = sub_cnt + 1
	 call Make_LU_SLV_HDR( n,  class, sub_cnt, machine )
	 code = ' '
      end if

      if( n > 0 ) then
         write(30,100) blank
         write(30,100) comment
         code = '!       ... Solve U * x = y'
         write(30,100) trim(code)
         write(30,100) comment
         code = ' '
      end if

!-----------------------------------------------------------------------
!        ... Solve U * x = y
!-----------------------------------------------------------------------
Backward_loop : &
      do col = n,1,-1
         write(num,'(i4)') col
	 num = ADJUSTL( num )
	 l = LEN_trim( num )
         code(10:) = trim( b_piece) // num(:l) // ') = ' // trim( b_piece ) // num(:l) // ')'
         buff = ' * ' // trim( b_piece ) // num(:l) // ')'
         write(num,'(i4)') sp_map(col,col)
	 num = ADJUSTL( num )
	 l = LEN_trim( num )
         code(LEN_trim(code)+2:) = '* ' // trim( mat_piece ) // num(:l) // ')'
	 write(30,100) trim(code)
	 line_cnt = line_cnt + 1
	 do row = col-1,1,-1
	    if( lu_sp_pat(row,col) ) then
               write(num,'(i4)') row
	       num = ADJUSTL( num )
	       l = LEN_trim( num )
               code(10:) = trim( b_piece ) // num(:l) // ') = ' // trim( b_piece ) // num(:l) // ')'
               indx = sp_map(row,col)
               write(num,'(i4)') indx
	       num = ADJUSTL( num )
	       l = LEN_trim( num )
               code(LEN_trim(code)+2:) = '- ' // trim( mat_piece ) // num(:l) // ')' // buff(:LEN_trim(buff))
               write(30,100) trim(code)
	       line_cnt = line_cnt + 1
	    end if
	 end do
         write(30,100) blank
	 if( line_cnt > 200 ) then
	    if( machine /= 'INTEL' ) then
	       code = '      end do'
               write(30,100) trim(code)
	    end if
            write(30,100) blank
            write(num,'(i3)') 100+sub_cnt
            write(code,'(''      end subroutine '',a,''lu_slv'',a)') up_hdr,num(2:3)
            write(30,100) trim(code)
	    line_cnt = 0
	    if( col /= 1 ) then
	       sub_cnt = sub_cnt + 1
	       call Make_LU_SLV_HDR( n,  class, sub_cnt, machine )
	    end if
	    code = ' '
	 end if
      end do Backward_loop

      if( line_cnt /= 0 ) then
	 if( machine /= 'INTEL' ) then
	    code = '      end do'
            write(30,100) trim(code)
	 end if
         write(30,100) blank
         write(num,'(i3)') 100+sub_cnt
         write(code,'(''      end subroutine '',a,''lu_slv'',a)') up_hdr,num(2:3)
         write(30,100) trim(code)
      end if

      if( n > 0 ) then
         call MAKE_LU_SLV_HDR( n,  class, 0, machine )
      end if

      do k = 1,sub_cnt
         write(num,'(i3)') 100+k
	 select case( machine )
	    case( 'NEC', 'FUJITSU' )
	       write(code,'(''      call '',a,''lu_slv'',a,''( ofl, ofu, lu, b )'')') up_hdr,num(2:3)
	    case default
	       write(code,'(''      call '',a,''lu_slv'',a,''( lu, b )'')') up_hdr,num(2:3)
	 end select
         write(30,100) trim(code)
      end do

      write(30,100) blank
      code(7:) = 'end subroutine ' // up_hdr // 'lu_slv'
      write(30,100) trim(code)
      write(30,100) blank
      if( class == 4 ) then
         code = '      end module mo_imp_solve'
      else if( class == 5 ) then
         code = '      end module mo_rod_solve'
      end if
      write(30,100) trim(code)

      CLOSE( 30 )

100   format(a)

      end subroutine MAKE_LU_SLV

      subroutine MAKE_LU_SLV_HDR( n, class, sub_cnt, machine )
!-----------------------------------------------------------------------
!        ... Write the fortran header code for the sparse matrix solver
!-----------------------------------------------------------------------

!-----------------------------------------------------------------------
!        ... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: n, class
      integer, intent(in) :: sub_cnt
      character(len=8), intent(in) :: machine

!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      character(len=3)  :: num
      character(len=72) :: code, comment, blank


      code = ' ' ; blank = ' '
      comment = '!------------------------------------------------------------------------'

      write(30,100) blank
      write(num,'(i3)') 100+sub_cnt
      select case( machine )
         case( 'NEC', 'FUJITSU' )
            if( sub_cnt /= 0 ) then
               write(code,'(''      subroutine '',a,''lu_slv'',a,''( ofl, ofu, lu, b )'')') up_hdr,num(2:3)
            else
               write(code,'(''      subroutine '',a,''lu_slv( ofl, ofu, lu, b )'')') up_hdr
            end if
         case default
            if( sub_cnt /= 0 ) then
               write(code,'(''      subroutine '',a,''lu_slv'',a,''( lu, b )'')') up_hdr,num(2:3)
            else
               write(code,'(''      subroutine '',a,''lu_slv( lu, b )'')') up_hdr
            end if
      end select
      write(30,100) trim(code)
      write(30,100) blank
      if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
         code(7:) = 'use mo_grid,   only : plnplv'
         write(30,100) trim(code)
         write(code(7:),'(''use chem_mods, only : ' // hdr // 'nzcnt, clscnt'',i1)') class
      else
         write(code(7:),'(''use chem_mods, only : ' // hdr // 'nzcnt, clsze, clscnt'',i1)') class
      end if
      write(30,100) trim(code)
      write(30,100) blank
      code(7:) = 'implicit none '
      write(30,100) trim(code)
      write(30,100) blank
      write(30,100) comment
      code = '!       ... Dummy args'
      write(30,100) trim(code)
      write(30,100) comment
      code = ' '
      if( machine == 'INTEL' ) then
         code(7:) = 'real, intent(in)    ::   lu(' // hdr // 'nzcnt)'
      else
	 if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
            code(7:) = 'integer, intent(in) ::   ofl'
            write(30,100) trim(code)
            code(7:) = 'integer, intent(in) ::   ofu'
            write(30,100) trim(code)
            code(7:) = 'real, intent(in)    ::   lu(plnplv,' // hdr // 'nzcnt)'
	 else
            code(7:) = 'real, intent(in)    ::   lu(clsze,' // hdr // 'nzcnt)'
	 end if
      end if
      write(30,100) trim(code)
      write(num,'(i3)') n
      num = ADJUSTL( num )
      if( machine == 'INTEL' ) then
         write(code(7:),'(''real, intent(inout) ::   b(clscnt'',i1,'')'')') class
      else if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
         write(code(7:),'(''real, intent(inout) ::   b(plnplv,clscnt'',i1,'')'')') class
      else
         write(code(7:),'(''real, intent(inout) ::   b(clsze,clscnt'',i1,'')'')') class
      end if
      write(30,100) trim(code)
      write(30,100) blank
      if( sub_cnt /= 0 ) then
         write(30,100) comment
         code = '!       ... Local variables'
         write(30,100) trim(code)
         write(30,100) comment
         code = ' '
         if( machine /= 'INTEL' ) then
            code(7:) = 'integer :: k'
            write(30,100) trim(code)
         end if
         if( machine == 'CRAY' .or. machine == 'CRAYYMP' .or. machine == 'J90' .or. machine == 'C90' ) then
            write(30,100) blank
            code = 'CDIR$ IVDEP '
            write(30,100) trim(code)
         end if
         write(30,100) blank
         write(30,100) comment
         code = '!       ... Solve L * y = b'
         write(30,100) trim(code)
         write(30,100) comment
         if( machine /= 'INTEL' ) then
            code = ' '
            if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
               code(7:) = 'do k = ofl,ofu'
	    else
               code(7:) = 'do k = 1,clsze'
	    end if
            write(30,100) trim(code)
         end if
      end if

100   format(a)

      end subroutine MAKE_LU_SLV_HDR

      end module LU_SOLVE
