      
      module simulation_dat

      implicit none

      private
      public :: make_sim_dat

      contains

      subroutine make_sim_dat( sparse, bc_cnt, bc_is_fixed, bc_alias )
!-------------------------------------------------------------------
!	... write the simulation data routine; only for CAM
!-------------------------------------------------------------------

      use io,      only : temp_path
      use sp_mods, only : sparsity
      use var_mod, only : clscnt, clsmap, permute, new_nq, new_solsym
      use var_mod, only : nq, newind, mass, temp_mass
      use var_mod, only : ngrp, grp_rat_ind, grp_mem_cnt
      use var_mod, only : srf_flx_cnt, srf_flx_map, megan_map, xactive_map
      use var_mod, only : dvel_cnt, dvel_map
      use var_mod, only : nfs, fixsym, inv_from_dataset
      use rxt_mod, only : rxntot, cls_rxt_cnt
      use rxt_mod, only : rxmcnt, prdcnt, fixcnt
      use rxt_mod, only : rxmap, prdmap, fixmap
      use rxt_mod, only : hetcnt, hetmap
      use rxt_mod, only : usrcnt, usrmap, frc_from_dataset
      use rxt_mod, only : rxt_has_tag, rxt_tag
      use rxt_mod, only : phtcnt, pht_alias, pht_alias_mult


!-------------------------------------------------------------------
!	... dummy arguments
!-------------------------------------------------------------------
      type(sparsity), intent(in) :: sparse(2)
      integer, intent(in)        :: bc_cnt(2)
      logical, intent(in)        :: bc_is_fixed(new_nq,2)
      character(len=*), intent(in)  :: bc_alias(:,:)

!-------------------------------------------------------------------
!	... local variables
!-------------------------------------------------------------------
      integer, parameter :: max_len = 128
      integer, parameter :: lower = 1
      integer, parameter :: upper = 2

      integer  ::  i, k, l, m, m1, n, n1
      integer  ::  astat
      integer, allocatable   :: ndx(:)
      integer, allocatable   :: rxt_rate_map(:,:)
      character(len=max_len) :: line
      character(len=64)      :: frmt
      logical  ::  lexist

!-------------------------------------------------------------------
!	... check for file, remove if exists, open for writing
!-------------------------------------------------------------------
      inquire( file = trim( temp_path ) // 'mo_sim_dat.F', exist = lexist )
      if( lexist ) then
         call system( 'rm ' // trim( temp_path ) // 'mo_sim_dat.F' )
      end if
      open( unit = 30, file = trim( temp_path ) // 'mo_sim_dat.F' )

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'module mo_sim_dat'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'private'
      write(30,100) trim(line)
      line(7:) = 'public :: set_sim_dat'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'contains'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'subroutine set_sim_dat'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : explicit, implicit, rodas'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : pcnstm1, grpcnt, ngrp, grp_mem_cnt, nfs'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : hetcnt, drydep_cnt, srfems_cnt, extcnt, rxt_tag_cnt, fbc_cnt'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : nadv_mass, adv_mass'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : drydep_lst, srfems_lst, het_lst, extfrc_lst, grp_lst, inv_lst'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : megan_map, xactive_srf_flx_map'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : flbc_lst, fubc_lst, fubc_alias_lst, flbc_alias_lst'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : rxt_tag_map, rxt_tag_lst'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : rxntot, rxt_rate_map'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : phtcnt, pht_alias_lst, pht_alias_mult'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : inv_from_dataset'
      write(30,100) trim(line)
      line(7:) = 'use chem_mods,   only : frc_from_dataset'
      write(30,100) trim(line)
      line(7:) = 'use m_tracname,  only : tracnam, natsnam'
      write(30,100) trim(line)
      line(7:) = 'use mo_histout,  only : hfile, hst_file_max, moz_file_cnt, match_file_cnt'
      write(30,100) trim(line)
      line(7:) = 'use mass_diags,  only : ndiags'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'implicit none '
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------'
      write(30,100) trim(line)
      line = '!      ... local variables'
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------'
      write(30,100) trim(line)
      line = '      integer :: ios'
      write(30,100) trim(line)
!-------------------------------------------------------------------
!	... set the simulation chemical mechanism data
!-------------------------------------------------------------------
!-------------------------------------------------------------------
!	... species symbols
!-------------------------------------------------------------------
      if( nq > 0 ) then
         line = ' '
         write(30,100) trim(line)
         write(line,'("      tracnam(:",i3,") = (/")') new_nq
         m = len_trim(line) + 2
         do n = 1,new_nq,5
            n1 = min( n+4,new_nq )
            if( n1 /= new_nq ) then
               write(line(m:),'(5("''",a8,"'',")," &")') new_solsym(n:n1)
            else
               if( n1 > n ) then
                  write(frmt,'("(",i1)') n1 - n
                  frmt(len_trim(frmt)+1:) = '("''",a8,"'',"),"''",a8,"'' /)")'
               else
                  frmt = '("''",a8,"'' /)")'
               end if
               write(line(m:),trim(frmt)) new_solsym(n:n1)
            end if
            write(30,'(a)') trim(line)
            line = ' '
         end do
!-------------------------------------------------------------------
!	... advected species mass
!-------------------------------------------------------------------
         line = ' '
         write(30,100) trim(line)
         temp_mass(:) = 0.
         do n = 1,nq
            if( newind(n) /= 0 ) then
               temp_mass(newind(n)) = mass(n)
            end if
         end do
         line = '      adv_mass(:'
         write(line(len_trim(line)+1:),'(i3,") = (/")') new_nq
         m    = len_trim(line) + 2
         do n = 1,new_nq,5
            n1 = min( n+4,new_nq )
            if( n1 /= new_nq ) then
               write(line(m:),'(5(g15.9,",")," &")') temp_mass(n:n1)
            else
               if( n1 > n ) then
                  write(frmt,'("(",i1)') n1 - n
                  frmt(len_trim(frmt)+1:) = '(g15.9,","),g15.9," /)")'
               else
                  frmt = '(g15.9," /)")'
               end if
               write(line(m:),trim(frmt)) temp_mass(n:n1)
            end if
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... non-advected species mass
!-------------------------------------------------------------------
      if( ngrp > 0 ) then
         line = ' '
         write(30,100) trim(line)
         temp_mass(:) = 0.
         do n = 1,nq
            if( grp_rat_ind(n) /= 0 ) then
               temp_mass(grp_rat_ind(n)) = mass(n)
            end if
         end do
         line = '      nadv_mass(:'
         write(line(len_trim(line)+1:),'(i3,") = (/")') grp_mem_cnt
         m    = len_trim(line) + 2
         do n = 1,grp_mem_cnt,5
            n1 = min( n+4,grp_mem_cnt )
            if( n1 /= grp_mem_cnt ) then
               write(line(m:),'(5(g15.9,",")," &")') temp_mass(n:n1)
            else
               if( n1 > n ) then
                  write(frmt,'("(",i1)') n1 - n
                  frmt(len_trim(frmt)+1:) = '(g15.9,","),g15.9," /)")'
               else
                  frmt = '(g15.9," /)")'
               end if
               write(line(m:),trim(frmt)) temp_mass(n:n1)
            end if
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... class reaction count
!-------------------------------------------------------------------
      line = ' '
      write(30,100) trim(line)
      do i = 1,5
         if( clscnt(i) > 0 ) then
            select case( i )
               case( 1 )
                  line = '      explicit%cls_rxt_cnt(:) = (/'
               case( 4 )
                  line = '      implicit%cls_rxt_cnt(:) = (/'
               case( 5 )
                  line = '      rodas%cls_rxt_cnt(:) = (/'
            end select
            m = len_trim(line) + 2
            write(line(m:),*) cls_rxt_cnt(1,i),',',cls_rxt_cnt(2,i),',',cls_rxt_cnt(3,i),',',cls_rxt_cnt(4,i),' /)'
            write(30,'(a)') trim(line)
         end if
      end do


!-------------------------------------------------------------------
!	... class map
!-------------------------------------------------------------------
      line = ' '
      write(30,100) trim(line)
      do i = 1,5
         if( clscnt(i) > 0 ) then
            select case( i )
               case( 1 )
                  write(line,'("      explicit%clsmap(:",i3,") = (/")') clscnt(i)
               case( 4 )
                  write(line,'("      implicit%clsmap(:",i3,") = (/")') clscnt(i)
               case( 5 )
                  write(line,'("      rodas%clsmap(:",i3,") = (/")') clscnt(i)
            end select
            m = len_trim(line) + 2
            do n = 1,clscnt(i),10
               n1 = min( n+9,clscnt(i) )
               if( n1 /= clscnt(i) ) then
                  write(line(m:),'(10(i4,",")," &")') clsmap(n:n1,i,2)
               else
                  if( n1 > n ) then
                     write(frmt,'("(",i1)') n1 - n
                     frmt(len_trim(frmt)+1:) = '(i4,","),i4," /)")'
                  else
                     frmt = '(i4," /)")'
                  end if
                  write(line(m:),trim(frmt)) clsmap(n:n1,i,2)
               end if
               write(30,'(a)') trim(line)
               line = ' '
            end do
         end if
      end do

!-------------------------------------------------------------------
!	... class permutation map
!-------------------------------------------------------------------
      line = ' '
      write(30,100) trim(line)
      do i = 2,5
         if( clscnt(i) > 0 ) then
            select case( i )
               case( 4 )
                  write(line,'("      implicit%permute(:",i3,") = (/")') clscnt(i)
               case( 5 )
                  write(line,'("      rodas%permute(:",i3,") = (/")') clscnt(i)
            end select
            m = len_trim(line) + 2
            do n = 1,clscnt(i),10
               n1 = min( n+9,clscnt(i) )
               if( n1 /= clscnt(i) ) then
                  write(line(m:),'(10(i4,",")," &")') permute(n:n1,i)
               else
                  if( n1 > n ) then
                     write(frmt,'("(",i1)') n1 - n
                     frmt(len_trim(frmt)+1:) = '(i4,","),i4," /)")'
                  else
                     frmt = '(i4," /)")'
                  end if
                  write(line(m:),trim(frmt)) permute(n:n1,i)
               end if
               write(30,'(a)') trim(line)
               line = ' '
            end do
         end if
      end do

!-------------------------------------------------------------------
!	... class diagonal indicies
!-------------------------------------------------------------------
      line = ' '
      write(30,100) trim(line)
      do i = 4,5
         if( clscnt(i) > 0 ) then
            select case( i )
               case( 4 )
                  write(line,'("      implicit%diag_map(:",i3,") = (/")') clscnt(i)
               case( 5 )
                  write(line,'("      rodas%diag_map(:",i3,") = (/")') clscnt(i)
            end select
            m = len_trim(line) + 2
            do n = 1,clscnt(i),10
               n1 = min( n+9,clscnt(i) )
               if( n1 /= clscnt(i) ) then
                  write(line(m:),'(10(i4,",")," &")') sparse(i-3)%diag_map(n:n1)
               else
                  if( n1 > n ) then
                     write(frmt,'("(",i1)') n1 - n
                     frmt(len_trim(frmt)+1:) = '(i4,","),i4," /)")'
                  else
                     frmt = '(i4," /)")'
                  end if
                  write(line(m:),trim(frmt)) sparse(i-3)%diag_map(n:n1)
               end if
               write(30,'(a)') trim(line)
               line = ' '
            end do
         end if
      end do

!-------------------------------------------------------------------
!	... surface emissions
!-------------------------------------------------------------------
      if( srf_flx_cnt > 0 ) then
         line = ' '
         write(30,100) trim(line)
         write(line,'("      srfems_cnt = ",i4)') srf_flx_cnt
         write(30,100) trim(line)
         line = ' '
         line(7:) = 'if( allocated( srfems_lst ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( srfems_lst )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( srfems_lst(srfems_cnt),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate srfems_lst; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'if( allocated( megan_map ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( megan_map )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'if( allocated( xactive_srf_flx_map ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( xactive_srf_flx_map )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( megan_map(srfems_cnt),xactive_srf_flx_map(srfems_cnt),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate megan_map,xactive_srf_flx_map; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line = '      srfems_lst(:srfems_cnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,srf_flx_cnt,5
            n1 = min( n+4,srf_flx_cnt )
            m = m1
            do l = n,n1
               if( l /= srf_flx_cnt ) then
                  if( l /= n1 ) then
                     write(line(m:),'("''",a8,"'',")') new_solsym(srf_flx_map(l))
                  else
                     write(line(m:),'("''",a8,"'', &")') new_solsym(srf_flx_map(l))
                  end if
               else
                  write(line(m:),'("''",a8,"'' /)")') new_solsym(srf_flx_map(l))
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
         line = '      megan_map(:srfems_cnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,srf_flx_cnt,5
            n1 = min( n+4,srf_flx_cnt )
            m = m1
            do l = n,n1
               if( l /= srf_flx_cnt ) then
                  if( l /= n1 ) then
                     if( megan_map(l) ) then
                        write(line(m:),'(".true.,")')
                     else
                        write(line(m:),'(".false.,")')
                     end if
                  else
                     if( megan_map(l) ) then
                        write(line(m:),'(".true., &")')
                     else
                        write(line(m:),'(".false., &")')
                     end if
                  end if
               else
                  if( megan_map(l) ) then
                     write(line(m:),'(".true. /)")')
                  else
                     write(line(m:),'(".false. /)")')
                  end if
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
         line = '      xactive_srf_flx_map(:srfems_cnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,srf_flx_cnt,5
            n1 = min( n+4,srf_flx_cnt )
            m = m1
            do l = n,n1
               if( l /= srf_flx_cnt ) then
                  if( l /= n1 ) then
                     if( xactive_map(l) ) then
                        write(line(m:),'(".true.,")')
                     else
                        write(line(m:),'(".false.,")')
                     end if
                  else
                     if( xactive_map(l) ) then
                        write(line(m:),'(".true., &")')
                     else
                        write(line(m:),'(".false., &")')
                     end if
                  end if
               else
                  if( xactive_map(l) ) then
                     write(line(m:),'(".true. /)")')
                  else
                     write(line(m:),'(".false. /)")')
                  end if
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... dry deposition
!-------------------------------------------------------------------
      if( dvel_cnt > 0 ) then
         line = ' '
         write(30,100) trim(line)
         write(line,'("      drydep_cnt = ",i4)') dvel_cnt
         write(30,100) trim(line)
         line = ' '
         line(7:) = 'if( allocated( drydep_lst ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( drydep_lst )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( drydep_lst(drydep_cnt),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate drydep_lst; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line = '      drydep_lst(:drydep_cnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,dvel_cnt,5
            n1 = min( n+4,dvel_cnt )
            m = m1
            do l = n,n1
               if( l /= dvel_cnt ) then
                  if( l /= n1 ) then
                     write(line(m:),'("''",a8,"'',")') new_solsym(dvel_map(l))
                  else
                     write(line(m:),'("''",a8,"'', &")') new_solsym(dvel_map(l))
                  end if
               else
                  write(line(m:),'("''",a8,"'' /)")') new_solsym(dvel_map(l))
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... wet removal
!-------------------------------------------------------------------
      if( hetcnt > 0 ) then
         line = ' '
         write(30,100) trim(line)
         line = '      het_lst(:hetcnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,hetcnt,5
            n1 = min( n+4,hetcnt )
            m = m1
            do l = n,n1
               if( l /= hetcnt ) then
                  if( l /= n1 ) then
                     write(line(m:),'("''",a8,"'',")') new_solsym(hetmap(l,1))
                  else
                     write(line(m:),'("''",a8,"'', &")') new_solsym(hetmap(l,1))
                  end if
               else
                  write(line(m:),'("''",a8,"'' /)")') new_solsym(hetmap(l,1))
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... invariants
!-------------------------------------------------------------------
      if( nfs > 0 ) then
         line = ' '
         write(30,100) trim(line)
         line = '      inv_from_dataset(:nfs) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,nfs,5
            n1 = min( n+4,nfs )
            m = m1
            do l = n,n1
               if( l /= nfs ) then
                  if( l /= n1 ) then
                     if( inv_from_dataset(l) ) then
                        write(line(m:),'(".true.,")')
                     else
                        write(line(m:),'(".false.,")')
                     end if
                  else
                     if( inv_from_dataset(l) ) then
                        write(line(m:),'(".true., &")')
                     else
                        write(line(m:),'(".false., &")')
                     end if
                  end if
               else
                  if( inv_from_dataset(l) ) then
                     write(line(m:),'(".true. /)")')
                  else
                     write(line(m:),'(".false. /)")')
                  end if
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... external forcing
!-------------------------------------------------------------------
      if( usrcnt > 0 ) then
         line = ' '
         write(30,100) trim(line)
         line = '      extfrc_lst(:extcnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,usrcnt,5
            n1 = min( n+4,usrcnt )
            m = m1
            do l = n,n1
               if( l /= usrcnt ) then
                  if( l /= n1 ) then
                     write(line(m:),'("''",a8,"'',")') new_solsym(usrmap(l))
                  else
                     write(line(m:),'("''",a8,"'', &")') new_solsym(usrmap(l))
                  end if
               else
                  write(line(m:),'("''",a8,"'' /)")') new_solsym(usrmap(l))
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
         line = ' '
         write(30,100) trim(line)
         line = '      frc_from_dataset(:extcnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,usrcnt,5
            n1 = min( n+4,usrcnt )
            m = m1
            do l = n,n1
               if( l /= usrcnt ) then
                  if( l /= n1 ) then
                     if( frc_from_dataset(l) ) then
                        write(line(m:),'(".true.,")')
                     else
                        write(line(m:),'(".false.,")')
                     end if
                  else
                     if( frc_from_dataset(l) ) then
                        write(line(m:),'(".true., &")')
                     else
                        write(line(m:),'(".false., &")')
                     end if
                  end if
               else
                  if( frc_from_dataset(l) ) then
                     write(line(m:),'(".true. /)")')
                  else
                     write(line(m:),'(".false. /)")')
                  end if
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... reaction tags
!-------------------------------------------------------------------
      i = count( rxt_has_tag(:rxntot) )
      if( i > 0 ) then
         allocate( ndx(i) )
         ndx(:) = pack( (/ (m,m=1,rxntot) /),rxt_has_tag(:) )
         line = ' '
         write(30,100) trim(line)
         write(line,'("      rxt_tag_cnt = ",i4)') i
         write(30,100) trim(line)
         line = ' '
         line(7:) = 'if( allocated( rxt_tag_lst ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( rxt_tag_lst )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate rxt_tag_lst; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'if( allocated( rxt_tag_map ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( rxt_tag_map )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate rxt_tag_map; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line = '      rxt_tag_lst(:rxt_tag_cnt) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,i,4
            n1 = min( n+3,i )
            m = m1
            do l = n,n1
               if( l /= i ) then
                  if( l /= n1 ) then
                     write(line(m:),'("''",a16,"'',")') rxt_tag(ndx(l))
                  else
                     write(line(m:),'("''",a16,"'', &")') rxt_tag(ndx(l))
                  end if
               else
                  write(line(m:),'("''",a16,"'' /)")') rxt_tag(ndx(l))
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do

         line = '      rxt_tag_map(:rxt_tag_cnt) = (/'
         m = len_trim(line) + 2
         do n = 1,i,10
            n1 = min( n+9,i )
            if( n1 /= i ) then
               write(line(m:),'(10(i4,",")," &")') ndx(n:n1)
            else
               if( n1 > n ) then
                  write(frmt,'("(",i1)') n1 - n
                  frmt(len_trim(frmt)+1:) = '(i4,","),i4," /)")'
               else
                  frmt = '(i4," /)")'
               end if
               write(line(m:),trim(frmt)) ndx(n:n1)
            end if
            write(30,'(a)') trim(line)
            line = ' '
         end do
         deallocate( ndx )
      end if

!-------------------------------------------------------------------
!	... photoreactions alias
!-------------------------------------------------------------------
      if( phtcnt > 0 ) then
         line = ' '
         line(7:) = 'if( allocated( pht_alias_lst ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( pht_alias_lst )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( pht_alias_lst(phtcnt,2),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate pht_alias_lst; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line = ' '
         line(7:) = 'if( allocated( pht_alias_mult ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( pht_alias_mult )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( pht_alias_mult(phtcnt,2),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate pht_alias_mult; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         do i = 1,2
            if( i == 1 ) then
               line = '      pht_alias_lst(:,1) = (/ '
            else
               line = '      pht_alias_lst(:,2) = (/ '
            end if
            m1 = len_trim(line) + 2
            do n = 1,phtcnt,4
               n1 = min( n+3,phtcnt )
               m = m1
               do l = n,n1
                  if( l /= phtcnt ) then
                     if( l /= n1 ) then
                        write(line(m:),'("''",a16,"'',")') pht_alias(l,i)
                     else
                        write(line(m:),'("''",a16,"'', &")') pht_alias(l,i)
                     end if
                  else
                     write(line(m:),'("''",a16,"'' /)")') pht_alias(l,i)
                  end if
                  m = len_trim(line) + 2
               end do
               write(30,'(a)') trim(line)
               line = ' '
            end do
         end do
         do i = 1,2
            if( i == 1 ) then
               line = '      pht_alias_mult(:,1) = (/ '
            else
               line = '      pht_alias_mult(:,2) = (/ '
            end if
            m = len_trim(line) + 2
            do n = 1,phtcnt,5
               n1 = min( n+4,phtcnt )
               if( n1 /= phtcnt ) then
                  write(line(m:),'(5(g15.9,",")," &")') pht_alias_mult(n:n1,i)
               else
                  if( n1 > n ) then
                     write(frmt,'("(",i1)') n1 - n
                     frmt(len_trim(frmt)+1:) = '(g15.9,","),g15.9," /)")'
                  else
                     frmt = '(g15.9," /)")'
                  end if
                  write(line(m:),trim(frmt)) pht_alias_mult(n:n1,i)
               end if
               write(30,'(a)') trim(line)
               line = ' '
            end do
         end do
      end if

!-------------------------------------------------------------------
!	... fixed species
!-------------------------------------------------------------------
      if( nfs > 0 ) then
         line = ' '
         write(30,100) trim(line)
         line = '      inv_lst(:nfs) = (/ '
         m1 = len_trim(line) + 2
         do n = 1,nfs,5
            n1 = min( n+4,nfs )
            m = m1
            do l = n,n1
               if( l /= nfs ) then
                  if( l /= n1 ) then
                     write(line(m:),'("''",a8,"'',")') fixsym(l)
                  else
                     write(line(m:),'("''",a8,"'', &")') fixsym(l)
                  end if
               else
                  write(line(m:),'("''",a8,"'' /)")') fixsym(l)
               end if
               m = len_trim(line) + 2
            end do
            write(30,'(a)') trim(line)
            line = ' '
         end do
      end if

!-------------------------------------------------------------------
!	... fixed boundary conditions
!-------------------------------------------------------------------
      line = ' '
      write(30,100) trim(line)
      write(line,'("      fbc_cnt = (/ ",i4,",",i4," /)")') bc_cnt(:)
      write(30,100) trim(line)
bndy : &
      do k = lower,upper
         i = bc_cnt(k)
         if( i > 0 ) then
            if( allocated( ndx ) ) then
               deallocate( ndx )
            end if
            allocate( ndx(i) )
            l = 0
            do m = 1,new_nq
               if( bc_is_fixed(m,k) ) then
                  l = l + 1
                  ndx(l) = m
               end if
            end do 
            line = ' '
            if( k == lower ) then
               line(7:) = 'if( allocated( flbc_lst ) ) then'
            else
               line(7:) = 'if( allocated( fubc_lst ) ) then'
            end if
            write(30,100) trim(line)
            if( k == lower ) then
               line(7:) = '   deallocate( flbc_lst )'
            else
               line(7:) = '   deallocate( fubc_lst )'
            end if
            write(30,100) trim(line)
            line(7:) = 'end if'
            write(30,100) trim(line)
            if( k == upper ) then
               line(7:) = 'if( allocated( fubc_alias_lst ) ) then'
               write(30,100) trim(line)
               line(7:) = '   deallocate( fubc_alias_lst )'
               write(30,100) trim(line)
            else if( k == lower ) then
               line(7:) = 'if( allocated( flbc_alias_lst ) ) then'
               write(30,100) trim(line)
               line(7:) = '   deallocate( flbc_alias_lst )'
               write(30,100) trim(line)
            end if
            line(7:) = 'end if'
            write(30,100) trim(line)
            if( k == lower ) then
               line(7:) = 'allocate( flbc_lst(fbc_cnt(1)),flbc_alias_lst(fbc_cnt(1)),stat=ios )'
            else
               line(7:) = 'allocate( fubc_lst(fbc_cnt(2)),fubc_alias_lst(fbc_cnt(2)),stat=ios )'
            end if
            write(30,100) trim(line)
            line(7:) = 'if( ios /= 0 ) then'
            write(30,100) trim(line)
            line = ' '
            if( k == lower ) then
               line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate flbc_lst; error = '',ios'
            else
               line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate fubc_lst; error = '',ios'
            end if
            write(30,100) trim(line)
            line(10:) = 'call endrun'
            write(30,100) trim(line)
            line(7:) = 'end if'
            write(30,100) trim(line)
            if( k == lower ) then
               line = '      flbc_lst(:fbc_cnt(1)) = (/ '
            else
               line = '      fubc_lst(:fbc_cnt(2)) = (/ '
            end if
            m1 = len_trim(line) + 2
            do n = 1,i,4
               n1 = min( n+3,i )
               m = m1
               do l = n,n1
                  if( l /= i ) then
                     if( l /= n1 ) then
                        write(line(m:),'("''",a8,"'',")') new_solsym(ndx(l))
                     else
                        write(line(m:),'("''",a8,"'', &")') new_solsym(ndx(l))
                     end if
                  else
                     write(line(m:),'("''",a8,"'' /)")') new_solsym(ndx(l))
                  end if
                  m = len_trim(line) + 2
               end do
               write(30,'(a)') trim(line)
               line = ' '
            end do
            if( k == upper ) then
               line = '      fubc_alias_lst(:fbc_cnt(2)) = (/ '
            else
               line = '      flbc_alias_lst(:fbc_cnt(1)) = (/ '
            end if
            m1 = len_trim(line) + 2
            do n = 1,i,4
              n1 = min( n+3,i )
               m = m1
               do l = n,n1
                  if( l /= i ) then
                     if( l /= n1 ) then
                        write(line(m:),'("''",a16,"'',")') bc_alias(ndx(l),k)
                     else
                        write(line(m:),'("''",a16,"'', &")') bc_alias(ndx(l),k)
                     end if
                  else
                     write(line(m:),'("''",a16,"'' /)")') bc_alias(ndx(l),k)
                  end if
                  m = len_trim(line) + 2
               end do
               write(30,'(a)') trim(line)
               line = ' '
            end do
         end if
      end do bndy

!-------------------------------------------------------------------
!	... reaction rate map
!-------------------------------------------------------------------
has_rxts : &
      if( rxntot > 0 ) then
!-------------------------------------------------------------------
!	... allocate working variable
!-------------------------------------------------------------------
         allocate( rxt_rate_map(rxntot,3),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'make_sim_dat: failed to allocate rxt_rate_map; error = ',astat
            stop 'allocation failure'
         else
            rxt_rate_map(:,:) = 0
         end if
!-------------------------------------------------------------------
!	... linear reaction
!-------------------------------------------------------------------
         do k = 1,rxmcnt(1)
            rxt_rate_map(rxmap(k,1,1),1) = rxmap(k,2,1)
         end do
!-------------------------------------------------------------------
!	... non-linear reaction
!-------------------------------------------------------------------
         do k = 1,rxmcnt(2)
            rxt_rate_map(rxmap(k,1,2),1:2) = rxmap(k,2:3,2)
         end do
!-------------------------------------------------------------------
!	... fixed reactants
!-------------------------------------------------------------------
         do m = 1,2
            do k = 1,fixcnt(m)
               n1 = abs( fixmap(k,1,m) )
               rxt_rate_map(n1,3) = count( fixmap(k,2:3,m) /= 0 )
            end do
         end do

         line(7:) = 'if( allocated( rxt_rate_map ) ) then'
         write(30,100) trim(line)
         line(7:) = '   deallocate( rxt_rate_map )'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line(7:) = 'allocate( rxt_rate_map(rxntot,3),stat=ios )'
         write(30,100) trim(line)
         line(7:) = 'if( ios /= 0 ) then'
         write(30,100) trim(line)
         line = ' '
         line(10:) = 'write(*,*) ''set_sim_dat: failed to allocate rxt_rate_map; error = '',ios'
         write(30,100) trim(line)
         line(10:) = 'call endrun'
         write(30,100) trim(line)
         line(7:) = 'end if'
         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
         do k = 1,3
            write(line(7:),'("rxt_rate_map(:rxntot,",i1,") = (/")') k
            m = len_trim( line ) + 2
            do n = 1,rxntot,10
               n1 = min( n+9,rxntot )
               if( n1 /= rxntot ) then
                  write(line(m:),'(10(i4,",")," &")') abs(rxt_rate_map(n:n1,k))
               else
                  if( n1 > n ) then
                     write(frmt,'("(",i1)') n1 - n
                     frmt(len_trim(frmt)+1:) = '(i4,","),i4," /)")'
                  else
                     frmt = '(i4," /)")'
                  end if
                  write(line(m:),trim(frmt)) abs(rxt_rate_map(n:n1,k))
               end if
               write(30,'(a)') trim(line)
               line = ' '
            end do
         end do
      end if has_rxts

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end subroutine set_sim_dat'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end module mo_sim_dat'
      write(30,100) trim(line)

      close( 30 )

      if( rxntot > 0 ) then
         deallocate( rxt_rate_map )
      end if

100   format(a)

      end subroutine make_sim_dat

      end module simulation_dat
