
      subroutine MAKE_PADJ( fixmap, &
                            fixcnt, &
                            phtcnt, &
			    f90 )
!-----------------------------------------------------------------------
!        ... Write the photorate adjustment code
!-----------------------------------------------------------------------

      use VAR_MOD, only : var_lim
      use IO,      only : temp_path

      implicit none

!-----------------------------------------------------------------------
!        ... The arguments
!-----------------------------------------------------------------------
      integer, intent(in) ::  fixcnt
      integer, intent(in) ::  phtcnt
      integer, intent(in) ::  fixmap(var_lim,2)
      logical, intent(in) ::  f90

!-----------------------------------------------------------------------
!        ... The local variables
!-----------------------------------------------------------------------
      integer  ::   k, rxno
      character(len=72) :: line
      logical  ::  first
      logical  ::  lexist

      
      INQUIRE( file = TRIM( temp_path ) // 'mo_phtadj.F', exist = lexist )
      if( lexist ) then
	 call SYSTEM( 'rm ' // TRIM( temp_path ) // 'mo_phtadj.F' )
      end if
      OPEN( unit = 30, file = TRIM( temp_path ) // 'mo_phtadj.F' )

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'module mo_phtadj'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'private'
      write(30,100) trim(line)
      line(7:) = 'public :: phtadj'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'contains'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'subroutine phtadj( p_rate, inv, m, plnplv )'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'use chem_mods, only : nfs, phtcnt'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'implicit none '
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '!       ... Dummy arguments'
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '      integer, intent(in) :: plnplv'
      write(30,100) trim(line)
      line = '      real, intent(in)    :: inv(plnplv,nfs)'
      write(30,100) trim(line)
      line = '      real, intent(in)    :: m(plnplv)'
      write(30,100) trim(line)
      line = '      real, intent(inout) :: p_rate(plnplv,phtcnt)'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '!       ... Local variables'
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '      real    ::  im(plnplv)'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      
      first = .true.
      do k = 1,fixcnt
         rxno = ABS( fixmap(k,1) )
         if( fixmap(k,1) < 0 .and. rxno <= phtcnt ) then
            if( first ) then
               line(7:) = 'im(:) = 1. / m(:)'
               write(30,100) trim(line)
               line = ' '
               first = .false.
            end if
            line(7:) = 'p_rate(:,   ) = p_rate(:,   )'
            write(line(16:18),'(i3)') rxno
            write(line(32:34),'(i3)') rxno
            line(LEN_TRIM(line)+2:) = ' * inv(:,'
            write(line(LEN_TRIM(line)+1:),'(i2)') fixmap(k,2)
            line(LEN_TRIM(line)+1:) = ') * im(:)'
            write(30,100) trim(line)
         end if
      end do

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end subroutine phtadj'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end module mo_phtadj'
      write(30,100) trim(line)
      
      CLOSE(30)
      
100   format(a)      
      
      end subroutine MAKE_PADJ
