      module mo_sim_dat
      private
      public :: set_sim_dat
      contains
      subroutine set_sim_dat
      use chem_mods, only : explicit, implicit, rodas
      use chem_mods, only : pcnstm1, grpcnt, ngrp, grp_mem_cnt, nfs
      use chem_mods, only : hetcnt, drydep_cnt, srfems_cnt, extcnt, rxt_tag_cnt, fbc_cnt
      use chem_mods, only : nadv_mass, adv_mass
      use chem_mods, only : drydep_lst, srfems_lst, het_lst, extfrc_lst, grp_lst, inv_lst
      use chem_mods, only : megan_map, xactive_srf_flx_map
      use chem_mods, only : flbc_lst, fubc_lst, fubc_alias_lst
      use chem_mods, only : rxt_tag_map, rxt_tag_lst
      use chem_mods, only : rxntot, rxt_rate_map
      use chem_mods, only : phtcnt, pht_alias_lst, pht_alias_mult
      use chem_mods, only : inv_from_dataset
      use chem_mods, only : frc_from_dataset
      use m_tracname, only : tracnam, natsnam
      use mo_histout, only : hfile, hst_file_max, moz_file_cnt, match_file_cnt
      use mass_diags, only : ndiags
      implicit none
!--------------------------------------------------------------
! ... local variables
!--------------------------------------------------------------
      integer :: ios
      tracnam(: 98) = (/ 'O3      ','O       ','O1D     ','N2O     ','NO      ', &
                         'NO2     ','NO3     ','HNO3    ','HO2NO2  ','N2O5    ', &
                         'H2      ','OH      ','HO2     ','H2O2    ','CH4     ', &
                         'CO      ','CH3O2   ','CH3OOH  ','CH2O    ','CH3OH   ', &
                         'C2H5OH  ','C2H4    ','EO      ','EO2     ','CH3COOH ', &
                         'GLYALD  ','C2H6    ','C2H5O2  ','C2H5OOH ','CH3CHO  ', &
                         'CH3CO3  ','CH3COOOH','C3H6    ','C3H8    ','C3H7O2  ', &
                         'C3H7OOH ','PO2     ','POOH    ','CH3COCH3','RO2     ', &
                         'ROOH    ','BIGENE  ','ENEO2   ','MEK     ','MEKO2   ', &
                         'MEKOOH  ','BIGALK  ','ALKO2   ','ALKOOH  ','ISOP    ', &
                         'ISOPO2  ','ISOPOOH ','MVK     ','MACR    ','MACRO2  ', &
                         'MACROOH ','MCO3    ','HYDRALD ','HYAC    ','CH3COCHO', &
                         'XO2     ','XOOH    ','C10H16  ','TERPO2  ','TERPOOH ', &
                         'TOLUENE ','CRESOL  ','TOLO2   ','TOLOOH  ','XOH     ', &
                         'BIGALD  ','GLYOXAL ','PAN     ','ONIT    ','MPAN    ', &
                         'ISOPNO3 ','ONITR   ','CB1     ','CB2     ','OC1     ', &
                         'OC2     ','SOA     ','SO2     ','DMS     ','SO4     ', &
                         'NH3     ','NH4     ','NH4NO3  ','SA1     ','SA2     ', &
                         'SA3     ','SA4     ','Rn      ','Pb      ','O3S     ', &
                         'O3INERT ','SYNOZ   ','O3RAD   ' /)
      adv_mass(: 98) = (/ 47.9981995 , 15.9994001 , 15.9994001 , 44.0128784 , 30.0061398 , &
                           46.0055389 , 62.0049400 , 63.0123405 , 79.0117416 , 108.010483 , &
                           2.01480007 , 17.0067997 , 33.0061989 , 34.0135994 , 16.0405998 , &
                           28.0103989 , 47.0319977 , 48.0393982 , 30.0251999 , 32.0400009 , &
                           46.0657997 , 28.0515995 , 61.0578041 , 77.0571976 , 60.0503998 , &
                           60.0504036 , 30.0663986 , 61.0578003 , 62.0651970 , 44.0510025 , &
                           75.0424042 , 76.0498047 , 42.0773964 , 44.0921974 , 75.0836029 , &
                           76.0909958 , 91.0829926 , 92.0903931 , 58.0768051 , 89.0681992 , &
                           90.0755997 , 56.1031990 , 105.108795 , 72.1026001 , 103.093994 , &
                           104.101395 , 72.1437988 , 103.135201 , 104.142601 , 68.1141968 , &
                           117.119804 , 118.127205 , 70.0878067 , 70.0878067 , 119.093399 , &
                           120.100800 , 101.079208 , 100.113007 , 74.0762024 , 72.0614014 , &
                           133.119202 , 134.126602 , 136.228394 , 185.234009 , 186.241394 , &
                           92.1362000 , 108.135597 , 173.140594 , 174.147995 , 190.147400 , &
                           98.0982056 , 58.0355988 , 121.047943 , 119.074341 , 147.084747 , &
                           162.117935 , 147.125946 , 12.0109997 , 12.0109997 , 12.0109997 , &
                           12.0109997 , 144.131989 , 64.0648041 , 62.1324005 , 96.0635986 , &
                           17.0289402 , 18.0363388 , 80.0412750 , 58.4424667 , 58.4424667 , &
                           58.4424667 , 58.4424667 , 222.000000 , 207.199997 , 47.9981995 , &
                           47.9981995 , 47.9981995 , 47.9981995 /)
      explicit%cls_rxt_cnt(:) = (/ 30 , 9 , 0 , 1 /)
      implicit%cls_rxt_cnt(:) = (/ 2 , 60 , 139 , 42 /)
      explicit%clsmap(: 10) = (/ 15, 4, 16, 93, 94, 11, 96, 95, 97, 98 /)
      implicit%clsmap(: 88) = (/ 1, 3, 2, 5, 6, 7, 8, 9, 10, 12, &
                                   13, 14, 17, 18, 19, 20, 21, 22, 23, 24, &
                                   25, 26, 27, 28, 29, 30, 31, 32, 33, 34, &
                                   35, 36, 37, 38, 39, 40, 41, 42, 43, 47, &
                                   48, 49, 44, 45, 46, 50, 51, 52, 53, 54, &
                                   55, 56, 57, 58, 59, 60, 61, 62, 63, 64, &
                                   65, 66, 67, 68, 69, 70, 71, 72, 73, 74, &
                                   75, 76, 77, 83, 84, 85, 86, 87, 88, 82, &
                                   78, 79, 80, 81, 89, 90, 91, 92 /)
      implicit%permute(: 88) = (/ 83, 25, 52, 80, 81, 82, 51, 38, 26, 86, &
                                    87, 21, 85, 34, 72, 55, 28, 36, 23, 40, &
                                    45, 56, 14, 64, 37, 69, 88, 44, 68, 15, &
                                    65, 29, 61, 47, 60, 70, 30, 16, 31, 17, &
                                    63, 58, 43, 59, 32, 67, 76, 53, 78, 77, &
                                    79, 33, 84, 39, 74, 73, 75, 22, 57, 71, &
                                    46, 19, 20, 48, 41, 24, 49, 35, 50, 42, &
                                    54, 62, 66, 18, 27, 1, 13, 2, 3, 4, &
                                     5, 6, 7, 8, 9, 10, 11, 12 /)
      implicit%diag_map(: 88) = (/ 1, 2, 3, 4, 5, 7, 8, 10, 11, 12, &
                                     13, 14, 15, 17, 20, 23, 26, 30, 32, 37, &
                                     40, 43, 46, 50, 54, 61, 66, 71, 75, 80, &
                                     85, 92, 97, 102, 107, 110, 117, 122, 127, 131, &
                                    138, 144, 148, 153, 158, 161, 168, 177, 185, 190, &
                                    197, 201, 207, 215, 223, 228, 232, 242, 253, 260, &
                                    266, 274, 288, 303, 313, 324, 334, 352, 365, 374, &
                                    387, 400, 406, 414, 426, 440, 452, 466, 484, 522, &
                                    543, 575, 604, 619, 648, 722, 770, 793 /)
      srfems_cnt = 25
      if( allocated( srfems_lst ) ) then
         deallocate( srfems_lst )
      end if
      allocate( srfems_lst(srfems_cnt),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate srfems_lst; error = ',ios
         call endrun
      end if
      if( allocated( megan_map ) ) then
         deallocate( megan_map )
      end if
      if( allocated( xactive_srf_flx_map ) ) then
         deallocate( xactive_srf_flx_map )
      end if
      allocate( megan_map(srfems_cnt),xactive_srf_flx_map(srfems_cnt),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate megan_map,xactive_srf_flx_map; error = ',ios
         call endrun
      end if
      srfems_lst(:srfems_cnt) = (/ 'NO      ', 'CH2O    ', 'CO      ', 'C2H6    ', 'C2H4    ', &
                                   'C3H8    ', 'C3H6    ', 'BIGALK  ', 'BIGENE  ', 'ISOP    ', &
                                   'C10H16  ', 'TOLUENE ', 'CH3OH   ', 'C2H5OH  ', 'CH3COCH3', &
                                   'CH3CHO  ', 'MEK     ', 'CB1     ', 'CB2     ', 'OC1     ', &
                                   'OC2     ', 'SO2     ', 'DMS     ', 'NH3     ', 'Rn      ' /)
      megan_map(:srfems_cnt) = (/ .false., .false., .false., .false., .false., &
                                  .false., .false., .false., .false., .true., &
                                  .true., .false., .false., .false., .false., &
                                  .false., .false., .false., .false., .false., &
                                  .false., .false., .false., .false., .false. /)
      xactive_srf_flx_map(:srfems_cnt) = (/ .true., .false., .false., .false., .false., &
                                            .false., .false., .false., .false., .true., &
                                            .true., .false., .false., .false., .false., &
                                            .false., .false., .false., .false., .false., &
                                            .false., .false., .false., .false., .false. /)
      drydep_cnt = 51
      if( allocated( drydep_lst ) ) then
         deallocate( drydep_lst )
      end if
      allocate( drydep_lst(drydep_cnt),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate drydep_lst; error = ',ios
         call endrun
      end if
      drydep_lst(:drydep_cnt) = (/ 'O3      ', 'NO2     ', 'HNO3    ', 'NO      ', 'HO2NO2  ', &
                                   'CH3OOH  ', 'CH2O    ', 'CO      ', 'H2O2    ', 'CH3COOOH', &
                                   'PAN     ', 'MPAN    ', 'C2H5OOH ', 'ONIT    ', 'POOH    ', &
                                   'C3H7OOH ', 'ROOH    ', 'CH3COCHO', 'CH3COCH3', 'Pb      ', &
                                   'O3INERT ', 'O3S     ', 'ONITR   ', 'MACROOH ', 'XOOH    ', &
                                   'ISOPOOH ', 'CH3OH   ', 'C2H5OH  ', 'CH3CHO  ', 'GLYALD  ', &
                                   'HYAC    ', 'HYDRALD ', 'ALKOOH  ', 'MEKOOH  ', 'TOLOOH  ', &
                                   'TERPOOH ', 'CH3COOH ', 'SO2     ', 'SO4     ', 'NH3     ', &
                                   'NH4     ', 'NH4NO3  ', 'SOA     ', 'CB1     ', 'CB2     ', &
                                   'OC1     ', 'OC2     ', 'SA1     ', 'SA2     ', 'SA3     ', &
                                   'SA4     ' /)
      het_lst(:hetcnt) = (/ 'H2O2    ', 'HNO3    ', 'CH2O    ', 'CH3OOH  ', 'POOH    ', &
                            'CH3COOOH', 'HO2NO2  ', 'ONIT    ', 'MVK     ', 'MACR    ', &
                            'C2H5OOH ', 'C3H7OOH ', 'ROOH    ', 'CH3COCHO', 'Pb      ', &
                            'MACROOH ', 'XOOH    ', 'ONITR   ', 'ISOPOOH ', 'CH3OH   ', &
                            'C2H5OH  ', 'GLYALD  ', 'HYAC    ', 'HYDRALD ', 'CH3CHO  ', &
                            'ISOPNO3 ', 'ALKOOH  ', 'MEKOOH  ', 'TOLOOH  ', 'TERPOOH ', &
                            'CH3COOH ', 'SO2     ', 'SO4     ', 'SOA     ', 'NH3     ', &
                            'NH4     ', 'NH4NO3  ', 'CB2     ', 'OC2     ', 'SA1     ', &
                            'SA2     ', 'SA3     ', 'SA4     ' /)
      inv_from_dataset(:nfs) = (/ .false., .false., .false., .false. /)
      extfrc_lst(:extcnt) = (/ 'NO      ', 'CO      ', 'SO2     ', 'SYNOZ   ' /)
      frc_from_dataset(:extcnt) = (/ .true., .true., .true., .false. /)
      rxt_tag_cnt = 94
      if( allocated( rxt_tag_lst ) ) then
         deallocate( rxt_tag_lst )
      end if
      allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate rxt_tag_lst; error = ',ios
         call endrun
      end if
      if( allocated( rxt_tag_map ) ) then
         deallocate( rxt_tag_map )
      end if
      allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate rxt_tag_map; error = ',ios
         call endrun
      end if
      rxt_tag_lst(:rxt_tag_cnt) = (/ 'jo2             ', 'jo1d            ', 'jo3p            ', 'jn2o            ', &
                                     'jno2            ', 'jn2o5           ', 'jhno3           ', 'jno3            ', &
                                     'jho2no2         ', 'jch3ooh         ', 'jch2o_a         ', 'jch2o_b         ', &
                                     'jh2o2           ', 'jch3cho_a       ', 'jch3cho_b       ', 'jch3cho_c       ', &
                                     'jpooh           ', 'jch3co3h        ', 'jpan            ', 'jmpan           ', &
                                     'jmacr           ', 'jmvk            ', 'jc2h5ooh        ', 'jc3h7ooh        ', &
                                     'jrooh           ', 'jacet           ', 'jmgly           ', 'jxooh           ', &
                                     'jonitr          ', 'jisopooh        ', 'jhyac           ', 'jglyald         ', &
                                     'jmek            ', 'jbigald         ', 'jglyoxal        ', 'jalkooh         ', &
                                     'jmekooh         ', 'jtolooh         ', 'jterpooh        ', 'usr1            ', &
                                     'o1d_n2          ', 'o1d_o2          ', 'ox_l1           ', 'ox_l2           ', &
                                     'ox_l3           ', 'usr9            ', 'ox_p1           ', 'usr2            ', &
                                     'usr3            ', 'usr4            ', 'usr5            ', 'usr6            ', &
                                     'usr7            ', 'usr16           ', 'usr17           ', 'usr17a          ', &
                                     'ox_p2           ', 'usr8            ', 'usr13           ', 'ox_l6           ', &
                                     'ox_p16          ', 'ox_p5           ', 'usr10           ', 'ox_l4           ', &
                                     'ox_p3           ', 'ox_p4           ', 'usr11           ', 'usr12           ', &
                                     'ox_p9           ', 'usr22           ', 'ox_p10          ', 'ox_p15          ', &
                                     'soa5            ', 'ox_p14          ', 'ox_p17          ', 'soa4            ', &
                                     'ox_p12          ', 'ox_l5           ', 'ox_p6           ', 'ox_l7           ', &
                                     'ox_l8           ', 'ox_p7           ', 'ox_p8           ', 'usr14           ', &
                                     'usr15           ', 'soa2            ', 'soa1            ', 'soa3            ', &
                                     'ox_p13          ', 'ox_p11          ', 'usr21           ', 'usr23           ', &
                                     'usr24           ', 'usr26           ' /)
      rxt_tag_map(:rxt_tag_cnt) = (/ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, &
                                       11, 12, 13, 14, 15, 16, 17, 18, 19, 20, &
                                       21, 22, 23, 24, 25, 26, 27, 28, 29, 30, &
                                       31, 32, 33, 34, 35, 36, 37, 38, 39, 40, &
                                       42, 43, 44, 49, 50, 51, 58, 63, 64, 65, &
                                       66, 68, 70, 71, 72, 73, 76, 83, 84, 85, &
                                       86, 90, 95, 96, 98, 103, 104, 108, 111, 115, &
                                      116, 121, 122, 123, 128, 131, 134, 139, 140, 147, &
                                      149, 150, 157, 163, 164, 165, 166, 167, 168, 181, &
                                      187, 196, 198, 202 /)
      if( allocated( pht_alias_lst ) ) then
         deallocate( pht_alias_lst )
      end if
      allocate( pht_alias_lst(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate pht_alias_lst; error = ',ios
         call endrun
      end if
      if( allocated( pht_alias_mult ) ) then
         deallocate( pht_alias_mult )
      end if
      allocate( pht_alias_mult(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate pht_alias_mult; error = ',ios
         call endrun
      end if
      pht_alias_lst(:,1) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ' /)
      pht_alias_lst(:,2) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', 'jno3            ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              'jch3ooh         ', 'jh2o2           ', '                ', 'jpan            ', &
                              '                ', '                ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', '                ', '                ', 'jch3ooh         ', &
                              'userdefined     ', 'jch3ooh         ', 'jhyac           ', '                ', &
                              'jacet           ', 'jno2            ', 'jmgly           ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ' /)
      pht_alias_mult(:,1) = (/ 1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. /)
      pht_alias_mult(:,2) = (/ 1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1.1236 ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,.28 ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               1. ,1. ,1. ,1. ,1. , &
                               2. ,1. ,1. ,.2 ,1. , &
                               1. ,1. ,1. ,1. /)
      inv_lst(:nfs) = (/ 'M       ', 'N2      ', 'O2      ', 'H2O     ' /)
      fbc_cnt = (/ 3, 8 /)
      if( allocated( flbc_lst ) ) then
         deallocate( flbc_lst )
      end if
      allocate( flbc_lst(fbc_cnt(1)),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate flbc_lst; error = ',ios
         call endrun
      end if
      flbc_lst(:fbc_cnt(1)) = (/ 'N2O     ', 'H2      ', 'CH4     ' /)
      if( allocated( fubc_lst ) ) then
         deallocate( fubc_lst )
      end if
      if( allocated( fubc_alias_lst ) ) then
         deallocate( fubc_alias_lst )
      end if
      allocate( fubc_lst(fbc_cnt(2)),fubc_alias_lst(fbc_cnt(2)),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate fubc_lst; error = ',ios
         call endrun
      end if
      fubc_lst(:fbc_cnt(2)) = (/ 'N2O     ', 'NO      ', 'NO2     ', 'HNO3    ', &
                                 'N2O5    ', 'CH4     ', 'CO      ', 'O3RAD   ' /)
      fubc_alias_lst(:fbc_cnt(2)) = (/ '        ', '        ', '        ', '        ', &
                                       '        ', '        ', '        ', '        ' /)
      if( allocated( rxt_rate_map ) ) then
         deallocate( rxt_rate_map )
      end if
      allocate( rxt_rate_map(rxntot,3),stat=ios )
      if( ios /= 0 ) then
         write(*,*) 'set_sim_dat: failed to allocate rxt_rate_map; error = ',ios
         call endrun
      end if
      rxt_rate_map(:rxntot,1) = (/ 0, 1, 1, 4, 6, 10, 8, 7, 9, 18, &
                                     19, 19, 14, 30, 30, 30, 38, 32, 73, 75, &
                                     54, 53, 29, 36, 41, 39, 60, 62, 77, 52, &
                                     59, 26, 44, 71, 72, 49, 46, 69, 65, 2, &
                                      2, 3, 3, 3, 11, 11, 2, 13, 12, 13, &
                                     13, 14, 12, 12, 12, 4, 4, 5, 5, 6, &
                                      6, 7, 6, 10, 6, 8, 7, 6, 9, 9, &
                                     10, 7, 6, 15, 15, 17, 17, 17, 17, 18, &
                                     19, 19, 16, 22, 22, 24, 23, 23, 27, 28, &
                                     28, 28, 28, 29, 33, 33, 33, 37, 37, 38, &
                                     30, 30, 31, 31, 31, 31, 32, 73, 31, 34, &
                                     35, 35, 35, 36, 39, 40, 40, 40, 41, 42, &
                                     43, 47, 48, 48, 49, 74, 44, 45, 45, 46, &
                                     66, 67, 70, 68, 68, 69, 72, 50, 50, 51, &
                                     51, 51, 52, 51, 51, 53, 53, 54, 54, 55, &
                                     55, 55, 55, 55, 55, 56, 57, 57, 57, 57, &
                                     57, 57, 57, 75, 63, 63, 63, 64, 64, 65, &
                                     25, 50, 76, 76, 76, 60, 60, 77, 77, 58, &
                                     61, 61, 61, 61, 61, 62, 62, 20, 21, 75, &
                                     73, 59, 26, 93, 78, 83, 84, 84, 84, 86, &
                                     80, 13 /)
      rxt_rate_map(:rxntot,2) = (/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      1, 0, 0, 0, 3, 12, 12, 2, 1, 1, &
                                     13, 12, 13, 12, 12, 3, 3, 13, 1, 2, &
                                      1, 13, 7, 0, 12, 12, 5, 13, 12, 0, &
                                      0, 0, 0, 12, 3, 5, 17, 17, 13, 12, &
                                      7, 12, 12, 12, 1, 5, 0, 0, 12, 5, &
                                     13, 17, 28, 12, 12, 1, 7, 5, 13, 12, &
                                     12, 7, 5, 6, 13, 17, 12, 0, 31, 12, &
                                      5, 13, 17, 12, 12, 5, 13, 17, 12, 12, &
                                      5, 12, 5, 13, 12, 12, 12, 5, 13, 12, &
                                     12, 12, 6, 5, 13, 12, 12, 12, 1, 5, &
                                      7, 13, 12, 17, 31, 12, 1, 12, 1, 5, &
                                      5, 7, 13, 17, 31, 12, 5, 7, 13, 17, &
                                     31, 57, 6, 0, 12, 1, 7, 5, 13, 12, &
                                     12, 7, 5, 7, 13, 12, 7, 12, 7, 12, &
                                      5, 7, 13, 17, 31, 12, 12, 12, 12, 12, &
                                     12, 12, 12, 0, 0, 12, 12, 12, 7, 12, &
                                      0, 0 /)
      rxt_rate_map(:rxntot,3) = (/ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 2, &
                                      0, 1, 1, 1, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, &
                                      0, 0, 1, 1, 1, 0, 0, 1, 0, 1, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 1, 0, 0, 1, 0, 0, 0, &
                                      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &
                                      0, 0 /)
      end subroutine set_sim_dat
      end module mo_sim_dat
