
      module mo_aphys

      contains

      subroutine aphys( lat, ip, nstep, tdt, pmid, &
			pint, pdel, rpdel, zm, gz, &
			zi, tpert, qpert, phis, pblht, &
			t, q1, q, cmfmc, zdu, cmfdqr, &
			precc, cnt, cnb, dlf, plonl )
!-----------------------------------------------------------------------
! 	... convective adjustments using ccm3 parameterizations (zhang + hack).
!-----------------------------------------------------------------------

      use mo_grid,  only : plev, plevp, pcnst
      use mo_zhang, only : conv_ccm
      use mo_hack,  only : cmfcma
      use mo_qneg,  only : qneg3

      implicit none

!-----------------------------------------------------------------------
! 	... dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: &
           lat,ip, &               ! latitude index (s->n)
           plonl, &                ! lon tile dim
           nstep                   ! current time step index
      real, intent(in) :: &
           tdt                     ! 2 delta-t (seconds)
      real, dimension(plonl,plev), intent(in) :: &
           pmid, &                 ! pressure at midpoints
           pdel, &                 ! delta-p across layers
           rpdel, &                ! 1./pdel
           zm, &                   ! height above sfc at layer midpoints
           gz                      ! geopotential
      real, dimension(plonl,plevp), intent(in) :: &
           zi, &                   ! interface height above sfc
           pint                    ! pressure at interfaces
      real, dimension(plonl), intent(in) :: &
           tpert, &                ! pbl perturbation theta
           qpert, &                ! pbl perturbation specific humidity 
           phis, &                 ! surface geopotential
           pblht                   ! pbl height (provided by pbl routine)

      real, dimension(plonl,plev), intent(inout) :: &
           t, &                    ! temperature (t bar)
           q1                      ! specific humidity (sh bar)
      real, intent(inout) :: &
           q(plonl,plev,pcnst)     ! passive tracers

      real, dimension(plonl,plev), intent(out) :: &
           cmfmc, &                ! moist convection cloud mass flux
           zdu, &                  ! du2 from conv_ccm, 1/s
           cmfdqr, &               ! dq/dt due to convective rainout 
           dlf                     ! detraining cloud water from convection
      real, dimension(plonl), intent(out) :: &
           precc, &                ! convective precipitation rate
           cnt, &                  ! top level of convective activity   
           cnb                     ! bottom level of convective activity

!-----------------------------------------------------------------------
! 	... local variables
!-----------------------------------------------------------------------
      integer :: &
           i, k

      real, dimension(plonl,plev) :: &
           zmdt, &                 ! zhang convective temperature tendency
           zmdq, &                 ! zhang convective moisture tendency
           cme, &                  ! zhang condensation - evaporation
           zmu, &                  ! mu2 from conv_ccm, kg/m2/s
           zmd, &                  ! md2 from conv_ccm, kg/m2/s
           zeu                     ! eu2 from conv_ccm, 1/s

      real, dimension(plonl) :: &
           precc2, &                ! convective-scale preciptn rate
           cnt2, &                  ! top level of convective activity
           cnb2, &                  ! bottom level of convective activity
           tpert2, &                ! perturbation t
           qpert2                   ! perturbation q
      real, dimension(plonl,plev) :: &
           coneta, &                ! eta from cmfmca
           conbeta, &               ! beta from cmfmca
           cmfdt, &                 ! dt/dt due to moist convection
           cmfdq, &                 ! dq/dt due to moist convection
           qc2, &                   ! dq/dt due to rainout terms
           cmfdqr2, &               ! dq/dt due to moist convective rainout 
           cmfmc2, &                ! moist convection cloud mass flux
           cmfsl2, &                ! moist convection lw stat energy flux
           cmflq2                   ! moist convection total water flux
      real :: &
           pflx(plonl,plevp)        ! conv rain flux thru btm of that lev

!-----------------------------------------------------------------------
!     	... zhang convection
!-----------------------------------------------------------------------
      do k = 1,plev
         zmdt(:,k)   = 0.
         zmdq(:,k)   = 0.
         cmfmc(:,k)  = 0.
         cme(:,k)    = 0.
         cmfdqr(:,k) = 0.
      end do

      call qneg3( 'aphys_bz', lat, q, plonl )
!-----------------------------------------------------------------------
!     	... use t(1,plev) instead of ts
!-----------------------------------------------------------------------
      call conv_ccm( t, q1, q, pcnst, precc, &
		     cnt, cnb, pblht, zm, phis, &
		     zi, zmdq, zmdt, pmid, pint, &
		     pdel, t(1,plev), .5*tdt, cmfmc, cme, &
		     nstep, lat, ip, tpert, qpert, &
		     dlf, pflx, zdu, cmfdqr, zmu, &
		     zmd, zeu, plonl )
      call qneg3( 'aphys_az', lat, q, plonl )

!-----------------------------------------------------------------------
!     	... hack convection
!-----------------------------------------------------------------------
      tpert2(:plonl) = 0.
      qpert2(:plonl) = qpert(:plonl)

      call cmfcma( lat, nstep, tdt, pmid, pdel, &
                   rpdel, gz, tpert2, qpert2, phis, &
                   pblht, t, q1, q, pcnst, &
                   coneta, conbeta, cmfdt, cmfdq, cmfmc2, &
		   cmfdqr2, cmfsl2, cmflq2, precc2, qc2, &
		   cnt2, cnb2, plonl )
      call qneg3( 'aphys_ah', lat, q, plonl )

!-----------------------------------------------------------------------
!     	... merge zhang and hack diagnostics
!-----------------------------------------------------------------------
      precc(:plonl) = precc(:plonl) + precc2(:plonl)
      where( cnt2(:plonl) < cnt(:plonl) )
	 cnt(:plonl) = cnt2(:plonl)
      endwhere
      where( cnb2(:plonl) > cnb(:plonl) )
	 cnb(:plonl) = cnb2(:plonl)
      endwhere

      do k = 1,plev
         cmfmc(:,k)  = cmfmc(:,k)  + cmfmc2(:,k)
         cmfdqr(:,k) = cmfdqr(:,k) + cmfdqr2(:,k)
      end do

      end subroutine aphys

      subroutine aphysar( lat, nstep, tdt, pdel, rpdel, &
                          zmu, zmd, zeu, coneta, conbeta, &
			  q, plonl )
!-----------------------------------------------------------------------
! 	... convective adjustments using ccm3 parameterizations (zhang + hack)
!           with archived coefficients.
!-----------------------------------------------------------------------

      use mo_grid, only : plev, plevp, pcnst
      use mo_hack, only : cmfadj
      use mo_qneg, only : qneg3

      implicit none

!-----------------------------------------------------------------------
! 	... dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: &
        lat, &                 ! latitude index (s->n)
        plonl, &               ! lon tile dim
        nstep                  ! current time step index
      real, intent(in) :: &
        tdt                    ! 2 delta-t (seconds)
      real, dimension(plonl,plev), intent(in) :: &
        pdel, &                ! delta-p across layers
        rpdel, &               ! 1./pdel
        zmu, &                 ! mu2 from conv_ccm, kg/m2/s
        zmd, &                 ! md2 from conv_ccm, kg/m2/s
        zeu, &                 ! eu2 from conv_ccm, 1/s
        coneta, &              ! eta from cmfmca
        conbeta                ! beta from cmfmca

      real, intent(inout) :: &
        q(plonl,plev,pcnst)    ! passive tracers

!-----------------------------------------------------------------------
!     	... archived zhang convection
!-----------------------------------------------------------------------
!     call arconvtran( nstep, lat, .5*tdt, pdel, zmu, zmd, zeu
!                      pcnst, q )
!     call qneg3( 'aphysarz', lat, q )

!-----------------------------------------------------------------------
!     	... archived hack convection
!-----------------------------------------------------------------------
      call cmfadj( tdt, rpdel, coneta, conbeta, q, plonl )
      call qneg3( 'aphysarh', lat, q, plonl )

      end subroutine aphysar

      end module mo_aphys
