
      module MO_EXTYV

      CONTAINS

      subroutine EXTYV( u, v, plonl, platl, pplon )
!----------------------------------------------------------------------
!       ... Fill latitude extensions of a vector component extended array.
!           This is done in 2 steps:
!
!   1) interpolate to the pole points;
!     a) Lagrangian cubic interpolation of the coefficients for zonal
!        wave number 1 on the two Gaussian latitudes closest to the
!        pole.   (DISABLED) or,
!     b) use coefficients for zonal wave number 1 on the Gaussian
!        latitude closest to the pole.
!----------------------------------------------------------------------

      use MO_GRID,      only : plon, plev, plat
      use MO_MPI,       only : base_lat, masternode, lastnode
      use M_ADV,        only : has_spole, has_npole
      use MO_CONSTANTS, only : coslam, sinlam

      implicit none

      integer, parameter ::  plon2  = plon/2

!----------------------------------------------------------------------
!       ...On entry
!  uv      Extended data array with only the interior filled
!       ...On return
!  uv      As on entry except with the pole latitude and extensions
!          beyond it filled.
!----------------------------------------------------------------------
      integer, intent(in) ::  plonl, platl, pplon
      real, intent(inout) ::  u(plonl,plev,-3:platl+4,pplon)
      real, intent(inout) ::  v(plonl,plev,-2:platl+3,pplon)

!----------------------------------------------------------------------
!       ... Local variables
!----------------------------------------------------------------------
      integer :: ip, igl, igu, j, jb, k
      integer :: ipole
      real    :: factor
      real, dimension(plonl,plev,pplon,2) :: zpolec, zpoles
      real, dimension(plev,2) :: zpolec_avg, zpoles_avg
      real, dimension(plon)   :: wrk
      logical :: polar_u, polar_v

      if( .not. (has_spole .or. has_npole) ) then
         return
      end if

      do ipole = 1,2
         if( ipole == 1 .and. has_spole ) then
	    polar_u = .true.
	    polar_v = masternode .or. lastnode
            jb = 2 - base_lat
         else if( ipole == 2 .and. has_npole ) then
	    polar_u = .true.
	    polar_v = masternode .or. lastnode
            jb = plat - (base_lat + 1)
         else 
            cycle
         end if 

!----------------------------------------------------------------------
!        ... Fill polar line
!----------------------------------------------------------------------
         if( pplon > 1 ) then
!$OMP PARALLEL DO private( ip, igl, igu, k )
            do ip = 1,pplon
	       igl = (ip-1)*plonl + 1
	       igu = ip*plonl
	       if( polar_u ) then
                  do k = 1,plev
                     zpolec(:plonl,k,ip,1) = u(:plonl,k,jb,ip)*coslam(igl:igu)
                     zpoles(:plonl,k,ip,1) = u(:plonl,k,jb,ip)*sinlam(igl:igu)
	          end do
	       end if
	       if( polar_v ) then
                  do k = 1,plev
                     zpolec(:plonl,k,ip,2) = v(:plonl,k,jb,ip)*coslam(igl:igu)
                     zpoles(:plonl,k,ip,2) = v(:plonl,k,jb,ip)*sinlam(igl:igu)
	          end do
	       end if
            end do
!$OMP END PARALLEL DO
         else
	    if( polar_u ) then
               do k = 1,plev
                  zpolec(:plonl,k,1,1) = u(:plonl,k,jb,1)*coslam(1:plonl)
                  zpoles(:plonl,k,1,1) = u(:plonl,k,jb,1)*sinlam(1:plonl)
	       end do
	    end if
	    if( polar_v ) then
               do k = 1,plev
                  zpolec(:plonl,k,1,2) = v(:plonl,k,jb,1)*coslam(1:plonl)
                  zpoles(:plonl,k,1,2) = v(:plonl,k,jb,1)*sinlam(1:plonl)
	       end do
	    end if
	 end if

	 factor = 1./real( plon2 )
	 if( polar_u ) then
            do k = 1,plev
	       wrk(:) = reshape( zpolec(:plonl,k,:pplon,1), (/plon/) )
               zpolec_avg(k,1) = sum( wrk(:) ) * factor
	       wrk(:) = reshape( zpoles(:plonl,k,:pplon,1), (/plon/) )
               zpoles_avg(k,1) = sum( wrk(:) ) * factor
            end do
	 end if
	 if( polar_v ) then
            do k = 1,plev
	       wrk(:) = reshape( zpolec(:plonl,k,:pplon,2), (/plon/) )
               zpolec_avg(k,2) = sum( wrk(:) ) * factor
	       wrk(:) = reshape( zpoles(:plonl,k,:pplon,2), (/plon/) )
               zpoles_avg(k,2) = sum( wrk(:) ) * factor
            end do
	 end if
         if( ipole == 1 ) then
	    jb = jb - 1
         end if
         if( ipole == 2 ) then
	    jb = jb + 1
         end if

         if( pplon > 1 ) then
!$OMP PARALLEL DO private( ip, igl, igu, k )
            do ip = 1,pplon
	       igl = (ip-1)*plonl + 1
	       igu = ip*plonl
	       if( polar_u ) then
                  do k = 1,plev
                     u(:plonl,k,jb,ip) = zpolec_avg(k,1)*coslam(igl:igu) + zpoles_avg(k,1)*sinlam(igl:igu)
                  end do
	       end if
	       if( polar_v ) then
                  do k = 1,plev
                     v(:plonl,k,jb,ip) = zpolec_avg(k,2)*coslam(igl:igu) + zpoles_avg(k,2)*sinlam(igl:igu)
                  end do
	       end if
            end do
!$OMP END PARALLEL DO
         else
	    if( polar_u ) then
               do k = 1,plev
                  u(:plonl,k,jb,1) = zpolec_avg(k,1)*coslam(1:plonl) + zpoles_avg(k,1)*sinlam(1:plonl)
               end do
	    end if
	    if( polar_v ) then
               do k = 1,plev
                  v(:plonl,k,jb,1) = zpolec_avg(k,2)*coslam(1:plonl) + zpoles_avg(k,2)*sinlam(1:plonl)
               end do
	    end if
	 end if
      end do

      end subroutine EXTYV

      end module MO_EXTYV
