
      module mo_hook

      use mo_grid, only : plev

      implicit none

      private
      public  :: moz_hook_inti, moz_hook

      save

      real    :: csrf
      logical :: table_soilw
      logical :: do_Rn

      contains

      subroutine moz_hook_inti( plonl, platl, pplon )
!----------------------------------------------------------------------
!       ... initialize the chemistry "hook" routine
!----------------------------------------------------------------------

      use mo_constants, only : twopi, rearth
      use mo_chem_utls, only : has_drydep, get_spc_ndx
      use mo_grid,      only : plon
      use mo_control,   only : xactive_drydep, dyn_soilw

      implicit none

!----------------------------------------------------------------------
!	... dummy args
!----------------------------------------------------------------------
      integer, intent(in)        :: platl
      integer, intent(in)        :: plonl
      integer, intent(in)        :: pplon

      csrf = twopi*rearth*rearth/real(plon)    ! rearth in m
      table_soilw = .not. dyn_soilw .and. &
		     (xactive_drydep .and. (has_drydep( 'H2' ) .or. has_drydep( 'CO' )))
      do_Rn       = get_spc_ndx( 'Rn' ) > 0

      end subroutine moz_hook_inti

      subroutine moz_hook( ncdate, ncsec, caldayh, caldayf, cldtop, &
                           cldbot, oro, zm, zint, t, &
                           ts_avg, fsds_avg, plonl, platl, pplon )
!----------------------------------------------------------------------
!	... general purpose chemistry "hook" routine.
!           update deposition velocity and sulfur input fields,
!           and calculate lightning nox source & rn emissions.
!----------------------------------------------------------------------

      use mo_mpi
      use mo_constants, only : dayspy, phi, latwts, lat25, lat60, lat70
      use mo_srf_emis,  only : baseflux, landflux, srf_emis_chk
      use mo_extfrc,    only : extfrc_timestep_init
      use mo_flbc,      only : flbc_chk
      use chem_mods,    only : nadv_mass, adv_mass, phtcnt
      use mo_grid,      only : plat, plev, plevp, plon => plon
      use mo_histout,   only : outfld, match_file_cnt
      use mo_control,   only : delt, use_dust, xactive_prates
      use mo_sulf,      only : read_sulf
      use mo_strato_sad,only : strato_sad_timestep_init
      use mo_dust,      only : read_dust
      use mo_drydep,    only : chk_soilw
      use mo_solar_parms, only : solar_parms_timestep_init
      use mo_photo,     only : photo_timestep_init
      use mo_jlong,     only : jlong_timestep_init
      use mo_xemis,     only : has_xemis_isop, has_xemis_mterps
      use mo_xemis,     only : xemis_timestep_inti

      implicit none

!----------------------------------------------------------------------
!	... dummy args
!----------------------------------------------------------------------
      integer, intent(in) :: ncdate                     ! date of current step (yyyymmdd)
      integer, intent(in) :: ncsec                      ! seconds of current step
      integer, intent(in) :: plonl
      integer, intent(in) :: platl
      integer, intent(in) :: pplon
      real, intent(in) :: caldayh                       ! day of year at midpoint
      real, intent(in) :: caldayf                       ! day of year at endpoint
      real, intent(in) :: cldtop(plonl,platl,pplon)     ! cloud top level index
      real, intent(in) :: cldbot(plonl,platl,pplon)     ! cloud bottom level index
      real, intent(in) :: oro(plonl,platl,pplon)        ! orography "flag"
      real, intent(in) :: zm(plonl,plev,platl,pplon)    ! geopot height above surface at midpoints (m)
      real, intent(in) :: zint(plonl,plevp,platl,pplon) ! geopot height above surface at interfaces (m)
      real, intent(in) :: t(plonl,plev,platl,pplon)     ! temperature
      real, intent(in) :: ts_avg(plonl,platl,pplon)     ! time averaged surface temperature
      real, intent(in) :: fsds_avg(plonl,platl,pplon)   ! time averaged fsds

!----------------------------------------------------------------------
!	... local variables
!----------------------------------------------------------------------
      integer, parameter :: land   = 1
      integer, parameter :: ocean  = 0
      real, parameter    :: secpyr = dayspy * 8.64e4

      integer :: i, ip, istat, j, jgbl, &
                 surf_type, &
                 node, &
                 file               ! file index
      integer :: day, month
      real    :: sflux1, sflux2, sumocn, sumlnd
      real    :: total_flux
      real    :: gather_buff(plonl,platl,pplon,maxnodes)

!----------------------------------------------------------------------
!	... check srf emission timing
!----------------------------------------------------------------------
      call srf_emis_chk( plonl, platl, pplon, ncdate, ncsec )
      if( has_xemis_isop .or. has_xemis_mterps ) then
         day   = mod( ncdate,100 )
         if( day == 1 .and. ncsec == 0 ) then
            month = mod( ncdate,10000 )/100
            call xemis_timestep_inti( month, ts_avg, fsds_avg, plonl, platl, pplon )
         end if
      end if
!----------------------------------------------------------------------
!	... check insitu frcing timing
!----------------------------------------------------------------------
      call extfrc_timestep_init( plonl, platl, pplon, ncdate, ncsec )
!----------------------------------------------------------------------
!	... check flbc timing
!----------------------------------------------------------------------
      call flbc_chk( plonl, platl, pplon, ncdate, ncsec )
!----------------------------------------------------------------------
!	... check sad timing
!----------------------------------------------------------------------
      call strato_sad_timestep_init( plonl, platl, pplon, ncdate, ncsec )
!----------------------------------------------------------------------
!	... check for new sulfate input
!----------------------------------------------------------------------
      call read_sulf( plonl, platl, pplon, caldayf )

has_photolysis : &
      if( phtcnt > 0 ) then
         if( .not. xactive_prates ) then
!----------------------------------------------------------------------
!	... check etf update
!----------------------------------------------------------------------
            call solar_parms_timestep_init( ncdate, ncsec )
         end if
!----------------------------------------------------------------------
!	... set timing parms for photo module
!----------------------------------------------------------------------
         call photo_timestep_init( caldayf, ncsec )
!----------------------------------------------------------------------
!	... check photo etf update
!----------------------------------------------------------------------
         if( .not. xactive_prates ) then
!----------------------------------------------------------------------
!	... check jlong etf update
!----------------------------------------------------------------------
            call jlong_timestep_init( ncsec )
         end if
      end if has_photolysis

!----------------------------------------------------------------------
!	... check for new dust input
!----------------------------------------------------------------------
      if( use_dust ) then
         call read_dust( plonl, platl, pplon, caldayf )
      end if

!----------------------------------------------------------------------
!	... set soil moisture timing variable
!----------------------------------------------------------------------
      if( table_soilw ) then
         call chk_soilw( caldayf )
      end if

      if( do_Rn ) then
!--------------------------------------------------------------------------------
!	... form radon surface emission factors
!	    note : radon global emission = 15 kg/yr
!--------------------------------------------------------------------------------
         total_flux = 15. / secpyr                                ! kg/s
         sflux1 = 0.
         sflux2 = 0.
#ifdef USE_MPI
         call mpi_gather( oro, plon*platl, mpi_double_precision, &
		          gather_buff, plon*platl, mpi_double_precision, 0, mpi_comm_comp, istat )
         if( istat /= mpi_success ) then
            write(*,*) 'moz_hook: mpi_gather for oro failed; error = ',istat
	    call endrun
         end if
         if( masternode ) then
            do node = 1,maxnodes
               do j = 1,platl
	          jgbl = (node-1)*platl + j
                  if( phi(jgbl) < lat70 .and. phi(jgbl) > -lat60 ) then
	             sumocn = 0.
	             sumlnd = 0.
                     do ip = 1,pplon
	                do i = 1,plonl
	                   surf_type = nint( gather_buff(i,j,ip,node) )
	                   if( surf_type == ocean ) then
	                      sumocn = sumocn + 1.
	                   else if( surf_type == land ) then
	                      if( phi(jgbl) >=  lat60 ) then
		                 sumlnd = sumlnd + .5
                              else
		                 sumlnd = sumlnd + 1.
		              end if
	                   end if
	                end do
	             end do
	             sflux1 = sflux1 + csrf * latwts(jgbl) * sumocn * baseflux
	             sflux2 = sflux2 + csrf * latwts(jgbl) * sumlnd
	          end if
               end do
            end do
         end if
         call mpi_bcast( sflux1, 1, mpi_double_precision, 0, mpi_comm_comp, istat )
         if( istat /= mpi_success ) then
            write(*,*) 'moz_hook: mpi_bcast for sflux1 failed; error = ',istat
	    call endrun
         end if
         call mpi_bcast( sflux2, 1, mpi_double_precision, 0, mpi_comm_comp, istat )
         if( istat /= mpi_success ) then
            write(*,*) 'moz_hook: mpi_bcast for sflux2 failed; error = ',istat
	    call endrun
         end if
#else
         do j = 1,plat
            if( phi(j) < lat70 .and. phi(j) > -lat60 ) then
	       sumocn = 0.
	       sumlnd = 0.
	       do ip = 1,pplon
	          do i = 1,plonl
	             surf_type = nint( oro(i,j,ip) )
	             if( surf_type == ocean ) then
	                sumocn = sumocn + 1.
	             else if( surf_type == land ) then
	                if( phi(j) >=  lat60 ) then
	                   sumlnd = sumlnd + .5
                        else
		           sumlnd = sumlnd + 1.
		        end if
	             end if
	          end do
	       end do
	       sflux1 = sflux1 + csrf * latwts(j) * sumocn * baseflux
	       sflux2 = sflux2 + csrf * latwts(j) * sumlnd
	    end if
         end do
#endif
         landflux = (total_flux - sflux1) / sflux2
      end if

      end subroutine moz_hook

      end module mo_hook
