
#undef QNEG_DIAGS

      module MO_QNEG
!----------------------------------------------------------------------------
! 	... Minimum mass mixing ratio for constituents
!----------------------------------------------------------------------------

      use mo_grid, only : pcnst

      implicit none

      save

      real :: &
        qmin(pcnst)     ! Global minimum constituent concentration

      CONTAINS

      subroutine INIQNEG( xqmin )
!----------------------------------------------------------------------------
! 	... Set the minimum mass mixing ratios
!----------------------------------------------------------------------------

      implicit none

!----------------------------------------------------------------------------
! 	... Dummy arguments
!----------------------------------------------------------------------------
      real, intent(in) :: &
            xqmin(pcnst)  ! Minimum mixing ratio for constituents.

      qmin(:pcnst) = xqmin(:pcnst)

      end subroutine INIQNEG

      subroutine QNEG3( subnam, lat, q, plonl )
!-----------------------------------------------------------------------
! 	... Check moisture and tracers for minimum value, reset any below
!           minimum value to minimum value and return information to allow
!           warning message to be printed. The global average is NOT preserved.
!-----------------------------------------------------------------------

      use mo_grid, only : plev

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: lat                 ! latitude index
      integer, intent(in) :: plonl               ! lon tile dim
      real, intent(inout) :: q(plonl,plev,pcnst) ! moisture/tracer field
      character(len=8), intent(in) :: subnam     ! name of calling routine

!-----------------------------------------------------------------------
! 	... Local variables
!-----------------------------------------------------------------------
      integer :: nvals            ! number of values found < qmin
      integer :: m                ! constituent index
      logical :: found            ! true => at least 1 minimum violator found
      integer :: min_ind(2)       ! i,k indices of worst violator
      real :: worst               ! biggest violator

      do m = 1,pcnst
!-----------------------------------------------------------------------
! 	... Test all field values for being less than minimum value.
!           Set q = qmin for all such points. Trace offenders and
!           identify worst one.
!-----------------------------------------------------------------------
	 nvals = COUNT( q(:plonl,:plev,m) < qmin(m) )
	 found = nvals > 0
         if( found ) then
#ifdef QNEG_DIAGS
	    worst      = MINVAL( q(:plonl,:plev,m) )
            min_ind(:) = MINLOC( q(:plonl,:plev,m) )
            write(*,9000) subnam, m, lat, nvals, qmin(m), worst, min_ind(:)
#endif
            q(:plonl,:plev,m) = MAX( qmin(m),q(:plonl,:plev,m) )
         end if
      end do

#ifdef QNEG_DIAGS
 9000 format(' QNEG3 from ',a8,':m=',i3,' lat=',i3, &
             ' Min. mixing ratio violated at ',i4,' points.  Reset to ', &
             1p,e8.1,' Worst =',e8.1,' at i,k=',i4,i3)
#endif

      end subroutine QNEG3

      subroutine SHNEG( mes, lat, q, plonl )
!-----------------------------------------------------------------------
! 	... Check fields and reset any negative values to zero.
!-----------------------------------------------------------------------

      use mo_grid, only : plev

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: lat              ! latitude index
      integer, intent(in) :: plonl            ! lon tile dim
      real, intent(inout) :: q(plonl,plev)    ! specific humidity
      character(len=*), intent(in) :: mes     ! message

!-----------------------------------------------------------------------
! 	... Local variables
!-----------------------------------------------------------------------
      real, parameter :: qmin = 1.e-12
      integer :: nvals            ! number of values found < qmin
      logical :: found            ! true => at least 1 minimum violator found
      integer :: min_ind(2)       ! i,k indices of worst violator
      real :: worst               ! biggest violator

      nvals = COUNT( q(:plonl,:plev) < qmin )
      found = nvals > 0
      if( found ) then
#ifdef QNEG_DIAGS
         if( mes /= 'VDIFF:sh' ) then
	    worst = MINVAL( q(:plonl,:plev) )
            min_ind(:) = MINLOC( q(:plonl,:plev) )
            write(*,9000) mes, lat, nvals, qmin, worst, min_ind(:)
         end if
#endif
         q(:plonl,:plev) = MAX( qmin,q(:plonl,:plev) )
      end if

#ifdef QNEG_DIAGS
 9000 format('shneg: ',a8,' lat=',i3, &
             ' neg values at ',i4,' points.  Reset to ', &
             1p,e8.1,' Worst =',e8.1,' at i,k=',i4,i3)
#endif

      end subroutine SHNEG

      end module MO_QNEG
