
      module mo_timer

      implicit none

      save

      real :: elapsed(40) = 0.
      character(len=8)  :: cdate(20)
      character(len=10) :: ctime(20)

      contains

      real function sw_second()

      real(4) :: times(2), eltime

#ifdef IBM_UND
      real(4) :: etime

      eltime = etime( times )
#elif defined IBM
      real(4) :: etime_

      eltime = etime_( times )
#else
      real(4) :: etime

      eltime = etime( times )
#endif

      sw_second = dble( eltime )

      end function sw_second

      real function time_diff( time1, time2 )

      implicit none

      character(len=10), intent(in) :: time1, time2

      real :: hr, min, sec, elapsed

      read(time1(1:2),*) hr
      read(time1(3:4),*) min
      read(time1(5:),*) sec
      elapsed = 60.*(min + 60.*hr) + sec

      read(time2(1:2),*) hr
      read(time2(3:4),*) min
      read(time2(5:),*) sec

      time_diff = 60.*(min + 60.*hr) + sec - elapsed
      if( time_diff < 0. ) then
	 time_diff = time_diff + 8.64e4
      end if

      end function time_diff

      end module mo_timer
