
      module mo_vgrid

      private
      public :: hycoef

      contains

      subroutine hycoef( hyai, hyam, hybi, hybm, hypi, &
                         hybd, nprlev, etamid, etaint )
!-----------------------------------------------------------------------
! 	... Initialize hybrid coordinates.
!           Hybrid level definitions: p = a*p0 + b*ps
!           interfaces   p(k) = hyai(k)*p0 + hybi(k)*ps
!           midpoints    p(k) = hyam(k)*p0 + hybm(k)*ps
!-----------------------------------------------------------------------

      use mo_grid, only : plev, plevp

      implicit none

!-----------------------------------------------------------------------
! 	... Dummy arguments
!-----------------------------------------------------------------------
      real, dimension(plev), intent(in) :: &
        hyam, &          ! p0 component of hybrid coordinate - midpoints
        hybm             ! ps component of hybrid coordinate - midpoints

      real, dimension(plevp), intent(inout) :: &
        hyai, &          ! p0 component of hybrid coordinate - interfaces
        hybi             ! ps component of hybrid coordinate - interfaces
                         ! hyai(1) and hybi(1) are set to hyai(2)/10. and
                         ! hybi(2)/10. resp. if they are BOTH zero on input.

      real, intent(out) :: &
        hypi(plevp), &   ! ref press at interfaces
        hybd(plev), &    ! difference of the hybis
        etamid(plev), &  ! hyam + hybm
        etaint(plevp)    ! hyai + hybi

      integer, intent(out) :: &
        nprlev           ! index of lowest pure pressure interface

!-----------------------------------------------------------------------
! 	... Local variables
!-----------------------------------------------------------------------
      integer :: &
        k             ! indices

      etamid(:plev)  = hyam(:plev) + hybm(:plev)
      etaint(:plevp) = hyai(:plevp) + hybi(:plevp)
      hypi(:plevp)   = 1.e5 * (hyai(:plevp) + hybi(:plevp))

!-----------------------------------------------------------------------
!     	... Because of the scheme used in the SLT for estimating vertical departure
!           points, the top of the model cant be at eta=0.
!-----------------------------------------------------------------------
      if( etaint(1) == 0. ) then
         hyai(1)   = hyai(2) / 10.
         hybi(1)   = hybi(2) / 10.
         etaint(1) = hyai(1) + hybi(1)
      end if

!-----------------------------------------------------------------------
!     	... Set delta sigma part of layer thickness
!-----------------------------------------------------------------------
      do k = 1,plev
         hybd(k) = hybi(k+1) - hybi(k)
      end do

!-----------------------------------------------------------------------
!     	... Set nprlev to the interface above, the first time a 
!           nonzero surface pressure contribution is found. "nprlev" 
!           identifies the lowest pure pressure interface.
!-----------------------------------------------------------------------
      write(*,*) 'hcoeff: diagnostic'
      write(*,*) 'hyam'
      write(*,'(5(1p,e20.13))') hyam
      write(*,*) 'hybm'
      write(*,'(5(1p,e20.13))') hybm
      nprlev = 0
      do k = 1,plev
         if( nprlev == 0 .and. hybi(k) /= 0. ) then
	    nprlev = k - 1
	 end if
      end do
!-----------------------------------------------------------------------
!     	... Set nprlev if no nonzero bs have been found. All interfaces are 
!           pure pressure. A pure pressure model requires other changes as well. 
!-----------------------------------------------------------------------
      if( nprlev == 0 ) then
         nprlev = plev + 2
      end if
      write(*,*) 'hycoef: nprlev = ',nprlev

      end subroutine hycoef

      end module mo_vgrid
