
      module mo_virtem

      implicit none

      private
      public :: inivtem, virtem

      save

      real :: zvir

      contains

      subroutine inivtem( xzvir )
!-----------------------------------------------------------------------
!	... initialize module
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
! 	... dummy arguments
!-----------------------------------------------------------------------
      real, intent(in) :: &
        xzvir      ! rh2o/rair - 1.

      zvir = xzvir

      end subroutine inivtem

      subroutine virtem( t, q, tv, plonl )
!-----------------------------------------------------------------------
! 	... compute the virtual temperature
!-----------------------------------------------------------------------

      use mo_grid, only : plev

      implicit none

!-----------------------------------------------------------------------
! 	... dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: &
	   plonl
      real, dimension(plonl,plev), intent(in) :: &
           t, &                ! temperature
           q                   ! specific humidity
      real, intent(out) :: &
           tv(plonl,plev)      ! virtual temperature

!-----------------------------------------------------------------------
! 	... local variables
!-----------------------------------------------------------------------
      integer :: &
           k                ! longitude and level indexes

      do k = 1,plev
         tv(:,k) = t(:,k)*(1. + zvir*q(:,k))
      end do
      
      end subroutine virtem

      end module mo_virtem
