module drydep_input_data_tables

implicit none

save

!---------------------------------------------------------------------------
! Table 1 from Wesely, Atmos. Environment, 1989, p1293
! Table 2 from Sheih, microfiche PB86-218104 and Walcek, Atmos.  Environment, 1986, p949
! Table 3-5 compiled by P. Hess
!
! index #1 : season
!           1 -> midsummer with lush vegetation
!           2 -> autumn with unharvested cropland
!           3 -> late autumn after frost, no snow
!           4 -> winter, snow on ground, and subfreezing
!           5 -> transitional spring with partially green short annuals
!
! index #2 : landuse type
!           1 -> urban land
!           2 -> agricultural land
!           3 -> range land
!           4 -> deciduous forest
!           5 -> coniferous forest
!           6 -> mixed forest including wetland
!           7 -> water, both salt and fresh
!           8 -> barren land, mostly desert
!           9 -> nonforested wetland
!           10 -> mixed agricultural and range land
!           11 -> rocky open areas with low growing shrubs
!
! JFL August 2000
!---------------------------------------------------------------------------

!---------------------------------------------------------------------------
! table to parameterize the impact of soil moisture on the deposition of H2 and
! CO on soils (from Sanderson et al., J. Atmos. Chem., 46, 15-28, 2003).
!---------------------------------------------------------------------------
  real, dimension(11) :: h2_a, h2_b, h2_c

  data h2_a(1:11) /  0.000,  0.000, 0.270,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000/
  data h2_b(1:11) /  0.000,-41.390,-0.472,-41.900,-41.900,-41.900,  0.000,  0.000,  0.000,-41.390,  0.000/
  data h2_c(1:11) /  0.000, 16.850, 1.235, 19.700, 19.700, 19.700,  0.000,  0.000,  0.000, 17.700,  1.000/

  real, dimension(5,11) :: ri, rlu, rac, rgss, rgso, rcls, rclo

  data ri  (1,1:11) /1.e36,  60., 120.,  70., 130., 100.,1.e36,1.e36,  80., 100., 150./
  data rlu (1,1:11) /1.e36,2000.,2000.,2000.,2000.,2000.,1.e36,1.e36,2500.,2000.,4000./
  data rac (1,1:11) / 100., 200., 100.,2000.,2000.,2000.,   0.,   0., 300., 150., 200./
  data rgss(1,1:11) / 400., 150., 350., 500., 500., 100.,   0.,1000.,  0., 220., 400./
  data rgso(1,1:11) / 300., 150., 200., 200., 200., 300.,2000., 400.,1000., 180., 200./
  data rcls(1,1:11) /1.e36,2000.,2000.,2000.,2000.,2000.,1.e36,1.e36,2500.,2000.,4000./
  data rclo(1,1:11) /1.e36,1000.,1000.,1000.,1000.,1000.,1.e36,1.e36,1000.,1000.,1000./

  data ri  (2,1:11) /1.e36,1.e36,1.e36,1.e36, 250., 500.,1.e36,1.e36,1.e36,1.e36,1.e36/
  data rlu (2,1:11) /1.e36,9000.,9000.,9000.,4000.,8000.,1.e36,1.e36,9000.,9000.,9000./
  data rac (2,1:11) / 100., 150., 100.,1500.,2000.,1700.,   0.,   0., 200., 120., 140./
  data rgss(2,1:11) / 400., 200., 350., 500., 500., 100.,   0.,1000.,   0., 300., 400./
  data rgso(2,1:11) / 300., 150., 200., 200., 200., 300.,2000., 400., 800., 180., 200./
  data rcls(2,1:11) /1.e36,9000.,9000.,9000.,2000.,4000.,1.e36,1.e36,9000.,9000.,9000./
  data rclo(2,1:11) /1.e36, 400., 400., 400.,1000., 600.,1.e36,1.e36, 400., 400., 400./

  data ri  (3,1:11) /1.e36,1.e36,1.e36,1.e36, 250., 500.,1.e36,1.e36,1.e36,1.e36,1.e36/
  data rlu (3,1:11) /1.e36,1.e36,9000.,9000.,4000.,8000.,1.e36,1.e36,9000.,9000.,9000./
  data rac (3,1:11) / 100.,  10., 100.,1000.,2000.,1500.,   0.,   0., 100.,  50., 120./
  data rgss(3,1:11) / 400., 150., 350., 500., 500., 200.,   0.,1000.,   0., 200., 400./
  data rgso(3,1:11) / 300., 150., 200., 200., 200., 300.,2000., 400.,1000., 180., 200./
  data rcls(3,1:11) /1.e36,1.e36,9000.,9000.,3000.,6000.,1.e36,1.e36,9000.,9000.,9000./
  data rclo(3,1:11) /1.e36,1000., 400., 400.,1000., 600.,1.e36,1.e36, 800., 600., 600./

  data ri  (4,1:11) /1.e36,1.e36,1.e36,1.e36, 400., 800.,1.e36,1.e36,1.e36,1.e36,1.e36/
  data rlu (4,1:11) /1.e36,1.e36,1.e36,1.e36,6000.,9000.,1.e36,1.e36,9000.,9000.,9000./
  data rac (4,1:11) / 100.,  10.,  10.,1000.,2000.,1500.,   0.,   0.,  50.,  10.,  50./
  data rgss(4,1:11) / 100., 100., 100., 100., 100., 100.,   0.,1000., 100., 100.,  50./
  data rgso(4,1:11) / 600.,3500.,3500.,3500.,3500.,3500.,2000., 400.,3500.,3500.,3500./
  data rcls(4,1:11) /1.e36,1.e36,1.e36,9000., 200., 400.,1.e36,1.e36,9000.,1.e36,9000./
  data rclo(4,1:11) /1.e36,1000.,1000., 400.,1500., 600.,1.e36,1.e36, 800.,1000., 800./

  data ri  (5,1:11) /1.e36, 120., 240., 140., 250., 190.,1.e36,1.e36, 160., 200., 300./
  data rlu (5,1:11) /1.e36,4000.,4000.,4000.,2000.,3000.,1.e36,1.e36,4000.,4000.,8000./
  data rac (5,1:11) / 100.,  50.,  80.,1200.,2000.,1500.,   0.,   0., 200.,  60., 120./
  data rgss(5,1:11) / 500., 150., 350., 500., 500., 200.,   0.,1000.,   0., 250., 400./
  data rgso(5,1:11) / 300., 150., 200., 200., 200., 300.,2000., 400.,1000., 180., 200./
  data rcls(5,1:11) /1.e36,4000.,4000.,4000.,2000.,3000.,1.e36,1.e36,4000.,4000.,8000./
  data rclo(5,1:11) /1.e36,1000., 500., 500.,1500., 700.,1.e36,1.e36, 600., 800., 800./

!---------------------------------------------------------------------------
!         ... roughness length
!---------------------------------------------------------------------------
  real, dimension(5,11) :: z0

  data z0  (1,1:11) /1.000,0.250,0.050,1.000,1.000,1.000,0.0006,0.002,0.150,0.100,0.100/
  data z0  (2,1:11) /1.000,0.100,0.050,1.000,1.000,1.000,0.0006,0.002,0.100,0.080,0.080/
  data z0  (3,1:11) /1.000,0.005,0.050,1.000,1.000,1.000,0.0006,0.002,0.100,0.020,0.060/
  data z0  (4,1:11) /1.000,0.001,0.001,1.000,1.000,1.000,0.0006,0.002,0.001,0.001,0.040/
  data z0  (5,1:11) /1.000,0.030,0.020,1.000,1.000,1.000,0.0006,0.002,0.010,0.030,0.060/

!---------------------------------------------------------------------------
! chemical data
!---------------------------------------------------------------------------
  integer, parameter :: n_species_table = 54

  real, dimension(n_species_table*6) :: dheff
  real, dimension(n_species_table)   :: dfoxd
  character(len=20), dimension(n_species_table) :: species_name_table

  data species_name_table / 'OX'                             & 
                           ,'SO2'                            &
                           ,'H2O2'                           & 
                           ,'HO'                             & 
                           ,'HO2'                            & 
                           ,'CO'                             & 
                           ,'CH4'                            & 
                           ,'CH3O2'                          & 
                           ,'CH3OOH'                         & 
                           ,'CH2O'                           & 
                           ,'CHOOH'                          & 
                           ,'NO'                             & 
                           ,'NO2'                            & 
                           ,'HNO3'                           & 
                           ,'CO2'                            & 
                           ,'NH3'                            & 
                           ,'N2O5'                           & 
                           ,'NO3'                            & 
                           ,'CH3OH'                          & 
                           ,'HO2NO2'                         & 
                           ,'O1D'                            & 
                           ,'C2H6'                           & 
                           ,'C2H5O2'                         & 
                           ,'PO2'                            & 
                           ,'MACRO2'                         & 
                           ,'ISOPO2'                         & 
                           ,'C4H10'                          & 
                           ,'CH3CHO'                         & 
                           ,'C2H5OOH'                        & 
                           ,'C3H6'                           & 
                           ,'POOH'                           & 
                           ,'C2H4'                           & 
                           ,'PAN'                            & 
                           ,'CH3COOOH'                       & 
                           ,'C10H16'                         & 
                           ,'CHOCHO'                         & 
                           ,'CH3COCHO'                       & 
                           ,'GLYALD'                         & 
                           ,'CH3CO3'                         & 
                           ,'C3H8'                           & 
                           ,'C3H7O2'                         & 
                           ,'CH3COCH3'                       & 
                           ,'C3H7OOH'                        & 
                           ,'RO2'                            & 
                           ,'ROOH'                           & 
                           ,'Rn'                             & 
                           ,'ISOP'                           &
                           ,'MVK'                            &
                           ,'MACR'                           &
                           ,'C2H5OH'                         &
                           ,'ONITR'                          & 
                           ,'ONIT'                           & 
                           ,'ISOPNO3'                        & 
                           ,'HYDRALD'                        &
                           /

  data dheff /1.15e-02, 2560.,0.     ,    0.,0.     ,    0.  &
             ,8.33e+04, 7379.,2.2e-12,-3730.,0.     ,    0.  &
             ,8.33e+04, 7379.,2.2e-12,-3730.,0.     ,    0.  &
             ,3.00e+01,    0.,0.     ,    0.,0.     ,    0.  &
             ,2.00e+03, 6600.,3.5e-05,    0.,0.     ,    0.  &
             ,1.00e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,7.47e+00, 5241.,0.     ,    0.,0.     ,    0.  &
             ,3.11e+02, 5241.,0.     ,    0.,0.     ,    0.  &
             ,6.30e+03, 6425.,0.     ,    0.,0.     ,    0.  &
             ,5.53e+03, 5700.,1.8e-04,-1510.,0.     ,    0.  &
             ,1.90e-03, 1480.,0.     ,    0.,0.     ,    0.  &
             ,6.40e-03, 2500.,0.     ,    0.,0.     ,    0.  &
             ,0.      ,    0.,2.6e+06, 8700.,0.     ,    0.  &
             ,3.40e-02, 2420.,4.5e-07,-1000.,3.6e-11,-1760.  &
             ,7.40e+01, 3400.,1.7e-05, -450.,1.0e-14,-6716.  &
             ,2.14e+00, 3362.,0.     ,    0.,0.     ,    0.  &
             ,0.65e+00,    0.,0.     ,    0.,0.     ,    0.  &
             ,2.20e+02, 4934.,0.     ,    0.,0.     ,    0.  &
             ,0.      ,    0.,3.2e+01,    0.,0.     ,    0.  &
             ,1.00e-16,    0.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,7.47e+00, 5241.,0.     ,    0.,0.     ,    0.  &
             ,7.47e+00, 5241.,0.     ,    0.,0.     ,    0.  &
             ,7.47e+00, 5241.,0.     ,    0.,0.     ,    0.  &
             ,7.47e+00, 5241.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &  
             ,1.14e+01, 6267.,0.     ,    0.,0.     ,    0.  &
             ,3.36e+02, 5995.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,2.20e+02, 5653.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,5.00e+00,    0.,0.     ,    0.,0.     ,    0.  &
             ,8.37e+02, 5308.,1.8e-04,-1510.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,3.00e+05,    0.,0.     ,    0.,0.     ,    0.  &
             ,3.71e+03, 7541.,0.     ,    0.,0.     ,    0.  &
             ,4.14e+04, 4630.,0.     ,    0.,0.     ,    0.  &
             ,7.47e+00, 5241.,0.     ,    0.,0.     ,    0.  &
             ,1.45e-03, 2700.,0.     ,    0.,0.     ,    0.  &
             ,3.00e+06,    0.,0.     ,    0.,0.     ,    0.  &
             ,2.70e+01, 5300.,0.     ,    0.,0.     ,    0.  &
             ,3.36e+02, 5995.,0.     ,    0.,0.     ,    0.  &  
             ,7.47e+00, 5241.,0.     ,    0.,0.     ,    0.  &
             ,3.36e+02, 5995.,0.     ,    0.,0.     ,    0.  &
             ,0.00e+00,    0.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,1.70e-03,    0.,0.     ,    0.,0.     ,    0.  &
             ,2.00e+02, 6500.,0.     ,    0.,0.     ,    0.  &
             ,7.51e+03, 6485.,0.     ,    0.,0.     ,    0.  &
             ,1.00e+03, 6000.,0.     ,    0.,0.     ,    0.  &
             ,1.00e+01,    0.,0.     ,    0.,0.     ,    0.  &
             ,7.00e+01, 6000.,0.     ,    0.,0.     ,    0.  &
            /

data dfoxd /  1.        &
             ,0.        &
             ,1.        &
             ,1.        &
             ,.1        &
             ,1.e-36    &
             ,1.e-36    &
             ,1.        &
             ,.1        &
             ,1.e-36    &
             ,0.        &
             ,0.        &
             ,.1        &
             ,1.e-36    &
             ,1.e-36    &
             ,1.e-36    &
             ,.1        &
             ,1.        &
             ,1.e-36    &
             ,.1        &
             ,1.        &
             ,1.e-36    &
             ,.1        &
             ,.1        &
             ,.1        &
             ,.1        &
             ,1.e-36    &
             ,1.e-36    &
             ,.1        &
             ,1.e-36    &
             ,.1        &
             ,1.e-36    &
             ,.1        &
             ,.1        &
             ,1.e-36    &
             ,1.e-36    &
             ,1.e-36    &
             ,1.e-36    &
             ,.1        &
             ,1.e-36    &
             ,.1        &
             ,1.e-36    &
             ,.1        &
             ,.1        &
             ,.1        &
             ,1.e-36    &
             ,1.e-36    &  
             ,1.e-36    &  
             ,1.e-36    &  
             ,1.e-36    &
             ,.1        &
             ,.1        &
             ,.1        &
             ,1.e-36    &
            /

end module drydep_input_data_tables
