
      module mo_addpnt

      private
      public :: addpnt

      contains

      subroutine addpnt( x, y, ld, n, xnew, ynew )
!-----------------------------------------------------------------------------
!   purpose:
!   add a point <xnew,ynew> to a set of data pairs <x,y>.  x must be in
!   ascending order
!-----------------------------------------------------------------------------
!   parameters:
!   x    - real vector of length ld, x-coordinates                       (io)
!   y    - real vector of length ld, y-values                            (io)
!   ld   - integer, dimension of x, y exactly as declared in the calling  (i)
!          program
!   n    - integer, number of elements in x, y.  on entry, it must be:   (io)
!          n < ld.  on exit, n is incremented by 1.
!   xnew - real, x-coordinate at which point is to be added               (i)
!   ynew - real, y-value of point to be added                             (i)
!-----------------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)    :: ld
      integer, intent(inout) :: n
      real, intent(in)       :: xnew, ynew
      real, intent(inout)    :: x(ld)
      real, intent(inout)    :: y(ld)

!-----------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------
      integer :: insert
      integer :: i

!-----------------------------------------------------------------------------
! 	... check n < ld to make sure x will hold another point
!-----------------------------------------------------------------------------
      if( n >= ld ) then
         write(*,*) 'addpnt: cannot expand array; all elements used.'
         call endrun
      end if

      insert = 1
      i = 2

!-----------------------------------------------------------------------------
! 	... check, whether x is already sorted.
!           also, use this loop to find the point at which xnew needs to be inserted
!           into vector x, if x is sorted.
!-----------------------------------------------------------------------------
      do
         if( i < n ) then
            if( x(i) < x(i-1) ) then
               write(*,*) 'addpnt: x-data must be in ascending order!'
               call endrun
            else
               if( xnew > x(i) ) then
	          insert = i + 1
	       end if
            end if
            i = i + 1
	 else
	    exit
         end if
      end do

!-----------------------------------------------------------------------------
! 	... if <xnew,ynew> needs to be appended at the end, just do so,
!           otherwise, insert <xnew,ynew> at position insert
!-----------------------------------------------------------------------------
      if( xnew > x(n) ) then
         x(n+1) = xnew
         y(n+1) = ynew
      else
!-----------------------------------------------------------------------------
! 	... shift all existing points one index up
!-----------------------------------------------------------------------------
         do i = n,insert,-1
           x(i+1) = x(i)
           y(i+1) = y(i)
         end do
!-----------------------------------------------------------------------------
! 	... insert new point
!-----------------------------------------------------------------------------
         x(insert) = xnew
         y(insert) = ynew
      end if

!-----------------------------------------------------------------------------
! 	... increase total number of elements in x, y
!-----------------------------------------------------------------------------
      n = n + 1

      end subroutine addpnt

      end module mo_addpnt
