
      module mo_calcoe

      private
      public :: calcoe

      contains

      subroutine calcoe( c, xz, tt, adjin, adjcoe )
!-----------------------------------------------------------------------------
!   parameters:
!   adjcoe - real, coross section adjust coefficients (in and out)
!   c(5,28)-polynomal coef
!   tt     -nomarlized temperature
!-----------------------------------------------------------------------------*

      use mo_grid,   only : plevp

      implicit none

!-----------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------
      real, intent(in)    :: adjin
      real, intent(in)    :: tt
      real, intent(in)    :: c(5)
      real, intent(in)    :: xz(plevp)
      real, intent(inout) :: adjcoe(:)

!-----------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------
      integer :: k
      real    :: x

      do k = 1,plevp
	 x = xz(k)
         adjcoe(k) = adjin * (1. + .01*(c(1) + x*(c(2) + x*(c(3) + x*(c(4) + x*c(5))))))
      end do
        
      end subroutine calcoe

      end module mo_calcoe
