
      module mo_chemini

      private
      public :: chemini

      contains

      subroutine chemini( calday, plonl, platl, pplon, ncdate, &
                          ncsec, emis_timing, frc_timing, flbc_timing, sad_timing, &
                          dtime )
!-----------------------------------------------------------------------
! 	... Chemistry module intialization
!-----------------------------------------------------------------------

      use m_tracname,    only : tracnam
      use mo_setinv,     only : setinv_inti
      use mo_ub_vals,    only : ub_inti
      use mo_flbc,       only : flbc_inti
      use mo_surf,       only : surf_inti
      use mo_srfalb,     only : srfalb_inti
      use mo_solar_parms, only : solar_parms_init, get_solar_parms
      use woods,         only : woods_init, woods_set_etf
      use neckel,        only : neckel_init, neckel_scale_etf
      use mo_photo,      only : photo_inti
      use mo_chem_utls,  only : chem_utls_inti, has_drydep, get_spc_ndx
      use mo_srf_emis,   only : srf_emis_inti
      use mo_extfrc,     only : extfrc_inti
      use mo_sethet,     only : sethet_inti
      use mo_synoz,      only : synoz_inti
      use mo_tropopause, only : trop_inti
      use mo_setext,     only : setext_inti
      use mo_usrrxt,     only : usrrxt_inti
      use mo_grp_ratios, only : set_grp_ratios_inti
      use mo_sulf,       only : sulf_inti
      use mo_strato_sad, only : strato_sad_inti
      use mo_dust,       only : dust_inti
      use chem_mods,     only : grpcnt, clscnt1, clscnt4, clscnt5, phtcnt
      use mo_grid,       only : pcnstm1, plevp
      use mass_diags,    only : diags_inti
      use mo_control,    only : ubc_flsp, sulf_flsp, surf_flsp, emis_flsp
      use mo_control,    only : dust_flsp, use_dust, xactive_drydep, dvel_flsp
      use mo_control,    only : sad_flsp, xactive_prates
      use mo_exp_sol,    only : exp_slv_inti
      use mo_imp_sol,    only : imp_slv_inti
      use mo_rodas_sol,  only : rodas_slv_inti
      use m_types,       only : time_ramp, filespec

      implicit none

!-----------------------------------------------------------------------
! 	... dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) :: plonl, platl, pplon
      integer, intent(in) :: ncdate, ncsec
      integer, intent(in) :: dtime                             ! model time step (s)
      real, intent(in)    :: calday
      type(time_ramp), intent(in) :: emis_timing
      type(time_ramp), intent(in) :: frc_timing
      type(time_ramp), intent(in) :: flbc_timing
      type(time_ramp), intent(in) :: sad_timing

!-----------------------------------------------------------------------
! 	... local variables
!-----------------------------------------------------------------------
      real              ::   f107
      real              ::   f107a
      character(len=80) ::   lpath
      character(len=80) ::   mspath
      character(len=32) ::   filename
      character(len=30) ::   emires, surfres

!-----------------------------------------------------------------------
! 	... diagnostics initialization
!-----------------------------------------------------------------------
      call diags_inti( tracnam, plonl, platl, pplon )

!-----------------------------------------------------------------------
! 	... initialize invariant module
!-----------------------------------------------------------------------
      call setinv_inti

!-----------------------------------------------------------------------
!	... initialize solar etf
!-----------------------------------------------------------------------
      if( .not. xactive_prates ) then
         write(*,*) ' '
         write(*,*) 'chemini: before etf initialization'
         call solar_parms_init( ncdate, ncsec )
         call get_solar_parms( f107_s = f107, f107a_s = f107a )
         call woods_init
         call woods_set_etf( f107, f107a )
         call neckel_init
         call neckel_scale_etf( f107, f107a )
      end if

!-----------------------------------------------------------------------
! 	... initialize photorate module
!-----------------------------------------------------------------------
      if( phtcnt > 0 ) then
         call photo_inti( plonl, platl, pplon )
      end if

!-----------------------------------------------------------------------
! 	... initialize the chem utils module
!-----------------------------------------------------------------------
      call chem_utls_inti

!-----------------------------------------------------------------------
!       ... initialize the stratospheric ozone source
!-----------------------------------------------------------------------
      if( get_spc_ndx( 'SYNOZ' ) > 0 ) then
         call synoz_inti( plonl, platl, pplon )
      end if

!-----------------------------------------------------------------------
! 	... initialize dust module
!-----------------------------------------------------------------------
      if( use_dust ) then
         filename = dust_flsp%nl_filename
         lpath    = dust_flsp%local_path
         mspath   = dust_flsp%remote_path
         call dust_inti( plonl, platl, pplon, filename, lpath, mspath )
      end if

!-----------------------------------------------------------------------
! 	... initialize time-dependent surface flux datasets
!-----------------------------------------------------------------------
      call srf_emis_inti( plonl, platl, pplon, emis_timing, ncdate, ncsec )

!-----------------------------------------------------------------------
! 	... initialize time-dependent insitu forcing datasets
!-----------------------------------------------------------------------
      call extfrc_inti( plonl, platl, pplon, frc_timing, ncdate, ncsec )

!-----------------------------------------------------------------------
! 	... initialize the surface albedo module
!-----------------------------------------------------------------------
      filename = 'albedo_modis.nc'
      lpath    = surf_flsp%local_path
      mspath   = surf_flsp%remote_path
      call srfalb_inti( filename, lpath, mspath, plonl, platl, pplon )

!-----------------------------------------------------------------------
! 	... intialize the het rates module
!-----------------------------------------------------------------------
      call sethet_inti

!-----------------------------------------------------------------------
! 	... intialize the ext frcing module
!-----------------------------------------------------------------------
      call setext_inti

!-----------------------------------------------------------------------
! 	... intialize the rxt rate constant module
!-----------------------------------------------------------------------
      call usrrxt_inti

!-----------------------------------------------------------------------
! 	... intialize the grp ratios module
!-----------------------------------------------------------------------
      call set_grp_ratios_inti

!-----------------------------------------------------------------------
! 	... read time-dependent surface variables dataset
!-----------------------------------------------------------------------
      surfres = surf_flsp%hor_res
      if( surfres(1:1) /= '.' ) then
         surfres = '.' // surfres
      end if
      filename = 'surfdata' // trim(surfres) // '.nc'
      lpath    = surf_flsp%local_path
      mspath   = surf_flsp%remote_path
      call surf_inti( filename, lpath, mspath, plonl, platl, pplon )

!-----------------------------------------------------------------------
! 	... initialize the upper boundary module
!-----------------------------------------------------------------------
      filename = ubc_flsp%nl_filename
      lpath    = ubc_flsp%local_path
      mspath   = ubc_flsp%remote_path
      call ub_inti( platl, filename, lpath, mspath, dtime )

!-----------------------------------------------------------------------
! 	... initialize the tropopause
!-----------------------------------------------------------------------
      filename = 'clim_p_trop.nc'
      lpath    = ubc_flsp%local_path
      mspath   = ubc_flsp%remote_path
      call trop_inti( plonl, platl, pplon, filename, lpath, mspath )

!-----------------------------------------------------------------------
! 	... initialize the lbc module
!-----------------------------------------------------------------------
      call flbc_inti( plonl, platl, pplon, flbc_timing, ncdate, ncsec )

!-----------------------------------------------------------------------
! 	... read the troposheric sulfate dataset
!-----------------------------------------------------------------------
      filename = sulf_flsp%nl_filename
      lpath    = sulf_flsp%local_path
      mspath   = sulf_flsp%remote_path
      call sulf_inti( plonl, platl, pplon, filename, lpath, mspath )

!-----------------------------------------------------------------------
! 	... read the stratospheric sad dataset
!-----------------------------------------------------------------------
      filename = sad_flsp%nl_filename
      lpath    = sad_flsp%local_path
      mspath   = sad_flsp%remote_path
      call strato_sad_inti( plonl, platl, pplon, ncdate, ncsec, &
                            filename, lpath, mspath, sad_timing )

      if( clscnt1 > 0 ) then
!-----------------------------------------------------------------------
!	... initialize the explicit solver
!-----------------------------------------------------------------------
         call exp_slv_inti
      end if
      if( clscnt4 > 0 ) then
!-----------------------------------------------------------------------
!	... initialize the implicit solver
!-----------------------------------------------------------------------
         call imp_slv_inti
      end if
      if( clscnt5 > 0 ) then
!-----------------------------------------------------------------------
!	... initialize the rodas solver
!-----------------------------------------------------------------------
         call rodas_slv_inti
      end if

      end subroutine chemini

      end module mo_chemini
