
      module mo_exp_sol

      implicit none

      save

      private
      public :: exp_slv_inti, exp_sol

      integer, parameter ::  inst = 1, avrg = 2

      integer ::  o3s_ndx, o3inert_ndx
      integer ::  oh_ndx, ho2_ndx, c2h4_ndx, c3h6_ndx, isop_ndx
      integer ::  mvk_ndx, macr_ndx, c10h16_ndx, no2_ndx, n2o5_ndx
      integer ::  no3_ndx, ox_ndx
      integer ::  jo1d_ndx, ox_l1_ndx, o1d_n2_ndx, o1d_o2_ndx, ox_l2_ndx
      integer ::  ox_l3_ndx, ox_l4_ndx, ox_l5_ndx, ox_l6_ndx, ox_l7_ndx
      integer ::  ox_l8_ndx, ox_l9_ndx, usr4_ndx, usr16_ndx, usr17_ndx
      logical ::  o3s_loss
      logical ::  class_hist_prod = .false.
      logical ::  class_hist_loss = .false.

      contains

      subroutine exp_slv_inti
!-----------------------------------------------------------------------      
!	... initialize the explicit solver
!-----------------------------------------------------------------------      

      use chem_mods,    only : clscnt1, explicit
      use mo_grid,      only : pcnstm1
      use mo_histout,   only : hfile, moz_file_cnt
      use mo_chem_utls, only : get_spc_ndx, get_rxt_ndx
      use mo_control,   only : xactive_prates

      implicit none

!-----------------------------------------------------------------------      
!	... local variables
!-----------------------------------------------------------------------      
      integer :: m, file, timetype
      integer :: il, iu

      o3s_ndx     = get_spc_ndx( 'O3S' )
      o3inert_ndx = get_spc_ndx( 'O3INERT' )
      if( o3s_ndx > 0 ) then
         ox_ndx      = get_spc_ndx( 'OX' )
         if( ox_ndx < 1 ) then
            ox_ndx   = get_spc_ndx( 'O3' )
         end if
         oh_ndx      = get_spc_ndx( 'OH' )
         ho2_ndx     = get_spc_ndx( 'HO2' )
         c2h4_ndx    = get_spc_ndx( 'C2H4' )
         c3h6_ndx    = get_spc_ndx( 'C3H6' )
         isop_ndx    = get_spc_ndx( 'ISOP' )
         mvk_ndx     = get_spc_ndx( 'MVK' )
         macr_ndx    = get_spc_ndx( 'MACR' )
         c10h16_ndx  = get_spc_ndx( 'C10H16' )
         no2_ndx     = get_spc_ndx( 'NO2' )
         n2o5_ndx    = get_spc_ndx( 'N2O5' )
         no3_ndx     = get_spc_ndx( 'NO3' )

         if( xactive_prates ) then
            jo1d_ndx  = get_rxt_ndx( 'jo1d' )
         else
            jo1d_ndx  = get_rxt_ndx( 'jo3_a' )
         end if
         ox_l1_ndx = get_rxt_ndx( 'ox_l1' )
         ox_l2_ndx = get_rxt_ndx( 'ox_l2' )
         ox_l3_ndx = get_rxt_ndx( 'ox_l3' )
         ox_l4_ndx = get_rxt_ndx( 'ox_l4' )
         ox_l5_ndx = get_rxt_ndx( 'ox_l5' )
         ox_l6_ndx = get_rxt_ndx( 'ox_l6' )
         ox_l7_ndx = get_rxt_ndx( 'ox_l7' )
         ox_l8_ndx = get_rxt_ndx( 'ox_l8' )
         ox_l9_ndx = get_rxt_ndx( 'soa1' )
         if( ox_l9_ndx < 1 ) then
            ox_l9_ndx = get_rxt_ndx( 'ox_l9' )
         end if
         o1d_n2_ndx = get_rxt_ndx( 'o1d_n2' )
         o1d_o2_ndx = get_rxt_ndx( 'o1d_o2' )
         usr4_ndx   = get_rxt_ndx( 'usr4' )
         usr16_ndx  = get_rxt_ndx( 'usr16' )
         usr17_ndx  = get_rxt_ndx( 'usr17' )
      end if

!-----------------------------------------------------------------------      
!	... scan for class production to history file(s)
!-----------------------------------------------------------------------      
      do file = 1,moz_file_cnt
         do timetype = inst,avrg
            if( hfile(file)%histout_cnt(14,timetype) > 0 ) then
               il = hfile(file)%histout_ind(14,timetype)
               iu = il + hfile(file)%histout_cnt(14,timetype) - 1
               if( timetype == inst ) then
                  if( any( hfile(file)%inst_map(il:iu)/1000 == 1 ) ) then
                     class_hist_prod = .true.
                     exit
                  end if
               else if( timetype == avrg ) then
                  if( any( hfile(file)%timav_map(il:iu)/1000 == 1 ) ) then
                     class_hist_prod = .true.
                     exit
                  end if
               end if
            end if
         end do
         if( class_hist_prod ) then
            exit
         end if
      end do
!-----------------------------------------------------------------------      
!	... scan for class loss to history file(s)
!-----------------------------------------------------------------------      
      do file = 1,moz_file_cnt
         do timetype = inst,avrg
            if( hfile(file)%histout_cnt(15,timetype) > 0 ) then
               il = hfile(file)%histout_ind(15,timetype)
               iu = il + hfile(file)%histout_cnt(15,timetype) - 1
               if( timetype == inst ) then
                  if( any( hfile(file)%inst_map(il:iu)/1000 == 1 ) ) then
                     class_hist_loss = .true.
                     exit
                  end if
               else if( timetype == avrg ) then
                  if( any( hfile(file)%timav_map(il:iu)/1000 == 1 ) ) then
                     class_hist_loss = .true.
                     exit
                  end if
               end if
            end if
         end do
         if( class_hist_loss ) then
            exit
         end if
      end do

      end subroutine exp_slv_inti

      subroutine exp_sol( base_sol, reaction_rates, het_rates, extfrc, nstep, &
                          delt, hnm, pdel, lat, ip, &
                          plonl, plnplv )
!-----------------------------------------------------------------------
!      	... exp_sol advances the volumetric mixing ratio
!           forward one time step via the fully explicit
!           euler scheme
!           note : this code has o3inert and o3s as the last
!                  two class members;  neither has production
!                  or loss - some dimensionality below has been
!                  altered to acount for this
!-----------------------------------------------------------------------

      use chem_mods,        only : clscnt1, explicit, extcnt, hetcnt, rxntot
      use mo_indprd,        only : indprd
      use mo_exp_prod_loss, only : exp_prod_loss
      use mo_grid,          only : plev, pcnstm1
      use mo_histout,       only : outfld, hfile, moz_file_cnt
      use mo_lifetime,      only : lt_struct

      implicit none
!-----------------------------------------------------------------------
!     	... dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) ::  nstep                                 ! time step index
      integer, intent(in) ::  lat                                   ! latitude index
      integer, intent(in) ::  plonl                                 ! lon tile dim
      integer, intent(in) ::  plnplv                                ! plonl*plev
      integer, intent(in) ::  ip                                    ! longitude tile index
      real, intent(in)    ::  delt                                  ! time step in seconds
      real, intent(in)    ::  reaction_rates(plnplv,max(1,rxntot))
      real, intent(in)    ::  hnm(plnplv)                           ! atmospheric density (molec/cm^3)
      real, intent(in)    ::  pdel(plnplv)                          ! pressure delta about midpoints (Pa)
      real, intent(in)    ::  het_rates(plnplv,max(1,hetcnt))       ! washout rates (1/s)
      real, intent(in)    ::  extfrc(plnplv,max(1,extcnt))          ! "external" forcing (1/s)
      real, intent(inout) ::  base_sol(plnplv,pcnstm1)              ! species concentrations (mol/mol)

!-----------------------------------------------------------------------
!     	... local variables
!-----------------------------------------------------------------------
      integer  ::  k, l, m, n
      integer  ::  il, iu
      integer  ::  class
      integer  ::  file
      integer  ::  hndx
      integer  ::  base_ndx
      integer  ::  cls_ndx
      real     ::  timer 
      real, dimension(plnplv,max(1,clscnt1)) :: &
                   prod, &
                   loss, &
                   ind_prd
      real, dimension(plnplv) :: &
                   wrk
      real, dimension(plonl) :: &
                   lt_mass, lt_loss
      character(len=32) :: &
                   fldname

      if( explicit%indprd_cnt /= 0 .or. extcnt > 0 ) then
!-----------------------------------------------------------------------      
!        ... put "independent" production in the forcing
!-----------------------------------------------------------------------      
         call indprd( 1, ind_prd, base_sol, extfrc, reaction_rates )
      else
         do m = 1,max(1,clscnt1)
            ind_prd(:,m) = 0.
         end do
      end if
!-----------------------------------------------------------------------      
!      	... form f(y)
!-----------------------------------------------------------------------      
      call exp_prod_loss( prod, loss, base_sol, reaction_rates, het_rates )

!-----------------------------------------------------------------------      
!    	... solve for the mixing ratio at t(n+1)
!-----------------------------------------------------------------------      
      do m = 1,clscnt1
         l = explicit%clsmap(m)
         if( l /= o3s_ndx .and. l /= o3inert_ndx ) then
            base_sol(:,l) = base_sol(:,l) + delt * (prod(:,m) + ind_prd(:,m) - loss(:,m))
         else if( l == o3s_ndx ) then
!-----------------------------------------------------------------------      
!    	... special code for o3s
! nb: the coefficients for o3s loss from rxn with isop, mvk, macr, and c10h16
!     are unity. for the ox loss rate (in imp_sol) they are adjusted (downward)
!     to account for the regeneration of ox by these rxns. but here, we
!     consider this regenerated ox to be "tropospheric."  -- lwh 2/01
!     also include o3s loss from no2+oh, n2o5+aerosol, no3+aerosol
!-----------------------------------------------------------------------      
            do k = 1,plnplv
               loss(k,m) = &
                  reaction_rates(k,jo1d_ndx)*reaction_rates(k,ox_l1_ndx) &
                  /(reaction_rates(k,o1d_n2_ndx) + reaction_rates(k,o1d_o2_ndx) &
                    + reaction_rates(k,ox_l1_ndx)) &
                + reaction_rates(k,ox_l2_ndx)*base_sol(k,oh_ndx) &
                + reaction_rates(k,ox_l3_ndx)*base_sol(k,ho2_ndx) &
                + reaction_rates(k,ox_l6_ndx)*base_sol(k,c2h4_ndx) &
                + reaction_rates(k,ox_l4_ndx)*base_sol(k,c3h6_ndx) &
                + reaction_rates(k,ox_l5_ndx)*base_sol(k,isop_ndx) &
                + reaction_rates(k,ox_l7_ndx)*base_sol(k,mvk_ndx) &
                + reaction_rates(k,ox_l8_ndx)*base_sol(k,macr_ndx) &
                + reaction_rates(k,ox_l9_ndx)*base_sol(k,c10h16_ndx) &
                + ((reaction_rates(k,usr4_ndx)*base_sol(k,no2_ndx)*base_sol(k,oh_ndx) &
                   + 3.*reaction_rates(k,usr16_ndx)*base_sol(k,n2o5_ndx) &
                   + 2.*reaction_rates(k,usr17_ndx)*base_sol(k,no3_ndx)) &
                   / max( base_sol(k,ox_ndx), 1.e-20 ))
               base_sol(k,l) = base_sol(k,l)*exp( -delt*loss(k,m) )
               loss(k,m)     = loss(k,m)*base_sol(k,l)
            end do
         end if
      end do

!-----------------------------------------------------------------------      
!    	... check for explicit species production and loss output
!           first check instantaneous then time averaged
!-----------------------------------------------------------------------      
      if( class_hist_prod ) then
         do file = 1,moz_file_cnt
            if( hfile(file)%wrhstts .and. hfile(file)%histout_cnt(14,1) > 0 ) then
               do n = 1,hfile(file)%histout_cnt(14,1)
                  class = hfile(file)%inst_map(hfile(file)%histout_ind(14,1)+n-1)/1000
                  if( class == 1 ) then
                     cls_ndx = mod( hfile(file)%inst_map(hfile(file)%histout_ind(14,1)+n-1),1000 )
                     fldname = hfile(file)%hist_inst(hfile(file)%histout_ind(14,1)+n-1)
                     wrk(:)  = (prod(:,cls_ndx) + ind_prd(:,cls_ndx)) * hnm(:)
                     call outfld( fldname, wrk, plonl, ip, lat, file )
                  end if
               end do
            end if
            if( hfile(file)%histout_cnt(14,2) > 0 ) then
               do n = 1,hfile(file)%histout_cnt(14,2)
                  class = hfile(file)%timav_map(hfile(file)%histout_ind(14,2)+n-1)/1000
                  if( class == 1 ) then
                     cls_ndx = mod( hfile(file)%timav_map(hfile(file)%histout_ind(14,2)+n-1),1000 )
                     fldname = hfile(file)%hist_timav(hfile(file)%histout_ind(14,2)+n-1)
                     wrk(:) = (prod(:,cls_ndx) + ind_prd(:,cls_ndx)) * hnm(:)
                     call outfld( fldname, wrk, plonl, ip, lat, file )
                  end if
               end do
            end if
         end do
      end if
      if( class_hist_loss ) then
         do file = 1,moz_file_cnt
            if( hfile(file)%wrhstts .and. hfile(file)%histout_cnt(15,1) > 0 ) then
               do n = 1,hfile(file)%histout_cnt(15,1)
                  class = hfile(file)%inst_map(hfile(file)%histout_ind(15,1)+n-1)/1000
                  if( class == 1 ) then
                     cls_ndx = mod( hfile(file)%inst_map(hfile(file)%histout_ind(15,1)+n-1),1000 )
                     fldname = hfile(file)%hist_inst(hfile(file)%histout_ind(15,1)+n-1)
                     l       = explicit%clsmap(cls_ndx)
                     wrk(:)  = loss(:,cls_ndx) * hnm(:)
                     call outfld( fldname, wrk, plonl, ip, lat, file )
                  end if
               end do
            end if
            if( hfile(file)%histout_cnt(15,2) > 0 ) then
               do n = 1,hfile(file)%histout_cnt(15,2)
                  class = hfile(file)%timav_map(hfile(file)%histout_ind(15,2)+n-1)/1000
                  if( class == 1 ) then
                     cls_ndx = mod( hfile(file)%timav_map(hfile(file)%histout_ind(15,2)+n-1),1000 )
                     fldname = hfile(file)%hist_timav(hfile(file)%histout_ind(15,2)+n-1)
                     l       = explicit%clsmap(cls_ndx)
                     wrk(:)  = loss(:,cls_ndx) * hnm(:)
                     call outfld( fldname, wrk, plonl, ip, lat, file )
                  end if
               end do
            end if
         end do
      end if

!-----------------------------------------------------------------------      
!    	... check for explicit species lifetime output
!           first check instantaneous then time averaged
!-----------------------------------------------------------------------      
      do file = 1,moz_file_cnt
         if( hfile(file)%wrhstts .and. lt_struct(1,file)%cnt(1) > 0 ) then
            l = 0
            do n = 1,hfile(file)%histout_cnt(19,1)
               hndx  = hfile(file)%histout_ind(19,1)+n-1
               m     = hfile(file)%inst_map(hndx)
               if( m/1000 == 1 ) then
                  cls_ndx  = mod( m,1000 )
                  base_ndx = explicit%clsmap(cls_ndx)
                  lt_loss(:) = 0.
                  lt_mass(:) = 0.
                  do k = 1,plev
                     il = (k - 1)*plonl + 1
                     iu = il + plonl - 1
                     lt_mass(:) = lt_mass(:) + base_sol(il:iu,base_ndx)*pdel(il:iu)
                     lt_loss(:) = lt_loss(:) + loss(il:iu,cls_ndx)*pdel(il:iu)
                  end do
                  l = l + 1
                  lt_struct(1,file)%lt_mass_inst(:,lat,ip,l) = lt_mass(:)
                  lt_struct(1,file)%lt_loss_inst(:,lat,ip,l) = lt_loss(:)
               end if
            end do
         end if
         if( lt_struct(1,file)%cnt(2) > 0 ) then
            l = 0
            do n = 1,hfile(file)%histout_cnt(19,2)
               hndx  = hfile(file)%histout_ind(19,2)+n-1
               m     = hfile(file)%timav_map(hndx)
               if( m/1000 == 1 ) then
                  cls_ndx = mod( m,1000 )
                  base_ndx = explicit%clsmap(cls_ndx)
                  lt_loss(:) = 0.
                  lt_mass(:) = 0.
                  do k = 1,plev
                     il = (k - 1)*plonl + 1
                     iu = il + plonl - 1
                     lt_mass(:) = lt_mass(:) + base_sol(il:iu,base_ndx)*pdel(il:iu)
                     lt_loss(:) = lt_loss(:) + loss(il:iu,cls_ndx)*pdel(il:iu)
                  end do
                  l = l + 1
                  lt_struct(1,file)%lt_mass_avrg(:,lat,ip,l) = lt_mass(:)
                  lt_struct(1,file)%lt_loss_avrg(:,lat,ip,l) = lt_loss(:)
               end if
            end do
         end if
      end do

      end subroutine exp_sol

      end module mo_exp_sol
