
      module mo_grp_ratios

      private
      public :: set_grp_ratios_inti, set_grp_ratios

      save

      integer ::  ox_ndx, o3_ndx, o_ndx, o1d_ndx
      integer ::  jo1d_ndx, jo3p_ndx, usr1_ndx, o1d_n2_ndx, o1d_o2_ndx, ox_l1_ndx
      logical ::  do_ox_grp

      contains

      subroutine set_grp_ratios_inti
!-----------------------------------------------------------------
!        ... Initialize the grp ratios module
!-----------------------------------------------------------------

      use mo_chem_utls, only : get_spc_ndx, get_rxt_ndx, get_grp_mem_ndx
      use mo_control,   only : xactive_prates

      ox_ndx = get_spc_ndx( 'OX' )
      if( ox_ndx > 0 ) then
	 o3_ndx  = get_grp_mem_ndx( 'O3' )
	 o_ndx   = get_grp_mem_ndx( 'O' )
	 o1d_ndx = get_grp_mem_ndx( 'O1D' )
	 do_ox_grp = o3_ndx > 0 .and. o1d_ndx > 0 .and. o_ndx > 0
	 if( do_ox_grp ) then
            if( xactive_prates ) then
	       jo1d_ndx   = get_rxt_ndx( 'jo1d' )
	       jo3p_ndx   = get_rxt_ndx( 'jo3p' )
            else
	       jo1d_ndx   = get_rxt_ndx( 'jo3_a' )
	       jo3p_ndx   = get_rxt_ndx( 'jo3_b' )
            end if
	    usr1_ndx   = get_rxt_ndx( 'usr1' )
	    o1d_n2_ndx = get_rxt_ndx( 'o1d_n2' )
	    o1d_o2_ndx = get_rxt_ndx( 'o1d_o2' )
	    ox_l1_ndx  = get_rxt_ndx( 'ox_l1' )
	    do_ox_grp = jo1d_ndx > 0 .and. jo3p_ndx > 0 .and. &
			usr1_ndx > 0 .and. o1d_n2_ndx > 0 .and. o1d_o2_ndx > 0 &
			.and. ox_l1_ndx > 0
	 end if
      else
	 do_ox_grp = .false.
      end if

      write(*,*) ' '
      write(*,*) 'set_grp_ratios_inti: diagnostics'
      write(*,*)  ox_ndx, o3_ndx, o_ndx, o1d_ndx, &
                  jo1d_ndx, jo3p_ndx, usr1_ndx, o1d_n2_ndx, o1d_o2_ndx, ox_l1_ndx
      write(*,*) ' '

      end subroutine set_grp_ratios_inti

      subroutine set_grp_ratios( grp_ratios, rxt, vmr, mmr, nas, &
				 mbar, invariants, plonl )
!-----------------------------------------------------------------
!        ... Set the group member partitioning
!-----------------------------------------------------------------

      use chem_mods,    only : adv_mass, nadv_mass, nfs, grpcnt, rxntot
      use mo_grid,      only : plev, pcnstm1, pcnst
     
      implicit none

!-----------------------------------------------------------------
!        ... Dummy arguments
!-----------------------------------------------------------------
      integer, intent(in)  ::   plonl
      real, intent(out)    ::   grp_ratios(:,:,:)
      real, intent(in)     ::   rxt(:,:,:)
      real, intent(inout)  ::   vmr(plonl,plev,pcnstm1)
      real, intent(in)     ::   mmr(plonl,plev,pcnst)
      real, intent(in)     ::   nas(:,:,:)
      real, intent(in)     ::   invariants(:,:,:)
      real, intent(in)     ::   mbar(plonl,plev)

!-----------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------
      integer  ::  k
      real, dimension(plonl) :: &
                   a, b, &
                   grp_mass ! weighted group mass

      if( do_ox_grp ) then
         do k = 1,plev
            a(:) = rxt(:,k,jo3p_ndx) / rxt(:,k,usr1_ndx)
            b(:) = rxt(:,k,jo1d_ndx) &
		   / (rxt(:,k,o1d_n2_ndx) + rxt(:,k,o1d_o2_ndx) + rxt(:,k,ox_l1_ndx))
            grp_ratios(:,k,o3_ndx)  = 1. / (1. + a(:) + b(:))                  ! o3/ox    ratio
            grp_ratios(:,k,o1d_ndx) = b(:) * grp_ratios(:,k,o3_ndx)            ! o(1d)/ox ratio
            grp_ratios(:,k,o_ndx)   = a(:) * grp_ratios(:,k,o3_ndx)            ! o/ox     ratio
            grp_mass(:) = grp_ratios(:,k,o3_ndx)*nadv_mass(o3_ndx) &
                          + grp_ratios(:,k,o_ndx)*nadv_mass(o_ndx) &
                          + grp_ratios(:,k,o1d_ndx)*nadv_mass(o1d_ndx)
            vmr(:,k,ox_ndx) = mbar(:,k) * mmr(:plonl,k,ox_ndx) / grp_mass(:)
         end do
      end if

      end subroutine set_grp_ratios

      end module mo_grp_ratios
