
      module mo_lifetime

      use mo_grid, only : plev

      implicit none

      save

      integer, parameter :: inst = 1
      integer, parameter :: avrg = 2
!-----------------------------------------------------------------------------------
!	... history lifetime user type
!-----------------------------------------------------------------------------------
      type hst_lt
         integer       :: cnt(2)
         real, pointer :: lt_mass_inst(:,:,:,:)
         real, pointer :: lt_mass_avrg(:,:,:,:)
         real, pointer :: lt_loss_inst(:,:,:,:)
         real, pointer :: lt_loss_avrg(:,:,:,:)
      end type hst_lt

      type(hst_lt), allocatable :: lt_struct(:,:)

      contains

      subroutine lifetime_inti( plonl, platl, pplon )
!-----------------------------------------------------------------------------------
!	... initialize module
!-----------------------------------------------------------------------------------

      use mo_histout, only : hfile, moz_file_cnt

      implicit none

!-----------------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------------
      integer, intent(in) ::  plonl
      integer, intent(in) ::  platl
      integer, intent(in) ::  pplon

!-----------------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------------
      integer :: class
      integer :: il, iu
      integer :: m
      integer :: n
      integer :: file
      integer :: timetype
      integer :: astat

      if( moz_file_cnt > 0 ) then
         allocate( lt_struct(5,moz_file_cnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'lifetime_inti: failed to allocate lifetime user type; error = ',astat
            call endrun
         end if
         do file = 1,moz_file_cnt
            do class = 1,5
               lt_struct(class,file)%cnt(:) = 0
            end do
         end do
file_loop : &
         do file = 1,moz_file_cnt
tt_loop :   do timetype = inst,avrg
               if( hfile(file)%histout_cnt(19,timetype) > 0 ) then
                  il = hfile(file)%histout_ind(19,timetype)
                  iu = il + hfile(file)%histout_cnt(19,timetype) - 1
                  do m = il,iu
                     if( timetype == inst ) then
                        class = hfile(file)%inst_map(m)/1000
                     else if( timetype == avrg ) then
                        class = hfile(file)%timav_map(m)/1000
                     end if
                     lt_struct(class,file)%cnt(timetype) = lt_struct(class,file)%cnt(timetype) + 1
                  end do
               end if
            end do tt_loop
class_loop : &
            do class = 1,5
               do timetype = inst,avrg
                  n = lt_struct(class,file)%cnt(timetype)
                  if( n > 0 ) then
                     if( timetype == inst ) then
                        allocate( lt_struct(class,file)%lt_mass_inst(plonl,platl,pplon,n),stat=astat )
                     else
                        allocate( lt_struct(class,file)%lt_mass_avrg(plonl,platl,pplon,n),stat=astat )
                     end if
                     if( astat /= 0 ) then
                        write(*,*) 'lifetime_inti: failed to allocate mass struct variable; error = ',astat
                        call endrun
                     end if
                     if( class >= 4 ) then
                        if( timetype == inst ) then
                           lt_struct(class,file)%lt_mass_inst(:,:,:,:) = 0.
                        else
                           lt_struct(class,file)%lt_mass_avrg(:,:,:,:) = 0.
                        end if
                     end if
                     if( timetype == inst ) then
                        allocate( lt_struct(class,file)%lt_loss_inst(plonl,platl,pplon,n),stat=astat )
                     else
                        allocate( lt_struct(class,file)%lt_loss_avrg(plonl,platl,pplon,n),stat=astat )
                     end if
                     if( astat /= 0 ) then
                        write(*,*) 'lifetime_inti: failed to allocate loss struct variable; error = ',astat
                        call endrun
                     end if
                     if( class >= 4 ) then
                        if( timetype == inst ) then
                           lt_struct(class,file)%lt_loss_inst(:,:,:,:) = 0.
                        else
                           lt_struct(class,file)%lt_loss_avrg(:,:,:,:) = 0.
                        end if
                     end if
                  end if
               end do
            end do class_loop
         end do file_loop
         write(*,*) ' '
         write(*,*) 'lifetime_inti: diagnostics'
         do file = 1,moz_file_cnt
            do m = 1,5
               do timetype = inst,avrg
                  if( lt_struct(m,file)%cnt(timetype) /= 0 ) then
                     write(*,*) 'lifetime_inti: for class,file,type ',m,file,timetype,' cnt = ',lt_struct(m,file)%cnt(timetype)
                  end if
               end do
            end do
         end do
         write(*,*) ' '
      end if

      end subroutine lifetime_inti

      subroutine set_lifetime( plonl, platl, pplon )
!-----------------------------------------------------------------------------------
!	... set and output lifetimes
!-----------------------------------------------------------------------------------

      use mo_mpi
      use mo_histout,   only : hfile, moz_file_cnt
      use mo_histout,   only : outfld
      use mo_constants, only : latwts

      implicit none

!-----------------------------------------------------------------------------------
!	... dummy variables
!-----------------------------------------------------------------------------------
      integer, intent(in) :: plonl
      integer, intent(in) :: platl
      integer, intent(in) :: pplon

!-----------------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------------
      integer           :: l, n
      integer           :: ip
      integer           :: istat
      integer           :: j
      integer           :: lat
      integer           :: file
      integer           :: hndx
      integer           :: class
      integer           :: class_cnt(5)
      real              :: numer
      real              :: denom
      real              :: g_numer
      real              :: g_denom
      real              :: wrk(plonl)
      character(len=32) :: fldname

      do file = 1,moz_file_cnt
         class_cnt(:) = 0
         if( hfile(file)%wrhstts .and. hfile(file)%histout_cnt(19,1) > 0 ) then
            do n = 1,hfile(file)%histout_cnt(19,1)
               hndx    = hfile(file)%histout_ind(19,1)+n-1
               class   = hfile(file)%inst_map(hndx)/1000
               fldname = hfile(file)%hist_inst(hndx)
               class_cnt(class) = class_cnt(class) + 1
               numer = 0.
               denom = 0.
               l = class_cnt(class)
               do j = 1,platl
                  numer = numer + sum( lt_struct(class,file)%lt_mass_inst(:,j,:,l) ) * latwts(j+base_lat)
                  denom = denom + sum( lt_struct(class,file)%lt_loss_inst(:,j,:,l) ) * latwts(j+base_lat)
               end do
#ifdef USE_MPI
               call mpi_reduce( numer, g_numer, 1, mpi_double_precision, &
                                mpi_sum, 0, mpi_comm_comp, istat )
               if( istat /= mpi_success ) then
                  write(*,*) 'set_lifetime: mpi_reduce for numer failed; error = ',istat
                  call endrun
               end if
               call mpi_reduce( denom, g_denom, 1, mpi_double_precision, &
                                mpi_sum, 0, mpi_comm_comp, istat )
               if( istat /= mpi_success ) then
                  write(*,*) 'set_lifetime: mpi_reduce for denom failed; error = ',istat
                  call endrun
               end if
#else
               g_numer = numer
               g_denom = denom
#endif
               wrk(:) = g_numer/g_denom
               do lat = 1,platl
                  do ip = 1,pplon
                     call outfld( fldname, wrk, plonl, ip, lat, file )
                  end do
               end do
               if( class >= 4 ) then
                  lt_struct(4,file)%lt_mass_inst(:,:,:,l) = 0.
                  lt_struct(4,file)%lt_loss_inst(:,:,:,l) = 0.
               end if
            end do
         end if
         class_cnt(:) = 0
         if( hfile(file)%histout_cnt(19,2) > 0 ) then
            do n = 1,hfile(file)%histout_cnt(19,2)
               hndx    = hfile(file)%histout_ind(19,2)+n-1
               class   = hfile(file)%timav_map(hndx)/1000
               fldname = hfile(file)%hist_timav(hndx)
               class_cnt(class) = class_cnt(class) + 1
               numer = 0.
               denom = 0.
               l = class_cnt(class)
               do j = 1,platl
                  numer = numer + sum( lt_struct(class,file)%lt_mass_avrg(:,j,:,l) ) * latwts(j+base_lat)
                  denom = denom + sum( lt_struct(class,file)%lt_loss_avrg(:,j,:,l) ) * latwts(j+base_lat)
               end do
#ifdef USE_MPI
               call mpi_allreduce( numer, g_numer, 1, mpi_double_precision, &
                                mpi_sum, mpi_comm_comp, istat )
               if( istat /= mpi_success ) then
                  write(*,*) 'set_lifetime: mpi_reduce for numer failed; error = ',istat
                  call endrun
               end if
               call mpi_allreduce( denom, g_denom, 1, mpi_double_precision, &
                                mpi_sum, mpi_comm_comp, istat )
               if( istat /= mpi_success ) then
                  write(*,*) 'set_lifetime: mpi_reduce for denom failed; error = ',istat
                  call endrun
               end if
#else
               g_numer = numer
               g_denom = denom
#endif
               wrk(:) = g_numer/g_denom
               do lat = 1,platl
                  do ip = 1,pplon
                     call outfld( fldname, wrk, plonl, ip, lat, file )
                  end do
               end do
               if( class >= 4 ) then
                  lt_struct(4,file)%lt_mass_avrg(:,:,:,l) = 0.
                  lt_struct(4,file)%lt_loss_avrg(:,:,:,l) = 0.
               end if
            end do
         end if
      end do

      end subroutine set_lifetime

      end module mo_lifetime
