
      module mo_setinv

      implicit none

      save

      integer :: m_ndx, o2_ndx, n2_ndx, h2o_ndx, o3_ndx
      logical :: has_o2, has_n2, has_h2o, has_o3

      private
      public :: setinv_inti, setinv, has_h2o, o2_ndx, h2o_ndx

      contains

      subroutine setinv_inti
!-----------------------------------------------------------------
!        ... initialize the module
!-----------------------------------------------------------------

      use mo_chem_utls, only : get_inv_ndx

      implicit none

      m_ndx   = get_inv_ndx( 'M' )
      n2_ndx  = get_inv_ndx( 'N2' )
      o2_ndx  = get_inv_ndx( 'O2' )
      h2o_ndx = get_inv_ndx( 'H2O' )
      o3_ndx  = get_inv_ndx( 'O3' )

      has_n2  = n2_ndx > 0
      has_o2  = o2_ndx > 0
      has_h2o = h2o_ndx > 0
      has_o3  = o3_ndx > 0

      write(*,*) 'setinv_inti: m,n2,o2,h2o ndx = ',m_ndx,n2_ndx,o2_ndx,h2o_ndx

      end subroutine setinv_inti

      subroutine setinv( invariants, tfld, h2ovmr, pmid, plonl, &
                         lat, ip )
!-----------------------------------------------------------------
!        ... set the invariant densities (molecules/cm**3)
!-----------------------------------------------------------------
      
      use mo_grid,      only : plev
      use chem_mods,    only : nfs
      use mo_constants, only : boltz
      use mo_chem_utls, only : get_inv_ndx
      use mo_offline_constits, only: cnsts_offline, cnsts_names, mxconstitflds
      use mo_histout,   only : outfld, sim_file_cnt

      implicit none

!-----------------------------------------------------------------
!        ... dummy arguments
!-----------------------------------------------------------------
      integer, intent(in) ::    lat, ip
      integer, intent(in) ::    plonl
      real, intent(in)    ::      tfld(plonl,plev)           ! temperature
      real, intent(in)    ::      h2ovmr(plonl,plev)         ! water vapor vmr
      real, intent(in)    ::      pmid(plonl,plev)           ! pressure
      real, intent(out)   ::      invariants(plonl,plev,nfs) ! invariant array
      
!-----------------------------------------------------------------
!        .. local variables
!-----------------------------------------------------------------
      integer :: k, m
      integer :: file, ndx

!-----------------------------------------------------------------
!        note: invariants are in cgs density units.
!              the pmid array is in pascals and must be
!	       mutiplied by 10. to yield dynes/cm**2.
!-----------------------------------------------------------------

      invariants(:,:,:) = 0.
!-----------------------------------------------------------------
!	... set m, n2, o2, and h2o densities
!-----------------------------------------------------------------
      do k = 1,plev
         invariants(:,k,m_ndx) = 10. * pmid(:,k) / (boltz*tfld(:,k))
      end do
      if( has_n2 ) then
         do k = 1,plev
            invariants(:,k,n2_ndx) = .79 * invariants(:,k,m_ndx)
         end do
      end if
      if( has_o2 ) then
         do k = 1,plev
            invariants(:,k,o2_ndx) = .21 * invariants(:,k,m_ndx)
         end do
      end if
      if( has_h2o ) then
         do k = 1,plev
            invariants(:,k,h2o_ndx) = h2ovmr(:,k) * invariants(:,k,m_ndx)
         end do
      end if

!-----------------------------------------------------------------
!	... set namelist specified invariants
!-----------------------------------------------------------------
      do m = 1,mxconstitflds
         ndx =  get_inv_ndx( cnsts_names(m) )
         if( ndx > 0 ) then
            do k = 1,plev
               invariants(:,k,ndx) = cnsts_offline(:,k,lat,ip,m)*invariants(:,k,m_ndx)
            end do
            if( trim(cnsts_names(m)) == 'OH' ) then
               do file = 1,sim_file_cnt
                  call outfld( 'OFFL_OH', cnsts_offline(:,:,lat,ip,m), plonl, ip, lat, file )
                  call outfld( 'INV_OH',  invariants(:,:,ndx), plonl, ip, lat, file )
               end do
            end if
         end if
      end do

      end subroutine setinv

      end module mo_setinv
