
      module neckel

      use mo_mpi, only : masternode

      implicit none

      private
      public :: neckel_init
      public :: neckel_scale_etf
      public :: nw, we, etf

      save

      integer           :: nw
      real, allocatable :: we(:)
      real, allocatable :: base_etf(:)
      real, allocatable :: etf(:)

      contains

      subroutine neckel_init
!-------------------------------------------------------------
!	... initialize neckel module
!-------------------------------------------------------------

      use mo_file_utils,  only : open_netcdf_file
      use mo_control,     only : neckel_flsp
      use netcdf
      use mo_mpi

!-------------------------------------------------------------
!	... local variables
!-------------------------------------------------------------
      integer               :: wn
      integer               :: ncid
      integer               :: dimid, varid
      integer               :: funit
      integer               :: astat
      integer               :: istat, iret
      character(len=80)     :: err_msg

master_only : &
      if( masternode ) then
         ncid = open_netcdf_file( neckel_flsp%nl_filename, &
                                  neckel_flsp%local_path, &
                                  neckel_flsp%remote_path, masteronly=.true. )
!------------------------------------------------------------------------------
!       ... get dimensions
!------------------------------------------------------------------------------
         iret = nf_inq_dimid( ncid, 'nw', dimid )
         if( iret /= nf_noerr) then 
            write(*,*) 'neckel_init : failed to get nw id ; error = ',iret
            call endrun
         end if
         iret = nf_inq_dimlen( ncid, dimid, nw )
         if( iret /= nf_noerr) then 
	    write(*,*) 'neckel_init : failed to get nw ; error = ',iret
            call endrun
         end if
         allocate( we(nw+1), etf(nw), base_etf(nw), stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'neckel_init: failed to allocate wc ... base_etf; error = ',astat
            call endrun
         end if
         err_msg = 'neckel_init: failed to get we id'
         call handle_ncerr( nf_inq_varid( ncid, 'we', varid ), trim(err_msg) )
         err_msg = 'neckel_init: failed to read we'
         call handle_ncerr( nf_get_var_double( ncid, varid, we ), trim(err_msg) )
         err_msg = 'neckel_init: failed to get base_etf id'
         call handle_ncerr( nf_inq_varid( ncid, 'base_etf', varid ), trim(err_msg) )
         err_msg = 'neckel_init: failed to read base_etf'
         call handle_ncerr( nf_get_var_double( ncid, varid, base_etf ), trim(err_msg) )
         iret = nf_close( ncid )
      end if master_only
#ifdef USE_MPI
      call mpi_bcast( nw, 1, mpi_integer, 0, mpi_comm_comp, istat )
      if( istat /= 0 ) then
         write(*,*) 'neckel_init: failed to bcast nw; error = ',istat
         call endrun
      end if
      if( .not. masternode ) then
         allocate( we(nw+1), etf(nw), base_etf(nw), stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'neckel_init: failed to allocate wc ... base_etf; error = ',astat
            call endrun
         end if
      end if
      call mpi_bcast( we, nw+1, mpi_double_precision, 0, mpi_comm_comp, istat )
      if( istat /= 0 ) then
         write(*,*) 'neckel_init: failed to bcast we; error = ',istat
         call endrun
      end if
      call mpi_bcast( base_etf, nw, mpi_double_precision, 0, mpi_comm_comp, istat )
      if( istat /= 0 ) then
         write(*,*) 'neckel_init: failed to bcast sht_indexer; error = ',istat
         call endrun
      end if
#endif

#ifdef NECKEL_DIAGS
      if( masternode ) then
         write(*,*) ' '
         write(*,*) '========================================================='
         write(*,*) 'neckel_init: wn,we,base_etf'
         do wn = 1,nw
            write(*,'(i4,1p,2g15.7)') wn,we(wn),base_etf(wn)
         end do
         write(*,'(i4,1p,g15.7)') nw+1,we(nw+1)
         write(*,*) '========================================================='
         write(*,*) ' '
      end if
#endif
      
      end subroutine neckel_init

      subroutine neckel_scale_etf( f107, f107a )
!-------------------------------------------------------------
!	... adjust neckel with woods 350 nm value
!-------------------------------------------------------------

!-------------------------------------------------------------
!	... dummy arguments
!-------------------------------------------------------------
      real, intent(in) :: f107
      real, intent(in) :: f107a

!-------------------------------------------------------------
!	... local variables
!-------------------------------------------------------------
      real, parameter :: neckel_350 = 1.97811e14
      real, parameter :: f7min    = 71.
      real, parameter :: f7max    = 212.
      real, parameter :: f7deli   = 1./(f7max - f7min)
      real, parameter :: f7roti   = 1./73.
      real, parameter :: rt_min   = 2.0124e14
      real, parameter :: rt_27day = 1.
      real, parameter :: rt_11yr  = 1.001
      real, parameter :: ref_27day = rt_min * (rt_27day - 1.)
      real, parameter :: ref_11yr  = rt_min * (rt_11yr - 1.)

      integer  :: wn
      real     :: neckel_scale
      real     :: woods_etf

      woods_etf = rt_min + ref_27day * (f107 - f107a)*f7roti &
                         + ref_11yr * (f107a - f7min)*f7deli
      neckel_scale = woods_etf / neckel_350
      etf(:)       = neckel_scale * base_etf(:)

#ifdef NECKEL_DIAGS
      if( masterproc ) then
         write(*,*) '-----------------------------------------------'
         write(*,*) 'neckel_scale_etf: scale factor = ',neckel_scale
!        write(*,'(1p,5g15.7)') base_etf(:)
!        write(*,'(1p,5g15.7)') etf(:)
         write(*,*) '-----------------------------------------------'
      end if
#endif

      end subroutine neckel_scale_etf

      end module neckel
