
      module mo_rodas_sol

      use chem_mods, only : clscnt5

      implicit none

      private
      public :: rodas_slv_inti, rodas_sol

      save

      integer :: ox_ndx
      integer :: oh_ndx, ho2_ndx, ch3o2_ndx, po2_ndx, ch3co3_ndx, &
		 c2h5o2_ndx, isopo2_ndx, macro2_ndx, mco3_ndx, c3h7o2_ndx, &
		 ro2_ndx, xo2_ndx, no_ndx, no2_ndx, no3_ndx, n2o5_ndx, &
		 c2h4_ndx, c3h6_ndx, isop_ndx, mvk_ndx, c10h16_ndx, n_ndx
      real :: epsilon(max(1,clscnt5))
      real :: err_wghts(max(1,clscnt5))

      contains

      subroutine rodas_slv_inti
!-----------------------------------------------------------------------      
!	... initialize the implict solver
!-----------------------------------------------------------------------      

      use chem_mods,    only : rodas
      use mo_grid,      only : pcnstm1
      use mo_chem_utls, only : get_spc_ndx, get_rxt_ndx

      implicit none

!-----------------------------------------------------------------------      
!	... local variables
!-----------------------------------------------------------------------      
      real, parameter :: rel_err      = 1.e-2
      real, parameter :: high_rel_err = 1.e-3
      integer :: m
      real    :: eps(pcnstm1)
      real    :: wghts(pcnstm1)

      eps(:) = rel_err
      ox_ndx = get_spc_ndx( 'OX' )
      if( ox_ndx > 0 ) then
	 eps(ox_ndx) = high_rel_err
      else
         m = get_spc_ndx( 'O3' )
         if( m > 0 ) then
	    eps(m) = high_rel_err
         end if
      end if
      m = get_spc_ndx( 'NO' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if
      m = get_spc_ndx( 'NO2' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if
      m = get_spc_ndx( 'NO3' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if
      m = get_spc_ndx( 'HNO3' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if
      m = get_spc_ndx( 'HO2NO2' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if
      m = get_spc_ndx( 'N2O5' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if
      m = get_spc_ndx( 'OH' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if
      m = get_spc_ndx( 'HO2' )
      if( m > 0 ) then
	 eps(m) = high_rel_err
      end if

      wghts(:) = 1.
      n_ndx = get_spc_ndx( 'N' )
      if( n_ndx > 0 ) then
         wghts(n_ndx) = 0.
      end if
      do m = 1,rodas%clscnt
         epsilon(m)   = eps(rodas%clsmap(m))
         err_wghts(m) = wghts(rodas%clsmap(m))
      end do

      end subroutine rodas_slv_inti

      subroutine rodas_sol( base_sol, reaction_rates, het_rates, extfrc, nstep, &
                            delt, hnm, lat, ip, plonl, plnplv )
!-----------------------------------------------------------------------
!      	... rodas_sol advances the volumetric mixing ratio
!           forward one time step via the implicit runge-kutta rosenbrock scheme
!-----------------------------------------------------------------------

      use chem_mods,           only : rod_nzcnt, clscnt5, clsze, &
                                      rxntot, hetcnt, extcnt, rodas
      use mo_grid,             only : plev, pcnstm1
      use mo_indprd,           only : indprd
      use mo_rodas_prod_loss,  only : rodas_prod_loss
      use mo_rod_lin_matrix,   only : rod_linmat
      use mo_rod_nln_matrix,   only : rod_nlnmat
      use mo_rod_factor,       only : rod_lu_fac
      use mo_rod_solve,        only : rod_lu_slv

      implicit none

!-----------------------------------------------------------------------
!     	... dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) ::   nstep                     ! time step index (zero based)
      integer, intent(in) ::   lat, ip                   ! lat and longitude tile index
      integer, intent(in) ::   plonl                     ! longitude tile dimension
      integer, intent(in) ::   plnplv                    ! plonl*plev
      real, intent(in)    ::   delt                      ! time step (s)
      real, intent(in)    ::   reaction_rates(plnplv,rxntot), &
                               het_rates(plnplv,hetcnt), &
                               extfrc(plnplv,extcnt), &
                               hnm(plnplv)
      real, intent(inout) ::   base_sol(plnplv,pcnstm1)

      end subroutine rodas_sol

      end module mo_rodas_sol
