      module chem_mods
!--------------------------------------------------------------
! ... basic chemistry array parameters
!--------------------------------------------------------------
      use mo_grid, only : pcnstm1
      implicit none
      save
      integer, parameter :: hetcnt = 43, & ! number of heterogeneous processes
                            phtcnt = 37, & ! number of photo processes
                            rxntot = 200, & ! number of total reactions
                            gascnt = 163, & ! number of gas phase reactions
                            nfs = 4, & ! number of "fixed" species
                            relcnt = 0, & ! number of relationship species
                            grpcnt = 0, & ! number of group members
                            imp_nzcnt = 793, & ! number of non-zero implicit matrix entries
                            rod_nzcnt = 0, & ! number of non-zero rodas matrix entries
                            extcnt = 4, & ! number of species with external forcing
                            clscnt1 = 9, & ! number of species in explicit class
                            clscnt2 = 0, & ! number of species in hov class
                            clscnt3 = 0, & ! number of species in ebi class
                            clscnt4 = 88, & ! number of species in implicit class
                            clscnt5 = 0, & ! number of species in rodas class
                            indexm = 1, & ! index of total atm density in invariant array
                            ncol_abs = 2, & ! number of column densities
                            indexh2o = 4, & ! index of water vapor density
                            clsze = 1 ! loop length for implicit chemistry
      integer :: ngrp = 0
      integer :: drydep_cnt = 0
      integer :: srfems_cnt = 0
      integer :: rxt_tag_cnt = 0
      integer :: fbc_cnt(2) = 0
      integer, allocatable :: grp_mem_cnt(:)
      integer, allocatable :: rxt_tag_map(:)
      integer, allocatable :: rxt_rate_map(:,:)
      real :: adv_mass(pcnstm1)
      real :: nadv_mass(max(1,grpcnt))
      real, allocatable :: pht_alias_mult(:,:)
      character(len=16), allocatable :: rxt_tag_lst(:)
      character(len=16), allocatable :: pht_alias_lst(:,:)
      character(len=8), allocatable :: drydep_lst(:)
      character(len=8), allocatable :: srfems_lst(:)
      character(len=8), allocatable :: grp_lst(:)
      character(len=8), allocatable :: flbc_lst(:)
      character(len=16), allocatable :: flbc_alias_lst(:)
      character(len=8), allocatable :: fubc_lst(:)
      character(len=16), allocatable :: fubc_alias_lst(:)
      character(len=8) :: het_lst(max(1,hetcnt))
      character(len=8) :: extfrc_lst(max(1,extcnt))
      character(len=8) :: inv_lst(max(1,nfs))
      logical, allocatable :: megan_map(:)
      logical, allocatable :: xactive_srf_flx_map(:)
      logical :: frc_from_dataset(max(1,extcnt))
      logical :: inv_from_dataset(max(1,nfs))
      type solver_class
         integer :: clscnt
         integer :: lin_rxt_cnt
         integer :: nln_rxt_cnt
         integer :: indprd_cnt
         integer :: iter_max
         integer :: cls_rxt_cnt(4)
         integer, pointer :: permute(:)
         integer, pointer :: diag_map(:)
         integer, pointer :: clsmap(:)
      end type solver_class
      type(solver_class) :: explicit, implicit, rodas
      contains
      subroutine chem_mods_inti
!--------------------------------------------------------------
! ... intialize the class derived type
!--------------------------------------------------------------
      implicit none
      integer :: astat
      explicit%clscnt = 9
      explicit%indprd_cnt = 28
      implicit%clscnt = 88
      implicit%lin_rxt_cnt = 100
      implicit%nln_rxt_cnt = 139
      implicit%indprd_cnt = 2
      implicit%iter_max = 11
      rodas%clscnt = 0
      rodas%lin_rxt_cnt = 0
      rodas%nln_rxt_cnt = 0
      rodas%indprd_cnt = 0
      if( explicit%clscnt > 0 ) then
         allocate( explicit%clsmap(explicit%clscnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'chem_mods_inti: failed to allocate explicit%clsmap ; error = ',astat
            call endrun
         end if
         explicit%clsmap(:) = 0
      end if
      if( implicit%clscnt > 0 ) then
         allocate( implicit%permute(implicit%clscnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'chem_mods_inti: failed to allocate implicit%permute ; error = ',astat
            call endrun
         end if
         implicit%permute(:) = 0
         allocate( implicit%diag_map(implicit%clscnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'chem_mods_inti: failed to allocate implicit%diag_map ; error = ',astat
            call endrun
         end if
         implicit%diag_map(:) = 0
         allocate( implicit%clsmap(implicit%clscnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'chem_mods_inti: failed to allocate implicit%clsmap ; error = ',astat
            call endrun
         end if
         implicit%clsmap(:) = 0
      end if
      if( rodas%clscnt > 0 ) then
         allocate( rodas%permute(rodas%clscnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'chem_mods_inti: failed to allocate rodas%permute ; error = ',astat
            call endrun
         end if
         rodas%permute(:) = 0
         allocate( rodas%diag_map(rodas%clscnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'chem_mods_inti: failed to allocate rodas%diag_map ; error = ',astat
            call endrun
         end if
         rodas%diag_map(:) = 0
         allocate( rodas%clsmap(rodas%clscnt),stat=astat )
         if( astat /= 0 ) then
            write(*,*) 'chem_mods_inti: failed to allocate rodas%clsmap ; error = ',astat
            call endrun
         end if
         rodas%clsmap(:) = 0
      end if
      end subroutine chem_mods_inti
      end module chem_mods
