
      module mo_setrxt

      private
      public :: setrxt

      contains

      subroutine setrxt( rate, temp, m, plonl )

      use mo_grid,   only : plev, plnplv
      use chem_mods, only : rxntot
      use mo_jpl,    only : jpl

      implicit none

!-------------------------------------------------------
!       ... Dummy arguments
!-------------------------------------------------------
      integer, intent(in) :: plonl
      real, intent(in)    :: temp(plonl,plev), m(plonl,plev)
      real, intent(inout) :: rate(plonl,plev,rxntot)

!-------------------------------------------------------
!       ... Local variables
!-------------------------------------------------------
      real  ::  itemp(plonl,plev), exp_fac(plonl,plev)
      real, dimension(plonl,plev) :: ko, kinf

      rate(:,:,42) = 2.2e-10
      rate(:,:,43) = 1.1e-10
      rate(:,:,54) = 4.9e-11
      rate(:,:,55) = 6.7e-11
      rate(:,:,70) = 1.5e-10
      rate(:,:,77) = 9.e-12
      rate(:,:,83) = 1.e-14
      rate(:,:,88) = 2.e-13
      rate(:,:,89) = 6.8e-14
      rate(:,:,97) = 1e-12
      rate(:,:,98) = 4.e-14
      rate(:,:,101) = 1.e-11
      rate(:,:,102) = 1.1e-11
      rate(:,:,103) = 7.e-13
      rate(:,:,121) = 6.8e-13
      rate(:,:,124) = 3.e-12
      rate(:,:,125) = 5.4e-11
      rate(:,:,132) = 3.5e-12
      rate(:,:,139) = 2.4e-12
      rate(:,:,143) = 1.4e-11
      rate(:,:,146) = 2.4e-12
      rate(:,:,154) = 2.4e-12
      rate(:,:,157) = 1.4e-11
      rate(:,:,160) = 5.e-12
      rate(:,:,167) = 4.5e-11
      rate(:,:,171) = 2.4e-12
      rate(:,:,178) = 3.e-12
      rate(:,:,179) = 1.e-11
      rate(:,:,189) = 2.1e-6
      rate(:,:,193) = 7.1e-6
      rate(:,:,199) = 7.1e-6
      itemp(:,:) = 1. / temp(:,:)
      rate(:,:,39) = 8e-12 * exp( -2060. * itemp(:,:) )
      rate(:,:,40) = 2.1e-11 * exp( 115. * itemp(:,:) )
      rate(:,:,41) = 3.2e-11 * exp( 70. * itemp(:,:) )
      exp_fac(:,:) = exp( -2000. * itemp(:,:) )
      rate(:,:,44) = 5.5e-12 * exp_fac(:,:)
      rate(:,:,137) = 1.05e-14 * exp_fac(:,:)
      rate(:,:,45) = 2.2e-11 * exp( 120. * itemp(:,:) )
      exp_fac(:,:) = exp( 200. * itemp(:,:) )
      rate(:,:,46) = 3e-11 * exp_fac(:,:)
      rate(:,:,75) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,90) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,110) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,115) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,120) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,130) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,135) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,141) = 1.52e-11 * exp_fac(:,:)
      rate(:,:,158) = 2.3e-11 * exp_fac(:,:)
      rate(:,:,182) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,188) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,47) = 1.7e-12 * exp( -940. * itemp(:,:) )
      rate(:,:,48) = 1.e-14 * exp( -490. * itemp(:,:) )
      rate(:,:,50) = 2.9e-12 * exp( -160. * itemp(:,:) )
      exp_fac(:,:) = exp( 250. * itemp(:,:) )
      rate(:,:,51) = 4.8e-11 * exp_fac(:,:)
      rate(:,:,56) = 3.5e-12 * exp_fac(:,:)
      rate(:,:,52) = 4.2e-12 * exp( -240. * itemp(:,:) )
      rate(:,:,57) = 3e-12 * exp( -1500. * itemp(:,:) )
      exp_fac(:,:) = exp( 180. * itemp(:,:) )
      rate(:,:,58) = 5.6e-12 * exp_fac(:,:)
      rate(:,:,82) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,108) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,112) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,126) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,128) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,133) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,138) = 4.4e-12 * exp_fac(:,:)
      rate(:,:,180) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,186) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,59) = 1.2e-13 * exp( -2450. * itemp(:,:) )
      exp_fac(:,:) = exp( 170. * itemp(:,:) )
      rate(:,:,60) = 2.3e-12 * exp_fac(:,:)
      rate(:,:,65) = 1.5e-11 * exp_fac(:,:)
      rate(:,:,67) = 1.3e-12 * exp( 380. * itemp(:,:) )
      rate(:,:,69) = 2.45e-12 * exp( -1775. * itemp(:,:) )
      exp_fac(:,:) = exp( 300. * itemp(:,:) )
      rate(:,:,71) = 2.8e-12 * exp_fac(:,:)
      rate(:,:,117) = 2.9e-12 * exp_fac(:,:)
      rate(:,:,72) = 5.e-13 * exp( -424. * itemp(:,:) )
      rate(:,:,73) = 1.9e-14 * exp( 706. * itemp(:,:) )
      rate(:,:,74) = 4.1e-13 * exp( 750. * itemp(:,:) )
      rate(:,:,76) = 6.0e-13 * exp( -2058. * itemp(:,:) )
      rate(:,:,79) = 7.3e-12 * exp( -620. * itemp(:,:) )
      rate(:,:,81) = 1.2e-14 * exp( -2630. * itemp(:,:) )
      rate(:,:,84) = 1.6e11 * exp( -4150. * itemp(:,:) )
      rate(:,:,85) = 8.7e-12 * exp( -1070. * itemp(:,:) )
      rate(:,:,86) = 2.6e-12 * exp( 365. * itemp(:,:) )
      exp_fac(:,:) = exp( 700. * itemp(:,:) )
      rate(:,:,87) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,109) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,113) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,118) = 8.6e-13 * exp_fac(:,:)
      rate(:,:,129) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,134) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,140) = 8.e-13 * exp_fac(:,:)
      rate(:,:,147) = 8.e-13 * exp_fac(:,:)
      rate(:,:,155) = 8.e-13 * exp_fac(:,:)
      rate(:,:,172) = 8.e-13 * exp_fac(:,:)
      rate(:,:,181) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,187) = 7.5e-13 * exp_fac(:,:)
      exp_fac(:,:) = exp( 270. * itemp(:,:) )
      rate(:,:,91) = 5.6e-12 * exp_fac(:,:)
      rate(:,:,93) = 8.1e-12 * exp_fac(:,:)
      exp_fac(:,:) = exp( -1900. * itemp(:,:) )
      rate(:,:,92) = 1.4e-12 * exp_fac(:,:)
      rate(:,:,106) = 6.5e-15 * exp_fac(:,:)
      exp_fac(:,:) = exp( 1040. * itemp(:,:) )
      rate(:,:,95) = 4.3e-13 * exp_fac(:,:)
      rate(:,:,161) = 4.30e-13 * exp_fac(:,:)
      exp_fac(:,:) = exp( 500. * itemp(:,:) )
      rate(:,:,96) = 2.0e-12 * exp_fac(:,:)
      rate(:,:,100) = 2.5e-12 * exp_fac(:,:)
      rate(:,:,119) = 2.0e-12 * exp_fac(:,:)
      rate(:,:,162) = 2.0e-12 * exp_fac(:,:)
      rate(:,:,104) = 6.9e-12 * exp( -230. * itemp(:,:) )
      rate(:,:,107) = 4.6e-13 * exp( -1156. * itemp(:,:) )
      rate(:,:,111) = 1.0e-11 * exp( -660. * itemp(:,:) )
      rate(:,:,114) = 3.75e-13 * exp( -40. * itemp(:,:) )
      rate(:,:,122) = 8.4e-13 * exp( 830. * itemp(:,:) )
      exp_fac(:,:) = exp( -1860. * itemp(:,:) )
      rate(:,:,123) = 1.4e-12 * exp_fac(:,:)
      rate(:,:,168) = 1.4e-12 * exp_fac(:,:)
      rate(:,:,127) = 2.3e-12 * exp( -170. * itemp(:,:) )
      rate(:,:,136) = 2.54e-11 * exp( 410. * itemp(:,:) )
      exp_fac(:,:) = exp( 400. * itemp(:,:) )
      rate(:,:,142) = 5.e-13 * exp_fac(:,:)
      rate(:,:,156) = 5.e-13 * exp_fac(:,:)
      rate(:,:,173) = 5.e-13 * exp_fac(:,:)
      rate(:,:,144) = 3.03e-12 * exp( -446. * itemp(:,:) )
      exp_fac(:,:) = exp( 360. * itemp(:,:) )
      rate(:,:,145) = 2.7e-12 * exp_fac(:,:)
      rate(:,:,152) = 2.7e-12 * exp_fac(:,:)
      rate(:,:,153) = 1.3e-13 * exp_fac(:,:)
      rate(:,:,159) = 5.3e-12 * exp_fac(:,:)
      rate(:,:,170) = 2.7e-12 * exp_fac(:,:)
      rate(:,:,148) = 4.13e-12 * exp( 452. * itemp(:,:) )
      rate(:,:,149) = 7.52e-16 * exp( -1521. * itemp(:,:) )
      exp_fac(:,:) = exp( 175. * itemp(:,:) )
      rate(:,:,150) = 1.86e-11 * exp_fac(:,:)
      rate(:,:,169) = 1.86e-11 * exp_fac(:,:)
      rate(:,:,151) = 4.4e-15 * exp( -2500. * itemp(:,:) )
      exp_fac(:,:) = exp( 530. * itemp(:,:) )
      rate(:,:,163) = 4.6e-12 * exp_fac(:,:)
      rate(:,:,164) = 2.3e-12 * exp_fac(:,:)
      rate(:,:,174) = 1.3e-12 * exp( 640. * itemp(:,:) )
      rate(:,:,175) = 1.90e-12 * exp( 190. * itemp(:,:) )
      rate(:,:,177) = 1.7e-12 * exp( 352. * itemp(:,:) )
      rate(:,:,183) = 1.2e-11 * exp( 444. * itemp(:,:) )
      rate(:,:,184) = 1.e-15 * exp( -732. * itemp(:,:) )
      rate(:,:,185) = 1.2e-12 * exp( 490. * itemp(:,:) )
      rate(:,:,195) = 9.6e-12 * exp( -234. * itemp(:,:) )
      rate(:,:,197) = 1.9e-13 * exp( 520. * itemp(:,:) )
      rate(:,:,198) = 1.7e-12 * exp( -710. * itemp(:,:) )

      itemp(:,:) = 300. * itemp(:,:)

      ko(:,:) = 6.9e-31 * itemp(:,:)**1.
      kinf(:,:) = 2.6e-11
      call jpl( rate(1,1,53), m, .6, ko, kinf, plnplv )

      ko(:,:) = 2.e-30 * itemp(:,:)**4.4
      kinf(:,:) = 1.4e-12 * itemp(:,:)**.7
      call jpl( rate(1,1,61), m, .6, ko, kinf, plnplv )

      ko(:,:) = 2.0e-30 * itemp(:,:)**3.0
      kinf(:,:) = 2.5e-11
      call jpl( rate(1,1,63), m, .6, ko, kinf, plnplv )

      ko(:,:) = 1.8e-31 * itemp(:,:)**3.2
      kinf(:,:) = 4.7e-12 * itemp(:,:)**1.4
      call jpl( rate(1,1,66), m, .6, ko, kinf, plnplv )

      ko(:,:) = 1.e-28 * itemp(:,:)**.8
      kinf(:,:) = 8.8e-12
      call jpl( rate(1,1,80), m, .6, ko, kinf, plnplv )

      ko(:,:) = 8.5e-29 * itemp(:,:)**6.5
      kinf(:,:) = 1.1e-11 * itemp(:,:)
      call jpl( rate(1,1,94), m, .6, ko, kinf, plnplv )

      ko(:,:) = 8.e-27 * itemp(:,:)**3.5
      kinf(:,:) = 3.e-11
      call jpl( rate(1,1,105), m, .5, ko, kinf, plnplv )

      ko(:,:) = 8.e-27 * itemp(:,:)**3.5
      kinf(:,:) = 3.e-11
      call jpl( rate(1,1,131), m, .5, ko, kinf, plnplv )

      end subroutine setrxt

      end module mo_setrxt
