      
      subroutine MAK_GRP_VMR( grp_mem_cnt, mem2grp_map, arch_type, f90 )
!-------------------------------------------------------------------
!	... Write the group volume mixing ratios code
!-------------------------------------------------------------------

      use IO, only : temp_path

      implicit none

!-------------------------------------------------------------------
!	... Dummy args
!-------------------------------------------------------------------
      integer, intent(in) ::  grp_mem_cnt
      integer, intent(in) ::  mem2grp_map(*)
      logical, intent(in) ::  f90
      character(len=8), intent(in) :: arch_type

!-------------------------------------------------------------------
!	... Local variables
!-------------------------------------------------------------------
      integer, parameter :: max_len= 90
      integer  ::  m
      character(len=max_len) :: line
      logical  ::  lexist

      INQUIRE( file = trim( temp_path ) // 'mo_make_grp_vmr.F', exist = lexist )
      if( lexist ) then
	 call SYSTEM( 'rm ' // trim( temp_path ) // 'mo_make_grp_vmr.F' )
      end if
      OPEN( unit = 30, file = trim( temp_path ) // 'mo_make_grp_vmr.F' )

      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'module mo_make_grp_vmr'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'private'
      write(30,100) line(:len_trim(line))
      line(7:) = 'public :: mak_grp_vmr'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'contains'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'subroutine mak_grp_vmr( vmr, group_ratios, group_vmrs, plonl )'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'use mo_grid,   only : plev, pcnstm1'
      write(30,100) line(:len_trim(line))
      line(7:) = 'use chem_mods, only : grpcnt'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'implicit none '
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line = '!----------------------------------------------------------------------------'
      write(30,100) line(:len_trim(line))
      line = '!        ... Dummy arguments'
      write(30,100) line(:len_trim(line))
      line = '!----------------------------------------------------------------------------'
      write(30,100) line(:len_trim(line))
      line = '      integer, intent(in) :: plonl'
      write(30,100) line(:len_trim(line))
      line = '      real, intent(in)    :: vmr(plonl,plev,pcnstm1)'
      write(30,100) line(:len_trim(line))
      line = '      real, intent(in)    :: group_ratios(plonl,plev,grpcnt)'
      write(30,100) line(:len_trim(line))
      line = '      real, intent(out)   :: group_vmrs(plonl,plev,grpcnt)'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line = '!----------------------------------------------------------------------------'
      write(30,100) line(:len_trim(line))
      line = '!        ... Local variables'
      write(30,100) line(:len_trim(line))
      line = '!----------------------------------------------------------------------------'
      write(30,100) line(:len_trim(line))
      line = '      integer ::  k'
      write(30,100) line(:len_trim(line))
      if( grp_mem_cnt > 0 ) then
         line = ' '
         write(30,100) line(:len_trim(line))
         line(7:) = 'do k = 1,plev'
         write(30,100) line(:len_trim(line))
         do m = 1,grp_mem_cnt
	    line = ' '
	    line(10:) = 'group_vmrs(:,k,  ) = group_ratios(:,k,  )'
	    write(line(25:26),'(i2)') m
	    write(line(48:49),'(i2)') m
	    line(len_trim(line)+1:) = ' * vmr(:,k,'
	    write(line(len_trim(line)+1:),'(i2,'')'')') mem2grp_map(m)
            write(30,100) line(:len_trim(line))
         end do
         line = ' '
         line(7:) = 'end do'
         write(30,100) line(:len_trim(line))
      end if
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'end subroutine mak_grp_vmr'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'end module mo_make_grp_vmr'
      write(30,100) line(:len_trim(line))

      close( 30 )

100   format(a)

      end subroutine MAK_GRP_VMR
