
      module NLN_MATRIX

      use IO, only : temp_path

      implicit none

      character(len=4) :: hdr, up_hdr

      CONTAINS

      subroutine MAKE_NLN( clscnt, &
                           clsmap, &
                           cls_rxt_cnt, &
                           cls_rxt_map, &
                           pcoeff_ind, &
                           pcoeff, &
                           machine, &
			   permute, &
			   mat_map, &
			   class, &
			   lin_mat_pat, &
			   nzcnt, &
			   diag_map, &
			   f90 )
!-----------------------------------------------------------------------
!        ... Write the fortran code for the non-linear components
!	     of the Jacobian matrix
!-----------------------------------------------------------------------
     
      use VAR_MOD, only : var_lim
      use RXT_MOD, only : rxt_lim, prd_lim

      implicit none

!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) ::      clscnt, &                ! count of class members
				  class, &                 ! class index
				  nzcnt, &                 ! matrix non-zero count
                                  clsmap(var_lim,5,2), &
                                  cls_rxt_map(rxt_lim,prd_lim+3), &
                                  cls_rxt_cnt(4)           ! class rxtns count
      integer, intent(in) ::      permute(clscnt)
      integer, intent(in) ::      mat_map(clscnt,clscnt)
      integer, intent(in) ::      diag_map(:)
      integer, intent(in) ::      pcoeff_ind(*)            ! map for nonunity prod
      real, intent(in) ::         pcoeff(prd_lim,*)
      character(len=8), intent(in) ::  machine             ! target machine
      logical, intent(in) ::      f90                      ! Fortran 90
      logical, intent(in) ::      lin_mat_pat(:)
      
!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer, parameter :: max_len   = 90
      integer, parameter :: max_lines = 200
      integer  ::   i, j, k, l, m, m2, n, r1, r2
      integer  ::   length, index, pindx, mat_ind
      integer  ::   row, col, sub_cnt
      integer  ::   line_pos, buf_pos, rxno, target, line_cnt
      integer  ::   spos
      integer  ::   base
      integer  ::   species
      integer  ::   match_cnt
      integer  ::   list_cnt
      integer  ::   rxtnt_cnt, rxtnt1, rxtnt2
      integer  ::   other_ind
      integer  ::   match_ind(rxt_lim)
      integer  ::   rxt_match_ind(rxt_lim)
      integer  ::   scan(rxt_lim,4)
      integer  ::   rxtnt(2)
      real     ::   rate
      character(len=max_len+10) :: line
      character(len=max_len) :: buff
      character(len= 32) :: sub_name
      character(len= 16) :: rate_con
      character(len= 6) :: mat_piece, rxt_piece
      character(len= 4) :: sol_piece, num, num1
      logical  ::  beg_line
      logical  ::  lexist
      logical, allocatable  ::  nln_mat_pat(:)

      ALLOCATE( nln_mat_pat(nzcnt),stat=pindx )
      if( pindx /= 0 ) then
	 stop
      end if
      nln_mat_pat(:) = .false.
      
      if( class == 4 ) then
         sub_name = 'imp_nln_matrix.F'
	 up_hdr = 'imp_'
	 hdr    = 'imp_'
      else
         sub_name = 'rod_nln_matrix.F'
	 up_hdr = 'rod_'
	 hdr    = 'rod_'
      end if

      inquire( file = trim( temp_path ) // trim( sub_name ), exist = lexist )
      if( lexist ) then
         call system( 'rm ' // trim( temp_path ) // trim( sub_name ) )
      end if
      open( unit = 30, file = trim( temp_path ) // trim( sub_name ) )

      line_cnt = 0
      line = ' '
      write(30,100) trim(line)
      line = '      module mo_' // up_hdr // 'nln_matrix'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '      contains'
      write(30,100) trim(line)
      if( clscnt == 0 .or. cls_rxt_cnt(3) == 0 ) then
	 sub_cnt = 0
      else
	 sub_cnt = 1
      end if
      call MAKE_NLN_HDR( sub_cnt, machine )

      select case ( machine )
         case( 'INTEL' )
	    mat_piece = 'mat('
	    rxt_piece = 'rxt('
	    sol_piece = 'y('
	 case default
	    mat_piece = 'mat(k,'
	    rxt_piece = 'rxt(k,'
	    sol_piece = 'y(k,'
      end select

      base = SUM( cls_rxt_cnt(:2) )
Species_loop : &
      do species = 1,clscnt
         target = clsmap(species,class,2)
	 line   = ' '
!-----------------------------------------------------------------------
!       ... Write code for nonlinear loss entries
!-----------------------------------------------------------------------
         match_cnt = 0
         do k = base+1,base+cls_rxt_cnt(3)
!-----------------------------------------------------------------------
!       ... Find all reactions with target reactant
!-----------------------------------------------------------------------
            other_ind = 0
            do l = 2,3
               if( cls_rxt_map(k,l) == target ) then
                  if( other_ind == 0 ) then
                     match_cnt = match_cnt + 1
                     scan(match_cnt,1) = k
                     if( l == 2 ) then
                        scan(match_cnt,2) = ABS(cls_rxt_map(k,3))
                     else
                        scan(match_cnt,2) = ABS(cls_rxt_map(k,2))
                     end if
                     scan(match_cnt,4) = l
                  end if
                  other_ind = other_ind + 1
               end if
            end do
         end do
!-----------------------------------------------------------------------
!       ... Write the diagonal loss entry
!-----------------------------------------------------------------------
         if( match_cnt > 0 ) then
            scan(:match_cnt,3) = scan(:match_cnt,2)
	    pindx = permute(species)
	    mat_ind = mat_map(pindx,pindx)
            write(num,'(i4)') mat_map(pindx,pindx)
	    num = ADJUSTL( num )
	    n = LEN_trim( num )
            line = ' '
            line(10:) = trim( mat_piece ) // num(:n) // ') = -('
            line_pos = LEN_trim( line ) + 1
            beg_line = .true.
         end if
         list_cnt = match_cnt
         do while( list_cnt > 0 )
            do j = 1,match_cnt
               if( scan(j,2) /= 0 ) then
                  index = scan(j,2)
                  exit
               end if
            end do
            m = 0
            do j = 1,match_cnt
               if( scan(j,2) == index ) then
                  m = m + 1
                  match_ind(m) = j
                  scan(j,2)    = 0
                  list_cnt = list_cnt - 1
               end if
            end do
            do j = 1,m
               l = match_ind(j)
               rxno = cls_rxt_map(scan(l,1),1)
               buff = ' '
	       buf_pos = 1
               if( j == 1 .and. m > 1 ) then
                  if( scan(l,3) == target ) then
                     buff(buf_pos:) =  '(4.*'
                  else
                     buff(buf_pos:) =  '('
                  end if
               else if( scan(l,3) == target ) then
                  buff(buf_pos:) =  '4.*'
               end if
               write(num,'(i4)') rxno
	       num = ADJUSTL( num )
	       n = LEN_trim( num )
               buff(LEN_trim(buff)+1:) = trim( rxt_piece ) // num(:n) // ')'
               length = LEN_trim(buff)
               if( (line_pos + length) <= max_len-3 ) then
                  if( beg_line ) then
                     line(line_pos:) = buff(:length)
                     beg_line = .false.
                  else
                     line(line_pos:) = ' + ' // buff(:length)
                  end if
               else
	          line(LEN_trim(line)+1:) = ' &'
                  write(30,100) trim(line)
		  line_cnt = line_cnt + 1
                  line = ' '
                  line(23:) = '+ ' // buff(:length)
               end if
               line_pos = LEN_trim( line ) + 1
            end do
            write(num,'(i4)') scan(l,3)
	    num = ADJUSTL( num )
            if( m > 1 ) then
               buff = ') * ' // trim( sol_piece ) // num(:LEN_trim(num)) // ')'
            else
               buff = '*' // trim( sol_piece ) // num(:LEN_trim(num)) // ')'
            end if
            length = LEN_trim(buff)
            if( (line_pos + length) <= max_len-3 ) then
               line(line_pos:) = buff(:length)
            else
	       line(LEN_trim(line)+1:) = ' &'
               write(30,100) trim(line)
	       line_cnt = line_cnt + 1
               line = ' '
               line(23:) = buff(:length)
            end if
            line_pos = LEN_trim( line ) + 1
	    nln_mat_pat(mat_ind) = .true.
         end do
	 if( match_cnt /= 0 ) then
	    line(LEN_trim(line)+1:) = ')'
	 end if
	 if( line /= ' ' ) then
            write(30,100) trim(line)
            line_cnt = line_cnt + 1
	 end if
         
!-----------------------------------------------------------------------
!       ... Write nondiagonal loss entries
!-----------------------------------------------------------------------
         list_cnt = match_cnt
         do j = 1,match_cnt
            if( scan(j,3) == target ) then
               scan(j,2) = 0
               list_cnt = list_cnt - 1
            else
               scan(j,2) = scan(j,3)
            end if
         end do
         do while( list_cnt > 0 )
            do j = 1,match_cnt
               if( scan(j,2) /= 0 ) then
                  index = scan(j,2)
                  exit
               end if
            end do
            m = 0
            do j = 1,match_cnt
               if( scan(j,2) == index ) then
                  m = m + 1
                  match_ind(m) = j
                  scan(j,2)    = 0
                  list_cnt = list_cnt - 1
               end if
            end do
	    pindx = permute(clsmap(index,class,1))
            mat_ind = mat_map(permute(species),pindx)
            write(num,'(i4)') mat_map(permute(species),pindx)
	    num = ADJUSTL( num )
	    n = LEN_trim( num )
            line = ' '
            line(10:) = trim( mat_piece ) // num(:n) // ') = -'
            line_pos = LEN_trim( line ) + 1
            if( m > 0 ) then
               beg_line = .true.
	       nln_mat_pat(mat_ind) = .true.
            else
               line(line_pos:) = '0.'
            end if
            do j = 1,m
               l = match_ind(j)
               rxno = cls_rxt_map(scan(l,1),1)
               buff = ' '
               if( j == 1 .and. m > 1 ) then
                  buff =  '('
                  buf_pos = 2
               else
                  buf_pos = 1
               end if
               write(num,'(i4)') rxno
	       num = ADJUSTL( num )
	       n = LEN_trim( num )
               buff(buf_pos:) = trim( rxt_piece ) // num(:n) // ')'
               if( j == 1 ) then
                  if ( scan(l,4) == 2 ) then
                     index = 3
                  else
                     index = 2
                  end if
               end if
               length = LEN_trim(buff)
               if( (line_pos + length) <= max_len-3 ) then
                  if( beg_line ) then
                     line(line_pos:) = buff(:length)
                     beg_line = .false.
                  else
                     line(line_pos:) = ' + ' // buff(:length)
                  end if
               else
	          line(LEN_trim(line)+1:) = ' &'
                  write(30,100) trim(line)
		  line_cnt = line_cnt + 1
                  line = ' '
                  line(23:) = '+ ' // buff(:length)
               end if
               line_pos = LEN_trim( line ) + 1
            end do
            write(num,'(i4)') target
	    num = ADJUSTL( num )
            if( m > 1 ) then
               buff = ') * '// trim( sol_piece ) // num(:LEN_trim(num)) // ')'
            else
               buff = '*' // trim( sol_piece ) // num(:LEN_trim(num)) // ')'
            end if
            length = LEN_trim(buff)
            if( (line_pos + length) <= max_len-3 ) then
               line(line_pos:) = buff(:length)
            else
	       line(LEN_trim(line)+1:) = ' &'
               write(30,100) trim(line)
	       line_cnt = line_cnt + 1
               line = ' '
               line(23:) = buff(:length)
            end if
            write(30,100) trim(line)
            line_cnt = line_cnt + 1
         end do               
         line = ' '
         write(30,100) trim(line)

!-----------------------------------------------------------------------
!       ... Scan for production matches
!-----------------------------------------------------------------------
         match_cnt = 0
Product_match : &
         do k = base+1,base+cls_rxt_cnt(3)
            other_ind = 0
            do l = 4,prd_lim+3
               if( cls_rxt_map(k,l) == species ) then
                  if( other_ind == 0 ) then
                     match_cnt = match_cnt + 1
                     scan(match_cnt,1) = k
                     scan(match_cnt,2) = ABS(cls_rxt_map(k,2))
                     scan(match_cnt,4) = ABS(cls_rxt_map(k,3))
                  end if
                  other_ind = other_ind + 1
               end if
            end do
            if( other_ind /= 0 ) then
               scan(match_cnt,3) = other_ind
            end if
         end do Product_match
	 if( match_cnt == 0 ) then
	    cycle
	 end if
!-----------------------------------------------------------------------
!       ... "Order" the match list reactants
!-----------------------------------------------------------------------
         do j = 1,match_cnt
            if( scan(j,2) > scan(j,4) ) then
               l = scan(j,2)
               scan(j,2) = scan(j,4)
               scan(j,4) = l
            end if
         end do
!-----------------------------------------------------------------------
!       ... Search matching reactions for reactant match
!-----------------------------------------------------------------------
Reactant_match : &
         do r1 = 1,clscnt
	    m = 0
	    rxtnt1 = clsmap(r1,class,2)
            do j = 1,match_cnt
               if( scan(j,2) == rxtnt1 .or. scan(j,4) == rxtnt1 ) then
                  m = m + 1
                  match_ind(m) = j
               end if
	    end do
	    if( m == 0 ) then
	       cycle
	    end if
	    pindx   = permute(clsmap(rxtnt1,class,1))
            mat_ind = mat_map(permute(species),pindx)
            write(num,'(i4)') mat_ind
	    num = ADJUSTL( num )
            line      = ' '
            line(10:) = trim( mat_piece ) // num(:LEN_trim(num)) // ') ='
            beg_line  = .true.
	    if( nln_mat_pat(mat_ind) ) then
	       line_pos        = LEN_trim(line) + 2
               line(line_pos:) = trim( mat_piece ) // num(:LEN_trim(num)) // ')'
               beg_line        = .false.
	    end if
            nln_mat_pat(mat_ind) = .true.
Second_reactant_match : &
            do r2 = 1,clscnt
	       m2 = 0
	       rxtnt2 = clsmap(r2,class,2)
               do n = 1,m
	          j = match_ind(n)
		  if( rxtnt2 /= rxtnt1 ) then
                     if( scan(j,2) == rxtnt2 .or. scan(j,4) == rxtnt2 ) then
                        m2 = m2 + 1
                        rxt_match_ind(m2) = j
                     end if
		  else if( scan(j,2) == rxtnt2 .and. scan(j,4) == rxtnt2 ) then
                     m2 = m2 + 1
                     rxt_match_ind(m2) = j
                  end if
	       end do
	       if( m2 == 0 ) then
	          cycle
	       end if
	       if( .not. beg_line ) then
		  line(LEN_trim(line)+2:) = '+'
	       else
		  beg_line = .false.
	       end if
	       if( m2 > 1 ) then
	          line(LEN_trim(line)+2:) = '('
                  line_pos = LEN_trim( line ) + 1
	       else
                  line_pos = LEN_trim( line ) + 2
	       end if
Rates_loop : &
               do n = 1,m2
!-----------------------------------------------------------------------
!       ... The reaction rate
!-----------------------------------------------------------------------
                  l        = rxt_match_ind(n)
                  rxno     = cls_rxt_map(scan(l,1),1)
                  index    = pcoeff_ind(rxno)
                  rate     = 0.
                  if( index /= 0 ) then
                     do i = 4,prd_lim+3
                        if( cls_rxt_map(scan(l,1),i) == species ) then
                           rate = rate + pcoeff(i-3,index)
                        end if
                     end do
                  else if( scan(l,3) /= 1 ) then
                     rate = REAL(scan(l,3))
                  end if
                  if( rxtnt1 == rxtnt2 ) then
                     if( rate == 0. ) then
                        rate = 2.
                     else
                        rate = 2.*rate
                     end if
                  end if
                  buff = ' '
		  if( n > 1 .and. m2 > 1 ) then
                     buff = '+'
		  end if
                  if( rate /= 0. .and. rate /= 1. ) then
                     spos = len_trim(buff)+1
                     call R2C( rate_con, abs(rate), 'l' )
                     if( rate < 0. ) then
                        buff(spos:spos+1) = '(-'
                        spos = spos + 2
                     end if
                     buff(spos:) = trim(rate_con)
                     if( rate < 0. ) then
                        spos = len_trim(buff)+1
                        buff(spos:) = ')'
                     end if
!                    call R2C( buff(LEN_trim(buff)+1:), rate, 'l' )
                     buff(LEN_trim(buff)+1:) = '*'
                  end if
                  write(num,'(i4)') rxno
	          num = ADJUSTL( num )
                  buff(LEN_trim(buff)+1:) = trim( rxt_piece ) // num(:LEN_trim(num)) // ')'
                  length = LEN_trim(buff)
                  if( (line_pos + length) <= max_len-3 ) then
                     line(line_pos:) = buff(:length)
                  else
	             if( line(LEN_trim(line):LEN_trim(line)) /= '+' ) then
	                line(LEN_trim(line)+1:) = ' &'
		     else
	                line(LEN_trim(line):) = ' &'
		     end if
                     write(30,100) trim(line)
		     line_cnt  = line_cnt + 1
                     line      = ' '
		     if( buff(1:1) /= '+' ) then
                        line(23:) = '+ ' // buff(:length)
		     else
                        line(23:) = ' ' // buff(:length)
		     end if
!                    line(23:) = '+ ' // buff(:length)
                  end if
                  line_pos = LEN_trim( line ) + 1
               end do Rates_loop
!-----------------------------------------------------------------------
!       ... The reactant
!-----------------------------------------------------------------------
	       if( m2 > 1 ) then
	          line(LEN_trim(line)+1:) = ')'
                  line_pos = LEN_trim( line ) + 1
	       end if
               write(num,'(i4)') rxtnt2
	       num    = ADJUSTL( num )
               buff   = '*' // trim( sol_piece ) // num(:LEN_trim(num)) // ')'
               length = LEN_trim(buff)
               if( (line_pos + length) <= max_len-3 ) then
                  line(line_pos:) = buff(:length)
               else
	          line(LEN_trim(line)+1:) = ' &'
                  write(30,100) trim(line)
	          line_cnt  = line_cnt + 1
                  line      = ' '
                  line(23:) = buff(:length)
               end if
            end do Second_Reactant_match
            write(30,100) trim(line)
	    line_cnt  = line_cnt + 1
         end do Reactant_match
         line = ' '
         write(30,100) trim(line)
	 if( line_cnt > max_lines ) then
            if( machine /= 'INTEL' ) then
               line = '      end do'
               write(30,100) trim(line)
            end if
            line = ' '
            write(30,100) trim(line)
            write(num,'(i3)') 100+sub_cnt
            write(line,'(''      end subroutine '',a,''nlnmat'',a)') up_hdr,num(2:3)
            write(30,100) trim(line)
	    line_cnt = 0
	    if( species /= clscnt ) then
	       sub_cnt  = sub_cnt + 1
               call MAKE_NLN_HDR( sub_cnt, machine )
	    end if
	 end if
      end do Species_loop

      if( line_cnt /= 0 ) then
         if( machine /= 'INTEL' ) then
            line = '      end do'
            write(30,100) trim(line)
         end if

         line = ' '
         write(30,100) trim(line)
         write(num,'(i3)') 100+sub_cnt
         write(line,'(''      end subroutine '',a,''nlnmat'',a)') up_hdr,num(2:3)
         write(30,100) trim(line)
      end if
!-----------------------------------------------------------------------
!	... Make the inclusion routine
!-----------------------------------------------------------------------
      if( clscnt > 0 ) then
	 if( cls_rxt_cnt(3) == 0 ) then
	    select case( machine )
	       case ( 'NEC', 'FUJITSU' )
                  write(line,'(''      call '',a,''nlnmat_finit( ofl, ofu, mat, lmat, dti )'')') up_hdr
	       case default
                  write(line,'(''      call '',a,''nlnmat_finit( mat, lmat, dti )'')') up_hdr
	    end select
            write(30,100) trim(line)
            line = ' '
            write(30,100) trim(line)
            line = '      end subroutine ' // up_hdr // 'nlnmat'
            write(30,100) trim(line)
	 end if
         call MAKE_NLN_HDR( -1, machine )
         line = ' '
	 do n = 1,SIZE(lin_mat_pat)
	    if( lin_mat_pat(n) ) then
               write(num,'(i4)') n
	       m = LEN_trim( num )
	       if( nln_mat_pat(n) ) then
                  line(10:) = trim( mat_piece ) // num(:m) // ') = ' // trim(mat_piece) // num(:m) // ') + l' &
			      // trim(mat_piece) // num(:m) // ')'
               else
                  line(10:) = trim( mat_piece ) // num(:m) // ') = l' // trim(mat_piece) // num(:m) // ')'
	       end if
               write(30,100) trim(line)
	    end if
	 end do
         line = ' '
	 do n = 1,SIZE(lin_mat_pat)
	    if( .not. lin_mat_pat(n) .and. .not. nln_mat_pat(n) ) then
               write(num,'(i4)') n
	       m = LEN_trim( num )
               line(10:) = trim( mat_piece ) // num(:m) // ') = 0.'
               write(30,100) trim(line)
	    end if
	 end do
	 do n = 1,SIZE(diag_map)
	    l = diag_map(n)
	    if( lin_mat_pat(l) .or. nln_mat_pat(l) ) then
               write(num,'(i4)') l
	       m = LEN_trim( num )
               line(10:) = trim( mat_piece ) // num(:m) // ') = ' // trim(mat_piece) // num(:m) // ') - dti'
	    else
               write(num,'(i4)') l
	       m = LEN_trim( num )
               line(10:) = trim( mat_piece ) // num(:m) // ') = -dti'
	    end if
            write(30,100) trim(line)
	 end do
	 if( machine /= 'INTEL' ) then
            line = '      end do'
            write(30,100) trim(line)
	 end if
         line = ' '
         write(30,100) trim(line)
         line = '      end subroutine ' // up_hdr // 'nlnmat_finit'
         write(30,100) trim(line)
      end if
!-----------------------------------------------------------------------
!	... Now make the driver routine
!-----------------------------------------------------------------------
      if( clscnt > 0 .and. cls_rxt_cnt(3) > 0 ) then
         call MAKE_NLN_HDR( 0, machine )
      end if
      do n = 1,sub_cnt
         write(num,'(i3)') 100+n
	 select case( machine )
	    case ( 'NEC', 'FUJITSU' )
               write(line,'(''      call '',a,''nlnmat'',a,''( ofl, ofu, mat, y, rxt )'')') up_hdr,num(2:3)
	    case default
               write(line,'(''      call '',a,''nlnmat'',a,''( mat, y, rxt )'')') up_hdr,num(2:3)
	 end select
         write(30,100) trim(line)
      end do
      if( clscnt > 0 .and. cls_rxt_cnt(3) > 0 ) then
	 select case( machine )
	    case ( 'NEC', 'FUJITSU' )
               write(line,'(''      call '',a,''nlnmat_finit( ofl, ofu, mat, lmat, dti )'')') up_hdr
	    case default
               write(line,'(''      call '',a,''nlnmat_finit( mat, lmat, dti )'')') up_hdr
	 end select
         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
         line = '      end subroutine ' // up_hdr // 'nlnmat'
         write(30,100) trim(line)
      end if
      if( clscnt == 0 ) then
         line = ' '
         write(30,100) trim(line)
         line = '      end subroutine ' // up_hdr // 'nlnmat'
         write(30,100) trim(line)
      end if
      line = ' '
      write(30,100) trim(line)
      line = '      end module mo_' // up_hdr // 'nln_matrix'
      write(30,100) trim(line)

      if( ALLOCATED( nln_mat_pat ) ) then
         DEALLOCATE( nln_mat_pat )
      end if

      CLOSE( 30 )

100   format(a)

      end subroutine MAKE_NLN

      subroutine MAKE_NLN_HDR( sub_cnt, machine )
!-----------------------------------------------------------------------
!        ... Write the fortran header code for the non-linear components
!	     of the Jacobian matrix
!-----------------------------------------------------------------------
     
      implicit none

!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in)          :: sub_cnt              ! subroutine counter
      character(len=8), intent(in) :: machine              ! machine name
      
!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer           :: length
      character(len=72) :: line
      character(len=3)  :: num
      
      line = ' '
      write(30,100) trim(line)
      write(num,'(i3)') 100+sub_cnt
      select case( machine )
	 case ( 'NEC', 'FUJITSU' )
            if( sub_cnt > 0 ) then
               write(line,'(''      subroutine '',a,''nlnmat'',a,''( ofl, ofu, mat, y, rxt )'')') up_hdr,num(2:3)
            else if( sub_cnt < 0 ) then
               write(line,'(''      subroutine '',a,''nlnmat_finit( ofl, ofu, mat, lmat, dti )'')') up_hdr
            else
               write(line,'(''      subroutine '',a,''nlnmat( ofl, ofu, mat, y, rxt, lmat, dti )'')') up_hdr
            end if
	 case default
            if( sub_cnt > 0 ) then
               write(line,'(''      subroutine '',a,''nlnmat'',a,''( mat, y, rxt )'')') up_hdr,num(2:3)
            else if( sub_cnt < 0 ) then
               write(line,'(''      subroutine '',a,''nlnmat_finit( mat, lmat, dti )'')') up_hdr
            else
               write(line,'(''      subroutine '',a,''nlnmat( mat, y, rxt, lmat, dti )'')') up_hdr
            end if
      end select
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      select case( machine )
	 case( 'INTEL' )
            line = '      use mo_grid,   only : pcnstm1'
            write(30,100) trim(line)
            line = '      use chem_mods, only : rxntot, ' // hdr // 'nzcnt'
	 case ( 'NEC', 'FUJITSU' )
            line = '      use mo_grid,   only : pcnstm1, plnplv'
            write(30,100) trim(line)
            line = '      use chem_mods, only : rxntot, ' // hdr // 'nzcnt'
	 case default
            line = '      use mo_grid,   only : pcnstm1'
            write(30,100) trim(line)
            line = '      use chem_mods, only : rxntot, ' // hdr // 'nzcnt, clsze'
      end select
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '      implicit none '
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '!----------------------------------------------'
      write(30,100) trim(line)
      line = '!       ... Dummy args'
      write(30,100) trim(line)
      line = '!----------------------------------------------'
      write(30,100) trim(line)
      select case( machine )
	 case( 'INTEL' )
	    if( sub_cnt <= 0 ) then
               line = '      real, intent(in)    ::  dti'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  lmat(' // hdr // 'nzcnt)'
               write(30,100) trim(line)
	    end if
	    if( sub_cnt >= 0 ) then
               line = '      real, intent(in)    ::  y(pcnstm1)'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  rxt(rxntot)'
               write(30,100) trim(line)
	    end if
            line = '      real, intent(inout) ::  mat(' // hdr // 'nzcnt)'
	 case( 'CRAY', 'CRAYYMP', 'J90', 'C90' )
	    if( sub_cnt <= 0 ) then
               line = '      real, intent(in)    ::  dti'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  lmat(CLSZE,' // hdr // 'nzcnt)'
               write(30,100) trim(line)
	    end if
	    if( sub_cnt >= 0 ) then
               line = '      real, intent(in)    ::  y(plnplv,pcnstm1)'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  rxt(plnplv,rxntot)'
               write(30,100) trim(line)
	    end if
            line = '      real, intent(inout) ::  mat(CLSZE,' // hdr // 'nzcnt)'
	 case ( 'NEC', 'FUJITSU' )
            line = '      integer, intent(in) ::  ofl'
            write(30,100) trim(line)
            line = '      integer, intent(in) ::  ofu'
            write(30,100) trim(line)
	    if( sub_cnt <= 0 ) then
               line = '      real, intent(in)    ::  dti'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  lmat(plnplv,' // hdr // 'nzcnt)'
               write(30,100) trim(line)
	    end if
	    if( sub_cnt >= 0 ) then
               line = '      real, intent(in)    ::  y(plnplv,pcnstm1)'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  rxt(plnplv,rxntot)'
               write(30,100) trim(line)
	    end if
            line = '      real, intent(inout) ::  mat(plnplv,' // hdr // 'nzcnt)'
	 case ( 'IBM', 'DEC', 'ALPHA' )
	    if( sub_cnt <= 0 ) then
               line = '      real, intent(in)    ::  dti'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  lmat(clsze,' // hdr // 'nzcnt)'
               write(30,100) trim(line)
	    end if
	    if( sub_cnt >= 0 ) then
               line = '      real, intent(in)    ::  y(clsze,pcnstm1)'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  rxt(clsze,rxntot)'
               write(30,100) trim(line)
	    end if
            line = '      real, intent(inout) ::  mat(clsze,' // hdr // 'nzcnt)'
	 case default
	    if( sub_cnt <= 0 ) then
               line = '      real, intent(in)    ::  dti'
               write(30,100) trim(line)
               line = '      real, intent(in) ::  lmat(plnplv,' // hdr // 'nzcnt)'
               write(30,100) trim(line)
	    end if
	    if( sub_cnt >= 0 ) then
               line = '      real, intent(in)    ::  y(plnplv,pcnstm1)'
               write(30,100) trim(line)
               line = '      real, intent(in)    ::  rxt(plnplv,rxntot)'
               write(30,100) trim(line)
	    end if
            line = '      real, intent(inout) ::  mat(plnplv,' // hdr // 'nzcnt)'
      end select
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      if( sub_cnt /= 0 ) then
         line = ' '
         write(30,100) trim(line)
         line = '!----------------------------------------------'
         write(30,100) trim(line)
         line = '!       ... Local variables'
         write(30,100) trim(line)
         line = '!----------------------------------------------'
         write(30,100) trim(line)
         if( machine /= 'INTEL' ) then
            line = '      integer :: k'
            write(30,100) trim(line)
         end if
         line = ' '
         write(30,100) trim(line)

         line = '!----------------------------------------------'
         write(30,100) trim(line)
         line = '!       ... Complete matrix entries'
         length = LEN_trim( line ) + 2
         line(length:) = 'Implicit species'
         write(30,100) trim(line)
         line = '!----------------------------------------------'
         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
         if( machine /= 'INTEL' ) then
	    if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
               line(7:) = 'do k = ofl,ofu'
	    else
               line(7:) = 'do k = 1,clsze'
	    end if
            write(30,100) trim(line)
         end if
      end if

100   format(a)

      end subroutine MAKE_NLN_HDR
      
      end module NLN_MATRIX
